/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayDataFlavorSupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.screen.display.ChoiceElementDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.ScreenFileObjectListener;
import org.netbeans.modules.vmd.midp.screen.display.ScreenMoveArrayAcceptSuggestion;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midp.screen.display.WrappedLabel;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenBooleanPropertyEditor;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenStringPropertyEditor;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class ListElementEventSourceDisplayPresenter
extends ScreenDisplayPresenter {
    private static final String ICON_BROKEN_PATH = "org/netbeans/modules/vmd/midp/resources/screen/broken-image.png";
    private static final Icon ICON_BROKEN = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/screen/broken-image.png", (boolean)false);
    private JPanel view = new JPanel();
    private JLabel state;
    private JLabel image;
    private WrappedLabel label;
    private ScreenFileObjectListener imageFileListener;
    private FileObject imageFileObject;

    public ListElementEventSourceDisplayPresenter() {
        this.view.setLayout(new BoxLayout(this.view, 0));
        this.view.setOpaque(false);
        this.state = new JLabel();
        this.view.add(this.state);
        this.image = new JLabel();
        this.view.add(this.image);
        this.label = new WrappedLabel(){

            @Override
            protected int getLabelWidth() {
                return (int)(ListElementEventSourceDisplayPresenter.this.view.getSize().getWidth() - ListElementEventSourceDisplayPresenter.this.image.getSize().getWidth() - ListElementEventSourceDisplayPresenter.this.state.getSize().getWidth());
            }
        };
        this.view.add(this.label);
        this.view.add(Box.createHorizontalGlue());
        ScreenSupport.addKeyboardSupport(this);
    }

    public boolean isTopLevelDisplay() {
        return false;
    }

    public Collection<DesignComponent> getChildren() {
        return Collections.emptyList();
    }

    public JComponent getView() {
        return this.view;
    }

    public void reload(ScreenDeviceInfo deviceInfo) {
        if (this.getComponent() == null || this.getComponent().getParentComponent() == null) {
            return;
        }
        PropertyValue value = this.getComponent().getParentComponent().readProperty("listType");
        if (value == null) {
            return;
        }
        int type = !PropertyValue.Kind.USERCODE.equals((Object)value.getKind()) ? MidpTypes.getInteger(value) : 1;
        PropertyValue selectedValue = this.getComponent().readProperty("selected");
        boolean selected = selectedValue.getKind() == PropertyValue.Kind.VALUE && MidpTypes.getBoolean(selectedValue);
        switch (type) {
            case 1: {
                this.state.setIcon(selected ? ChoiceElementDisplayPresenter.ICON_RADIOBUTTON : ChoiceElementDisplayPresenter.ICON_EMPTY_RADIOBUTTON);
                break;
            }
            case 2: {
                this.state.setIcon(selected ? ChoiceElementDisplayPresenter.ICON_CHECKBOX : ChoiceElementDisplayPresenter.ICON_EMPTY_CHECKBOX);
                break;
            }
            default: {
                this.state.setIcon(null);
            }
        }
        DesignComponent imageComponent = null;
        String path = null;
        value = this.getComponent().readProperty("image");
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
            imageComponent = value.getComponent();
        }
        if (imageComponent != null) {
            path = (String)imageComponent.readProperty("resourcePath").getPrimitiveValue();
        }
        Icon icon = ScreenSupport.getIconFromImageComponent(imageComponent);
        this.imageFileObject = ScreenSupport.getFileObjectFromImageComponent(imageComponent);
        if (this.imageFileObject != null) {
            this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
            this.imageFileListener = new ScreenFileObjectListener(this.getRelatedComponent(), imageComponent, "resourcePath");
            this.imageFileObject.addFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        if (icon != null) {
            this.image.setIcon(icon);
        } else if (path != null) {
            this.image.setIcon(ICON_BROKEN);
        } else {
            this.image.setIcon(null);
        }
        String text = MidpValueSupport.getHumanReadableString(this.getComponent().readProperty("string"));
        this.label.setText(text);
        this.label.setMode(WrappedLabel.Mode.forInt(this.getFitPolicy()));
        value = this.getComponent().readProperty("font");
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
            DesignComponent font = value.getComponent();
            this.label.setFont(ScreenSupport.getFont(deviceInfo, font));
        }
        this.label.repaint();
    }

    public Shape getSelectionShape() {
        return new Rectangle(this.view.getSize());
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        return Arrays.asList(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.state, (ScreenPropertyEditor)new ScreenBooleanPropertyEditor("selected")), new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.label, (ScreenPropertyEditor)new ScreenStringPropertyEditor("string")));
    }

    public boolean isDraggable() {
        return true;
    }

    public AcceptSuggestion createSuggestion(Transferable transferable) {
        if (!transferable.isDataFlavorSupported(ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR)) {
            return null;
        }
        if (!transferable.isDataFlavorSupported(ScreenDisplayDataFlavorSupport.VERTICAL_POSITION_DATA_FLAVOR)) {
            return null;
        }
        ScreenDeviceInfo.Edge horizontalPosition = null;
        ScreenDeviceInfo.Edge verticalPosition = null;
        try {
            horizontalPosition = (ScreenDeviceInfo.Edge)transferable.getTransferData(ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR);
            verticalPosition = (ScreenDeviceInfo.Edge)transferable.getTransferData(ScreenDisplayDataFlavorSupport.VERTICAL_POSITION_DATA_FLAVOR);
        }
        catch (UnsupportedFlavorException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new ScreenMoveArrayAcceptSuggestion(horizontalPosition, verticalPosition);
    }

    private int getFitPolicy() {
        DesignComponent component = this.getRelatedComponent().getParentComponent();
        if (component != null) {
            return Integer.parseInt(component.readProperty("fitPolicy").getPrimitiveValue().toString());
        }
        return 0;
    }
}

