/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.vmd.api.screen.display.DeviceBorder;
import org.netbeans.modules.vmd.api.screen.display.DeviceTheme;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.openide.util.ImageUtilities;

public class MidpScreenDeviceInfo
extends ScreenDeviceInfo {
    protected DeviceBorder[] deviceBorders;
    private static final String IMAGE_BASE = "org/netbeans/modules/vmd/screen/resources/display/";
    private static final String[] IMAGE_NAMES = new String[]{"top.png", "top_right.png", "right.png", "bottom_right.png", "bottom.png", "bottom_left.png", "left.png", "top_left.png"};
    private Dimension currentScreenSize;
    private ArrayList<Dimension> customScreenSizes = new ArrayList();
    private DeviceTheme deviceTheme;

    public MidpScreenDeviceInfo() {
        this.loadImages();
        this.customScreenSizes.add(new Dimension(240, 320));
        this.customScreenSizes.add(new Dimension(128, 160));
        this.currentScreenSize = this.customScreenSizes.get(0);
    }

    public String getDeviceInfoID() {
        return "DefaultDevice";
    }

    public DeviceTheme getDeviceTheme() {
        if (this.deviceTheme == null) {
            this.deviceTheme = new MidpDeviceTheme();
        }
        return this.deviceTheme;
    }

    public Dimension getCurrentScreenSize() {
        return this.currentScreenSize;
    }

    public boolean supportsCustomScreenSize() {
        return true;
    }

    public Collection<Dimension> getCustomScreenSizes() {
        return this.customScreenSizes;
    }

    public boolean supportsArbitraryScreenSize() {
        return true;
    }

    public void setArbitraryScreenSize(Dimension newScreenSize) {
        this.currentScreenSize = newScreenSize;
    }

    public DeviceBorder getDeviceBorder(ScreenDeviceInfo.Edge edge) {
        return this.deviceBorders[edge.ordinal()];
    }

    protected void loadImages() {
        this.deviceBorders = new DeviceBorder[IMAGE_NAMES.length];
        for (int i = 0; i < IMAGE_NAMES.length; ++i) {
            this.deviceBorders[i] = new DeviceBorder(ImageUtilities.loadImage((String)(IMAGE_BASE + IMAGE_NAMES[i])));
        }
    }

    public static class MidpDeviceTheme
    extends DeviceTheme {
        private static final int FONT_SIZE_SMALL = 10;
        private static final int FONT_SIZE_MEDIUM = 12;
        private static final int FONT_SIZE_LARGE = 16;
        private static final String FONT_FACE_MONOSPACE = "Monospaced";
        private static final String FONT_FACE_PROPORTIONAL = "Dialog";
        private static final String FONT_FACE_SYSTEM = "Dialog";
        private static final Font FONT_DEFAULT = new Font("Dialog", 0, 12);
        private static final Font FONT_INPUT_TEXT = new Font("Dialog", 0, 12);
        private static final Font FONT_STATIC_TEXT = new Font("Dialog", 0, 12);
        private static final Map<TextAttribute, Integer> ATTR_MAP = new HashMap<TextAttribute, Integer>(1);

        public Font getFont(DeviceTheme.FontType type) {
            switch (type) {
                case INPUT_TEXT: {
                    return FONT_INPUT_TEXT;
                }
                case STATIC_TEXT: {
                    return FONT_STATIC_TEXT;
                }
            }
            return FONT_DEFAULT;
        }

        public Font getFont(DeviceTheme.FontFace face, EnumSet<DeviceTheme.FontStyle> style, DeviceTheme.FontSize size) {
            String name = "Dialog";
            if (face == DeviceTheme.FontFace.MONOSPACE) {
                name = FONT_FACE_MONOSPACE;
            } else if (face == DeviceTheme.FontFace.PROPORTIONAL) {
                name = "Dialog";
            }
            int styleInt = 0;
            if (style.contains(DeviceTheme.FontStyle.BOLD)) {
                styleInt |= 1;
            }
            if (style.contains(DeviceTheme.FontStyle.ITALIC)) {
                styleInt |= 2;
            }
            int sizeInt = 12;
            if (size == DeviceTheme.FontSize.LARGE) {
                sizeInt = 16;
            } else if (size == DeviceTheme.FontSize.SMALL) {
                sizeInt = 10;
            }
            Font font = new Font(name, styleInt, sizeInt);
            if (style.contains(DeviceTheme.FontStyle.UNDERLINED)) {
                font = font.deriveFont(ATTR_MAP);
            }
            return font;
        }

        public Color getColor(DeviceTheme.Colors colorType) {
            if (DeviceTheme.Colors.BACKGROUND == colorType) {
                return Color.WHITE;
            }
            if (DeviceTheme.Colors.FOREGROUND == colorType) {
                return Color.BLACK;
            }
            if (DeviceTheme.Colors.HIGHLIGHTED == colorType) {
                return Color.RED;
            }
            return null;
        }

        static {
            ATTR_MAP.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
    }
}

