/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.general.ClassCode;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementEvent;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementListener;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorMessageAwareness;

public abstract class PropertyEditorResourceElement
extends JPanel {
    private List<PropertyEditorResourceElementListener> listeners = new ArrayList<PropertyEditorResourceElementListener>(1);

    public abstract JComponent getJComponent();

    public abstract void setDesignComponentWrapper(DesignComponentWrapper var1);

    public abstract TypeID getTypeID();

    public abstract List<String> getPropertyValueNames();

    public boolean isPostSetValueSupported(DesignComponent component) {
        return false;
    }

    public void postSetValue(DesignComponent parentComponent, DesignComponent childComponent) {
    }

    public boolean isResetToDefaultAutomatically(DesignComponent component) {
        return true;
    }

    public void setPropertyEditorMessageAwareness(PropertyEditorMessageAwareness messageAwareness) {
    }

    public void postSaveValue(DesignComponent parentComponent) {
    }

    public String getIconPath() {
        return "org/netbeans/modules/vmd/midp/resources/components/resource_16.png";
    }

    @Deprecated
    public String getResourceNameSuggestion() {
        return ClassCode.getSuggestedMainName(this.getTypeID());
    }

    public void addPropertyEditorResourceElementListener(PropertyEditorResourceElementListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyEditorResourceElementListener(PropertyEditorResourceElementListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireElementChanged(long componentID, String propertyName, PropertyValue propertyValue) {
        for (PropertyEditorResourceElementListener listener : this.listeners) {
            listener.elementChanged(new PropertyEditorResourceElementEvent(componentID, propertyName, propertyValue));
        }
    }

    public void nullValueSet(DesignComponent component) {
    }

    public void preResetToDefaultValue(DesignComponent component) {
    }

    public static boolean isPropertyValueAUserCodeType(PropertyValue propertyValue) {
        return propertyValue != null && propertyValue.getKind() == PropertyValue.Kind.USERCODE;
    }

    public void listSelectionHappened() {
    }

    public void getCustomEdiotrNotification() {
    }

    public void setDesignComponent(DesignComponent component) {
    }

    public static class StringComparator
    implements Comparator {
        public static final StringComparator instance = new StringComparator();

        private StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).toLowerCase().compareTo(((String)o2).toLowerCase());
            }
            return ((Comparable)o1).compareTo((Comparable)o2);
        }
    }

    public static class DesignComponentWrapper {
        private DesignComponent component;
        private boolean isDeleted;
        private long componentID;
        private TypeID typeID;
        private Map<String, PropertyValue> changesMap;

        public DesignComponentWrapper(DesignComponent component) {
            this(component.getComponentID(), component.getType());
            this.component = component;
        }

        public DesignComponentWrapper(long componentID, TypeID typeID) {
            this.componentID = componentID;
            this.typeID = typeID;
            this.changesMap = new HashMap<String, PropertyValue>();
        }

        public DesignComponent getComponent() {
            return this.component;
        }

        public void deleteComponent() {
            this.component = null;
            this.isDeleted = true;
        }

        public long getComponentID() {
            return this.componentID;
        }

        public TypeID getTypeID() {
            return this.typeID;
        }

        public void setChangeRecord(String propertyName, PropertyValue value) {
            this.changesMap.put(propertyName, value);
        }

        public Map<String, PropertyValue> getChanges() {
            return Collections.unmodifiableMap(this.changesMap);
        }

        public boolean hasChanges() {
            return this.changesMap.size() > 0 || this.component == null;
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }
    }
}

