/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorInputMode
extends PropertyEditorUserCode {
    private static final String[] PREDEFINED_INPUT_MODES = new String[]{"UCB_BASIC_LATIN", "UCB_GREEK", "UCB_CYRILLIC", "UCB_ARMENIAN", "UCB_HEBREW", "UCB_ARABIC", "UCB_DEVANAGARI", "UCB_BENGALI", "UCB_THAI", "UCB_HIRAGANA", "UCB_KATAKANA", "UCB_HANGUL_SYLLABLES"};
    private List<PropertyEditorElement> elements;

    private PropertyEditorInputMode() {
        super(NbBundle.getMessage(PropertyEditorInputMode.class, (String)"LBL_INPUT_MODE_UCLABEL"));
    }

    public static final PropertyEditorInputMode createInstance() {
        return new PropertyEditorInputMode();
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.elements != null) {
            for (PropertyEditorElement e : this.elements) {
                if (!(e instanceof CleanUp)) continue;
                ((CleanUp)((Object)e)).clean(component);
            }
            if (this.elements != null) {
                this.elements.clear();
                this.elements = null;
            }
        }
    }

    @Override
    public String getAsText() {
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        return (String)value.getPrimitiveValue();
    }

    private void saveValue(String text) {
        if (text.length() > 0) {
            super.setValue((Object)MidpTypes.createStringValue(text));
        }
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        for (PropertyEditorElement element : this.elements) {
            if (!element.getRadioButton().isSelected()) continue;
            this.saveValue(element.getTextForPropertyValue());
            break;
        }
    }

    private boolean isPredefined(String str) {
        for (String inputMode : PREDEFINED_INPUT_MODES) {
            if (!inputMode.equals(str)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Component getCustomEditor() {
        if (this.elements == null) {
            this.elements = new ArrayList<PropertyEditorElement>(2);
            this.elements.add(new PredefinedEditor());
            this.elements.add(new CustomEditor());
            this.initElements(this.elements);
        }
        return super.getCustomEditor();
    }

    private final class CustomEditor
    implements PropertyEditorElement,
    DocumentListener,
    CleanUp {
        private JRadioButton radioButton = new JRadioButton();
        private JTextField textField;

        public CustomEditor() {
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorInputMode.class, (String)"LBL_CUSTOM"));
            this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorInputMode.class, (String)"ACSN_CUSTOM"));
            this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorInputMode.class, (String)"ACSD_CUSTOM"));
            this.textField = new JTextField();
            this.textField.getDocument().addDocumentListener(this);
            this.textField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorInputMode.class, (String)"ACSN_CUSTOM_VALUE"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorInputMode.class, (String)"ACSD_CUSTOM_VALUE"));
        }

        @Override
        public void clean(DesignComponent component) {
            this.radioButton = null;
            if (this.textField.getDocument() != null) {
                this.textField.getDocument().removeDocumentListener(this);
            }
            this.textField = null;
        }

        @Override
        public void updateState(PropertyValue value) {
            if (!PropertyEditorInputMode.this.isCurrentValueANull() && value != null) {
                String str = (String)value.getPrimitiveValue();
                if (!PropertyEditorInputMode.this.isPredefined(str)) {
                    this.textField.setText(str);
                }
            } else {
                this.textField.setText(null);
            }
        }

        @Override
        public void setTextForPropertyValue(String text) {
            PropertyEditorInputMode.this.saveValue(text);
        }

        @Override
        public String getTextForPropertyValue() {
            return this.textField.getText();
        }

        @Override
        public JComponent getCustomEditorComponent() {
            return this.textField;
        }

        @Override
        public JRadioButton getRadioButton() {
            return this.radioButton;
        }

        @Override
        public boolean isInitiallySelected() {
            return false;
        }

        @Override
        public boolean isVerticallyResizable() {
            return false;
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            if (this.textField.hasFocus()) {
                this.radioButton.setSelected(true);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            if (this.textField.hasFocus()) {
                this.radioButton.setSelected(true);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }
    }

    private final class PredefinedEditor
    implements PropertyEditorElement,
    ActionListener,
    CleanUp {
        private JRadioButton radioButton = new JRadioButton();
        private DefaultComboBoxModel model;
        private JComboBox combobox;

        public PredefinedEditor() {
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorInputMode.class, (String)"LBL_PREDEFINED"));
            this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorInputMode.class, (String)"ACSN_PREDEFINED"));
            this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorInputMode.class, (String)"ACSD_PREDEFINED"));
            this.model = new DefaultComboBoxModel<String>(PREDEFINED_INPUT_MODES);
            this.combobox = new JComboBox(this.model);
            this.combobox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorInputMode.class, (String)"ACSN_PREDEFINED_LIST"));
            this.combobox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorInputMode.class, (String)"ACSD_PREDEFINED_LIST"));
            this.combobox.addActionListener(this);
        }

        @Override
        public void clean(DesignComponent component) {
            this.radioButton.removeActionListener(this);
            this.radioButton = null;
            this.combobox.removeActionListener(this);
            this.combobox = null;
        }

        @Override
        public void updateState(PropertyValue value) {
            if (!PropertyEditorInputMode.this.isCurrentValueANull() && value != null) {
                for (int i = 0; i < this.model.getSize(); ++i) {
                    String inputMode = (String)this.model.getElementAt(i);
                    if (!inputMode.equals((String)value.getPrimitiveValue())) continue;
                    this.model.setSelectedItem(inputMode);
                    break;
                }
            }
        }

        @Override
        public void setTextForPropertyValue(String text) {
            PropertyEditorInputMode.this.saveValue(text);
        }

        @Override
        public String getTextForPropertyValue() {
            return (String)this.combobox.getSelectedItem();
        }

        @Override
        public JComponent getCustomEditorComponent() {
            return this.combobox;
        }

        @Override
        public JRadioButton getRadioButton() {
            return this.radioButton;
        }

        @Override
        public boolean isInitiallySelected() {
            return true;
        }

        @Override
        public boolean isVerticallyResizable() {
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.radioButton.setSelected(true);
        }
    }
}

