/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DisjunctiveTypeTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.lang.model.element.Name;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;

public class Reformatter
implements ReformatTask {
    private static final Object CT_HANDLER_DOC_PROPERTY = "code-template-insert-handler";
    private Source source;
    private org.netbeans.modules.editor.indent.spi.Context context;
    private CompilationController controller;
    private Document doc;

    public Reformatter(Source source, org.netbeans.modules.editor.indent.spi.Context context) {
        this.source = source;
        this.context = context;
        this.doc = context.document();
    }

    public void reformat() throws BadLocationException {
        if (this.controller == null) {
            try {
                if ("text/x-java".equals(this.source.getMimeType())) {
                    this.controller = JavaSourceAccessor.getINSTANCE().createCompilationController(this.source);
                } else {
                    ParserManager.parse(Collections.singletonList(this.source), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            Parser.Result result = this.findEmbeddedJava(resultIterator);
                            if (result != null) {
                                Reformatter.this.controller = CompilationController.get(result);
                            }
                        }

                        private Parser.Result findEmbeddedJava(ResultIterator theMess) throws ParseException {
                            LinkedList<Embedding> todo = new LinkedList<Embedding>();
                            for (Embedding embedding : theMess.getEmbeddings()) {
                                if ("text/x-java".equals(embedding.getMimeType())) {
                                    return theMess.getResultIterator(embedding).getParserResult();
                                }
                                todo.add(embedding);
                            }
                            for (Embedding embedding : todo) {
                                Parser.Result result = this.findEmbeddedJava(theMess.getResultIterator(embedding));
                                if (result == null) continue;
                                return result;
                            }
                            return null;
                        }
                    });
                }
                if (this.controller == null) {
                    return;
                }
                this.controller.toPhase(JavaSource.Phase.PARSED);
            }
            catch (Exception ex) {
                this.controller = null;
                return;
            }
        }
        CodeStyle cs = CodeStyle.getDefault(this.doc);
        java.util.List indentRegions = this.context.indentRegions();
        Collections.reverse(indentRegions);
        for (Context.Region region : indentRegions) {
            this.reformatImpl(region, cs);
        }
    }

    public static String reformat(String text, CodeStyle style) {
        return Reformatter.reformat(text, style, style.getRightMargin());
    }

    public static String reformat(String text, CodeStyle style, int rightMargin) {
        StringBuilder sb = new StringBuilder(text);
        try {
            ClassPath empty = ClassPathSupport.createClassPath((URL[])new URL[0]);
            ClasspathInfo cpInfo = ClasspathInfo.create(JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries(), empty, empty);
            JavacTaskImpl javacTask = JavacParser.createJavacTask(cpInfo, null, null, null, null, null, null);
            Context ctx = javacTask.getContext();
            JavaCompiler.instance((Context)ctx).genEndPos = true;
            CompilationUnitTree tree = (CompilationUnitTree)javacTask.parse(new JavaFileObject[]{FileObjects.memoryFileObject("", "", text)}).iterator().next();
            SourcePositions sp = JavacTrees.instance(ctx).getSourcePositions();
            TokenSequence tokens = TokenHierarchy.create((CharSequence)text, (Language)JavaTokenId.language()).tokenSequence(JavaTokenId.language());
            for (Diff diff : Pretty.reformat(text, (TokenSequence<JavaTokenId>)tokens, new TreePath(tree), sp, style, rightMargin)) {
                int start = diff.getStartOffset();
                int end = diff.getEndOffset();
                sb.delete(start, end);
                String t = diff.getText();
                if (t == null || t.length() <= 0) continue;
                sb.insert(start, t);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return sb.toString();
    }

    private void reformatImpl(Context.Region region, CodeStyle cs) throws BadLocationException {
        boolean templateEdit = this.doc.getProperty(CT_HANDLER_DOC_PROPERTY) != null;
        int startOffset = region.getStartOffset();
        int endOffset = region.getEndOffset();
        startOffset = this.controller.getSnapshot().getEmbeddedOffset(startOffset);
        if (startOffset < 0) {
            return;
        }
        endOffset = this.controller.getSnapshot().getEmbeddedOffset(endOffset);
        if (endOffset < 0) {
            return;
        }
        int embeddingOffset = -1;
        int firstLineIndent = -1;
        if (!"text/x-java".equals(this.context.mimePath())) {
            firstLineIndent = this.context.lineIndent(this.context.lineStartOffset(region.getStartOffset()));
            TokenSequence ts = this.controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            if (ts != null) {
                String t;
                ts.move(startOffset);
                if (ts.moveNext()) {
                    if (ts.token().id() == JavaTokenId.WHITESPACE) {
                        t = ((Object)ts.token().text()).toString();
                        if (ts.offset() < startOffset) {
                            t = t.substring(startOffset - ts.offset());
                        }
                        if (t.indexOf(10) < 0) {
                            embeddingOffset = ts.offset() + ts.token().length();
                        }
                    } else {
                        embeddingOffset = startOffset;
                    }
                }
                ts.move(endOffset);
                if (ts.moveNext() && ts.token().id() == JavaTokenId.WHITESPACE) {
                    int i;
                    t = ((Object)ts.token().text()).toString();
                    if (ts.offset() + t.length() > endOffset) {
                        t = t.substring(0, endOffset - ts.offset());
                    }
                    if ((i = t.lastIndexOf(10)) >= 0) {
                        endOffset -= t.length() - i;
                    }
                }
            }
        }
        if (startOffset >= endOffset) {
            return;
        }
        TreePath path = this.getCommonPath(startOffset, endOffset);
        if (path == null) {
            return;
        }
        for (Diff diff : Pretty.reformat(this.controller, path, cs, startOffset, endOffset, templateEdit, firstLineIndent)) {
            int idx2;
            int idx1;
            String t;
            TokenSequence ts;
            int start = diff.getStartOffset();
            int end = diff.getEndOffset();
            String text = diff.getText();
            if (startOffset > end || endOffset < start || endOffset == start && (text == null || !text.trim().equals("}") && !templateEdit) || embeddingOffset >= start) continue;
            if (startOffset >= start) {
                if (text != null && text.length() > 0) {
                    ts = this.controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                    if (ts == null || (ts.move(startOffset) != 0 ? !ts.moveNext() && !ts.movePrevious() : !ts.movePrevious() && !ts.moveNext())) continue;
                    if (ts.token().id() == JavaTokenId.WHITESPACE) {
                        t = ((Object)ts.token().text()).toString();
                        t = t.substring(0, startOffset - ts.offset());
                        if (ts.movePrevious() && ts.token().id() == JavaTokenId.LINE_COMMENT) {
                            t = "\n" + t;
                        }
                        if (templateEdit) {
                            int idx = t.lastIndexOf(10);
                            if (idx >= 0) {
                                t = t.substring(idx + 1);
                                idx = text.lastIndexOf(10);
                                if (idx >= 0) {
                                    text = text.substring(idx + 1);
                                }
                                text = text.trim().length() > 0 ? null : (text.length() > t.length() ? text.substring(t.length()) : null);
                            } else {
                                text = null;
                            }
                        } else {
                            idx1 = 0;
                            idx2 = 0;
                            int lastIdx1 = 0;
                            int lastIdx2 = 0;
                            while ((idx1 = t.indexOf(10, lastIdx1)) >= 0 && (idx2 = text.indexOf(10, lastIdx2)) >= 0) {
                                lastIdx1 = idx1 + 1;
                                lastIdx2 = idx2 + 1;
                            }
                            idx2 = text.lastIndexOf(10);
                            if (idx2 >= 0 && idx2 >= lastIdx2) {
                                if (lastIdx1 == 0) {
                                    t = null;
                                } else {
                                    text = text.substring(idx2 + 1);
                                    t = t.substring(lastIdx1);
                                }
                            } else {
                                idx1 = t.lastIndexOf(10);
                                if (idx1 >= 0 && idx1 >= lastIdx1) {
                                    t = t.substring(idx1 + 1);
                                    text = text.substring(lastIdx2);
                                } else {
                                    t = t.substring(lastIdx1);
                                    text = text.substring(lastIdx2);
                                }
                            }
                            if (text != null && t != null) {
                                text = text.length() > t.length() ? text.substring(t.length()) : null;
                            }
                        }
                    }
                }
                start = startOffset;
            }
            if (endOffset < end) {
                if (text != null && text.length() > 0 && !templateEdit && (ts = this.controller.getTokenHierarchy().tokenSequence(JavaTokenId.language())) != null) {
                    ts.move(endOffset);
                    if (ts.moveNext() && ts.token().id() == JavaTokenId.WHITESPACE) {
                        t = ((Object)ts.token().text()).toString();
                        t = t.substring(endOffset - ts.offset());
                        while ((idx1 = t.lastIndexOf(10)) >= 0 && (idx2 = text.lastIndexOf(10)) >= 0) {
                            t = t.substring(0, idx1);
                            text = text.substring(0, idx2);
                        }
                        text = text.length() > t.length() ? text.substring(0, text.length() - t.length()) : null;
                    }
                }
                end = endOffset;
            }
            start = this.controller.getSnapshot().getOriginalOffset(start);
            end = this.controller.getSnapshot().getOriginalOffset(end);
            if (start == -1 || end == -1) continue;
            this.doc.remove(start, end - start);
            if (text == null || text.length() <= 0) continue;
            this.doc.insertString(start, text, null);
        }
    }

    public ExtraLock reformatLock() {
        return "text/x-java".equals(this.source.getMimeType()) ? null : new ExtraLock(){

            public void lock() {
                Utilities.acquireParserLock();
            }

            public void unlock() {
                Utilities.releaseParserLock();
            }
        };
    }

    private TreePath getCommonPath(int startOffset, int endOffset) {
        TreeUtilities tu = this.controller.getTreeUtilities();
        TreePath startPath = tu.pathFor(startOffset);
        List<Tree> reverseStartPath = List.nil();
        for (Tree t : startPath) {
            reverseStartPath = reverseStartPath.prepend(t);
        }
        TreePath endPath = tu.pathFor(endOffset);
        List<Tree> reverseEndPath = List.nil();
        for (Tree t : endPath) {
            reverseEndPath = reverseEndPath.prepend(t);
        }
        TreePath path = null;
        TreePath statementPath = null;
        while (reverseStartPath.head != null && reverseStartPath.head == reverseEndPath.head) {
            TreePath treePath = path = reverseStartPath.head instanceof CompilationUnitTree ? new TreePath((CompilationUnitTree)reverseStartPath.head) : new TreePath(path, (Tree)reverseStartPath.head);
            if (reverseStartPath.head instanceof StatementTree) {
                statementPath = path;
            }
            reverseStartPath = reverseStartPath.tail;
            reverseEndPath = reverseEndPath.tail;
        }
        return statementPath != null ? statementPath : path;
    }

    private static class Diff {
        private int start;
        private int end;
        private String text;

        private Diff(int start, int end, String text) {
            this.start = start;
            this.end = end;
            this.text = text;
        }

        public int getStartOffset() {
            return this.start;
        }

        public int getEndOffset() {
            return this.end;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Diff<" + this.start + "," + this.end + ">:" + this.text;
        }
    }

    private static class Pretty
    extends TreePathScanner<Boolean, Void> {
        private static final String OPERATOR = "operator";
        private static final String EMPTY = "";
        private static final String SPACE = " ";
        private static final String NEWLINE = "\n";
        private static final String ERROR = "<error>";
        private static final int ANY_COUNT = -1;
        private final String fText;
        private final SourcePositions sp;
        private final CodeStyle cs;
        private final int rightMargin;
        private final int tabSize;
        private final int indentSize;
        private final int continuationIndentSize;
        private final boolean expandTabToSpaces;
        private TokenSequence<JavaTokenId> tokens;
        private int indent;
        private int col;
        private int endPos;
        private int lastBlankLines;
        private int lastBlankLinesTokenIndex;
        private Diff lastBlankLinesDiff;
        private boolean afterAnnotation;
        private boolean wrapAnnotation;
        private boolean fieldGroup;
        private boolean templateEdit;
        private LinkedList<Diff> diffs = new LinkedList();
        private DanglingElseChecker danglingElseChecker = new DanglingElseChecker();
        private CompilationUnitTree root;
        private int startOffset;
        private int endOffset;
        private int tpLevel;

        private Pretty(CompilationInfo info, TreePath path, CodeStyle cs, int startOffset, int endOffset, boolean templateEdit) {
            this(info.getText(), (TokenSequence<JavaTokenId>)info.getTokenHierarchy().tokenSequence(JavaTokenId.language()), path, info.getTrees().getSourcePositions(), cs, startOffset, endOffset);
            this.templateEdit = templateEdit;
        }

        private Pretty(String text, TokenSequence<JavaTokenId> tokens, TreePath path, SourcePositions sp, CodeStyle cs, int startOffset, int endOffset) {
            this(text, tokens, path, sp, cs, startOffset, endOffset, cs.getRightMargin());
        }

        private Pretty(String text, TokenSequence<JavaTokenId> tokens, TreePath path, SourcePositions sp, CodeStyle cs, int startOffset, int endOffset, int rightMargin) {
            this.fText = text;
            this.sp = sp;
            this.cs = cs;
            this.rightMargin = rightMargin;
            this.tabSize = cs.getTabSize();
            this.indentSize = cs.getIndentSize();
            this.continuationIndentSize = cs.getContinuationIndentSize();
            this.expandTabToSpaces = cs.expandTabToSpaces();
            this.lastBlankLines = -1;
            this.lastBlankLinesTokenIndex = -1;
            this.lastBlankLinesDiff = null;
            this.afterAnnotation = false;
            this.wrapAnnotation = false;
            this.fieldGroup = false;
            Tree tree = path.getLeaf();
            this.col = this.indent = tokens != null ? this.getIndentLevel(tokens, path) : 0;
            this.tokens = tokens;
            if (tree.getKind() == Tree.Kind.COMPILATION_UNIT) {
                tokens.moveEnd();
                tokens.movePrevious();
            } else {
                tokens.move((int)sp.getEndPosition(path.getCompilationUnit(), tree));
                if (!tokens.moveNext()) {
                    tokens.movePrevious();
                }
            }
            this.endPos = tokens.offset();
            if (tree.getKind() == Tree.Kind.COMPILATION_UNIT) {
                tokens.moveStart();
            } else {
                tokens.move((int)sp.getStartPosition(path.getCompilationUnit(), tree));
            }
            tokens.moveNext();
            this.root = path.getCompilationUnit();
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.tpLevel = 0;
        }

        public static LinkedList<Diff> reformat(CompilationInfo info, TreePath path, CodeStyle cs, int startOffset, int endOffset, boolean templateEdit, int firstLineIndent) {
            Pretty pretty = new Pretty(info, path, cs, startOffset, endOffset, templateEdit);
            if (pretty.indent >= 0) {
                if (firstLineIndent >= 0) {
                    pretty.indent = firstLineIndent;
                }
                pretty.scan(path, null);
            }
            if (path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                int cnt;
                CompilationUnitTree cut = (CompilationUnitTree)path.getLeaf();
                java.util.List<? extends Tree> typeDecls = cut.getTypeDecls();
                int size = typeDecls.size();
                int n = cnt = size > 0 && TreeUtilities.CLASS_TREE_KINDS.contains((Object)typeDecls.get(size - 1).getKind()) ? cs.getBlankLinesAfterClass() : 1;
                if (cnt < 1) {
                    cnt = 1;
                }
                String s = pretty.getNewlines(cnt);
                pretty.tokens.moveEnd();
                pretty.tokens.movePrevious();
                if (pretty.tokens.token().id() != JavaTokenId.WHITESPACE) {
                    String text = info.getText();
                    pretty.diffs.addFirst(new Diff(text.length(), text.length(), s));
                } else if (!s.contentEquals(pretty.tokens.token().text())) {
                    pretty.diffs.addFirst(new Diff(pretty.tokens.offset(), pretty.tokens.offset() + pretty.tokens.token().length(), s));
                }
            }
            return pretty.diffs;
        }

        public static LinkedList<Diff> reformat(String text, TokenSequence<JavaTokenId> tokens, TreePath path, SourcePositions sp, CodeStyle cs, int rightMargin) {
            int cnt;
            Pretty pretty = new Pretty(text, tokens, path, sp, cs, 0, text.length(), rightMargin);
            pretty.scan(path, null);
            CompilationUnitTree cut = (CompilationUnitTree)path.getLeaf();
            java.util.List<? extends Tree> typeDecls = cut.getTypeDecls();
            int size = typeDecls.size();
            int n = cnt = size > 0 && TreeUtilities.CLASS_TREE_KINDS.contains((Object)typeDecls.get(size - 1).getKind()) ? cs.getBlankLinesAfterClass() : 1;
            if (cnt < 1) {
                cnt = 1;
            }
            String s = pretty.getNewlines(cnt);
            tokens.moveEnd();
            tokens.movePrevious();
            if (tokens.token().id() != JavaTokenId.WHITESPACE) {
                pretty.diffs.addFirst(new Diff(text.length(), text.length(), s));
            } else if (!s.contentEquals(tokens.token().text())) {
                pretty.diffs.addFirst(new Diff(tokens.offset(), tokens.offset() + tokens.token().length(), s));
            }
            return pretty.diffs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean scan(Tree tree, Void p) {
            int lastEndPos = this.endPos;
            if (tree != null && tree.getKind() != Tree.Kind.COMPILATION_UNIT) {
                int startPos;
                this.endPos = tree instanceof FakeBlock ? Integer.MAX_VALUE : (int)this.sp.getEndPosition(this.getCurrentPath().getCompilationUnit(), tree);
                if (tree.getKind() != Tree.Kind.ERRONEOUS && tree.getKind() != Tree.Kind.BLOCK && (tree.getKind() != Tree.Kind.CLASS || this.getCurrentPath().getLeaf().getKind() != Tree.Kind.NEW_CLASS) && (tree.getKind() != Tree.Kind.NEW_ARRAY || this.getCurrentPath().getLeaf().getKind() != Tree.Kind.ASSIGNMENT && this.getCurrentPath().getLeaf().getKind() != Tree.Kind.VARIABLE) && (startPos = (int)this.sp.getStartPosition(this.getCurrentPath().getCompilationUnit(), tree)) >= 0 && startPos > this.tokens.offset()) {
                    this.tokens.move(startPos);
                    this.tokens.moveNext();
                }
            }
            try {
                Boolean bl = this.endPos < 0 ? false : (this.tokens.offset() <= this.endPos ? (Boolean)super.scan(tree, p) : true);
                return bl;
            }
            finally {
                this.endPos = lastEndPos;
            }
        }

        @Override
        public Boolean visitCompilationUnit(CompilationUnitTree node, Void p) {
            java.util.List<? extends ImportTree> imports;
            ExpressionTree pkg = node.getPackageName();
            if (pkg != null) {
                this.blankLines(this.cs.getBlankLinesBeforePackage());
                if (!node.getPackageAnnotations().isEmpty()) {
                    this.wrapList(this.cs.wrapAnnotations(), false, false, JavaTokenId.COMMA, node.getPackageAnnotations());
                    this.newline();
                }
                this.accept(JavaTokenId.PACKAGE, new JavaTokenId[0]);
                int old = this.indent;
                this.indent += this.continuationIndentSize;
                this.space();
                this.scan((Tree)pkg, p);
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
                this.indent = old;
                this.blankLines(this.cs.getBlankLinesAfterPackage());
            }
            if ((imports = node.getImports()) != null && !imports.isEmpty()) {
                this.blankLines(this.cs.getBlankLinesBeforeImports());
                for (ImportTree importTree : imports) {
                    this.blankLines();
                    this.scan((Tree)importTree, p);
                }
                this.blankLines(this.cs.getBlankLinesAfterImports());
            }
            boolean semiRead = false;
            for (Tree tree : node.getTypeDecls()) {
                Diff d;
                if (semiRead && tree.getKind() == Tree.Kind.EMPTY_STATEMENT) continue;
                if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
                    this.blankLines(this.cs.getBlankLinesBeforeClass());
                }
                this.scan(tree, p);
                int index = this.tokens.index();
                int c = this.col;
                Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                if (this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]) == JavaTokenId.SEMICOLON) {
                    semiRead = true;
                } else {
                    this.rollback(index, c, d);
                    semiRead = false;
                }
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                this.blankLines(this.cs.getBlankLinesAfterClass());
            }
            return true;
        }

        @Override
        public Boolean visitImport(ImportTree node, Void p) {
            this.accept(JavaTokenId.IMPORT, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            this.space();
            if (node.isStatic()) {
                this.accept(JavaTokenId.STATIC, new JavaTokenId[0]);
                this.space();
            }
            this.scan(node.getQualifiedIdentifier(), p);
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitClass(ClassTree node, Void p) {
            Diff diff;
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            if (!(parent.getKind() == Tree.Kind.NEW_CLASS || parent.getKind() == Tree.Kind.VARIABLE && this.isEnumerator((VariableTree)parent))) {
                java.util.List<? extends Tree> impls;
                Tree ext;
                java.util.List<? extends TypeParameterTree> tparams;
                int old = this.indent;
                ModifiersTree mods = node.getModifiers();
                if (mods != null) {
                    if (this.scan((Tree)mods, p).booleanValue()) {
                        this.indent += this.continuationIndentSize;
                        if (this.cs.placeNewLineAfterModifiers()) {
                            this.newline();
                        } else {
                            this.space();
                        }
                    } else if (this.afterAnnotation) {
                        this.blankLines();
                    }
                    this.afterAnnotation = false;
                }
                JavaTokenId id = this.accept(JavaTokenId.CLASS, JavaTokenId.INTERFACE, JavaTokenId.ENUM, JavaTokenId.AT);
                if (this.indent == old) {
                    this.indent += this.continuationIndentSize;
                }
                if (id == JavaTokenId.AT) {
                    this.accept(JavaTokenId.INTERFACE, new JavaTokenId[0]);
                }
                this.space();
                if (!ERROR.contentEquals(node.getSimpleName())) {
                    this.accept(JavaTokenId.IDENTIFIER, new JavaTokenId[0]);
                }
                if ((tparams = node.getTypeParameters()) != null && !tparams.isEmpty()) {
                    JavaTokenId accepted;
                    if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                        ++this.tpLevel;
                    }
                    Iterator<? extends TypeParameterTree> it = tparams.iterator();
                    while (it.hasNext()) {
                        TypeParameterTree tparam = it.next();
                        this.scan((Tree)tparam, p);
                        if (!it.hasNext()) continue;
                        this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                        this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                        this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                    }
                    if (this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                        switch (accepted) {
                            case GTGTGT: {
                                this.tpLevel -= 3;
                                break;
                            }
                            case GTGT: {
                                this.tpLevel -= 2;
                                break;
                            }
                            case GT: {
                                --this.tpLevel;
                            }
                        }
                    }
                }
                if ((ext = node.getExtendsClause()) != null) {
                    this.wrapToken(this.cs.wrapExtendsImplementsKeyword(), -1, 1, JavaTokenId.EXTENDS, new JavaTokenId[0]);
                    this.space();
                    this.scan(ext, p);
                }
                if ((impls = node.getImplementsClause()) != null && !impls.isEmpty()) {
                    this.wrapToken(this.cs.wrapExtendsImplementsKeyword(), -1, 1, id == JavaTokenId.INTERFACE ? JavaTokenId.EXTENDS : JavaTokenId.IMPLEMENTS, new JavaTokenId[0]);
                    this.wrapList(this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements(), true, JavaTokenId.COMMA, impls);
                }
                this.indent = old;
            }
            CodeStyle.BracePlacement bracePlacement = this.cs.getClassDeclBracePlacement();
            boolean spaceBeforeLeftBrace = this.cs.spaceBeforeClassDeclLeftBrace();
            int old = this.indent;
            int halfIndent = this.indent;
            switch (bracePlacement) {
                case SAME_LINE: {
                    this.spaces(spaceBeforeLeftBrace ? 1 : 0, this.tokens.offset() < this.startOffset);
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent += this.indentSize;
                    break;
                }
                case NEW_LINE: {
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent += this.indentSize;
                    break;
                }
                case NEW_LINE_HALF_INDENTED: {
                    this.indent += this.indentSize >> 1;
                    halfIndent = this.indent;
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = old + this.indentSize;
                    break;
                }
                case NEW_LINE_INDENTED: {
                    this.indent += this.indentSize;
                    halfIndent = this.indent;
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                }
            }
            boolean emptyClass = true;
            for (Tree tree : node.getMembers()) {
                if (this.isSynthetic(this.getCurrentPath().getCompilationUnit(), tree)) continue;
                emptyClass = false;
                break;
            }
            if (emptyClass) {
                this.newline();
            } else {
                if (!this.cs.indentTopLevelClassMembers()) {
                    this.indent = old;
                }
                this.blankLines(this.cs.getBlankLinesAfterClassHeader());
                JavaTokenId id = null;
                boolean bl = true;
                boolean semiRead = false;
                block19: for (Tree tree : node.getMembers()) {
                    boolean bl2;
                    if (this.isSynthetic(this.getCurrentPath().getCompilationUnit(), tree)) continue;
                    switch (tree.getKind()) {
                        case VARIABLE: {
                            Diff d;
                            int c;
                            int index;
                            if (this.isEnumerator((VariableTree)tree)) {
                                this.wrapTree(this.cs.wrapEnumConstants(), -1, id == JavaTokenId.COMMA ? 1 : 0, tree);
                                index = this.tokens.index();
                                c = this.col;
                                d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                id = this.accept(JavaTokenId.COMMA, JavaTokenId.SEMICOLON);
                                if (id == JavaTokenId.COMMA) {
                                    index = this.tokens.index();
                                    c = this.col;
                                    Diff diff2 = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                    if (this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]) != null) break;
                                    this.rollback(index, c, d);
                                    break;
                                }
                                if (id == JavaTokenId.SEMICOLON) {
                                    this.blankLines(this.cs.getBlankLinesAfterFields());
                                    break;
                                }
                                this.rollback(index, c, d);
                                this.blankLines(this.cs.getBlankLinesAfterFields());
                                break;
                            }
                            boolean b = this.tokens.moveNext();
                            if (!b) break;
                            this.tokens.movePrevious();
                            if (!this.fieldGroup && !bl2) {
                                this.blankLines(this.cs.getBlankLinesBeforeFields());
                            }
                            this.scan(tree, p);
                            if (this.fieldGroup) break;
                            this.blankLines(this.cs.getBlankLinesAfterFields());
                            break;
                        }
                        case METHOD: {
                            if (!bl2) {
                                this.blankLines(this.cs.getBlankLinesBeforeMethods());
                            }
                            this.scan(tree, p);
                            this.blankLines(this.cs.getBlankLinesAfterMethods());
                            break;
                        }
                        case BLOCK: {
                            Diff d;
                            if (semiRead && !((BlockTree)tree).isStatic() && ((BlockTree)tree).getStatements().isEmpty()) {
                                semiRead = false;
                                continue block19;
                            }
                            if (!bl2) {
                                this.blankLines(this.cs.getBlankLinesBeforeMethods());
                            }
                            int index = this.tokens.index();
                            int c = this.col;
                            Diff diff3 = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                            if (this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]) == JavaTokenId.SEMICOLON) continue block19;
                            this.rollback(index, c, d);
                            this.scan(tree, p);
                            this.blankLines(this.cs.getBlankLinesAfterMethods());
                            break;
                        }
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            Diff d;
                            if (!bl2) {
                                this.blankLines(this.cs.getBlankLinesBeforeClass());
                            }
                            this.scan(tree, p);
                            int index = this.tokens.index();
                            int c = this.col;
                            Diff diff4 = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                            if (this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]) == JavaTokenId.SEMICOLON) {
                                semiRead = true;
                            } else {
                                this.rollback(index, c, d);
                                semiRead = false;
                            }
                            this.blankLines(this.cs.getBlankLinesAfterClass());
                        }
                    }
                    bl2 = false;
                }
                if (this.lastBlankLinesTokenIndex < 0) {
                    this.newline();
                }
            }
            this.indent = halfIndent;
            Diff diff5 = diff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            if (diff != null && diff.end == this.tokens.offset()) {
                String string;
                if (diff.text != null) {
                    int n = diff.text.lastIndexOf(10);
                    if (n < 0) {
                        diff.text = this.getIndent();
                    } else {
                        diff.text = diff.text.substring(0, n + 1) + this.getIndent();
                    }
                }
                String string2 = string = diff.text != null ? diff.text : this.getIndent();
                if (string.equals(this.fText.substring(diff.start, diff.end))) {
                    this.diffs.removeFirst();
                }
            } else if (this.tokens.movePrevious()) {
                if (this.tokens.token().id() == JavaTokenId.WHITESPACE) {
                    String ind;
                    String string = ((Object)this.tokens.token().text()).toString();
                    int idx = string.lastIndexOf(10);
                    if (idx >= 0) {
                        String string3 = string.substring(idx + 1);
                        ind = this.getIndent();
                        if (!ind.equals(string3)) {
                            this.addDiff(new Diff(this.tokens.offset() + idx + 1, this.tokens.offset() + this.tokens.token().length(), ind));
                        }
                    } else if (this.tokens.movePrevious()) {
                        if (this.tokens.token().id() == JavaTokenId.LINE_COMMENT) {
                            this.tokens.moveNext();
                            ind = this.getIndent();
                            if (!ind.equals(string)) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset() + this.tokens.token().length(), ind));
                            }
                        } else {
                            this.tokens.moveNext();
                        }
                    }
                }
                this.tokens.moveNext();
            }
            this.col = this.indent;
            this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitVariable(VariableTree node, Void p) {
            int old = this.indent;
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            boolean insideForOrCatch = EnumSet.of(Tree.Kind.FOR_LOOP, Tree.Kind.CATCH).contains((Object)parent.getKind());
            ModifiersTree mods = node.getModifiers();
            if (mods != null && !this.fieldGroup && this.sp.getStartPosition(this.root, mods) < this.sp.getEndPosition(this.root, mods)) {
                if (this.scan((Tree)mods, p).booleanValue()) {
                    if (!insideForOrCatch) {
                        this.indent += this.continuationIndentSize;
                        if (this.cs.placeNewLineAfterModifiers()) {
                            this.newline();
                        } else {
                            this.space();
                        }
                    } else {
                        this.space();
                    }
                } else if (this.afterAnnotation) {
                    if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) || parent.getKind() == Tree.Kind.BLOCK) {
                        switch (this.cs.wrapAnnotations()) {
                            case WRAP_ALWAYS: {
                                this.newline();
                                break;
                            }
                            case WRAP_IF_LONG: {
                                if (this.col >= this.rightMargin) {
                                    this.newline();
                                    break;
                                }
                                this.spaces(1, true);
                                break;
                            }
                            case WRAP_NEVER: {
                                this.spaces(1, true);
                            }
                        }
                    } else {
                        this.space();
                    }
                }
                this.afterAnnotation = false;
            }
            if (this.isEnumerator(node)) {
                this.accept(JavaTokenId.IDENTIFIER, new JavaTokenId[0]);
                ExpressionTree init = node.getInitializer();
                if (init != null && init.getKind() == Tree.Kind.NEW_CLASS) {
                    ClassTree body;
                    java.util.List<? extends ExpressionTree> args;
                    NewClassTree nct = (NewClassTree)init;
                    int index = this.tokens.index();
                    int c = this.col;
                    Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    this.spaces(this.cs.spaceBeforeMethodCallParen() ? 1 : 0);
                    JavaTokenId id = this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
                    if (id != JavaTokenId.LPAREN) {
                        this.rollback(index, c, d);
                    }
                    if ((args = nct.getArguments()) != null && !args.isEmpty()) {
                        this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0, true);
                        this.wrapList(this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs(), false, JavaTokenId.COMMA, args);
                        this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0);
                    }
                    if (id == JavaTokenId.LPAREN) {
                        this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
                    }
                    if ((body = nct.getClassBody()) != null) {
                        this.scan((Tree)body, p);
                    }
                }
            } else {
                ExpressionTree init;
                if (this.indent == old && !insideForOrCatch) {
                    this.indent += this.continuationIndentSize;
                }
                if (this.scan(node.getType(), p).booleanValue()) {
                    this.spaces(1, this.fieldGroup);
                    if (!ERROR.contentEquals(node.getName())) {
                        this.accept(JavaTokenId.IDENTIFIER, new JavaTokenId[0]);
                    }
                }
                if ((init = node.getInitializer()) != null) {
                    int alignIndent = -1;
                    if (this.cs.alignMultilineAssignment()) {
                        alignIndent = this.col;
                        if (!ERROR.contentEquals(node.getName())) {
                            alignIndent -= node.getName().length();
                        }
                    }
                    this.spaces(this.cs.spaceAroundAssignOps() ? 1 : 0);
                    this.accept(JavaTokenId.EQ, new JavaTokenId[0]);
                    if (init.getKind() == Tree.Kind.NEW_ARRAY && ((NewArrayTree)init).getType() == null) {
                        if (this.cs.getOtherBracePlacement() == CodeStyle.BracePlacement.SAME_LINE) {
                            this.spaces(this.cs.spaceAroundAssignOps() ? 1 : 0);
                        }
                        this.scan((Tree)init, p);
                    } else {
                        this.wrapTree(this.cs.wrapAssignOps(), alignIndent, this.cs.spaceAroundAssignOps() ? 1 : 0, init);
                    }
                }
                this.fieldGroup = this.accept(JavaTokenId.SEMICOLON, JavaTokenId.COMMA) == JavaTokenId.COMMA;
            }
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitMethod(MethodTree node, Void p) {
            Tree init;
            Tree retType;
            java.util.List<? extends TypeParameterTree> tparams;
            int old = this.indent;
            ModifiersTree mods = node.getModifiers();
            if (mods != null) {
                if (this.scan((Tree)mods, p).booleanValue()) {
                    this.indent += this.continuationIndentSize;
                    if (this.cs.placeNewLineAfterModifiers()) {
                        this.newline();
                    } else {
                        this.space();
                    }
                } else {
                    this.blankLines();
                }
                this.afterAnnotation = false;
            }
            if ((tparams = node.getTypeParameters()) != null && !tparams.isEmpty()) {
                JavaTokenId accepted;
                if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                    ++this.tpLevel;
                }
                if (this.indent == old) {
                    this.indent += this.continuationIndentSize;
                }
                Iterator<? extends TypeParameterTree> it = tparams.iterator();
                while (it.hasNext()) {
                    TypeParameterTree tparam = it.next();
                    this.scan((Tree)tparam, p);
                    if (!it.hasNext()) continue;
                    this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                    this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                    this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                }
                if (this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                    switch (accepted) {
                        case GTGTGT: {
                            this.tpLevel -= 3;
                            break;
                        }
                        case GTGT: {
                            this.tpLevel -= 2;
                            break;
                        }
                        case GT: {
                            --this.tpLevel;
                        }
                    }
                }
                this.space();
            }
            if ((retType = node.getReturnType()) != null) {
                this.scan(retType, p);
                if (this.indent == old) {
                    this.indent += this.continuationIndentSize;
                }
                this.space();
            }
            if (!ERROR.contentEquals(node.getName())) {
                this.accept(JavaTokenId.IDENTIFIER, new JavaTokenId[0]);
            }
            if (this.indent == old) {
                this.indent += this.continuationIndentSize;
            }
            this.spaces(this.cs.spaceBeforeMethodDeclParen() ? 1 : 0);
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            java.util.List<? extends VariableTree> params = node.getParameters();
            if (params != null && !params.isEmpty()) {
                this.spaces(this.cs.spaceWithinMethodDeclParens() ? 1 : 0, true);
                this.wrapList(this.cs.wrapMethodParams(), this.cs.alignMultilineMethodParams(), false, JavaTokenId.COMMA, params);
                this.spaces(this.cs.spaceWithinMethodDeclParens() ? 1 : 0);
            }
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            java.util.List<? extends ExpressionTree> threxs = node.getThrows();
            if (threxs != null && !threxs.isEmpty()) {
                this.wrapToken(this.cs.wrapThrowsKeyword(), -1, 1, JavaTokenId.THROWS, new JavaTokenId[0]);
                this.wrapList(this.cs.wrapThrowsList(), this.cs.alignMultilineThrows(), true, JavaTokenId.COMMA, threxs);
            }
            if ((init = node.getDefaultValue()) != null) {
                this.spaces(1, true);
                this.accept(JavaTokenId.DEFAULT, new JavaTokenId[0]);
                this.space();
                this.scan(init, p);
            }
            this.indent = old;
            BlockTree body = node.getBody();
            if (body != null) {
                this.scan((Tree)body, p);
            } else {
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            return true;
        }

        @Override
        public Boolean visitModifiers(ModifiersTree node, Void p) {
            boolean isStandalone;
            boolean ret = true;
            JavaTokenId id = null;
            this.afterAnnotation = false;
            Iterator<? extends AnnotationTree> annotations = node.getAnnotations().iterator();
            TreePath path = this.getCurrentPath().getParentPath();
            Tree parent = path.getLeaf();
            path = path.getParentPath();
            Tree grandParent = path.getLeaf();
            boolean bl = isStandalone = parent.getKind() != Tree.Kind.VARIABLE || TreeUtilities.CLASS_TREE_KINDS.contains((Object)grandParent.getKind()) || grandParent.getKind() == Tree.Kind.BLOCK;
            while (this.tokens.offset() < this.endPos) {
                if (this.afterAnnotation) {
                    if (!isStandalone) {
                        this.spaces(1, true);
                    } else {
                        switch (this.cs.wrapAnnotations()) {
                            case WRAP_ALWAYS: {
                                this.newline();
                                break;
                            }
                            case WRAP_IF_LONG: {
                                if (this.col >= this.rightMargin) {
                                    this.newline();
                                    break;
                                }
                                this.spaces(1, true);
                                break;
                            }
                            case WRAP_NEVER: {
                                this.spaces(1, true);
                            }
                        }
                    }
                } else if (id != null) {
                    this.space();
                }
                int index = this.tokens.index();
                int c = this.col;
                Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                int lbl = this.lastBlankLines;
                int lblti = this.lastBlankLinesTokenIndex;
                Diff lbld = this.lastBlankLinesDiff;
                id = this.accept(JavaTokenId.PRIVATE, JavaTokenId.PROTECTED, JavaTokenId.PUBLIC, JavaTokenId.STATIC, JavaTokenId.TRANSIENT, JavaTokenId.FINAL, JavaTokenId.ABSTRACT, JavaTokenId.NATIVE, JavaTokenId.VOLATILE, JavaTokenId.SYNCHRONIZED, JavaTokenId.STRICTFP, JavaTokenId.AT);
                if (id == null) break;
                if (id == JavaTokenId.AT) {
                    if (annotations.hasNext()) {
                        this.rollback(index, c, d);
                        this.lastBlankLines = lbl;
                        this.lastBlankLinesTokenIndex = lblti;
                        this.lastBlankLinesDiff = lbld;
                        boolean bl2 = this.wrapAnnotation = this.cs.wrapAnnotations() == CodeStyle.WrapStyle.WRAP_ALWAYS;
                        if (!isStandalone || !this.afterAnnotation) {
                            this.scan((Tree)annotations.next(), p);
                        } else {
                            this.wrapTree(this.cs.wrapAnnotations(), -1, 0, annotations.next());
                        }
                        this.wrapAnnotation = false;
                        this.afterAnnotation = true;
                        ret = false;
                        continue;
                    }
                    this.afterAnnotation = false;
                    ret = false;
                    continue;
                }
                this.afterAnnotation = false;
                ret = true;
            }
            return ret;
        }

        @Override
        public Boolean visitAnnotation(AnnotationTree node, Void p) {
            this.accept(JavaTokenId.AT, new JavaTokenId[0]);
            this.scan(node.getAnnotationType(), p);
            java.util.List<? extends ExpressionTree> args = node.getArguments();
            this.spaces(this.cs.spaceBeforeAnnotationParen() ? 1 : 0);
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            if (args != null && !args.isEmpty()) {
                this.spaces(this.cs.spaceWithinAnnotationParens() ? 1 : 0);
                this.wrapList(this.cs.wrapAnnotationArgs(), this.cs.alignMultilineAnnotationArgs(), false, JavaTokenId.COMMA, args);
                this.spaces(this.cs.spaceWithinAnnotationParens() ? 1 : 0);
            }
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            return true;
        }

        @Override
        public Boolean visitTypeParameter(TypeParameterTree node, Void p) {
            java.util.List<? extends Tree> bounds;
            if (!ERROR.contentEquals(node.getName())) {
                this.accept(JavaTokenId.IDENTIFIER, new JavaTokenId[0]);
            }
            if ((bounds = node.getBounds()) != null && !bounds.isEmpty()) {
                this.space();
                this.accept(JavaTokenId.EXTENDS, new JavaTokenId[0]);
                this.space();
                Iterator<? extends Tree> it = bounds.iterator();
                while (it.hasNext()) {
                    Tree bound = it.next();
                    this.scan(bound, p);
                    if (!it.hasNext()) continue;
                    this.space();
                    this.accept(JavaTokenId.AMP, new JavaTokenId[0]);
                    this.space();
                }
            }
            return true;
        }

        @Override
        public Boolean visitParameterizedType(ParameterizedTypeTree node, Void p) {
            JavaTokenId accepted;
            boolean ltRead;
            block10: {
                Diff d;
                this.scan(node.getType(), p);
                int index = this.tokens.index();
                int c = this.col;
                Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                    ++this.tpLevel;
                    ltRead = true;
                } else {
                    this.rollback(index, c, d);
                    ltRead = false;
                }
                java.util.List<? extends Tree> targs = node.getTypeArguments();
                if (targs != null && !targs.isEmpty()) {
                    Iterator<? extends Tree> it = targs.iterator();
                    Tree targ = it.hasNext() ? it.next() : null;
                    while (true) {
                        this.scan(targ, p);
                        Tree tree = targ = it.hasNext() ? it.next() : null;
                        if (targ == null) break block10;
                        if (targ.getKind() == Tree.Kind.ERRONEOUS && ((ErroneousTree)targ).getErrorTrees().isEmpty() && !it.hasNext()) break;
                        this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                        this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                        this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                    }
                    this.scan(targ, p);
                    return true;
                }
            }
            if (ltRead && this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                switch (accepted) {
                    case GTGTGT: {
                        this.tpLevel -= 3;
                        break;
                    }
                    case GTGT: {
                        this.tpLevel -= 2;
                        break;
                    }
                    case GT: {
                        --this.tpLevel;
                    }
                }
            }
            return true;
        }

        @Override
        public Boolean visitWildcard(WildcardTree node, Void p) {
            this.accept(JavaTokenId.QUESTION, new JavaTokenId[0]);
            Tree bound = node.getBound();
            if (bound != null) {
                this.space();
                this.accept(JavaTokenId.EXTENDS, JavaTokenId.SUPER);
                this.space();
                this.scan(bound, p);
            }
            return true;
        }

        @Override
        public Boolean visitBlock(BlockTree node, Void p) {
            CodeStyle.BracePlacement bracePlacement;
            if (node.isStatic()) {
                this.accept(JavaTokenId.STATIC, new JavaTokenId[0]);
            }
            boolean spaceBeforeLeftBrace = false;
            switch (this.getCurrentPath().getParentPath().getLeaf().getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    if (!node.isStatic()) break;
                    spaceBeforeLeftBrace = this.cs.spaceBeforeStaticInitLeftBrace();
                    break;
                }
                case METHOD: {
                    bracePlacement = this.cs.getMethodDeclBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeMethodDeclLeftBrace();
                    break;
                }
                case TRY: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    if (((TryTree)this.getCurrentPath().getParentPath().getLeaf()).getBlock() == node) {
                        spaceBeforeLeftBrace = this.cs.spaceBeforeTryLeftBrace();
                        break;
                    }
                    spaceBeforeLeftBrace = this.cs.spaceBeforeFinallyLeftBrace();
                    break;
                }
                case CATCH: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeCatchLeftBrace();
                    break;
                }
                case WHILE_LOOP: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeWhileLeftBrace();
                    break;
                }
                case FOR_LOOP: 
                case ENHANCED_FOR_LOOP: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeForLeftBrace();
                    break;
                }
                case DO_WHILE_LOOP: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeDoLeftBrace();
                    break;
                }
                case IF: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    if (((IfTree)this.getCurrentPath().getParentPath().getLeaf()).getThenStatement() == node) {
                        spaceBeforeLeftBrace = this.cs.spaceBeforeIfLeftBrace();
                        break;
                    }
                    spaceBeforeLeftBrace = this.cs.spaceBeforeElseLeftBrace();
                    break;
                }
                case SYNCHRONIZED: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeSynchronizedLeftBrace();
                    break;
                }
                case CASE: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = true;
                    break;
                }
                default: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                }
            }
            int old = this.indent;
            int halfIndent = this.indent;
            switch (bracePlacement) {
                case SAME_LINE: {
                    this.spaces(spaceBeforeLeftBrace ? 1 : 0, this.tokens.offset() < this.startOffset);
                    if (node instanceof FakeBlock) {
                        this.appendToDiff("{");
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.lastBlankLinesDiff = null;
                    } else {
                        this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    }
                    this.indent += this.indentSize;
                    break;
                }
                case NEW_LINE: {
                    this.newline();
                    if (node instanceof FakeBlock) {
                        this.indent += this.indentSize;
                        this.appendToDiff("{");
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.lastBlankLinesDiff = null;
                        break;
                    }
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent += this.indentSize;
                    break;
                }
                case NEW_LINE_HALF_INDENTED: {
                    this.indent += this.indentSize >> 1;
                    halfIndent = this.indent;
                    this.newline();
                    if (node instanceof FakeBlock) {
                        this.indent = old + this.indentSize;
                        this.appendToDiff("{");
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.lastBlankLinesDiff = null;
                        break;
                    }
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = old + this.indentSize;
                    break;
                }
                case NEW_LINE_INDENTED: {
                    this.indent += this.indentSize;
                    halfIndent = this.indent;
                    this.newline();
                    if (node instanceof FakeBlock) {
                        this.appendToDiff("{");
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.lastBlankLinesDiff = null;
                        break;
                    }
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                }
            }
            boolean isEmpty = true;
            for (StatementTree statementTree : node.getStatements()) {
                if (this.isSynthetic(this.getCurrentPath().getCompilationUnit(), statementTree)) continue;
                isEmpty = false;
                if (statementTree.getKind() == Tree.Kind.LABELED_STATEMENT && this.cs.absoluteLabelIndent()) {
                    int o = this.indent;
                    this.indent = 0;
                    if (node instanceof FakeBlock) {
                        this.appendToDiff(this.getNewlines(1) + this.getIndent());
                        this.col = this.indent;
                    } else {
                        this.blankLines();
                    }
                    this.indent = o;
                }
                if (node instanceof FakeBlock) {
                    this.appendToDiff(this.getNewlines(1) + this.getIndent());
                    this.col = this.indent;
                } else if (statementTree.getKind() == Tree.Kind.EMPTY_STATEMENT) {
                    this.spaces(0, true);
                } else if (!this.fieldGroup || statementTree.getKind() != Tree.Kind.VARIABLE) {
                    this.blankLines();
                }
                this.scan((Tree)statementTree, p);
            }
            if (isEmpty || this.templateEdit) {
                this.newline();
            }
            if (node instanceof FakeBlock) {
                boolean bl;
                this.indent = halfIndent;
                int i = this.tokens.index();
                boolean bl2 = true;
                block24: while (bl) {
                    switch ((JavaTokenId)this.tokens.token().id()) {
                        case WHITESPACE: {
                            if (((Object)this.tokens.token().text()).toString().indexOf(10) < 0) {
                                this.tokens.moveNext();
                                continue block24;
                            }
                            bl = false;
                            this.appendToDiff(NEWLINE);
                            this.col = 0;
                            continue block24;
                        }
                        case LINE_COMMENT: {
                            bl = false;
                        }
                        case BLOCK_COMMENT: {
                            this.tokens.moveNext();
                            continue block24;
                        }
                    }
                    if (this.tokens.index() != i) {
                        this.tokens.moveIndex(i);
                        this.tokens.moveNext();
                    }
                    bl = false;
                    this.appendToDiff(NEWLINE);
                    this.col = 0;
                }
                this.appendToDiff(this.getIndent() + "}");
                this.col = this.indent + 1;
                this.lastBlankLines = -1;
                this.lastBlankLinesTokenIndex = -1;
                this.lastBlankLinesDiff = null;
            } else {
                Diff diff;
                this.blankLines();
                this.indent = halfIndent;
                Diff diff2 = diff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                if (diff != null && diff.end == this.tokens.offset()) {
                    String string;
                    if (diff.text != null) {
                        int n = diff.text.lastIndexOf(10);
                        if (n < 0) {
                            diff.text = this.getIndent();
                        } else {
                            diff.text = diff.text.substring(0, n + 1) + this.getIndent();
                        }
                    }
                    String string2 = string = diff.text != null ? diff.text : this.getIndent();
                    if (string.equals(this.fText.substring(diff.start, diff.end))) {
                        this.diffs.removeFirst();
                    }
                } else if (this.tokens.movePrevious()) {
                    if (this.tokens.token().id() == JavaTokenId.WHITESPACE) {
                        String string = ((Object)this.tokens.token().text()).toString();
                        int idx = string.lastIndexOf(10);
                        if (idx >= 0) {
                            String string3 = string.substring(idx + 1);
                            String ind = this.getIndent();
                            if (!ind.equals(string3)) {
                                this.addDiff(new Diff(this.tokens.offset() + idx + 1, this.tokens.offset() + this.tokens.token().length(), ind));
                            }
                        } else if (this.tokens.movePrevious()) {
                            if (this.tokens.token().id() == JavaTokenId.LINE_COMMENT) {
                                this.tokens.moveNext();
                                String ind = this.getIndent();
                                if (!ind.equals(string)) {
                                    this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset() + this.tokens.token().length(), ind));
                                }
                            } else {
                                this.tokens.moveNext();
                            }
                        }
                    }
                    this.tokens.moveNext();
                }
                this.col = this.indent;
                this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
            }
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitMemberSelect(MemberSelectTree node, Void p) {
            this.scan((Tree)node.getExpression(), p);
            this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
            this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.STAR, JavaTokenId.THIS, JavaTokenId.SUPER, JavaTokenId.CLASS);
            return true;
        }

        @Override
        public Boolean visitMethodInvocation(MethodInvocationTree node, Void p) {
            ExpressionTree ms = node.getMethodSelect();
            if (ms.getKind() == Tree.Kind.MEMBER_SELECT) {
                ExpressionTree exp = ((MemberSelectTree)ms).getExpression();
                this.scan((Tree)exp, p);
                this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
                java.util.List<? extends Tree> targs = node.getTypeArguments();
                if (targs != null && !targs.isEmpty()) {
                    JavaTokenId accepted;
                    if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                        ++this.tpLevel;
                    }
                    Iterator<? extends Tree> it = targs.iterator();
                    while (it.hasNext()) {
                        Tree targ = it.next();
                        this.scan(targ, p);
                        if (!it.hasNext()) continue;
                        this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                        this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                        this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                    }
                    if (this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                        switch (accepted) {
                            case GTGTGT: {
                                this.tpLevel -= 3;
                                break;
                            }
                            case GTGT: {
                                this.tpLevel -= 2;
                                break;
                            }
                            case GT: {
                                --this.tpLevel;
                            }
                        }
                    }
                }
                CodeStyle.WrapStyle wrapStyle = this.cs.wrapChainedMethodCalls();
                if (exp.getKind() == Tree.Kind.METHOD_INVOCATION) {
                    this.wrapToken(wrapStyle, -1, 0, JavaTokenId.IDENTIFIER, JavaTokenId.THIS, JavaTokenId.SUPER);
                } else {
                    int index = this.tokens.index();
                    int c = this.col;
                    Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.THIS, JavaTokenId.SUPER);
                    if (wrapStyle != CodeStyle.WrapStyle.WRAP_NEVER && this.col > this.rightMargin && c > this.indent) {
                        this.rollback(index, c, d);
                        this.newline();
                        this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.THIS, JavaTokenId.SUPER);
                    }
                }
            } else {
                this.scan((Tree)node.getMethodSelect(), p);
            }
            this.spaces(this.cs.spaceBeforeMethodCallParen() ? 1 : 0);
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            java.util.List<? extends ExpressionTree> args = node.getArguments();
            if (args != null && !args.isEmpty()) {
                this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0, true);
                this.wrapList(this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs(), false, JavaTokenId.COMMA, args);
                this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0);
            }
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            return true;
        }

        @Override
        public Boolean visitNewClass(NewClassTree node, Void p) {
            ExpressionTree encl = node.getEnclosingExpression();
            if (encl != null) {
                this.scan((Tree)encl, p);
                this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
            }
            boolean indented = false;
            if (this.col == this.indent) {
                Diff d;
                Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                if (d != null && d.getStartOffset() == this.tokens.offset() && d.getText() != null && d.getText().indexOf(10) >= 0) {
                    indented = true;
                } else {
                    this.tokens.movePrevious();
                    if (this.tokens.token().id() == JavaTokenId.WHITESPACE && ((Object)this.tokens.token().text()).toString().indexOf(10) >= 0) {
                        indented = true;
                    }
                    this.tokens.moveNext();
                }
            }
            this.accept(JavaTokenId.NEW, new JavaTokenId[0]);
            this.space();
            java.util.List<? extends Tree> targs = node.getTypeArguments();
            if (targs != null && !targs.isEmpty()) {
                JavaTokenId accepted;
                if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                    ++this.tpLevel;
                }
                Iterator<? extends Tree> it = targs.iterator();
                while (it.hasNext()) {
                    Tree targ = it.next();
                    this.scan(targ, p);
                    if (!it.hasNext()) continue;
                    this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                    this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                    this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                }
                if (this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                    switch (accepted) {
                        case GTGTGT: {
                            this.tpLevel -= 3;
                            break;
                        }
                        case GTGT: {
                            this.tpLevel -= 2;
                            break;
                        }
                        case GT: {
                            --this.tpLevel;
                        }
                    }
                }
            }
            this.scan((Tree)node.getIdentifier(), p);
            this.spaces(this.cs.spaceBeforeMethodCallParen() ? 1 : 0);
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            java.util.List<? extends ExpressionTree> args = node.getArguments();
            if (args != null && !args.isEmpty()) {
                this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0, true);
                this.wrapList(this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs(), false, JavaTokenId.COMMA, args);
                this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0);
            }
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            ClassTree body = node.getClassBody();
            if (body != null) {
                int old = this.indent;
                if (!indented) {
                    this.indent -= this.continuationIndentSize;
                }
                this.scan((Tree)body, p);
                this.indent = old;
            }
            return true;
        }

        @Override
        public Boolean visitAssert(AssertTree node, Void p) {
            this.accept(JavaTokenId.ASSERT, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            this.space();
            this.scan((Tree)node.getCondition(), p);
            ExpressionTree detail = node.getDetail();
            if (detail != null) {
                this.spaces(this.cs.spaceBeforeColon() ? 1 : 0);
                this.accept(JavaTokenId.COLON, new JavaTokenId[0]);
                this.wrapTree(this.cs.wrapAssert(), -1, this.cs.spaceAfterColon() ? 1 : 0, detail);
            }
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitReturn(ReturnTree node, Void p) {
            this.accept(JavaTokenId.RETURN, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            ExpressionTree exp = node.getExpression();
            if (exp != null) {
                this.space();
                this.scan((Tree)exp, p);
            }
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitThrow(ThrowTree node, Void p) {
            this.accept(JavaTokenId.THROW, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            ExpressionTree exp = node.getExpression();
            if (exp != null) {
                this.space();
                this.scan((Tree)exp, p);
            }
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitTry(TryTree node, Void p) {
            this.accept(JavaTokenId.TRY, new JavaTokenId[0]);
            java.util.List<? extends Tree> res = node.getResources();
            if (res != null && !res.isEmpty()) {
                Diff d;
                int old = this.indent;
                this.indent += this.continuationIndentSize;
                this.spaces(this.cs.spaceBeforeTryParen() ? 1 : 0);
                this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
                this.spaces(this.cs.spaceWithinTryParens() ? 1 : 0, true);
                this.wrapList(this.cs.wrapTryResources(), this.cs.alignMultilineTryResources(), false, JavaTokenId.SEMICOLON, res);
                int n = this.tokens.index();
                int c = this.col;
                Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                if (this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]) == null) {
                    this.rollback(n, c, d);
                }
                this.spaces(this.cs.spaceWithinTryParens() ? 1 : 0);
                this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
                this.indent = old;
            }
            this.scan((Tree)node.getBlock(), p);
            for (CatchTree catchTree : node.getCatches()) {
                if (this.cs.placeCatchOnNewLine()) {
                    this.newline();
                } else {
                    this.spaces(this.cs.spaceBeforeCatch() ? 1 : 0);
                }
                this.scan((Tree)catchTree, p);
            }
            BlockTree finallyBlockTree = node.getFinallyBlock();
            if (finallyBlockTree != null) {
                if (this.cs.placeFinallyOnNewLine()) {
                    this.newline();
                } else {
                    this.spaces(this.cs.spaceBeforeFinally() ? 1 : 0);
                }
                this.accept(JavaTokenId.FINALLY, new JavaTokenId[0]);
                this.scan((Tree)finallyBlockTree, p);
            }
            return true;
        }

        @Override
        public Boolean visitCatch(CatchTree node, Void p) {
            this.accept(JavaTokenId.CATCH, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            this.spaces(this.cs.spaceBeforeCatchParen() ? 1 : 0);
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            this.spaces(this.cs.spaceWithinCatchParens() ? 1 : 0);
            this.scan((Tree)node.getParameter(), p);
            this.spaces(this.cs.spaceWithinCatchParens() ? 1 : 0);
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            this.indent = old;
            this.scan((Tree)node.getBlock(), p);
            return true;
        }

        public Boolean visitDisjunctiveType(DisjunctiveTypeTree node, Void p) {
            java.util.List alts = node.getTypeAlternatives();
            if (alts != null && !alts.isEmpty()) {
                this.wrapList(this.cs.wrapDisjunctiveCatchTypes(), this.cs.alignMultilineDisjunctiveCatchTypes(), false, JavaTokenId.BAR, alts);
            }
            return true;
        }

        @Override
        public Boolean visitIf(IfTree node, Void p) {
            this.accept(JavaTokenId.IF, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            this.spaces(this.cs.spaceBeforeIfParen() ? 1 : 0);
            this.scan((Tree)node.getCondition(), p);
            this.indent = old;
            StatementTree elseStat = node.getElseStatement();
            CodeStyle.BracesGenerationStyle redundantIfBraces = this.cs.redundantIfBraces();
            if (elseStat != null && redundantIfBraces == CodeStyle.BracesGenerationStyle.ELIMINATE && this.danglingElseChecker.hasDanglingElse(node.getThenStatement()) || redundantIfBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || (long)this.endOffset < this.sp.getEndPosition(this.root, node))) {
                redundantIfBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
            }
            boolean prevblock = this.wrapStatement(this.cs.wrapIfStatement(), redundantIfBraces, this.cs.spaceBeforeIfLeftBrace() ? 1 : 0, node.getThenStatement());
            if (elseStat != null) {
                if (this.cs.placeElseOnNewLine() || !prevblock) {
                    this.newline();
                } else {
                    this.spaces(this.cs.spaceBeforeElse() ? 1 : 0, this.tokens.offset() < this.startOffset);
                }
                this.accept(JavaTokenId.ELSE, new JavaTokenId[0]);
                if (elseStat.getKind() == Tree.Kind.IF && this.cs.specialElseIf()) {
                    this.space();
                    this.scan((Tree)elseStat, p);
                } else {
                    redundantIfBraces = this.cs.redundantIfBraces();
                    if (redundantIfBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || (long)this.endOffset < this.sp.getEndPosition(this.root, node))) {
                        redundantIfBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
                    }
                    this.wrapStatement(this.cs.wrapIfStatement(), redundantIfBraces, this.cs.spaceBeforeElseLeftBrace() ? 1 : 0, elseStat);
                }
                this.indent = old;
            }
            return true;
        }

        @Override
        public Boolean visitDoWhileLoop(DoWhileLoopTree node, Void p) {
            this.accept(JavaTokenId.DO, new JavaTokenId[0]);
            int old = this.indent;
            CodeStyle.BracesGenerationStyle redundantDoWhileBraces = this.cs.redundantDoWhileBraces();
            if (redundantDoWhileBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || (long)this.endOffset < this.sp.getEndPosition(this.root, node))) {
                redundantDoWhileBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
            }
            boolean prevblock = this.wrapStatement(this.cs.wrapDoWhileStatement(), redundantDoWhileBraces, this.cs.spaceBeforeDoLeftBrace() ? 1 : 0, node.getStatement());
            if (this.cs.placeWhileOnNewLine() || !prevblock) {
                this.newline();
            } else {
                this.spaces(this.cs.spaceBeforeWhile() ? 1 : 0);
            }
            this.accept(JavaTokenId.WHILE, new JavaTokenId[0]);
            this.indent += this.continuationIndentSize;
            this.spaces(this.cs.spaceBeforeWhileParen() ? 1 : 0);
            this.scan((Tree)node.getCondition(), p);
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitWhileLoop(WhileLoopTree node, Void p) {
            this.accept(JavaTokenId.WHILE, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            this.spaces(this.cs.spaceBeforeWhileParen() ? 1 : 0);
            this.scan((Tree)node.getCondition(), p);
            this.indent = old;
            CodeStyle.BracesGenerationStyle redundantWhileBraces = this.cs.redundantWhileBraces();
            if (redundantWhileBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || (long)this.endOffset < this.sp.getEndPosition(this.root, node))) {
                redundantWhileBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
            }
            this.wrapStatement(this.cs.wrapWhileStatement(), redundantWhileBraces, this.cs.spaceBeforeWhileLeftBrace() ? 1 : 0, node.getStatement());
            return true;
        }

        @Override
        public Boolean visitForLoop(ForLoopTree node, Void p) {
            this.accept(JavaTokenId.FOR, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            this.spaces(this.cs.spaceBeforeForParen() ? 1 : 0);
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            this.spaces(this.cs.spaceWithinForParens() ? 1 : 0);
            java.util.List<? extends StatementTree> inits = node.getInitializer();
            int alignIndent = -1;
            if (inits != null && !inits.isEmpty()) {
                if (this.cs.alignMultilineFor()) {
                    alignIndent = this.col;
                }
                Iterator<? extends StatementTree> it = inits.iterator();
                while (it.hasNext()) {
                    this.scan((Tree)it.next(), p);
                    if (!it.hasNext() || this.fieldGroup) continue;
                    this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                    this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                    this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                }
                this.spaces(this.cs.spaceBeforeSemi() ? 1 : 0);
            }
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            ExpressionTree cond = node.getCondition();
            if (cond != null) {
                this.wrapTree(this.cs.wrapFor(), alignIndent, this.cs.spaceAfterSemi() ? 1 : 0, cond);
                this.spaces(this.cs.spaceBeforeSemi() ? 1 : 0);
            }
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            java.util.List<? extends ExpressionStatementTree> updates = node.getUpdate();
            if (updates != null && !updates.isEmpty()) {
                boolean first = true;
                Iterator<? extends ExpressionStatementTree> it = updates.iterator();
                while (it.hasNext()) {
                    ExpressionStatementTree update = it.next();
                    if (first) {
                        this.wrapTree(this.cs.wrapFor(), alignIndent, this.cs.spaceAfterSemi() ? 1 : 0, update);
                    } else {
                        this.scan((Tree)update, p);
                    }
                    first = false;
                    if (!it.hasNext()) continue;
                    this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                    this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                    this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                }
            }
            this.spaces(this.cs.spaceWithinForParens() ? 1 : 0);
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            this.indent = old;
            CodeStyle.BracesGenerationStyle redundantForBraces = this.cs.redundantForBraces();
            if (redundantForBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || (long)this.endOffset < this.sp.getEndPosition(this.root, node))) {
                redundantForBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
            }
            this.wrapStatement(this.cs.wrapForStatement(), redundantForBraces, this.cs.spaceBeforeForLeftBrace() ? 1 : 0, node.getStatement());
            return true;
        }

        @Override
        public Boolean visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
            this.accept(JavaTokenId.FOR, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            this.spaces(this.cs.spaceBeforeForParen() ? 1 : 0);
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            this.spaces(this.cs.spaceWithinForParens() ? 1 : 0);
            int alignIndent = this.cs.alignMultilineFor() ? this.col : -1;
            this.scan((Tree)node.getVariable(), p);
            this.spaces(this.cs.spaceBeforeColon() ? 1 : 0);
            this.accept(JavaTokenId.COLON, new JavaTokenId[0]);
            this.wrapTree(this.cs.wrapFor(), alignIndent, this.cs.spaceAfterColon() ? 1 : 0, node.getExpression());
            this.spaces(this.cs.spaceWithinForParens() ? 1 : 0);
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            this.indent = old;
            CodeStyle.BracesGenerationStyle redundantForBraces = this.cs.redundantForBraces();
            if (redundantForBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || (long)this.endOffset < this.sp.getEndPosition(this.root, node))) {
                redundantForBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
            }
            this.wrapStatement(this.cs.wrapForStatement(), redundantForBraces, this.cs.spaceBeforeForLeftBrace() ? 1 : 0, node.getStatement());
            return true;
        }

        @Override
        public Boolean visitSynchronized(SynchronizedTree node, Void p) {
            this.accept(JavaTokenId.SYNCHRONIZED, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            this.spaces(this.cs.spaceBeforeSynchronizedParen() ? 1 : 0);
            this.scan((Tree)node.getExpression(), p);
            this.indent = old;
            this.scan((Tree)node.getBlock(), p);
            return true;
        }

        @Override
        public Boolean visitSwitch(SwitchTree node, Void p) {
            Diff diff;
            this.accept(JavaTokenId.SWITCH, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            this.spaces(this.cs.spaceBeforeSwitchParen() ? 1 : 0);
            this.scan((Tree)node.getExpression(), p);
            CodeStyle.BracePlacement bracePlacement = this.cs.getOtherBracePlacement();
            boolean spaceBeforeLeftBrace = this.cs.spaceBeforeSwitchLeftBrace();
            boolean indentCases = this.cs.indentCasesFromSwitch();
            int halfIndent = this.indent = old;
            switch (bracePlacement) {
                case SAME_LINE: {
                    this.spaces(spaceBeforeLeftBrace ? 1 : 0, this.tokens.offset() < this.startOffset);
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    if (!indentCases) break;
                    this.indent += this.indentSize;
                    break;
                }
                case NEW_LINE: {
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    if (!indentCases) break;
                    this.indent += this.indentSize;
                    break;
                }
                case NEW_LINE_HALF_INDENTED: {
                    this.indent += this.indentSize >> 1;
                    halfIndent = this.indent;
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    if (indentCases) {
                        this.indent = old + this.indentSize;
                        break;
                    }
                    this.indent = old;
                    break;
                }
                case NEW_LINE_INDENTED: {
                    this.indent += this.indentSize;
                    halfIndent = this.indent;
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    if (indentCases) break;
                    this.indent = old;
                }
            }
            for (CaseTree caseTree : node.getCases()) {
                this.blankLines();
                this.scan((Tree)caseTree, p);
            }
            this.blankLines();
            this.indent = halfIndent;
            Diff diff2 = diff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            if (diff != null && diff.end == this.tokens.offset()) {
                String string;
                if (diff.text != null) {
                    int n = diff.text.lastIndexOf(10);
                    if (n < 0) {
                        diff.text = this.getIndent();
                    } else {
                        diff.text = diff.text.substring(0, n + 1) + this.getIndent();
                    }
                }
                String string2 = string = diff.text != null ? diff.text : this.getIndent();
                if (string.equals(this.fText.substring(diff.start, diff.end))) {
                    this.diffs.removeFirst();
                }
            } else if (this.tokens.movePrevious()) {
                String string;
                int idx;
                if (this.tokens.token().id() == JavaTokenId.WHITESPACE && (idx = (string = ((Object)this.tokens.token().text()).toString()).lastIndexOf(10)) >= 0) {
                    String string3 = string.substring(idx + 1);
                    String ind = this.getIndent();
                    if (!ind.equals(string3)) {
                        this.addDiff(new Diff(this.tokens.offset() + idx + 1, this.tokens.offset() + this.tokens.token().length(), ind));
                    }
                }
                this.tokens.moveNext();
            }
            this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitCase(CaseTree node, Void p) {
            ExpressionTree exp = node.getExpression();
            if (exp != null) {
                this.accept(JavaTokenId.CASE, new JavaTokenId[0]);
                this.space();
                this.scan((Tree)exp, p);
            } else {
                this.accept(JavaTokenId.DEFAULT, new JavaTokenId[0]);
            }
            this.accept(JavaTokenId.COLON, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.indentSize;
            for (StatementTree statementTree : node.getStatements()) {
                if (statementTree.getKind() == Tree.Kind.BLOCK) {
                    this.indent = old;
                    this.scan((Tree)statementTree, p);
                    continue;
                }
                this.blankLines();
                this.scan((Tree)statementTree, p);
            }
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitBreak(BreakTree node, Void p) {
            this.accept(JavaTokenId.BREAK, new JavaTokenId[0]);
            Name label = node.getLabel();
            if (label != null) {
                this.space();
                this.accept(JavaTokenId.IDENTIFIER, new JavaTokenId[0]);
            }
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            return true;
        }

        @Override
        public Boolean visitContinue(ContinueTree node, Void p) {
            this.accept(JavaTokenId.CONTINUE, new JavaTokenId[0]);
            Name label = node.getLabel();
            if (label != null) {
                this.space();
                this.accept(JavaTokenId.IDENTIFIER, new JavaTokenId[0]);
            }
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            return true;
        }

        @Override
        public Boolean visitAssignment(AssignmentTree node, Void p) {
            int alignIndent = this.cs.alignMultilineAssignment() ? this.col : -1;
            boolean b = this.scan((Tree)node.getVariable(), p);
            if (b || this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
                this.spaces(this.cs.spaceAroundAssignOps() ? 1 : 0);
                this.accept(JavaTokenId.EQ, new JavaTokenId[0]);
                ExpressionTree expr = node.getExpression();
                if (expr.getKind() == Tree.Kind.NEW_ARRAY && ((NewArrayTree)expr).getType() == null) {
                    if (this.cs.getOtherBracePlacement() == CodeStyle.BracePlacement.SAME_LINE) {
                        this.spaces(this.cs.spaceAroundAssignOps() ? 1 : 0);
                    }
                    this.scan((Tree)expr, p);
                } else if (this.wrapAnnotation && expr.getKind() == Tree.Kind.ANNOTATION) {
                    this.wrapTree(CodeStyle.WrapStyle.WRAP_ALWAYS, alignIndent, this.cs.spaceAroundAssignOps() ? 1 : 0, expr);
                } else {
                    this.wrapTree(this.cs.wrapAssignOps(), alignIndent, this.cs.spaceAroundAssignOps() ? 1 : 0, expr);
                }
            } else {
                this.scan((Tree)node.getExpression(), p);
            }
            return true;
        }

        @Override
        public Boolean visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
            int alignIndent = this.cs.alignMultilineAssignment() ? this.col : -1;
            this.scan((Tree)node.getVariable(), p);
            this.spaces(this.cs.spaceAroundAssignOps() ? 1 : 0);
            if (OPERATOR.equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                this.col += this.tokens.token().length();
                this.lastBlankLines = -1;
                this.lastBlankLinesTokenIndex = -1;
                this.lastBlankLinesDiff = null;
                this.tokens.moveNext();
            }
            this.wrapTree(this.cs.wrapAssignOps(), alignIndent, this.cs.spaceAroundAssignOps() ? 1 : 0, node.getExpression());
            return true;
        }

        @Override
        public Boolean visitPrimitiveType(PrimitiveTypeTree node, Void p) {
            switch (node.getPrimitiveTypeKind()) {
                case BOOLEAN: {
                    this.accept(JavaTokenId.BOOLEAN, new JavaTokenId[0]);
                    break;
                }
                case BYTE: {
                    this.accept(JavaTokenId.BYTE, new JavaTokenId[0]);
                    break;
                }
                case CHAR: {
                    this.accept(JavaTokenId.CHAR, new JavaTokenId[0]);
                    break;
                }
                case DOUBLE: {
                    this.accept(JavaTokenId.DOUBLE, new JavaTokenId[0]);
                    break;
                }
                case FLOAT: {
                    this.accept(JavaTokenId.FLOAT, new JavaTokenId[0]);
                    break;
                }
                case INT: {
                    this.accept(JavaTokenId.INT, new JavaTokenId[0]);
                    break;
                }
                case LONG: {
                    this.accept(JavaTokenId.LONG, new JavaTokenId[0]);
                    break;
                }
                case SHORT: {
                    this.accept(JavaTokenId.SHORT, new JavaTokenId[0]);
                    break;
                }
                case VOID: {
                    this.accept(JavaTokenId.VOID, new JavaTokenId[0]);
                }
            }
            return true;
        }

        @Override
        public Boolean visitArrayType(ArrayTypeTree node, Void p) {
            boolean ret = this.scan(node.getType(), p);
            int index = this.tokens.index();
            int c = this.col;
            Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            JavaTokenId id = this.accept(JavaTokenId.LBRACKET, JavaTokenId.ELLIPSIS, JavaTokenId.IDENTIFIER);
            if (id == JavaTokenId.ELLIPSIS) {
                return ret;
            }
            if (id != JavaTokenId.IDENTIFIER) {
                this.accept(JavaTokenId.RBRACKET, new JavaTokenId[0]);
                return ret;
            }
            this.rollback(index, c, d);
            this.spaces(1, this.fieldGroup);
            this.accept(JavaTokenId.IDENTIFIER, new JavaTokenId[0]);
            this.accept(JavaTokenId.LBRACKET, new JavaTokenId[0]);
            this.accept(JavaTokenId.RBRACKET, new JavaTokenId[0]);
            return false;
        }

        @Override
        public Boolean visitArrayAccess(ArrayAccessTree node, Void p) {
            this.scan((Tree)node.getExpression(), p);
            this.accept(JavaTokenId.LBRACKET, new JavaTokenId[0]);
            this.scan((Tree)node.getIndex(), p);
            this.accept(JavaTokenId.RBRACKET, new JavaTokenId[0]);
            return true;
        }

        @Override
        public Boolean visitNewArray(NewArrayTree node, Void p) {
            Tree type = node.getType();
            java.util.List<? extends ExpressionTree> inits = node.getInitializers();
            if (type != null) {
                int n;
                this.accept(JavaTokenId.NEW, new JavaTokenId[0]);
                this.space();
                int n2 = n = inits != null ? 1 : 0;
                while (type.getKind() == Tree.Kind.ARRAY_TYPE) {
                    ++n;
                    type = ((ArrayTypeTree)type).getType();
                }
                this.scan(type, p);
                for (ExpressionTree expressionTree : node.getDimensions()) {
                    this.accept(JavaTokenId.LBRACKET, new JavaTokenId[0]);
                    this.spaces(this.cs.spaceWithinArrayInitBrackets() ? 1 : 0);
                    this.scan((Tree)expressionTree, p);
                    this.spaces(this.cs.spaceWithinArrayInitBrackets() ? 1 : 0);
                    this.accept(JavaTokenId.RBRACKET, new JavaTokenId[0]);
                }
                while (--n >= 0) {
                    this.accept(JavaTokenId.LBRACKET, new JavaTokenId[0]);
                    this.accept(JavaTokenId.RBRACKET, new JavaTokenId[0]);
                }
            }
            if (inits != null) {
                boolean afterNewline;
                CodeStyle.BracePlacement bracePlacement = this.cs.getOtherBracePlacement();
                boolean spaceBeforeLeftBrace = this.cs.spaceBeforeArrayInitLeftBrace();
                int n = this.indent;
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                switch (parent.getKind()) {
                    case ASSIGNMENT: {
                        Tree grandParent = this.getCurrentPath().getParentPath().getParentPath().getLeaf();
                        if (grandParent.getKind() == Tree.Kind.ANNOTATION) break;
                    }
                    case VARIABLE: 
                    case METHOD: {
                        this.indent -= this.continuationIndentSize;
                    }
                }
                int old = this.indent;
                int halfIndent = this.indent;
                switch (bracePlacement) {
                    case SAME_LINE: {
                        if (type != null) {
                            this.spaces(spaceBeforeLeftBrace ? 1 : 0, this.tokens.offset() < this.startOffset);
                        }
                        this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                        this.indent += this.indentSize;
                        break;
                    }
                    case NEW_LINE: {
                        this.newline();
                        this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                        this.indent += this.indentSize;
                        break;
                    }
                    case NEW_LINE_HALF_INDENTED: {
                        this.indent += this.indentSize >> 1;
                        halfIndent = this.indent;
                        this.newline();
                        this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                        this.indent = old + this.indentSize;
                        break;
                    }
                    case NEW_LINE_INDENTED: {
                        this.indent += this.indentSize;
                        halfIndent = this.indent;
                        this.newline();
                        this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    }
                }
                boolean bl = afterNewline = bracePlacement != CodeStyle.BracePlacement.SAME_LINE;
                if (!inits.isEmpty()) {
                    Diff d;
                    if (afterNewline) {
                        this.newline();
                    } else {
                        this.spaces(this.cs.spaceWithinBraces() ? 1 : 0, true);
                    }
                    this.wrapList(this.cs.wrapArrayInit(), this.cs.alignMultilineArrayInit(), false, JavaTokenId.COMMA, inits);
                    if (((Object)this.tokens.token().text()).toString().indexOf(10) >= 0) {
                        afterNewline = true;
                    }
                    int index = this.tokens.index();
                    int c = this.col;
                    Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    if (this.accept(JavaTokenId.COMMA, new JavaTokenId[0]) == null) {
                        this.rollback(index, c, d);
                    }
                    this.indent -= this.indentSize;
                    if (afterNewline) {
                        this.newline();
                    } else {
                        this.spaces(this.cs.spaceWithinBraces() ? 1 : 0);
                    }
                } else if (afterNewline) {
                    this.newline();
                }
                this.indent = halfIndent;
                if (afterNewline) {
                    Diff diff;
                    Diff diff2 = diff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    if (diff != null && diff.end == this.tokens.offset()) {
                        String spaces;
                        if (diff.text != null) {
                            int idx = diff.text.lastIndexOf(10);
                            if (idx < 0) {
                                diff.text = this.getIndent();
                            } else {
                                diff.text = diff.text.substring(0, idx + 1) + this.getIndent();
                            }
                        }
                        String string = spaces = diff.text != null ? diff.text : this.getIndent();
                        if (spaces.equals(this.fText.substring(diff.start, diff.end))) {
                            this.diffs.removeFirst();
                        }
                    } else if (this.tokens.movePrevious()) {
                        String text;
                        int idx;
                        if (this.tokens.token().id() == JavaTokenId.WHITESPACE && (idx = (text = ((Object)this.tokens.token().text()).toString()).lastIndexOf(10)) >= 0) {
                            text = text.substring(idx + 1);
                            String ind = this.getIndent();
                            if (!ind.equals(text)) {
                                this.addDiff(new Diff(this.tokens.offset() + idx + 1, this.tokens.offset() + this.tokens.token().length(), ind));
                            }
                        }
                        this.tokens.moveNext();
                    }
                }
                this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
                this.indent = n;
            }
            return true;
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree node, Void p) {
            this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.THIS, JavaTokenId.SUPER);
            return true;
        }

        @Override
        public Boolean visitUnary(UnaryTree node, Void p) {
            JavaTokenId id = (JavaTokenId)this.tokens.token().id();
            if (OPERATOR.equals(id.primaryCategory())) {
                this.spaces(this.cs.spaceAroundUnaryOps() ? 1 : 0);
                this.col += this.tokens.token().length();
                this.lastBlankLines = -1;
                this.lastBlankLinesTokenIndex = -1;
                this.lastBlankLinesDiff = null;
                this.tokens.moveNext();
                int index = this.tokens.index();
                int c = this.col;
                Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                this.spaces(this.cs.spaceAroundUnaryOps() ? 1 : 0);
                if (this.tokens.token().id() == id) {
                    this.rollback(index, c, d);
                    this.space();
                }
                this.scan((Tree)node.getExpression(), p);
            } else {
                this.scan((Tree)node.getExpression(), p);
                this.spaces(this.cs.spaceAroundUnaryOps() ? 1 : 0);
                this.col += this.tokens.token().length();
                this.lastBlankLines = -1;
                this.lastBlankLinesTokenIndex = -1;
                this.lastBlankLinesDiff = null;
                this.tokens.moveNext();
                this.spaces(this.cs.spaceAroundUnaryOps() ? 1 : 0);
            }
            return true;
        }

        @Override
        public Boolean visitBinary(BinaryTree node, Void p) {
            int alignIndent = this.cs.alignMultilineBinaryOp() ? this.col : -1;
            this.scan((Tree)node.getLeftOperand(), p);
            if (this.cs.wrapAfterBinaryOps()) {
                this.spaces(this.cs.spaceAroundBinaryOps() ? 1 : 0);
                if (OPERATOR.equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                    this.col += this.tokens.token().length();
                    this.lastBlankLines = -1;
                    this.lastBlankLinesTokenIndex = -1;
                    this.tokens.moveNext();
                }
                this.wrapTree(this.cs.wrapBinaryOps(), alignIndent, this.cs.spaceAroundBinaryOps() ? 1 : 0, node.getRightOperand());
            } else {
                this.wrapOperatorAndTree(this.cs.wrapBinaryOps(), alignIndent, this.cs.spaceAroundBinaryOps() ? 1 : 0, node.getRightOperand());
            }
            return true;
        }

        @Override
        public Boolean visitConditionalExpression(ConditionalExpressionTree node, Void p) {
            int alignIndent = this.cs.alignMultilineTernaryOp() ? this.col : -1;
            this.scan((Tree)node.getCondition(), p);
            if (this.cs.wrapAfterTernaryOps()) {
                this.spaces(this.cs.spaceAroundTernaryOps() ? 1 : 0);
                this.accept(JavaTokenId.QUESTION, new JavaTokenId[0]);
                this.wrapTree(this.cs.wrapTernaryOps(), alignIndent, this.cs.spaceAroundTernaryOps() ? 1 : 0, node.getTrueExpression());
                this.spaces(this.cs.spaceAroundTernaryOps() ? 1 : 0);
                this.accept(JavaTokenId.COLON, new JavaTokenId[0]);
                this.wrapTree(this.cs.wrapTernaryOps(), alignIndent, this.cs.spaceAroundTernaryOps() ? 1 : 0, node.getFalseExpression());
            } else {
                this.wrapOperatorAndTree(this.cs.wrapTernaryOps(), alignIndent, this.cs.spaceAroundTernaryOps() ? 1 : 0, node.getTrueExpression());
                this.wrapOperatorAndTree(this.cs.wrapTernaryOps(), alignIndent, this.cs.spaceAroundTernaryOps() ? 1 : 0, node.getFalseExpression());
            }
            return true;
        }

        @Override
        public Boolean visitEmptyStatement(EmptyStatementTree node, Void p) {
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            return true;
        }

        @Override
        public Boolean visitExpressionStatement(ExpressionStatementTree node, Void p) {
            int old = this.indent;
            this.indent += this.continuationIndentSize;
            this.scan((Tree)node.getExpression(), p);
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitInstanceOf(InstanceOfTree node, Void p) {
            this.scan((Tree)node.getExpression(), p);
            this.space();
            this.accept(JavaTokenId.INSTANCEOF, new JavaTokenId[0]);
            this.space();
            this.scan(node.getType(), p);
            return true;
        }

        @Override
        public Boolean visitLabeledStatement(LabeledStatementTree node, Void p) {
            if (!ERROR.contentEquals(node.getLabel())) {
                this.accept(JavaTokenId.IDENTIFIER, new JavaTokenId[0]);
            }
            this.accept(JavaTokenId.COLON, new JavaTokenId[0]);
            int old = this.indent;
            this.indent += this.cs.getLabelIndent();
            int cnt = this.indent - this.col;
            if (cnt < 0) {
                this.newline();
            } else {
                this.spaces(cnt);
            }
            this.scan((Tree)node.getStatement(), p);
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitTypeCast(TypeCastTree node, Void p) {
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            boolean spaceWithinParens = this.cs.spaceWithinTypeCastParens();
            this.spaces(spaceWithinParens ? 1 : 0);
            this.scan(node.getType(), p);
            this.spaces(spaceWithinParens ? 1 : 0);
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            this.spaces(this.cs.spaceAfterTypeCast() ? 1 : 0);
            this.scan((Tree)node.getExpression(), p);
            return true;
        }

        @Override
        public Boolean visitParenthesized(ParenthesizedTree node, Void p) {
            boolean spaceWithinParens;
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            int old = this.indent;
            switch (this.getCurrentPath().getParentPath().getLeaf().getKind()) {
                case IF: {
                    spaceWithinParens = this.cs.spaceWithinIfParens();
                    break;
                }
                case FOR_LOOP: {
                    spaceWithinParens = this.cs.spaceWithinForParens();
                    break;
                }
                case WHILE_LOOP: 
                case DO_WHILE_LOOP: {
                    spaceWithinParens = this.cs.spaceWithinWhileParens();
                    break;
                }
                case SWITCH: {
                    spaceWithinParens = this.cs.spaceWithinSwitchParens();
                    break;
                }
                case SYNCHRONIZED: {
                    spaceWithinParens = this.cs.spaceWithinSynchronizedParens();
                    break;
                }
                default: {
                    spaceWithinParens = this.cs.spaceWithinParens();
                    if (!this.cs.alignMultilineParenthesized()) break;
                    this.indent = this.col;
                }
            }
            this.spaces(spaceWithinParens ? 1 : 0);
            this.scan((Tree)node.getExpression(), p);
            this.spaces(spaceWithinParens ? 1 : 0);
            this.indent = old;
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            return true;
        }

        @Override
        public Boolean visitLiteral(LiteralTree node, Void p) {
            do {
                this.col += this.tokens.token().length();
            } while (this.tokens.moveNext() && this.tokens.offset() < this.endPos);
            this.lastBlankLines = -1;
            this.lastBlankLinesTokenIndex = -1;
            this.lastBlankLinesDiff = null;
            return true;
        }

        @Override
        public Boolean visitErroneous(ErroneousTree node, Void p) {
            for (Tree tree : node.getErrorTrees()) {
                int pos = (int)this.sp.getStartPosition(this.getCurrentPath().getCompilationUnit(), tree);
                while (this.tokens.offset() < pos) {
                    this.col += this.tokens.token().length();
                    if (this.tokens.moveNext()) continue;
                }
                this.lastBlankLines = -1;
                this.lastBlankLinesTokenIndex = -1;
                this.lastBlankLinesDiff = null;
                this.scan(tree, p);
            }
            while (this.tokens.offset() < this.endPos) {
                int len = this.tokens.token().length();
                if (this.tokens.token().id() == JavaTokenId.WHITESPACE && this.tokens.offset() + len >= this.endPos) break;
                this.col += len;
                if (this.tokens.moveNext()) continue;
            }
            this.lastBlankLines = -1;
            this.lastBlankLinesTokenIndex = -1;
            this.lastBlankLinesDiff = null;
            return true;
        }

        @Override
        public Boolean visitOther(Tree node, Void p) {
            do {
                this.col += this.tokens.token().length();
            } while (this.tokens.moveNext() && this.tokens.offset() < this.endPos);
            this.lastBlankLines = -1;
            this.lastBlankLinesTokenIndex = -1;
            this.lastBlankLinesDiff = null;
            return true;
        }

        private JavaTokenId accept(JavaTokenId first, JavaTokenId ... rest) {
            this.lastBlankLines = -1;
            this.lastBlankLinesTokenIndex = -1;
            this.lastBlankLinesDiff = null;
            EnumSet<JavaTokenId[]> tokenIds = EnumSet.of(first, rest);
            Token lastWSToken = null;
            int after = 0;
            do {
                String spaces;
                if (this.tokens.offset() >= this.endPos) {
                    if (lastWSToken != null) {
                        this.lastBlankLines = 0;
                        this.lastBlankLinesTokenIndex = this.tokens.index() - 1;
                        this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    }
                    return null;
                }
                JavaTokenId id = (JavaTokenId)this.tokens.token().id();
                if (tokenIds.contains(id)) {
                    String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                    if (lastWSToken != null) {
                        if (spaces == null || !spaces.contentEquals(lastWSToken.text())) {
                            this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                        }
                    } else if (spaces != null && spaces.length() > 0) {
                        this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                    }
                    if (after > 0) {
                        this.col = this.indent;
                    }
                    this.col += this.tokens.token().length();
                    return this.tokens.moveNext() ? id : null;
                }
                switch (id) {
                    case WHITESPACE: {
                        lastWSToken = this.tokens.token();
                        break;
                    }
                    case LINE_COMMENT: {
                        if (lastWSToken != null) {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                            lastWSToken = null;
                        } else {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces != null && spaces.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                            }
                        }
                        this.col = 0;
                        after = 1;
                        break;
                    }
                    case JAVADOC_COMMENT: {
                        if (lastWSToken != null) {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                            lastWSToken = null;
                            this.col = after > 0 ? this.indent : ++this.col;
                        } else {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces != null && spaces.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                            }
                            if (after > 0) {
                                this.col = this.indent;
                            }
                        }
                        String tokenText = ((Object)this.tokens.token().text()).toString();
                        int idx = tokenText.lastIndexOf(10);
                        if (idx >= 0) {
                            tokenText = tokenText.substring(idx + 1);
                        }
                        this.col += this.getCol(tokenText);
                        this.indentComment();
                        after = 2;
                        break;
                    }
                    case BLOCK_COMMENT: {
                        String spaces2;
                        if (lastWSToken != null) {
                            String string = after == 1 ? this.getIndent() : (spaces2 = after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            if (!spaces2.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces2));
                            }
                            lastWSToken = null;
                            this.col = after > 0 ? this.indent : ++this.col;
                        } else {
                            String string = after == 1 ? this.getIndent() : (spaces2 = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces2 != null && spaces2.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces2));
                            }
                            if (after > 0) {
                                this.col = this.indent;
                            }
                        }
                        String tokenText = ((Object)this.tokens.token().text()).toString();
                        int idx = tokenText.lastIndexOf(10);
                        if (idx >= 0) {
                            tokenText = tokenText.substring(idx + 1);
                        }
                        this.col += this.getCol(tokenText);
                        this.indentComment();
                        after = 0;
                        break;
                    }
                    default: {
                        if (lastWSToken != null) {
                            this.lastBlankLines = -1;
                            this.lastBlankLinesTokenIndex = this.tokens.index() - 1;
                            this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                        }
                        return null;
                    }
                }
            } while (this.tokens.moveNext());
            return null;
        }

        private void space() {
            this.spaces(1);
        }

        private void spaces(int count) {
            this.spaces(count, false);
        }

        private boolean spaces(int count, boolean preserveNewline) {
            Token lastWSToken = null;
            boolean containedNewLine = false;
            int after = 0;
            do {
                if (this.tokens.offset() >= this.endPos) {
                    return containedNewLine;
                }
                switch ((JavaTokenId)this.tokens.token().id()) {
                    case WHITESPACE: {
                        lastWSToken = this.tokens.token();
                        break;
                    }
                    case LINE_COMMENT: {
                        String text;
                        String spaces;
                        if (lastWSToken != null) {
                            spaces = after == 1 ? this.getIndent() : (after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            text = ((Object)lastWSToken.text()).toString();
                            int idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                containedNewLine = true;
                                if (preserveNewline) {
                                    spaces = this.getNewlines(1) + this.getIndent();
                                    this.lastBlankLines = 1;
                                    this.lastBlankLinesTokenIndex = this.tokens.index();
                                    Diff diff = this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                }
                            }
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                            lastWSToken = null;
                        } else {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces != null && spaces.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                            }
                        }
                        this.col = 0;
                        after = 1;
                        break;
                    }
                    case JAVADOC_COMMENT: {
                        String text;
                        String spaces;
                        if (lastWSToken != null) {
                            spaces = after == 1 ? this.getIndent() : (after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            text = ((Object)lastWSToken.text()).toString();
                            int idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                containedNewLine = true;
                                if (preserveNewline) {
                                    spaces = this.getNewlines(1) + this.getIndent();
                                    after = 3;
                                    this.lastBlankLines = 1;
                                    this.lastBlankLinesTokenIndex = this.tokens.index();
                                    Diff diff = this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                }
                            }
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                            lastWSToken = null;
                            this.col = after > 0 ? this.indent : ++this.col;
                        } else {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces != null && spaces.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                            }
                            if (after > 0) {
                                this.col = this.indent;
                            }
                        }
                        String tokenText = ((Object)this.tokens.token().text()).toString();
                        int idx = tokenText.lastIndexOf(10);
                        if (idx >= 0) {
                            tokenText = tokenText.substring(idx + 1);
                        }
                        this.col += this.getCol(tokenText);
                        this.indentComment();
                        after = 2;
                        break;
                    }
                    case BLOCK_COMMENT: {
                        String text;
                        String spaces;
                        if (lastWSToken != null) {
                            spaces = after == 1 ? this.getIndent() : (after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            text = ((Object)lastWSToken.text()).toString();
                            int idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                containedNewLine = true;
                                if (preserveNewline) {
                                    spaces = this.getNewlines(1) + this.getIndent();
                                    after = 3;
                                    this.lastBlankLines = 1;
                                    this.lastBlankLinesTokenIndex = this.tokens.index();
                                    Diff diff = this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                }
                            }
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                            lastWSToken = null;
                            this.col = after > 0 ? this.indent : ++this.col;
                        } else {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces != null && spaces.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                            }
                            if (after > 0) {
                                this.col = this.indent;
                            }
                        }
                        String tokenText = ((Object)this.tokens.token().text()).toString();
                        int idx = tokenText.lastIndexOf(10);
                        if (idx >= 0) {
                            tokenText = tokenText.substring(idx + 1);
                        }
                        this.col += this.getCol(tokenText);
                        this.indentComment();
                        after = 0;
                        break;
                    }
                    default: {
                        String spaces;
                        String text;
                        String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : this.getSpaces(count));
                        if (lastWSToken != null) {
                            text = ((Object)lastWSToken.text()).toString();
                            int idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                containedNewLine = true;
                                if (preserveNewline) {
                                    spaces = this.getNewlines(1) + this.getIndent();
                                    after = 3;
                                    this.lastBlankLines = 1;
                                    this.lastBlankLinesTokenIndex = this.tokens.index();
                                    Diff diff = this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                }
                            }
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                        } else if (spaces.length() > 0) {
                            this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                        }
                        this.col = after > 0 ? this.indent : (this.col += count);
                        return containedNewLine;
                    }
                }
            } while (this.tokens.moveNext());
            return containedNewLine;
        }

        private void newline() {
            this.blankLines(this.templateEdit ? -1 : 0);
        }

        private void blankLines() {
            this.blankLines(-1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void blankLines(int count) {
            if (count >= 0) {
                if (this.lastBlankLinesTokenIndex < 0) {
                    this.lastBlankLines = count;
                    this.lastBlankLinesTokenIndex = this.tokens.index();
                    this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                } else {
                    if (this.lastBlankLines >= count) return;
                    this.lastBlankLines = count;
                    this.rollback(this.lastBlankLinesTokenIndex, this.lastBlankLinesTokenIndex, this.lastBlankLinesDiff);
                }
            } else {
                if (this.lastBlankLinesTokenIndex >= 0) return;
                this.lastBlankLinesTokenIndex = this.tokens.index();
                this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            }
            Token lastToken = null;
            int after = 0;
            do {
                if (this.tokens.offset() >= this.endPos) {
                    return;
                }
                switch ((JavaTokenId)this.tokens.token().id()) {
                    case WHITESPACE: {
                        lastToken = this.tokens.token();
                        break;
                    }
                    case BLOCK_COMMENT: {
                        String indent;
                        int lastIdx;
                        int idx;
                        String text;
                        int offset;
                        if (count >= 0 && this.tokens.index() > 1 && after != 1) {
                            ++count;
                        }
                        if (lastToken != null) {
                            offset = this.tokens.offset() - lastToken.length();
                            text = ((Object)lastToken.text()).toString();
                            idx = 0;
                            lastIdx = 0;
                            while (count != 0 && (idx = text.indexOf(10, lastIdx)) >= 0) {
                                if (idx > lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx, null));
                                }
                                lastIdx = idx + 1;
                                --count;
                            }
                            idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                if (idx > lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx + 1, null));
                                }
                                lastIdx = idx + 1;
                            }
                            if (lastIdx > 0 && !(indent = this.getIndent()).contentEquals(text.substring(lastIdx))) {
                                this.addDiff(new Diff(offset + lastIdx, this.tokens.offset(), indent));
                            }
                            lastToken = null;
                        }
                        this.indentComment();
                        after = 3;
                        break;
                    }
                    case JAVADOC_COMMENT: {
                        String indent;
                        int lastIdx;
                        int idx;
                        String text;
                        int offset;
                        if (count >= 0 && this.tokens.index() > 1 && after != 1) {
                            ++count;
                        }
                        if (lastToken != null) {
                            offset = this.tokens.offset() - lastToken.length();
                            text = ((Object)lastToken.text()).toString();
                            idx = 0;
                            lastIdx = 0;
                            while (count != 0 && (idx = text.indexOf(10, lastIdx)) >= 0) {
                                if (idx > lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx, null));
                                }
                                lastIdx = idx + 1;
                                --count;
                            }
                            idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                after = 0;
                                if (idx >= lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx + 1, null));
                                }
                                lastIdx = idx + 1;
                            }
                            if (lastIdx == 0 && count < 0 && after != 1) {
                                count = count == -1 ? 1 : 0;
                            }
                            String string = indent = after == 3 ? SPACE : this.getNewlines(count) + this.getIndent();
                            if (!indent.contentEquals(text.substring(lastIdx))) {
                                this.addDiff(new Diff(offset + lastIdx, this.tokens.offset(), indent));
                            }
                            lastToken = null;
                        } else {
                            String text2;
                            if (this.lastBlankLines < 0 && count == -1) {
                                this.lastBlankLines = 1;
                                count = 1;
                            }
                            if ((text2 = this.getNewlines(count) + this.getIndent()).length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), text2));
                            }
                        }
                        this.indentComment();
                        count = 0;
                        after = 2;
                        break;
                    }
                    case LINE_COMMENT: {
                        String indent;
                        int lastIdx;
                        int idx;
                        String text;
                        int offset;
                        if (lastToken != null) {
                            offset = this.tokens.offset() - lastToken.length();
                            text = ((Object)lastToken.text()).toString();
                            if (count >= 0 && this.tokens.index() > 1 && after != 1 && text.indexOf(10) >= 0) {
                                ++count;
                            }
                            idx = 0;
                            lastIdx = 0;
                            while (count != 0 && (idx = text.indexOf(10, lastIdx)) >= 0) {
                                if (idx > lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx, null));
                                }
                                lastIdx = idx + 1;
                                --count;
                            }
                            idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                if (idx >= lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx + 1, null));
                                }
                                lastIdx = idx + 1;
                            }
                            if (lastIdx == 0 && after == 1) {
                                indent = this.getIndent();
                                if (!indent.contentEquals(text)) {
                                    this.addDiff(new Diff(offset, this.tokens.offset(), indent));
                                }
                            } else if (lastIdx > 0 && lastIdx < lastToken.length() && !(indent = this.getIndent()).contentEquals(text.substring(lastIdx))) {
                                this.addDiff(new Diff(offset + lastIdx, this.tokens.offset(), indent));
                            }
                            lastToken = null;
                        }
                        after = 1;
                        break;
                    }
                    default: {
                        String indent;
                        int lastIdx;
                        int idx;
                        String text;
                        int offset;
                        if (count >= 0 && this.tokens.index() > 1 && after != 1) {
                            ++count;
                        }
                        if (lastToken != null) {
                            offset = this.tokens.offset() - lastToken.length();
                            text = ((Object)lastToken.text()).toString();
                            idx = 0;
                            lastIdx = 0;
                            while (count != 0 && (idx = text.indexOf(10, lastIdx)) >= 0) {
                                if (idx > 0) {
                                    if (this.templateEdit && idx >= lastIdx) {
                                        this.addDiff(new Diff(offset + lastIdx, offset + idx, this.getIndent()));
                                    } else if (idx > lastIdx) {
                                        this.addDiff(new Diff(offset + lastIdx, offset + idx, null));
                                    }
                                }
                                lastIdx = idx + 1;
                                --count;
                            }
                            idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                after = 0;
                                if (idx >= lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx + 1, null));
                                }
                                lastIdx = idx + 1;
                            }
                            if (lastIdx == 0 && count < 0 && after != 1) {
                                count = count == -1 ? 1 : 0;
                            }
                            String string = indent = after == 3 ? SPACE : this.getNewlines(count) + this.getIndent();
                            if (!indent.contentEquals(text.substring(lastIdx))) {
                                this.addDiff(new Diff(offset + lastIdx, this.tokens.offset(), indent));
                            }
                        } else {
                            String text3;
                            if (this.lastBlankLines < 0 && count == -1) {
                                this.lastBlankLines = 1;
                                count = 1;
                            }
                            String string = text3 = after == 1 ? this.getIndent() : this.getNewlines(count) + this.getIndent();
                            if (text3.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), text3));
                            }
                        }
                        this.col = this.indent;
                        return;
                    }
                }
            } while (this.tokens.moveNext());
        }

        private void rollback(int index, int col, Diff diff) {
            this.tokens.moveIndex(index);
            this.tokens.moveNext();
            if (diff == null) {
                this.diffs.clear();
            } else {
                while (!this.diffs.isEmpty() && this.diffs.getFirst() != diff) {
                    this.diffs.removeFirst();
                }
            }
            this.col = col;
            if (index < this.lastBlankLinesTokenIndex) {
                this.lastBlankLinesTokenIndex = -1;
            }
        }

        private void appendToDiff(String s) {
            Diff d;
            int offset = this.tokens.offset();
            Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            if (d != null && d.getEndOffset() == offset) {
                d.text = d.text + s;
            } else {
                this.addDiff(new Diff(offset, offset, s));
            }
        }

        private void addDiff(Diff diff) {
            Diff d;
            Diff diff2 = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            if (d == null || d.getStartOffset() <= diff.getStartOffset()) {
                this.diffs.addFirst(diff);
            }
        }

        private int wrapToken(CodeStyle.WrapStyle wrapStyle, int alignIndent, int spacesCnt, JavaTokenId first, JavaTokenId ... rest) {
            int ret = -1;
            switch (wrapStyle) {
                case WRAP_ALWAYS: {
                    int old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.newline();
                    this.indent = old;
                    ret = this.col;
                    this.accept(first, rest);
                    break;
                }
                case WRAP_IF_LONG: {
                    int index = this.tokens.index();
                    int c = this.col;
                    Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    int old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.spaces(spacesCnt, true);
                    this.indent = old;
                    ret = this.col;
                    this.accept(first, rest);
                    if (this.col <= this.rightMargin) break;
                    this.rollback(index, c, d);
                    old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.newline();
                    this.indent = old;
                    ret = this.col;
                    this.accept(first, rest);
                    break;
                }
                case WRAP_NEVER: {
                    int old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.spaces(spacesCnt, true);
                    this.indent = old;
                    ret = this.col;
                    this.accept(first, rest);
                }
            }
            return ret;
        }

        private int wrapTree(CodeStyle.WrapStyle wrapStyle, int alignIndent, int spacesCnt, Tree tree) {
            int ret = -1;
            switch (wrapStyle) {
                case WRAP_ALWAYS: {
                    int old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.newline();
                    this.indent = old;
                    ret = this.col;
                    this.scan(tree, null);
                    break;
                }
                case WRAP_IF_LONG: {
                    int index = this.tokens.index();
                    int c = this.col;
                    Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    int old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.spaces(spacesCnt, true);
                    this.indent = old;
                    ret = this.col;
                    this.scan(tree, null);
                    if (this.col <= this.rightMargin) break;
                    this.rollback(index, c, d);
                    old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.newline();
                    this.indent = old;
                    ret = this.col;
                    this.scan(tree, null);
                    break;
                }
                case WRAP_NEVER: {
                    int old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.spaces(spacesCnt, true);
                    this.indent = old;
                    ret = this.col;
                    this.scan(tree, null);
                }
            }
            return ret;
        }

        private int wrapOperatorAndTree(CodeStyle.WrapStyle wrapStyle, int alignIndent, int spacesCnt, Tree tree) {
            int ret = -1;
            switch (wrapStyle) {
                case WRAP_ALWAYS: {
                    int old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.newline();
                    this.indent = old;
                    ret = this.col;
                    if (OPERATOR.equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                        this.col += this.tokens.token().length();
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.tokens.moveNext();
                    }
                    this.spaces(spacesCnt);
                    this.scan(tree, null);
                    break;
                }
                case WRAP_IF_LONG: {
                    int index = this.tokens.index();
                    int c = this.col;
                    Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    int old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.spaces(spacesCnt, true);
                    this.indent = old;
                    ret = this.col;
                    if (OPERATOR.equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                        this.col += this.tokens.token().length();
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.tokens.moveNext();
                    }
                    this.spaces(spacesCnt);
                    this.scan(tree, null);
                    if (this.col <= this.rightMargin) break;
                    this.rollback(index, c, d);
                    old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.newline();
                    this.indent = old;
                    ret = this.col;
                    if (OPERATOR.equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                        this.col += this.tokens.token().length();
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.tokens.moveNext();
                    }
                    this.spaces(spacesCnt);
                    this.scan(tree, null);
                    break;
                }
                case WRAP_NEVER: {
                    int index = this.tokens.index();
                    int c = this.col;
                    Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    int old = this.indent;
                    if (alignIndent >= 0) {
                        this.indent = alignIndent;
                    }
                    this.spaces(spacesCnt, true);
                    this.indent = old;
                    ret = this.col;
                    if (OPERATOR.equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                        this.col += this.tokens.token().length();
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.tokens.moveNext();
                    }
                    if (this.spaces(spacesCnt, false)) {
                        this.rollback(index, c, d);
                        old = this.indent;
                        if (alignIndent >= 0) {
                            this.indent = alignIndent;
                        }
                        this.newline();
                        this.indent = old;
                        ret = this.col;
                        if (OPERATOR.equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                            this.col += this.tokens.token().length();
                            this.lastBlankLines = -1;
                            this.lastBlankLinesTokenIndex = -1;
                            this.tokens.moveNext();
                        }
                        this.spaces(spacesCnt);
                    }
                    this.scan(tree, null);
                }
            }
            return ret;
        }

        private boolean wrapStatement(CodeStyle.WrapStyle wrapStyle, CodeStyle.BracesGenerationStyle bracesGenerationStyle, int spacesCnt, StatementTree tree) {
            if (tree.getKind() == Tree.Kind.EMPTY_STATEMENT) {
                this.scan((Tree)tree, null);
                return true;
            }
            if (tree.getKind() == Tree.Kind.BLOCK) {
                Iterator<? extends StatementTree> stats;
                if (bracesGenerationStyle == CodeStyle.BracesGenerationStyle.ELIMINATE && (stats = ((BlockTree)tree).getStatements().iterator()).hasNext()) {
                    StatementTree stat = stats.next();
                    if (!stats.hasNext() && stat.getKind() != Tree.Kind.VARIABLE) {
                        Diff d;
                        this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                        int start = this.tokens.offset() - 1;
                        while (!this.diffs.isEmpty() && (d = this.diffs.getFirst()) != null && d.getStartOffset() >= start) {
                            this.diffs.removeFirst();
                        }
                        this.addDiff(new Diff(start, this.tokens.offset(), null));
                        int old = this.indent;
                        this.indent += this.indentSize;
                        this.wrapTree(wrapStyle, -1, spacesCnt, stat);
                        this.indent = old;
                        this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
                        this.tokens.moveIndex(this.tokens.index() - 2);
                        this.tokens.moveNext();
                        if (this.tokens.token().id() == JavaTokenId.WHITESPACE) {
                            start = this.tokens.offset();
                            if (this.tokens.movePrevious()) {
                                if (this.tokens.token().id() == JavaTokenId.LINE_COMMENT) {
                                    --start;
                                }
                                this.tokens.moveNext();
                            }
                            this.tokens.moveNext();
                        } else {
                            this.tokens.moveNext();
                            start = this.tokens.offset();
                        }
                        this.tokens.moveNext();
                        while (!this.diffs.isEmpty() && (d = this.diffs.getFirst()) != null && d.getStartOffset() >= start) {
                            this.diffs.removeFirst();
                        }
                        this.addDiff(new Diff(start, this.tokens.offset(), null));
                        return false;
                    }
                }
                this.scan((Tree)tree, null);
                return true;
            }
            if (bracesGenerationStyle == CodeStyle.BracesGenerationStyle.GENERATE) {
                this.scan((Tree)new FakeBlock(tree), null);
                return true;
            }
            int old = this.indent;
            this.indent += this.indentSize;
            this.wrapTree(wrapStyle, -1, spacesCnt, tree);
            this.indent = old;
            return false;
        }

        private void wrapList(CodeStyle.WrapStyle wrapStyle, boolean align, boolean prependSpace, JavaTokenId separator, java.util.List<? extends Tree> trees) {
            boolean spaceAfterSeparator;
            boolean spaceBeforeSeparator;
            boolean first = true;
            int alignIndent = -1;
            switch (separator) {
                case COMMA: {
                    spaceBeforeSeparator = this.cs.spaceBeforeComma();
                    spaceAfterSeparator = this.cs.spaceAfterComma();
                    break;
                }
                case SEMICOLON: {
                    spaceBeforeSeparator = this.cs.spaceBeforeSemi();
                    spaceAfterSeparator = this.cs.spaceAfterSemi();
                    break;
                }
                default: {
                    spaceBeforeSeparator = spaceAfterSeparator = this.cs.spaceAroundBinaryOps();
                }
            }
            Iterator<? extends Tree> it = trees.iterator();
            while (it.hasNext()) {
                Tree impl = it.next();
                if (this.wrapAnnotation && impl.getKind() == Tree.Kind.ANNOTATION) {
                    this.wrapTree(CodeStyle.WrapStyle.WRAP_ALWAYS, alignIndent, spaceAfterSeparator ? 1 : 0, impl);
                } else if (impl.getKind() == Tree.Kind.ERRONEOUS) {
                    this.scan(impl, null);
                } else if (first) {
                    Diff d;
                    int index = this.tokens.index();
                    int c = this.col;
                    Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    if (prependSpace) {
                        this.spaces(1, true);
                    }
                    if (align) {
                        alignIndent = this.col;
                    }
                    this.scan(impl, null);
                    if (wrapStyle != CodeStyle.WrapStyle.WRAP_NEVER && this.col > this.rightMargin && c > this.indent) {
                        this.rollback(index, c, d);
                        this.newline();
                        this.scan(impl, null);
                    }
                } else {
                    this.wrapTree(wrapStyle, alignIndent, spaceAfterSeparator ? 1 : 0, impl);
                }
                first = false;
                if (!it.hasNext()) continue;
                this.spaces(spaceBeforeSeparator ? 1 : 0);
                this.accept(separator, new JavaTokenId[0]);
            }
        }

        private void indentComment() {
            if (this.tokens.token().id() != JavaTokenId.BLOCK_COMMENT && this.tokens.token().id() != JavaTokenId.JAVADOC_COMMENT) {
                return;
            }
            String indent = this.getIndent();
            String text = ((Object)this.tokens.token().text()).toString();
            int idx = 0;
            while ((idx = text.indexOf(10, idx)) >= 0) {
                String s;
                int i;
                for (i = idx + 1; i < text.length() && text.charAt(i) <= ' ' && text.charAt(i) != '\n'; ++i) {
                }
                if (i >= text.length()) break;
                String string = s = text.charAt(i) == '*' ? indent + SPACE : indent;
                if (!s.equals(text.substring(idx + 1, i))) {
                    this.addDiff(new Diff(this.tokens.offset() + idx + 1, this.tokens.offset() + i, s));
                }
                idx = i;
            }
        }

        private String getSpaces(int count) {
            if (count <= 0) {
                return EMPTY;
            }
            if (count == 1) {
                return SPACE;
            }
            StringBuilder sb = new StringBuilder();
            while (count-- > 0) {
                sb.append(' ');
            }
            return sb.toString();
        }

        private String getNewlines(int count) {
            if (count <= 0) {
                return EMPTY;
            }
            if (count == 1) {
                return NEWLINE;
            }
            StringBuilder sb = new StringBuilder();
            while (count-- > 0) {
                sb.append('\n');
            }
            return sb.toString();
        }

        private String getIndent() {
            StringBuilder sb = new StringBuilder();
            int col = 0;
            if (!this.expandTabToSpaces) {
                while (col + this.tabSize <= this.indent) {
                    sb.append('\t');
                    col += this.tabSize;
                }
            }
            while (col < this.indent) {
                sb.append(SPACE);
                ++col;
            }
            return sb.toString();
        }

        /*
         * WARNING - void declaration
         */
        private int getIndentLevel(TokenSequence<JavaTokenId> tokens, TreePath path) {
            if (path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                return 0;
            }
            Tree lastTree = null;
            int indent = -1;
            while (path != null) {
                int offset = (int)this.sp.getStartPosition(path.getCompilationUnit(), path.getLeaf());
                if (offset < 0) {
                    return indent;
                }
                tokens.move(offset);
                Object var6_9 = null;
                while (tokens.movePrevious()) {
                    Token token = tokens.token();
                    if (token.id() == JavaTokenId.WHITESPACE) {
                        String string = ((Object)token.text()).toString();
                        int idx = string.lastIndexOf(10);
                        if (idx < 0) continue;
                        String string2 = string.substring(idx + 1);
                        indent = this.getCol(string2);
                        break;
                    }
                    if (token.id() == JavaTokenId.LINE_COMMENT) {
                        void var6_10;
                        indent = var6_10 != null ? this.getCol((String)var6_10) : 0;
                        break;
                    }
                    if (token.id() != JavaTokenId.BLOCK_COMMENT && token.id() != JavaTokenId.JAVADOC_COMMENT) break;
                    Object var6_13 = null;
                }
                if (indent >= 0) break;
                lastTree = path.getLeaf();
                path = path.getParentPath();
            }
            if (lastTree != null && path != null) {
                block0 : switch (path.getLeaf().getKind()) {
                    case ANNOTATION_TYPE: 
                    case CLASS: 
                    case ENUM: 
                    case INTERFACE: {
                        for (Tree tree : ((ClassTree)path.getLeaf()).getMembers()) {
                            if (tree != lastTree) continue;
                            indent += this.tabSize;
                            break block0;
                        }
                        break;
                    }
                    case BLOCK: {
                        for (StatementTree statementTree : ((BlockTree)path.getLeaf()).getStatements()) {
                            if (statementTree != lastTree) continue;
                            indent += this.tabSize;
                            break block0;
                        }
                        break;
                    }
                }
            }
            return indent;
        }

        private int getCol(String text) {
            int col = 0;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\t') {
                    col += this.tabSize;
                    col -= col % this.tabSize;
                    continue;
                }
                ++col;
            }
            return col;
        }

        private boolean isEnumerator(VariableTree tree) {
            return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x4000L) != 0L;
        }

        private boolean isSynthetic(CompilationUnitTree cut, Tree leaf) {
            IdentifierTree it;
            MethodInvocationTree mit;
            ExpressionStatementTree est;
            JCTree tree = (JCTree)leaf;
            if (tree.pos == -1) {
                return true;
            }
            if (leaf.getKind() == Tree.Kind.METHOD) {
                return (((JCTree.JCMethodDecl)leaf).mods.flags & 0x1000000000L) != 0L;
            }
            if (leaf.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (est = (ExpressionStatementTree)leaf).getExpression().getKind() == Tree.Kind.METHOD_INVOCATION && (mit = (MethodInvocationTree)est.getExpression()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals((it = (IdentifierTree)mit.getMethodSelect()).getName().toString())) {
                return this.sp.getEndPosition(cut, leaf) == -1L;
            }
            return false;
        }

        private static class DanglingElseChecker
        extends SimpleTreeVisitor<Void, Void> {
            private boolean foundDanglingElse;

            private DanglingElseChecker() {
            }

            public boolean hasDanglingElse(Tree t) {
                if (t == null) {
                    return false;
                }
                this.foundDanglingElse = false;
                this.visit(t, null);
                return this.foundDanglingElse;
            }

            @Override
            public Void visitBlock(BlockTree node, Void p) {
                StatementTree stat;
                Iterator<? extends StatementTree> it = node.getStatements().iterator();
                StatementTree statementTree = stat = it.hasNext() ? it.next() : null;
                if (stat != null && !it.hasNext()) {
                    this.visit(stat, p);
                }
                return null;
            }

            @Override
            public Void visitDoWhileLoop(DoWhileLoopTree node, Void p) {
                return (Void)this.visit(node.getStatement(), p);
            }

            @Override
            public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
                return (Void)this.visit(node.getStatement(), p);
            }

            @Override
            public Void visitForLoop(ForLoopTree node, Void p) {
                return (Void)this.visit(node.getStatement(), p);
            }

            @Override
            public Void visitIf(IfTree node, Void p) {
                if (node.getElseStatement() == null) {
                    this.foundDanglingElse = true;
                } else {
                    this.visit(node.getElseStatement(), p);
                }
                return null;
            }

            @Override
            public Void visitLabeledStatement(LabeledStatementTree node, Void p) {
                return (Void)this.visit(node.getStatement(), p);
            }

            @Override
            public Void visitSynchronized(SynchronizedTree node, Void p) {
                return (Void)this.visit(node.getBlock(), p);
            }

            @Override
            public Void visitWhileLoop(WhileLoopTree node, Void p) {
                return (Void)this.visit(node.getStatement(), p);
            }
        }

        private static class FakeBlock
        extends JCTree.JCBlock {
            private StatementTree stat;

            private FakeBlock(StatementTree stat) {
                super(0L, List.of((JCTree.JCStatement)stat));
                this.stat = stat;
            }
        }
    }

    public static class Factory
    implements ReformatTask.Factory {
        public ReformatTask createTask(org.netbeans.modules.editor.indent.spi.Context context) {
            Source source = Source.create((Document)context.document());
            return source != null ? new Reformatter(source, context) : null;
        }
    }
}

