/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.DocumentProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.parsing.api.Source;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;

public class SourceFileObject
implements DocumentProvider,
InferableJavaFileObject {
    final Handle handle;
    private final JavaFileObject.Kind kind;
    private URI uri;
    private volatile String text;
    private TokenHierarchy<?> tokens;
    private final JavaFileFilterImplementation filter;
    private static final Logger log = Logger.getLogger(SourceFileObject.class.getName());

    public static SourceFileObject create(FileObject file, FileObject root) {
        try {
            return new SourceFileObject(file, root, null, false);
        }
        catch (IOException ioe) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, ioe.getMessage(), ioe);
            }
            return null;
        }
    }

    public SourceFileObject(FileObject file, FileObject root, JavaFileFilterImplementation filter, CharSequence content) throws IOException {
        this(new Handle(file, root), filter);
        this.update(content);
    }

    public SourceFileObject(FileObject file, FileObject root, JavaFileFilterImplementation filter, boolean renderNow) throws IOException {
        this(new Handle(file, root), filter);
        if (renderNow) {
            this.update();
        }
    }

    public SourceFileObject(Handle handle, JavaFileFilterImplementation filter) {
        assert (handle != null);
        this.handle = handle;
        this.filter = filter;
        String ext = this.handle.getExt();
        this.kind = filter == null ? FileObjects.getKind(ext) : JavaFileObject.Kind.SOURCE;
    }

    public final void update() throws IOException {
        if (this.kind != JavaFileObject.Kind.CLASS) {
            this.getContent(true);
        }
    }

    public final void update(CharSequence content) throws IOException {
        if (content == null) {
            this.update();
        } else {
            Source source;
            FileObject file;
            if (this.filter != null && (file = this.handle.resolveFileObject(false)) != null && (source = Source.create((FileObject)file)) != null && source.getDocument(false) == null) {
                content = this.filter.filterCharSequence(content);
            }
            this.text = this.toString(content);
        }
        this.tokens = null;
    }

    @Override
    public boolean isNameCompatible(String simplename, JavaFileObject.Kind kind) {
        assert (simplename != null);
        return this.kind == kind && this.getNameWithoutExtension().equals(simplename);
    }

    @Override
    public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
        String _text = this.text;
        if (_text == null) {
            _text = this.getContent(false);
        }
        return CharBuffer.wrap(_text);
    }

    public TokenHierarchy<?> getTokenHierarchy() throws IOException {
        if (this.tokens == null) {
            CharBuffer charBuffer = this.getCharContent(true);
            this.tokens = TokenHierarchy.create((CharSequence)charBuffer, (boolean)false, (Language)JavaTokenId.language(), null, null);
        }
        return this.tokens;
    }

    @Override
    public Writer openWriter() throws IOException {
        FileObject file = this.handle.resolveFileObject(true);
        if (file == null) {
            throw new IOException("Cannot create file: " + this.toString());
        }
        return new OutputStreamWriter(this.openOutputStream(), FileEncodingQuery.getEncoding((FileObject)file));
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        String _text = this.text;
        if (_text == null) {
            _text = this.getContent(false);
        }
        return new StringReader(_text);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        FileObject file = this.handle.resolveFileObject(true);
        if (file == null) {
            throw new IOException("Cannot create file: " + this.toString());
        }
        StyledDocument doc = this.getDocument();
        if (doc == null) {
            return new LckStream(file);
        }
        return new DocumentStream(doc);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        String _text = this.text;
        if (_text == null) {
            _text = this.getContent(false);
        }
        return new ByteArrayInputStream(_text.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete() {
        boolean bl;
        if (this.isModified() != null) {
            return false;
        }
        FileObject file = this.handle.resolveFileObject(false);
        if (file == null) {
            return false;
        }
        FileLock lock = file.lock();
        try {
            file.delete(lock);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                lock.releaseLock();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        lock.releaseLock();
        return bl;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.handle.getName(true);
    }

    public String getNameWithoutExtension() {
        return this.handle.getName(false);
    }

    @Override
    public synchronized URI toUri() {
        block3: {
            if (this.uri == null) {
                try {
                    this.uri = URI.create(this.handle.getURL().toExternalForm());
                }
                catch (IOException e) {
                    if (!log.isLoggable(Level.SEVERE)) break block3;
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return this.uri;
    }

    @Override
    public long getLastModified() {
        EditorCookie ec = this.isModified();
        if (ec == null) {
            return this.getFileLastModified();
        }
        StyledDocument doc = ec.getDocument();
        return doc != null ? DocumentUtilities.getDocumentTimestamp((Document)doc) : this.getFileLastModified();
    }

    private long getFileLastModified() {
        FileObject file = this.handle.resolveFileObject(false);
        try {
            if (file == null || file.getFileSystem() instanceof JarFileSystem) {
                return 0L;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return file.lastModified().getTime();
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    @Override
    public String inferBinaryName() {
        if (this.handle.root == null) {
            return null;
        }
        String relativePath = this.handle.getRelativePath();
        assert (relativePath != null) : "root=" + FileUtil.getFileDisplayName((FileObject)this.handle.root) + ", file=" + this.toString();
        int index = relativePath.lastIndexOf(46);
        assert (index > 0);
        String result = relativePath.substring(0, index).replace('/', '.');
        return result;
    }

    public String toString() {
        URI uri = this.toUri();
        try {
            File file = new File(uri);
            return file.getAbsolutePath();
        }
        catch (IllegalArgumentException iae) {
            return uri.toString();
        }
    }

    public boolean equals(Object other) {
        if (other instanceof SourceFileObject) {
            SourceFileObject otherSource = (SourceFileObject)other;
            return this.handle.equals(otherSource.handle);
        }
        return false;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    @Override
    public StyledDocument getDocument() {
        FileObject file = this.handle.resolveFileObject(false);
        if (file == null) {
            return null;
        }
        Source src = Source.create((FileObject)file);
        if (src == null) {
            return null;
        }
        Document doc = src.getDocument(false);
        return doc instanceof StyledDocument ? (StyledDocument)doc : null;
    }

    @Override
    public void runAtomic(Runnable r) {
        assert (r != null);
        StyledDocument doc = this.getDocument();
        if (doc == null) {
            throw new IllegalStateException();
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)r);
    }

    private EditorCookie isModified() {
        FileObject file = this.handle.resolveFileObject(false);
        if (file == null) {
            return null;
        }
        DataObject.Registry regs = DataObject.getRegistry();
        Set modified = regs.getModifiedSet();
        for (DataObject dobj : modified) {
            if (!file.equals(dobj.getPrimaryFile())) continue;
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            return ec;
        }
        return null;
    }

    private String getContent(boolean assign) throws IOException {
        FileObject file = this.handle.resolveFileObject(false);
        if (file == null) {
            throw new FileNotFoundException("Cannot open file: " + this.toString());
        }
        Source source = Source.create((FileObject)file);
        if (source == null) {
            throw new IOException("No source for: " + FileUtil.getFileDisplayName((FileObject)file));
        }
        CharSequence content = this.toString(source.createSnapshot().getText());
        if (this.filter != null && source.getDocument(false) == null) {
            content = this.filter.filterCharSequence(content);
        }
        String result = this.toString(content);
        if (assign) {
            this.text = result;
        }
        return result;
    }

    private String toString(CharSequence c) {
        if (c instanceof String) {
            return (String)c;
        }
        return ((Object)c).toString();
    }

    private class DocumentStream
    extends OutputStream {
        private static final int BUF_SIZ = 2048;
        private final StyledDocument doc;
        private byte[] data;
        private int pos;

        public DocumentStream(StyledDocument doc) {
            assert (doc != null);
            this.doc = doc;
            this.data = new byte[2048];
            this.pos = 0;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.ensureSize(len);
            System.arraycopy(b, off, this.data, this.pos, len);
            this.pos += len;
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            this.ensureSize(b.length);
            System.arraycopy(b, 0, this.data, this.pos, b.length);
            this.pos += b.length;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.ensureSize(1);
            this.data[this.pos++] = (byte)(b & 0xFF);
        }

        private void ensureSize(int delta) {
            int requiredLength = this.pos + delta;
            if (this.data.length < requiredLength) {
                int newSize;
                for (newSize = this.data.length + 2048; newSize < requiredLength; newSize += 2048) {
                }
                byte[] newData = new byte[newSize];
                System.arraycopy(this.data, 0, newData, 0, this.pos);
                this.data = newData;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            try {
                NbDocument.runAtomic((StyledDocument)this.doc, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                DocumentStream.this.doc.remove(0, DocumentStream.this.doc.getLength());
                                DocumentStream.this.doc.insertString(0, new String(DocumentStream.this.data, 0, DocumentStream.this.pos, FileEncodingQuery.getEncoding((FileObject)SourceFileObject.this.handle.resolveFileObject(false))), null);
                            }
                            catch (BadLocationException e) {
                                if (!log.isLoggable(Level.SEVERE)) break block2;
                                log.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                    }
                });
            }
            finally {
                SourceFileObject.this.text = null;
            }
        }
    }

    private class LckStream
    extends OutputStream {
        private final OutputStream delegate;
        private final FileLock lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LckStream(FileObject fo) throws IOException {
            assert (fo != null);
            this.lock = fo.lock();
            try {
                this.delegate = fo.getOutputStream(this.lock);
            }
            finally {
                if (this.delegate == null) {
                    this.lock.releaseLock();
                }
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.lock.releaseLock();
                SourceFileObject.this.text = null;
            }
        }
    }

    public static class Handle {
        protected final FileObject root;
        protected FileObject file;

        protected Handle(FileObject root) {
            this.root = root;
        }

        public Handle(FileObject file, FileObject root) {
            assert (file != null);
            this.file = file;
            this.root = root;
        }

        protected FileObject resolveFileObject(boolean write) {
            return this.file;
        }

        protected URL getURL() throws IOException {
            return this.file == null ? null : this.file.getURL();
        }

        protected String getExt() {
            return this.file == null ? null : this.file.getExt();
        }

        protected String getName(boolean includeExtension) {
            return this.file == null ? null : (includeExtension ? this.file.getNameExt() : this.file.getName());
        }

        protected String getRelativePath() {
            if (this.file == null) {
                return null;
            }
            String result = FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.file);
            assert (result != null) : String.format("root=%s(%b,%b) file=%s(%b)", FileUtil.getFileDisplayName((FileObject)this.root), this.root.isValid(), this.root.isFolder(), FileUtil.getFileDisplayName((FileObject)this.file), this.file.isValid());
            return result;
        }

        public int hashCode() {
            return this.file == null ? 0 : this.file.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Handle other = (Handle)obj;
            return this.file == null ? other.file == null : this.file.equals(other.file);
        }
    }
}

