/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectNameBasedKey;
import org.netbeans.modules.cnd.repository.spi.KeyDataPresentation;
import org.openide.util.CharSequences;

abstract class ProjectFileNameBasedKey
extends ProjectNameBasedKey {
    protected static final CharSequence NO_PROJECT = CharSequences.create((CharSequence)"<No Project Name>");
    protected final int fileNameIndex;

    protected ProjectFileNameBasedKey(CharSequence charSequence, CharSequence charSequence2) {
        super(charSequence);
        assert (charSequence2 != null);
        this.fileNameIndex = KeyUtilities.getFileIdByName(this.getUnitId(), charSequence2);
    }

    protected ProjectFileNameBasedKey(FileImpl fileImpl) {
        this(ProjectFileNameBasedKey.getProjectName(fileImpl), fileImpl.getAbsolutePath());
    }

    protected ProjectFileNameBasedKey(KeyDataPresentation keyDataPresentation) {
        super(keyDataPresentation);
        this.fileNameIndex = keyDataPresentation.getFilePresentation();
    }

    protected static CharSequence getProjectName(FileImpl fileImpl) {
        assert (fileImpl != null);
        ProjectBase projectBase = fileImpl.getProjectImpl(true);
        assert (projectBase != null);
        return projectBase == null ? NO_PROJECT : projectBase.getUniqueName();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeInt(this.fileNameIndex);
    }

    protected ProjectFileNameBasedKey(DataInput dataInput) throws IOException {
        super(dataInput);
        this.fileNameIndex = dataInput.readInt();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 19 * n + this.fileNameIndex;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ProjectFileNameBasedKey projectFileNameBasedKey = (ProjectFileNameBasedKey)object;
        return this.fileNameIndex == projectFileNameBasedKey.fileNameIndex;
    }

    int getProjectFileIndex() {
        return this.fileNameIndex;
    }

    protected CharSequence getFileName() {
        return KeyUtilities.getFileNameById(this.getUnitId(), this.fileNameIndex);
    }

    protected CharSequence getFileNameSafe() {
        return KeyUtilities.getFileNameByIdSafe(this.getUnitId(), this.fileNameIndex);
    }

    @Override
    public int getDepth() {
        assert (super.getDepth() == 0);
        return 1;
    }

    @Override
    public CharSequence getAt(int n) {
        assert (super.getDepth() == 0 && n < this.getDepth());
        return this.getFileName();
    }

    @Override
    public final int getFilePresentation() {
        return this.fileNameIndex;
    }
}

