/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.LazyStatementImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.fsm.core.DataRenderer;
import org.netbeans.modules.cnd.modelimpl.parser.CPPParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.FortranParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.generated.FortranParser;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;

public final class ParserProviderImpl
extends CsmParserProvider {
    @Override
    protected CsmParserProvider.CsmParser create(CsmFile csmFile) {
        if (csmFile instanceof FileImpl) {
            if (csmFile.getFileType() == CsmFile.FileType.SOURCE_FORTRAN_FILE) {
                return new Antrl3FortranParser((FileImpl)csmFile);
            }
            return new Antlr2CppParser((FileImpl)csmFile);
        }
        return null;
    }

    private static final class Antrl3FortranParser
    implements CsmParserProvider.CsmParser,
    CsmParserProvider.CsmParserResult {
        private final FileImpl file;
        private FortranParserEx parser;
        private CsmObject parserContainer;
        private FortranParser.program_return ret;
        private CsmParserProvider.CsmParser.ConstructionKind kind;

        Antrl3FortranParser(FileImpl fileImpl) {
            this.file = fileImpl;
        }

        @Override
        public void init(CsmObject csmObject, TokenStream tokenStream) {
            this.parser = new FortranParserEx(tokenStream);
        }

        @Override
        public CsmParserProvider.CsmParserResult parse(CsmParserProvider.CsmParser.ConstructionKind constructionKind) {
            try {
                this.kind = constructionKind;
                switch (constructionKind) {
                    case TRANSLATION_UNIT: {
                        this.ret = this.parser.program();
                        break;
                    }
                    default: {
                        assert (false) : "unexpected parse kind " + (Object)((Object)constructionKind);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getClass().getName() + " at parsing file " + this.file.getAbsolutePath());
            }
            return this;
        }

        @Override
        public void render(Object ... objectArray) {
            switch (this.kind) {
                case TRANSLATION_UNIT: {
                    new DataRenderer(this.file).render(this.parser.parsedObjects);
                    Antrl3FortranParser antrl3FortranParser = this;
                    antrl3FortranParser.file.incParseCount();
                    break;
                }
                default: {
                    assert (false) : "unexpected render kind " + (Object)((Object)this.kind);
                    break;
                }
            }
        }

        @Override
        public boolean isEmptyAST() {
            return this.ret == null || this.ret.getTree() == null;
        }

        @Override
        public Object getAST() {
            return this.ret == null ? null : this.ret.getTree();
        }

        @Override
        public int getErrorCount() {
            return this.parser.getNumberOfSyntaxErrors();
        }

        @Override
        public void dumpAST() {
            CommonTree commonTree = (CommonTree)this.ret.getTree();
            System.err.println(commonTree);
            System.err.println(commonTree.getChildren());
        }
    }

    private static final class Antlr2CppParser
    implements CsmParserProvider.CsmParser,
    CsmParserProvider.CsmParserResult {
        private final FileImpl file;
        private CPPParserEx parser;
        private final int flags;
        private CsmObject parserContainer;
        private AST ast;
        private CsmParserProvider.CsmParser.ConstructionKind kind;

        Antlr2CppParser(FileImpl fileImpl) {
            this.file = fileImpl;
            int n = 8;
            if (!TraceFlags.REPORT_PARSING_ERRORS) {
                n |= 4;
            }
            this.flags = n;
        }

        @Override
        public void init(CsmObject csmObject, TokenStream tokenStream) {
            assert (this.parser == null) : "parser can not be reused " + this.parser;
            assert (csmObject != null);
            assert (tokenStream != null);
            this.parserContainer = csmObject;
            this.parser = CPPParserEx.getInstance(((Object)this.file.getName()).toString(), tokenStream, this.flags);
        }

        @Override
        public CsmParserProvider.CsmParserResult parse(CsmParserProvider.CsmParser.ConstructionKind constructionKind) {
            try {
                this.kind = constructionKind;
                switch (constructionKind) {
                    case TRANSLATION_UNIT: {
                        this.parser.translation_unit();
                        break;
                    }
                    case TRY_BLOCK: {
                        this.parser.setLazyCompound(false);
                        this.parser.function_try_block(CsmKindUtilities.isConstructor((CsmObject)((CsmScopeElement)this.parserContainer).getScope()));
                        break;
                    }
                    case COMPOUND_STATEMENT: {
                        this.parser.setLazyCompound(false);
                        this.parser.compound_statement();
                        break;
                    }
                    case NAMESPACE_DEFINITION_BODY: {
                        this.parser.translation_unit();
                        break;
                    }
                    case CLASS_BODY: {
                        this.parser.fix_fake_class_members();
                        break;
                    }
                    default: {
                        assert (false) : "unexpected parse kind " + (Object)((Object)constructionKind);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                System.err.println(throwable.getClass().getName() + " at parsing file " + this.file.getAbsolutePath());
            }
            this.ast = this.parser.getAST();
            return this;
        }

        @Override
        public void render(Object ... objectArray) {
            switch (this.kind) {
                case TRY_BLOCK: 
                case COMPOUND_STATEMENT: {
                    List list = (List)objectArray[0];
                    ((LazyStatementImpl)this.parserContainer).renderStatements(this.ast, list);
                    break;
                }
                case TRANSLATION_UNIT: {
                    if (this.ast == null) break;
                    new AstRenderer(this.file).render(this.ast);
                    Antlr2CppParser antlr2CppParser = this;
                    antlr2CppParser.file.incParseCount();
                    break;
                }
                case NAMESPACE_DEFINITION_BODY: {
                    FileImpl fileImpl = (FileImpl)objectArray[0];
                    NamespaceDefinitionImpl namespaceDefinitionImpl = (NamespaceDefinitionImpl)objectArray[1];
                    CsmNamespace csmNamespace = namespaceDefinitionImpl.getNamespace();
                    if (this.ast == null || !(csmNamespace instanceof NamespaceImpl)) break;
                    new AstRenderer(fileImpl).render(this.ast, (NamespaceImpl)csmNamespace, namespaceDefinitionImpl);
                    break;
                }
                case CLASS_BODY: {
                    FileImpl fileImpl = (FileImpl)objectArray[0];
                    ClassImpl classImpl = (ClassImpl)objectArray[1];
                    CsmVisibility csmVisibility = (CsmVisibility)objectArray[2];
                    boolean bl = (Boolean)objectArray[3];
                    classImpl.fixFakeRender(fileImpl, csmVisibility, this.ast, bl);
                    break;
                }
                default: {
                    assert (false) : "unexpected parse kind " + (Object)((Object)this.kind);
                    break;
                }
            }
        }

        @Override
        public boolean isEmptyAST() {
            return AstUtil.isEmpty(this.ast, true);
        }

        @Override
        public void dumpAST() {
            System.err.println("\n");
            System.err.print("AST: ");
            System.err.print(this.file.getAbsolutePath());
            System.err.print(' ');
            AstUtil.toStream(this.ast, System.err);
            System.err.println("\n");
        }

        @Override
        public Object getAST() {
            return this.ast;
        }

        @Override
        public int getErrorCount() {
            return this.parser.getErrorCount();
        }
    }
}

