/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver3;

public class ResolverFactory {
    private static final ThreadLocal<LinkedList<Resolver>> stack = new ThreadLocal<LinkedList<Resolver>>(){

        @Override
        protected LinkedList<Resolver> initialValue() {
            return new LinkedList<Resolver>();
        }
    };
    private static final Resolver EMPTY_RESOLVER = new EmptyResolver();

    private ResolverFactory() {
    }

    public static Resolver createResolver(CsmOffsetable csmOffsetable) {
        return ResolverFactory.createResolver(csmOffsetable.getContainingFile(), csmOffsetable.getStartOffset());
    }

    public static Resolver createResolver(CsmFile csmFile, int n) {
        return ResolverFactory.createResolver(csmFile, n, null);
    }

    public static Resolver createResolver(CsmOffsetable csmOffsetable, CsmFile csmFile) {
        return ResolverFactory.createResolver(csmOffsetable.getContainingFile(), csmOffsetable.getStartOffset(), csmFile);
    }

    public static void releaseResolver(Resolver resolver) {
        LinkedList<Resolver> linkedList = stack.get();
        assert (!linkedList.isEmpty());
        Resolver resolver2 = linkedList.removeLast();
        assert (resolver == resolver2);
    }

    public static Resolver getCurrentResolver() {
        LinkedList<Resolver> linkedList = stack.get();
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList.peekLast();
    }

    private static Resolver createResolver(CsmFile csmFile, int n, CsmFile csmFile2) {
        Resolver resolver = null;
        LinkedList<Resolver> linkedList = stack.get();
        resolver = !linkedList.isEmpty() ? linkedList.getLast() : null;
        if (csmFile == null || linkedList.size() > 200) {
            if (csmFile == null) {
                System.err.println("FALLBACK INTO EMPTY RESOLVER");
            } else if (resolver instanceof Resolver3) {
                // empty if block
            }
            linkedList.addLast(EMPTY_RESOLVER);
            return EMPTY_RESOLVER;
        }
        if (csmFile2 == null) {
            csmFile2 = resolver == null ? csmFile : resolver.getStartFile();
        }
        Resolver3 resolver3 = new Resolver3(csmFile, n, resolver, csmFile2);
        linkedList.addLast(resolver3);
        return resolver3;
    }

    private static final class EmptyResolver
    implements Resolver {
        private EmptyResolver() {
        }

        @Override
        public Collection<CsmProject> getLibraries() {
            return Collections.emptyList();
        }

        @Override
        public CsmFile getStartFile() {
            return null;
        }

        @Override
        public CsmObject resolve(CharSequence[] charSequenceArray, int n) {
            return null;
        }

        @Override
        public boolean isRecursionOnResolving(int n) {
            return true;
        }

        @Override
        public CsmClassifier getOriginalClassifier(CsmClassifier csmClassifier) {
            return null;
        }
    }
}

