/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;

public class CompoundStatementImpl
extends StatementBase
implements CsmCompoundStatement {
    private volatile List<CsmStatement> statements;

    protected CompoundStatementImpl(AST aST, CsmFile csmFile, CsmScope csmScope) {
        super(aST, csmFile, csmScope);
    }

    public static CompoundStatementImpl create(AST aST, CsmFile csmFile, CsmScope csmScope) {
        return new CompoundStatementImpl(aST, csmFile, csmScope);
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.COMPOUND;
    }

    public final List<CsmStatement> getStatements() {
        if (this.statements == null) {
            this.renderStatements(this.getStartRenderingAst());
        }
        return this.statements;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.statements != null) {
            Utils.disposeAll(this.statements);
        }
    }

    protected AST getStartRenderingAst() {
        return this.getAst();
    }

    private void renderStatements(AST aST) {
        this.statements = Collections.emptyList();
        ArrayList<CsmStatement> arrayList = new ArrayList<CsmStatement>();
        if (aST != null) {
            for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
                StatementBase statementBase = AstRenderer.renderStatement(aST2, this.getContainingFile(), (CsmScope)this);
                if (statementBase == null) continue;
                arrayList.add(statementBase);
            }
        }
        this.statements = arrayList;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        List<CsmStatement> list = this.getStatements();
        return list;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
    }

    public CompoundStatementImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.statements = null;
    }
}

