/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.PositionManager;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public class OffsetableBase
implements CsmOffsetable,
Disposable {
    private CsmFile fileRef;
    private final CsmUID<CsmFile> fileUID;
    private final int startPosition;
    private final int endPosition;

    protected OffsetableBase(AST aST, CsmFile csmFile) {
        this(csmFile, OffsetableBase.getStartOffset(aST), OffsetableBase.getEndOffset(aST));
    }

    protected OffsetableBase(CsmFile csmFile, CsmOffsetable csmOffsetable) {
        this(csmFile, csmOffsetable != null ? csmOffsetable.getStartOffset() : 0, csmOffsetable != null ? csmOffsetable.getEndOffset() : 0);
    }

    protected OffsetableBase(CsmFile csmFile, int n, int n2) {
        this.fileUID = UIDCsmConverter.fileToUID(csmFile);
        this.fileRef = null;
        this.startPosition = PositionManager.createPositionID(this.fileUID, n, PositionManager.Position.Bias.FOWARD);
        this.endPosition = PositionManager.createPositionID(this.fileUID, n2, PositionManager.Position.Bias.BACKWARD);
    }

    public static OffsetableBase create(CsmFile csmFile, int n, int n2) {
        return new OffsetableBase(csmFile, n, n2);
    }

    public final int getStartOffset() {
        return PositionManager.getOffset(this.fileUID, this.startPosition);
    }

    public final int getEndOffset() {
        return this.endPosition != 0 ? PositionManager.getOffset(this.fileUID, this.endPosition) : PositionManager.getOffset(this.fileUID, this.startPosition);
    }

    public final CsmOffsetable.Position getStartPosition() {
        return PositionManager.getPosition(this.fileUID, this.startPosition);
    }

    public final CsmOffsetable.Position getEndPosition() {
        return PositionManager.getPosition(this.fileUID, this.endPosition);
    }

    public static int getStartOffset(AST aST) {
        CsmAST csmAST;
        if (aST != null && (csmAST = AstUtil.getFirstCsmAST(aST)) != null) {
            return csmAST.getOffset();
        }
        return 0;
    }

    public static int getEndOffset(AST aST) {
        AST aST2;
        if (aST != null && (aST2 = AstUtil.getLastChildRecursively(aST)) instanceof CsmAST) {
            return ((CsmAST)aST2).getEndOffset();
        }
        return 0;
    }

    public CsmFile getContainingFile() {
        return this._getFile();
    }

    public CharSequence getText() {
        return this.getContainingFile().getText(this.getStartOffset(), this.getEndOffset());
    }

    @Override
    public void dispose() {
        this.onDispose();
    }

    private synchronized void onDispose() {
        if (this.fileRef == null) {
            this.fileRef = UIDCsmConverter.UIDtoFile(this.fileUID);
            assert (this.fileRef != null) : "no object for UID " + this.fileUID;
        }
    }

    private synchronized CsmFile _getFile() {
        CsmFile csmFile = this.fileRef;
        if (csmFile == null) {
            csmFile = UIDCsmConverter.UIDtoFile(this.fileUID);
            assert (csmFile != null) : "no object for UID " + this.fileUID;
        }
        return csmFile;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.startPosition);
        dataOutput.writeInt(this.endPosition);
        assert (this.fileUID != null);
        UIDObjectFactory.getDefaultFactory().writeUID(this.fileUID, dataOutput);
    }

    protected OffsetableBase(DataInput dataInput) throws IOException {
        this.startPosition = dataInput.readInt();
        this.endPosition = dataInput.readInt();
        this.fileUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        assert (this.fileUID != null);
        this.fileRef = null;
    }

    protected String getOffsetString() {
        return "[" + this.getStartOffset() + "-" + this.getEndOffset() + "]";
    }

    protected CharSequence getPositionString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        CsmFile csmFile = this.getContainingFile();
        if (csmFile == null) {
            stringBuilder.append(" NO CONTAINER ").append(this.fileUID);
        } else {
            stringBuilder.append(csmFile.getName());
        }
        stringBuilder.append(' ');
        CsmOffsetable.Position position = this.getStartPosition();
        stringBuilder.append(position.getLine());
        stringBuilder.append(':');
        stringBuilder.append(position.getColumn());
        stringBuilder.append('-');
        position = this.getEndPosition();
        stringBuilder.append(position.getLine());
        stringBuilder.append(':');
        stringBuilder.append(position.getColumn());
        stringBuilder.append(']');
        return stringBuilder;
    }

    public String toString() {
        return this.getOffsetString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OffsetableBase offsetableBase = (OffsetableBase)object;
        if (!(this.fileUID == offsetableBase.fileUID || this.fileUID != null && this.fileUID.equals(offsetableBase.fileUID))) {
            return false;
        }
        if (this.startPosition != offsetableBase.startPosition) {
            return false;
        }
        return this.endPosition == offsetableBase.endPosition;
    }

    public int hashCode() {
        int n = 7;
        n = 47 * n + (this.fileUID != null ? this.fileUID.hashCode() : 0);
        n = 47 * n + this.startPosition;
        n = 47 * n + this.endPosition;
        return n;
    }
}

