/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;

public class Line2Offset {
    private String text;
    private char[] buffer;
    private final int[] lines;

    Line2Offset(String string) {
        this.text = string;
        this.lines = this.init();
    }

    Line2Offset(char[] cArray) {
        this.buffer = cArray;
        this.lines = this.init();
    }

    Line2Offset(char[] cArray, int[] nArray) {
        this.buffer = cArray;
        this.lines = nArray;
    }

    public int[] getLineColumnByOffset(int n) throws IOException {
        int[] nArray = new int[]{1, 1};
        int n2 = this._getLineByOffset(n);
        int n3 = this._getStartLineOffset(n2);
        nArray[0] = n2;
        int n4 = ModelSupport.getTabSize();
        int n5 = this.getLength();
        block4: for (int i = n3; i < n && i < n5; ++i) {
            char c = this.getCharAt(i);
            switch (c) {
                case '\n': {
                    nArray[0] = nArray[0] + 1;
                    nArray[1] = 1;
                    continue block4;
                }
                case '\t': {
                    int n6;
                    int n7 = nArray[1];
                    nArray[1] = n6 = ((n7 - 1) / n4 + 1) * n4 + 1;
                    continue block4;
                }
                default: {
                    nArray[1] = nArray[1] + 1;
                }
            }
        }
        return nArray;
    }

    public int getOffsetByLineColumn(int n, int n2) throws IOException {
        int n3;
        int n4 = this._getStartLineOffset(n);
        int n5 = ModelSupport.getTabSize();
        int n6 = 1;
        int n7 = this.getLength();
        block4: for (n3 = n4; n3 < n7 && n6 < n2; ++n3) {
            char c = this.getCharAt(n3);
            switch (c) {
                case '\n': {
                    break block4;
                }
                case '\t': {
                    int n8;
                    int n9 = n6;
                    n6 = n8 = ((n9 - 1) / n5 + 1) * n5 + 1;
                    continue block4;
                }
                default: {
                    ++n6;
                }
            }
        }
        return n3;
    }

    private int[] init() {
        int n = this.getLength();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n / 10);
        arrayList.add(0);
        for (int i = 0; i < n; ++i) {
            if (this.getCharAt(i) != '\n') continue;
            arrayList.add(i + 1);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    private char getCharAt(int n) {
        if (this.text != null) {
            return this.text.charAt(n);
        }
        return this.buffer[n];
    }

    private int getLength() {
        if (this.text != null) {
            return this.text.length();
        }
        return this.buffer.length;
    }

    private int _getStartLineOffset(int n) throws IOException {
        if (--n < this.lines.length) {
            return this.lines[n];
        }
        return this.lines[this.lines.length - 1];
    }

    private int _getLineByOffset(int n) throws IOException {
        int n2 = 0;
        int n3 = this.lines.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.lines[n4];
            if (n5 < n) {
                if (n2 == n3) {
                    return n2 + 1;
                }
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                if (n2 == n3) {
                    return n2;
                }
                n3 = n4 - 1;
                continue;
            }
            return n4 + 1;
        }
        return n2;
    }
}

