/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeclarationContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectDeclarationContainerKey;
import org.netbeans.modules.cnd.modelimpl.textcache.UniqueNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.openide.util.CharSequences;

public class DeclarationContainerProject
extends DeclarationContainer {
    private final Map<CharSequence, Set<CsmUID<CsmFriend>>> friends;
    private static final boolean TEST_DATABASE = false;
    private static final DeclarationContainerProject EMPTY = new DeclarationContainerProject(){

        @Override
        public void put() {
        }

        @Override
        public void putDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        }
    };

    public DeclarationContainerProject(ProjectBase projectBase) {
        super(new ProjectDeclarationContainerKey(projectBase.getUniqueName()), false);
        this.friends = new ConcurrentHashMap<CharSequence, Set<CsmUID<CsmFriend>>>();
        this.put();
    }

    public DeclarationContainerProject(DataInput dataInput) throws IOException {
        super(dataInput);
        int n = dataInput.readInt();
        this.friends = new ConcurrentHashMap<CharSequence, Set<CsmUID<CsmFriend>>>(n);
        UIDObjectFactory.getDefaultFactory().readStringToUIDMapSet(this.friends, dataInput, UniqueNameCache.getManager(), n);
    }

    private DeclarationContainerProject() {
        super(null, false);
        this.friends = new ConcurrentHashMap<CharSequence, Set<CsmUID<CsmFriend>>>();
    }

    public static DeclarationContainerProject empty() {
        return EMPTY;
    }

    @Override
    protected void onRemoveDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmFriend csmFriend;
        CharSequence charSequence;
        Set<CsmUID<CsmFriend>> set;
        if (CsmKindUtilities.isFriendClass((CsmObject)csmOffsetableDeclaration)) {
            CsmFriend csmFriend2 = (CsmFriend)csmOffsetableDeclaration;
            CharSequence charSequence2 = CharSequences.create((CharSequence)csmFriend2.getName());
            Set<CsmUID<CsmFriend>> set2 = this.friends.get(charSequence2);
            if (set2 != null) {
                set2.remove(UIDs.get((Object)csmFriend2));
                if (set2.isEmpty()) {
                    this.friends.remove(charSequence2);
                }
            }
        } else if (CsmKindUtilities.isFriendMethod((CsmObject)csmOffsetableDeclaration) && (set = this.friends.get(charSequence = CharSequences.create((CharSequence)((CsmFriendFunction)(csmFriend = (CsmFriend)csmOffsetableDeclaration)).getSignature()))) != null) {
            set.remove(UIDs.get((Object)csmFriend));
            if (set.isEmpty()) {
                this.friends.remove(charSequence);
            }
        }
    }

    @Override
    public void removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        super.removeDeclaration(csmOffsetableDeclaration);
    }

    @Override
    public void putDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        super.putDeclaration(csmOffsetableDeclaration);
    }

    @Override
    public Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence charSequence) {
        Collection<CsmOffsetableDeclaration> collection = super.findDeclarations(charSequence);
        return collection;
    }

    @Override
    public CsmDeclaration getDeclaration(CharSequence charSequence) {
        CsmDeclaration csmDeclaration = super.getDeclaration(charSequence);
        return csmDeclaration;
    }

    @Override
    protected void onPutDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (CsmKindUtilities.isFriendClass((CsmObject)csmOffsetableDeclaration)) {
            CsmFriend csmFriend = (CsmFriend)csmOffsetableDeclaration;
            CharSequence charSequence = CharSequences.create((CharSequence)csmFriend.getName());
            Set<CsmUID<CsmFriend>> set = this.friends.get(charSequence);
            if (set == null) {
                set = new HashSet<CsmUID<CsmFriend>>();
                this.friends.put(charSequence, set);
            }
            set.add((CsmUID<CsmFriend>)UIDs.get((Object)csmFriend));
        } else if (CsmKindUtilities.isFriendMethod((CsmObject)csmOffsetableDeclaration)) {
            CsmFriend csmFriend = (CsmFriend)csmOffsetableDeclaration;
            CharSequence charSequence = CharSequences.create((CharSequence)((CsmFriendFunction)csmFriend).getSignature());
            Set<CsmUID<CsmFriend>> set = this.friends.get(charSequence);
            if (set == null) {
                set = new HashSet<CsmUID<CsmFriend>>();
                this.friends.put(charSequence, set);
            }
            set.add((CsmUID<CsmFriend>)UIDs.get((Object)csmFriend));
        }
    }

    SortedMap<CharSequence, Set<CsmUID<CsmFriend>>> testFriends() {
        return new TreeMap<CharSequence, Set<CsmUID<CsmFriend>>>(this.friends);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmFriend> findFriends(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        Object object;
        CharSequence charSequence = null;
        if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) {
            object = (CsmClass)csmOffsetableDeclaration;
            charSequence = object.getName();
        } else if (CsmKindUtilities.isFunction((CsmObject)csmOffsetableDeclaration)) {
            object = (CsmFunction)csmOffsetableDeclaration;
            charSequence = object.getSignature();
        }
        if (charSequence != null) {
            Collection<Object> collection;
            charSequence = CharSequences.create((CharSequence)charSequence);
            object = new ArrayList();
            try {
                this.getLock().readLock().lock();
                collection = this.friends.get(charSequence);
                if (collection != null) {
                    object.addAll(collection);
                }
            }
            finally {
                this.getLock().readLock().unlock();
            }
            if (object.size() > 0) {
                collection = new ArrayList();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    CsmFriendClass csmFriendClass;
                    CsmUID csmUID = (CsmUID)iterator.next();
                    CsmFriend csmFriend = (CsmFriend)csmUID.getObject();
                    if (CsmKindUtilities.isFriendClass((CsmObject)csmFriend)) {
                        csmFriendClass = (CsmFriendClass)csmFriend;
                        if (!csmOffsetableDeclaration.equals(csmFriendClass.getReferencedClass())) continue;
                        collection.add((CsmUID<CsmFriend>)csmFriendClass);
                        continue;
                    }
                    if (!CsmKindUtilities.isFriendMethod((CsmObject)csmFriend) || !csmOffsetableDeclaration.equals((csmFriendClass = (CsmFriendFunction)csmFriend).getReferencedFunction())) continue;
                    collection.add(csmFriendClass);
                }
                return collection;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        try {
            this.getLock().readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMapSet(this.friends, dataOutput);
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }
}

