/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spi;

import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.spi.editor.hints.Severity;

public abstract class AbstractHint
implements TreeRule {
    private boolean enableDefault;
    private boolean showInTaskListDefault;
    private HintSeverity severityDefault;
    private String[] suppressBy;

    public AbstractHint(boolean enableDefault, boolean showInTaskListDefault, HintSeverity severityDefault, String ... suppressBy) {
        this.enableDefault = enableDefault;
        this.showInTaskListDefault = showInTaskListDefault;
        this.severityDefault = severityDefault;
        this.suppressBy = suppressBy;
    }

    public Preferences getPreferences(String profile) {
        return RulesManager.getPreferences(this.getId(), profile);
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    public abstract String getDescription();

    public final boolean isEnabled() {
        return HintsSettings.isEnabled(this, this.getPreferences(HintsSettings.getCurrentProfileId()));
    }

    public final HintSeverity getSeverity() {
        return HintsSettings.getSeverity(this, this.getPreferences(HintsSettings.getCurrentProfileId()));
    }

    static {
        HintsSettings.HINTS_ACCESSOR = new HintAccessorImpl();
    }

    private static class HintAccessorImpl
    implements HintsSettings.HintsAccessor {
        private HintAccessorImpl() {
        }

        @Override
        public boolean isEnabledDefault(AbstractHint hint) {
            return hint.enableDefault;
        }

        @Override
        public boolean isShowInTaskListDefault(AbstractHint hint) {
            return hint.showInTaskListDefault;
        }

        @Override
        public HintSeverity severiryDefault(AbstractHint hint) {
            return hint.severityDefault;
        }

        @Override
        public String[] getSuppressBy(AbstractHint hint) {
            return hint.suppressBy;
        }
    }

    public static enum HintSeverity {
        ERROR,
        WARNING,
        CURRENT_LINE_WARNING;


        public Severity toEditorSeverity() {
            switch (this) {
                case ERROR: {
                    return Severity.ERROR;
                }
                case WARNING: {
                    return Severity.VERIFIER;
                }
                case CURRENT_LINE_WARNING: {
                    return Severity.HINT;
                }
            }
            return null;
        }
    }
}

