/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public final class RemoveUselessCast
implements ErrorRule<Void> {
    @Override
    public Set<String> getCodes() {
        return Collections.singleton("compiler.warn.redundant.cast");
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        TreePath path = info.getTreeUtilities().pathFor(offset + 1);
        if (path != null && path.getLeaf().getKind() == Tree.Kind.TYPE_CAST) {
            return Collections.singletonList(JavaFix.toEditorFix(new FixImpl(info, path)));
        }
        return Collections.emptyList();
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return RemoveUselessCast.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(RemoveUselessCast.class, (String)"LBL_Remove_Useless_Cast_Fix");
    }

    public String getDescription() {
        return NbBundle.getMessage(RemoveUselessCast.class, (String)"DSC_Remove_Useless_Cast_Fix");
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath path) {
            super(info, path);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(RemoveUselessCast.class, (String)"LBL_FIX_Remove_redundant_cast");
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath path, JavaFix.UpgradeUICallback callback) {
            TypeCastTree tct = (TypeCastTree)path.getLeaf();
            ExpressionTree expression = tct.getExpression();
            while (expression.getKind() == Tree.Kind.PARENTHESIZED && !FixImpl.requiresParenthesis(((ParenthesizedTree)expression).getExpression(), tct, path.getParentPath().getLeaf())) {
                expression = ((ParenthesizedTree)expression).getExpression();
            }
            while (path.getParentPath().getLeaf().getKind() == Tree.Kind.PARENTHESIZED && !FixImpl.requiresParenthesis(expression, path.getLeaf(), path.getParentPath().getParentPath().getLeaf())) {
                path = path.getParentPath();
            }
            wc.rewrite(path.getLeaf(), (Tree)expression);
        }
    }
}

