/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.MagicSurroundWithTryCatchFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

class OrigSurroundWithTryCatchFix
implements Fix {
    private JavaSource javaSource;
    private List<TypeMirrorHandle> thandles;
    private TreePathHandle path;
    private List<String> fqns;

    public OrigSurroundWithTryCatchFix(JavaSource javaSource, List<TypeMirrorHandle> thandles, TreePathHandle path, List<String> fqns) {
        this.javaSource = javaSource;
        this.thandles = thandles;
        this.path = path;
        this.fqns = fqns;
    }

    public String getText() {
        return NbBundle.getMessage(MagicSurroundWithTryCatchFix.class, (String)"LBL_SurroundStatementWithTryCatch");
    }

    public ChangeInfo implement() throws Exception {
        this.javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy parameter) throws Exception {
                parameter.toPhase(JavaSource.Phase.RESOLVED);
                TreePath p = OrigSurroundWithTryCatchFix.this.path.resolve((CompilationInfo)parameter);
                if (p == null) {
                    return;
                }
                if ((p = OrigSurroundWithTryCatchFix.this.findStatement(p)) == null) {
                    return;
                }
                StatementTree leaf = (StatementTree)p.getLeaf();
                if (leaf.getKind() == Tree.Kind.VARIABLE && p.getParentPath().getLeaf().getKind() == Tree.Kind.FOR_LOOP) {
                    p = p.getParentPath();
                    leaf = (StatementTree)p.getLeaf();
                }
                GeneratorUtilities.get((WorkingCopy)parameter).importComments(p.getParentPath().getLeaf(), parameter.getCompilationUnit());
                TreeMaker make = parameter.getTreeMaker();
                if (leaf.getKind() == Tree.Kind.VARIABLE) {
                    TreePath block;
                    Element e = parameter.getTrees().getElement(p);
                    VariableTree vt = (VariableTree)leaf;
                    if (e != null && e.getKind() == ElementKind.LOCAL_VARIABLE && (block = OrigSurroundWithTryCatchFix.this.findBlockOrCase(p)) != null) {
                        boolean sep;
                        boolean bl = sep = new FindUsages(leaf, (CompilationInfo)parameter).scan(block, (VariableElement)e) == Boolean.TRUE;
                        if (sep) {
                            StatementTree assignment = make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.Identifier((CharSequence)vt.getName()), vt.getInitializer()));
                            StatementTree declaration = make.Variable(vt.getModifiers(), (CharSequence)vt.getName(), vt.getType(), null);
                            declaration = Utilities.copyComments(parameter, vt, declaration, true);
                            assignment = Utilities.copyComments(parameter, vt, assignment, false);
                            TryTree tryTree = make.Try(make.Block(Collections.singletonList(assignment), false), MagicSurroundWithTryCatchFix.createCatches((CompilationInfo)parameter, make, OrigSurroundWithTryCatchFix.this.thandles, p), null);
                            LinkedList<StatementTree> nueStatements = new LinkedList<StatementTree>();
                            if (block.getLeaf().getKind() == Tree.Kind.BLOCK) {
                                BlockTree bt = (BlockTree)block.getLeaf();
                                int index = bt.getStatements().indexOf(leaf);
                                assert (index != -1);
                                nueStatements.addAll(bt.getStatements().subList(0, index));
                                nueStatements.add(declaration);
                                nueStatements.add(tryTree);
                                nueStatements.addAll(bt.getStatements().subList(index + 1, bt.getStatements().size()));
                                parameter.rewrite((Tree)bt, (Tree)make.Block(nueStatements, false));
                            } else {
                                CaseTree ct = (CaseTree)block.getLeaf();
                                int index = ct.getStatements().indexOf(leaf);
                                assert (index != -1);
                                nueStatements.addAll(ct.getStatements().subList(0, index));
                                nueStatements.add(declaration);
                                nueStatements.add(tryTree);
                                nueStatements.addAll(ct.getStatements().subList(index + 1, ct.getStatements().size()));
                                parameter.rewrite((Tree)ct, (Tree)make.Case(ct.getExpression(), nueStatements));
                            }
                            return;
                        }
                    }
                }
                TryTree tryTree = make.Try(make.Block(Collections.singletonList(leaf), false), MagicSurroundWithTryCatchFix.createCatches((CompilationInfo)parameter, make, OrigSurroundWithTryCatchFix.this.thandles, p), null);
                parameter.rewrite((Tree)leaf, (Tree)tryTree);
            }
        }).commit();
        return null;
    }

    private TreePath findStatement(TreePath path) {
        while (path != null && !StatementTree.class.isAssignableFrom(path.getLeaf().getKind().asInterface())) {
            path = path.getParentPath();
        }
        return path;
    }

    private TreePath findBlockOrCase(TreePath path) {
        while (path != null && path.getLeaf().getKind() != Tree.Kind.BLOCK && path.getLeaf().getKind() != Tree.Kind.CASE) {
            path = path.getParentPath();
        }
        return path;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrigSurroundWithTryCatchFix other = (OrigSurroundWithTryCatchFix)obj;
        if (!(this.javaSource == other.javaSource || this.javaSource != null && this.javaSource.equals(other.javaSource))) {
            return false;
        }
        if (!this.path.equals((Object)other.path)) {
            return false;
        }
        return ((Object)this.fqns).equals(other.fqns);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.javaSource != null ? this.javaSource.hashCode() : 0);
        return hash;
    }

    private static final class FindUsages
    extends TreePathScanner<Boolean, VariableElement> {
        private Tree ignore;
        private CompilationInfo info;

        public FindUsages(Tree ignore, CompilationInfo info) {
            this.ignore = ignore;
            this.info = info;
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree node, VariableElement p) {
            return p.equals(this.info.getTrees().getElement(this.getCurrentPath()));
        }

        @Override
        public Boolean scan(Tree tree, VariableElement p) {
            if (tree == this.ignore) {
                return false;
            }
            return (Boolean)super.scan(tree, p);
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
        }
    }
}

