/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.GuardedException;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ImplementAllAbstractMethods
implements ErrorRule<Void> {
    private static final String PREMATURE_EOF_CODE = "compiler.err.premature.eof";

    @Override
    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.abstract.cant.be.instantiated", "compiler.err.does.not.override.abstract", "compiler.err.abstract.cant.be.instantiated"));
    }

    @Override
    public List<Fix> run(final CompilationInfo info, String diagnosticKey, final int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        final ArrayList<Fix> result = new ArrayList<Fix>();
        ImplementAllAbstractMethods.analyze(offset, info, new Performer(){

            @Override
            public void fixAllAbstractMethods(TreePath pathToModify, Tree toModify) {
                result.add(new FixImpl(info.getJavaSource(), offset, null));
            }

            @Override
            public void makeClassAbstract(Tree toModify, String className) {
                result.add(new FixImpl(info.getJavaSource(), offset, className));
            }
        });
        return result;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return ImplementAllAbstractMethods.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"LBL_Impl_Abstract_Methods");
    }

    public String getDescription() {
        return NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"DSC_Impl_Abstract_Methods");
    }

    private static void analyze(int offset, CompilationInfo info, Performer performer) {
        TreePath path = info.getTreeUtilities().pathFor(offset + 1);
        Element e = info.getTrees().getElement(path);
        boolean isUsableElement = e != null && (e.getKind().isClass() || e.getKind().isInterface());
        final Tree leaf = path.getLeaf();
        if (isUsableElement) {
            if (e.getKind() != ElementKind.ENUM) {
                for (ExecutableElement ee : ElementFilter.methodsIn(e.getEnclosedElements())) {
                    if (!ee.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                    performer.makeClassAbstract(leaf, e.getSimpleName().toString());
                    return;
                }
            }
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)leaf.getKind())) {
                CompilationUnitTree cut = info.getCompilationUnit();
                long start = info.getTrees().getSourcePositions().getStartPosition(cut, leaf);
                long end = info.getTrees().getSourcePositions().getEndPosition(cut, leaf);
                for (Diagnostic d : info.getDiagnostics()) {
                    long position = d.getPosition();
                    if (!d.getCode().equals(PREMATURE_EOF_CODE) || position <= start || position >= end) continue;
                    return;
                }
            }
            performer.fixAllAbstractMethods(path, leaf);
        } else if (leaf.getKind() == Tree.Kind.NEW_CLASS) {
            final boolean[] parentError = new boolean[]{false};
            new TreePathScanner(){

                @Override
                public Object visitNewClass(NewClassTree nct, Object o) {
                    if (leaf == nct) {
                        parentError[0] = this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.ERRONEOUS;
                    }
                    return super.visitNewClass(nct, o);
                }
            }.scan(path.getParentPath(), null);
            if (!parentError[0]) {
                performer.fixAllAbstractMethods(path, leaf);
            }
        }
    }

    static final class FixImpl
    implements Fix {
        private JavaSource js;
        private int offset;
        private String makeClassAbstractName;

        public FixImpl(JavaSource js, int offset, String makeClassAbstractName) {
            this.js = js;
            this.offset = offset;
            this.makeClassAbstractName = makeClassAbstractName;
        }

        public String getText() {
            return this.makeClassAbstractName == null ? NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"LBL_FIX_Impl_Abstract_Methods") : NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"LBL_FIX_Make_Class_Abstract", (Object)this.makeClassAbstractName);
        }

        public ChangeInfo implement() throws IOException {
            final boolean[] repeat = new boolean[]{true};
            while (repeat[0]) {
                repeat[0] = false;
                this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(final WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.RESOLVED);
                        ImplementAllAbstractMethods.analyze(FixImpl.this.offset, (CompilationInfo)copy, new Performer(){

                            @Override
                            public void fixAllAbstractMethods(TreePath pathToModify, Tree toModify) {
                                if (toModify.getKind() == Tree.Kind.NEW_CLASS) {
                                    int insertOffset = (int)copy.getTrees().getSourcePositions().getEndPosition(copy.getCompilationUnit(), toModify);
                                    if (insertOffset != -1) {
                                        try {
                                            copy.getDocument().insertString(insertOffset, " {}", null);
                                            FixImpl.this.offset = insertOffset + 1;
                                            repeat[0] = true;
                                        }
                                        catch (GuardedException e) {
                                            SwingUtilities.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    String message = NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"ERR_CannotApplyGuarded");
                                                    StatusDisplayer.getDefault().setStatusText(message);
                                                }
                                            });
                                        }
                                        catch (BadLocationException e) {
                                            Exceptions.printStackTrace((Throwable)e);
                                        }
                                        catch (IOException e) {
                                            Exceptions.printStackTrace((Throwable)e);
                                        }
                                    }
                                } else {
                                    GeneratorUtils.generateAllAbstractMethodImplementations((WorkingCopy)copy, (TreePath)pathToModify);
                                }
                            }

                            @Override
                            public void makeClassAbstract(Tree toModify, String className) {
                                if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)toModify.getKind())) {
                                    ClassTree clazz = (ClassTree)toModify;
                                    ModifiersTree modifiers = clazz.getModifiers();
                                    HashSet<Modifier> newModifiersSet = new HashSet<Modifier>(modifiers.getFlags());
                                    newModifiersSet.add(Modifier.ABSTRACT);
                                    copy.rewrite((Tree)modifiers, (Tree)copy.getTreeMaker().Modifiers(newModifiersSet, modifiers.getAnnotations()));
                                }
                            }
                        });
                    }
                }).commit();
            }
            return null;
        }

        String toDebugString() {
            return this.makeClassAbstractName == null ? "IAAM" : "MA:" + this.makeClassAbstractName;
        }
    }

    private static interface Performer {
        public void fixAllAbstractMethods(TreePath var1, Tree var2);

        public void makeClassAbstract(Tree var1, String var2);
    }
}

