/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WrongPackageSuggestion
extends AbstractHint {
    public WrongPackageSuggestion() {
        super(true, true, AbstractHint.HintSeverity.ERROR, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return Collections.singleton(Tree.Kind.COMPILATION_UNIT);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        long endPos;
        long startPos;
        boolean hasPackageClause;
        Tree t = treePath.getLeaf();
        assert (t.getKind() == Tree.Kind.COMPILATION_UNIT);
        CompilationUnitTree tree = (CompilationUnitTree)t;
        StringBuffer packageNameBuffer = new StringBuffer();
        boolean bl = hasPackageClause = tree.getPackageName() != null;
        if (hasPackageClause) {
            new TreeScanner<Void, StringBuffer>(){

                @Override
                public Void visitIdentifier(IdentifierTree node, StringBuffer p) {
                    p.append(node.getName().toString());
                    return null;
                }

                @Override
                public Void visitMemberSelect(MemberSelectTree node, StringBuffer p) {
                    super.visitMemberSelect(node, p);
                    p.append('.');
                    p.append(node.getIdentifier().toString());
                    return null;
                }
            }.scan(tree.getPackageName(), packageNameBuffer);
        } else if (tree.getTypeDecls().isEmpty()) {
            return null;
        }
        String packageName = packageNameBuffer.toString();
        ClassPath cp = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        if (cp == null || !cp.isResourceVisible(info.getFileObject())) {
            Logger.getLogger(WrongPackageSuggestion.class.getName()).log(Level.INFO, "source cp is either null or does not contain the compiled source cp={0}", cp);
            return null;
        }
        String packageLocation = cp.getResourceName(info.getFileObject().getParent(), '.', false);
        if (WrongPackageSuggestion.isCaseSensitive() && packageName.equals(packageLocation) || !WrongPackageSuggestion.isCaseSensitive() && packageName.toLowerCase().equals(packageLocation.toLowerCase())) {
            return null;
        }
        if (hasPackageClause) {
            startPos = info.getTrees().getSourcePositions().getStartPosition(tree, tree.getPackageName());
            endPos = info.getTrees().getSourcePositions().getEndPosition(tree, tree.getPackageName());
        } else {
            startPos = 0L;
            endPos = 1L;
        }
        if (startPos == -1L || endPos == -1L) {
            return null;
        }
        List<Fix> fixes = Arrays.asList(new MoveToCorrectPlace(info.getFileObject(), cp, packageName), new CorrectPackageDeclarationFix(info.getFileObject(), packageLocation));
        String description = NbBundle.getMessage(WrongPackageSuggestion.class, (String)"HINT_WrongPackage");
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)description, fixes, (FileObject)info.getFileObject(), (int)((int)startPos), (int)((int)endPos)));
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return WrongPackageSuggestion.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(WrongPackageSuggestion.class, (String)"DN_WrongPackage");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(WrongPackageSuggestion.class, (String)"DESC_WrongPackage");
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private static boolean isCaseSensitive() {
        return !new File("a").equals(new File("A"));
    }

    static final class CorrectPackageDeclarationFix
    implements Fix {
        private FileObject file;
        private String packageName;

        public CorrectPackageDeclarationFix(FileObject file, String packageName) {
            this.file = file;
            this.packageName = packageName;
        }

        public String getText() {
            return NbBundle.getMessage(WrongPackageSuggestion.class, (String)"FIX_WrongPackageFix", (Object)(this.packageName.length() == 0 ? 0 : 1), (Object)this.packageName);
        }

        public ChangeInfo implement() throws IOException {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws Exception {
                    copy.toPhase(JavaSource.Phase.PARSED);
                    CompilationUnitTree cut = copy.getCompilationUnit();
                    if (CorrectPackageDeclarationFix.this.packageName.length() == 0) {
                        copy.rewrite((Tree)cut, (Tree)copy.getTreeMaker().CompilationUnit(cut.getPackageAnnotations(), null, cut.getImports(), cut.getTypeDecls(), cut.getSourceFile()));
                    } else if (cut.getPackageName() == null) {
                        copy.rewrite((Tree)cut, (Tree)copy.getTreeMaker().CompilationUnit(cut.getPackageAnnotations(), CorrectPackageDeclarationFix.this.createForFQN(copy, CorrectPackageDeclarationFix.this.packageName), cut.getImports(), cut.getTypeDecls(), cut.getSourceFile()));
                    } else {
                        copy.rewrite((Tree)cut.getPackageName(), (Tree)CorrectPackageDeclarationFix.this.createForFQN(copy, CorrectPackageDeclarationFix.this.packageName));
                    }
                }
            }).commit();
            return null;
        }

        private ExpressionTree createForFQN(WorkingCopy copy, String fqn) {
            int dot = fqn.indexOf(46);
            if (dot == -1) {
                return copy.getTreeMaker().Identifier((CharSequence)fqn);
            }
            return copy.getTreeMaker().MemberSelect(this.createForFQN(copy, fqn.substring(0, dot)), (CharSequence)fqn.substring(dot + 1));
        }
    }

    static final class MoveToCorrectPlace
    implements Fix {
        private FileObject file;
        private ClassPath cp;
        private String packageName;

        public MoveToCorrectPlace(FileObject file, ClassPath cp, String packageName) {
            this.file = file;
            this.cp = cp;
            this.packageName = packageName;
        }

        public String getText() {
            return NbBundle.getMessage(WrongPackageSuggestion.class, (String)"FIX_WrongPackageMove");
        }

        public ChangeInfo implement() {
            try {
                String path = this.packageName.replace('.', '/');
                FileObject root = this.cp.findOwnerRoot(this.file);
                FileObject packFile = root.getFileObject(path);
                if (packFile != null && !packFile.isFolder()) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WrongPackageSuggestion.class, (String)"ERR_CannotMoveAlreadyExists"), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                    return null;
                }
                packFile = FileUtil.createFolder((FileObject)root, (String)this.packageName.replace('.', '/'));
                DataObject fileDO = DataObject.find((FileObject)this.file);
                DataFolder folder = DataFolder.findFolder((FileObject)packFile);
                fileDO.move(folder);
            }
            catch (IllegalArgumentException e) {
                Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(WrongPackageSuggestion.class, (String)"ERR_CannotMove"));
                ErrorManager.getDefault().notify(256, (Throwable)e);
                Logger.getLogger(WrongPackageSuggestion.class.getName()).log(Level.INFO, null, e);
            }
            catch (IOException e) {
                Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(WrongPackageSuggestion.class, (String)"ERR_CannotMove"));
                ErrorManager.getDefault().notify(256, (Throwable)e);
                Logger.getLogger(WrongPackageSuggestion.class.getName()).log(Level.INFO, null, e);
            }
            return null;
        }
    }
}

