/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.DoubleCheck;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class StaticAccess
extends AbstractHint {
    private static final String SUPPRESS_WARNINGS_KEY = "static-access";
    private volatile transient boolean stop;

    public StaticAccess() {
        super(true, true, AbstractHint.HintSeverity.WARNING, SUPPRESS_WARNINGS_KEY);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.MEMBER_SELECT);
    }

    protected List<Fix> computeFixes(CompilationInfo info, TreePath treePath, int[] bounds, int[] kind, String[] simpleName) {
        Element used;
        if (treePath.getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
            return null;
        }
        MemberSelectTree mst = (MemberSelectTree)treePath.getLeaf();
        ExpressionTree expression = mst.getExpression();
        TreePath expr = new TreePath(treePath, expression);
        TypeMirror tm = info.getTrees().getTypeMirror(expr);
        if (tm == null) {
            return null;
        }
        Element el = info.getTypes().asElement(tm);
        if (el == null || el.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement type = (TypeElement)el;
        if (this.isError(type)) {
            return null;
        }
        Name idName = null;
        if (expression.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree exprSelect = (MemberSelectTree)expression;
            idName = exprSelect.getIdentifier();
        }
        if (expression.getKind() == Tree.Kind.IDENTIFIER) {
            IdentifierTree idt = (IdentifierTree)expression;
            idName = idt.getName();
        }
        if (idName != null) {
            if (((Object)idName).equals(type.getSimpleName())) {
                return null;
            }
            if (((Object)idName).equals(type.getQualifiedName())) {
                return null;
            }
        }
        if ((used = info.getTrees().getElement(treePath)) == null || !used.getModifiers().contains((Object)Modifier.STATIC)) {
            return null;
        }
        if (this.isError(used)) {
            return null;
        }
        int[] span = new int[]{(int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), expression), (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), expression)};
        if (span[0] == -1 || span[1] == -1) {
            return null;
        }
        kind[0] = used.getKind().isField() ? 0 : (used.getKind() == ElementKind.METHOD ? 1 : 2);
        simpleName[0] = used.getSimpleName().toString();
        ArrayList<Fix> fixes = new ArrayList<Fix>(2);
        fixes.add(JavaFix.toEditorFix(new FixImpl(info, expr, type)));
        fixes.addAll(FixFactory.createSuppressWarnings(info, treePath, SUPPRESS_WARNINGS_KEY));
        bounds[0] = span[0];
        bounds[1] = span[1];
        return fixes;
    }

    private boolean isError(Element e) {
        if (e == null) {
            return true;
        }
        if (e.getKind() != ElementKind.CLASS) {
            return false;
        }
        TypeMirror type = ((TypeElement)e).asType();
        return type == null || type.getKind() == TypeKind.ERROR;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        this.stop = false;
        int[] span = new int[2];
        int[] kind = new int[1];
        String[] simpleName = new String[1];
        List<Fix> fixes = this.computeFixes(compilationInfo, treePath, span, kind, simpleName);
        if (fixes == null) {
            return null;
        }
        ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(StaticAccess.class, (String)"MSG_StaticAccess", (Object)kind[0], (Object)simpleName[0]), fixes, (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]);
        return Collections.singletonList(ed);
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_StaticAccessName");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"HINT_StaticAccess");
    }

    @Override
    public void cancel() {
        this.stop = true;
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    static final class FixImpl
    extends JavaFix {
        private final ElementHandle<TypeElement> desiredType;

        public FixImpl(CompilationInfo info, TreePath expr, TypeElement desiredType) {
            super(info, expr);
            this.desiredType = ElementHandle.create((Element)desiredType);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_StaticAccessText");
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath tp, JavaFix.UpgradeUICallback callback) {
            Element element = this.desiredType.resolve((CompilationInfo)wc);
            if (element == null) {
                Logger.getLogger("org.netbeans.modules.java.hints").log(Level.INFO, "Cannot resolve target element.");
                return;
            }
            ExpressionTree idt = wc.getTreeMaker().QualIdent(element);
            wc.rewrite(tp.getLeaf(), (Tree)idt);
        }
    }
}

