/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.autoupdate.ui.DetailsPanel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.SettingsTableModel;
import org.netbeans.modules.autoupdate.ui.UnitDetails;
import org.netbeans.modules.autoupdate.ui.UnitTab;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.UpdateUnitProviderPanel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class SettingsTab
extends JPanel {
    private DetailsPanel details;
    private JScrollPane scrollerForDetails;
    private JTable table;
    private JScrollPane scrollerForTable;
    private Action removeAction;
    private Action editAction;
    private Action addAction;
    private Listener listener;
    private PluginManagerUI manager;
    private boolean refreshModel;
    private JButton addButton;
    private JButton bProxy;
    private JComboBox cbCheckPeriod;
    private JCheckBox cbGlobalInstall;
    private JSeparator jSeparatorAdvanced;
    private JSeparator jSeparatorConnection;
    private JLabel lCheckPeriod;
    private JLabel lConnection;
    private JLabel lGeneral;
    private JLabel lUpdateCenters;
    private ButtonGroup pluginsViewGroup;
    private JSplitPane spTab;

    public SettingsTab(PluginManagerUI manager) {
        this.manager = manager;
        this.initComponents();
        this.scrollerForTable = new JScrollPane();
        this.table = new Table();
        this.scrollerForTable.setViewportView(this.table);
        this.scrollerForDetails = new JScrollPane();
        this.details = new DetailsPanel();
        this.scrollerForDetails.setViewportView(this.details);
        this.spTab.setLeftComponent(this.scrollerForTable);
        this.spTab.setRightComponent(this.scrollerForDetails);
        this.table.setModel(new SettingsTableModel());
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(1).setCellRenderer(new UpdateProviderRenderer());
        this.cbCheckPeriod.setModel(new DefaultComboBoxModel<String>(new String[]{SettingsTab.getMessage("CTL_Update_every_startup"), SettingsTab.getMessage("CTL_Update_every_day"), SettingsTab.getMessage("CTL_Update_every_week"), SettingsTab.getMessage("CTL_Update_every_2weeks"), SettingsTab.getMessage("CTL_Update_every_month"), SettingsTab.getMessage("CTL_Update_never")}));
        if (6 == this.getAutoUpdatePeriod()) {
            this.cbCheckPeriod.addItem(SettingsTab.getMessage("CTL_Update_custom"));
        }
        this.cbCheckPeriod.setSelectedIndex(this.getAutoUpdatePeriod());
        this.cbGlobalInstall.setSelected(Utilities.isGlobalInstallation());
        this.getSettingsTableModel().setSettingsTab(this);
        TableColumn activeColumn = this.table.getColumnModel().getColumn(0);
        activeColumn.setMaxWidth(this.table.getTableHeader().getHeaderRect((int)0).width);
        this.editAction = new EditAction();
        this.removeAction = new RemoveAction();
        this.addAction = new AddAction();
        this.addButton.setAction(this.addAction);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_displayName");
    }

    PluginManagerUI getPluginManager() {
        return this.manager;
    }

    private void addListener() {
        if (this.listener == null) {
            this.listener = new Listener();
            this.table.getSelectionModel().addListSelectionListener(this.listener);
            this.getSettingsTableModel().addTableModelListener(this.listener);
        }
    }

    private void removeListener() {
        if (this.listener != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.listener);
            this.getSettingsTableModel().removeTableModelListener(this.listener);
            this.listener = null;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Utilities.startAsWorkerThread(new Runnable(){

            @Override
            public void run() {
                SettingsTab.this.getSettingsTableModel().refreshModel();
            }
        });
        this.refreshModel = false;
        this.addListener();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeListener();
        this.doLazyRefresh(null);
    }

    public void doLazyRefresh(final Runnable postTask) {
        if (this.needRefresh()) {
            Utilities.startAsWorkerThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SettingsTab.this.setWaitingState(true);
                    try {
                        Utilities.presentRefreshProviders(SettingsTab.this.manager, false);
                        SettingsTab.this.manager.updateUnitsChanged();
                        if (postTask != null) {
                            postTask.run();
                        }
                    }
                    finally {
                        SettingsTab.this.setWaitingState(false);
                    }
                }
            });
        }
        this.refreshModel = false;
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(SettingsTab.class, (String)key);
    }

    private void initComponents() {
        this.pluginsViewGroup = new ButtonGroup();
        this.lUpdateCenters = new JLabel();
        this.spTab = new JSplitPane();
        this.addButton = new JButton();
        this.lConnection = new JLabel();
        this.jSeparatorConnection = new JSeparator();
        this.lCheckPeriod = new JLabel();
        this.cbCheckPeriod = new JComboBox();
        this.bProxy = new JButton();
        this.lGeneral = new JLabel();
        this.cbGlobalInstall = new JCheckBox();
        this.jSeparatorAdvanced = new JSeparator();
        Mnemonics.setLocalizedText((JLabel)this.lUpdateCenters, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lUpdateCenters.text"));
        this.spTab.setBorder(null);
        this.spTab.setDividerLocation(Integer.parseInt(NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_Splitter_DefaultDividerLocation")));
        this.spTab.setResizeWeight(0.5);
        this.spTab.setOneTouchExpandable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.addButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.lConnection, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lConnection.text"));
        this.lCheckPeriod.setLabelFor(this.cbCheckPeriod);
        Mnemonics.setLocalizedText((JLabel)this.lCheckPeriod, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lCheckPeriod.text"));
        this.cbCheckPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsTab.this.cbCheckPeriodActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bProxy, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bProxy.text"));
        this.bProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsTab.this.bProxyActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lGeneral, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lGeneral.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbGlobalInstall, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.text"));
        this.cbGlobalInstall.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbGlobalInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsTab.this.cbGlobalInstallActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.cbGlobalInstall)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addButton).addComponent(this.spTab, -1, 871, Short.MAX_VALUE)).addGap(1, 1, 1)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.lCheckPeriod).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbCheckPeriod, 0, 548, Short.MAX_VALUE).addGap(58, 58, 58).addComponent(this.bProxy)).addGroup(layout.createSequentialGroup().addComponent(this.lGeneral).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparatorAdvanced, -1, 792, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.lConnection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparatorConnection, -1, 630, Short.MAX_VALUE)).addComponent(this.lUpdateCenters)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lUpdateCenters).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spTab, -1, 37, Short.MAX_VALUE).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addGap(11, 11, 11).addComponent(this.jSeparatorConnection, -2, 10, -2)).addComponent(this.lConnection)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bProxy).addComponent(this.lCheckPeriod).addComponent(this.cbCheckPeriod, -2, -1, -2)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lGeneral, -2, 15, -2).addComponent(this.jSeparatorAdvanced, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbGlobalInstall).addContainerGap()));
    }

    private void cbGlobalInstallActionPerformed(ActionEvent evt) {
        if (this.cbGlobalInstall.isSelected()) {
            List<File> dirs = Utilities.sharedDirs();
            if (dirs.isEmpty()) {
                NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.NoSharedMessage"), NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.NoSharedTitle"), 0, 0, new Object[]{NotifyDescriptor.OK_OPTION}, null);
                DialogDisplayer.getDefault().notifyLater(nd);
                this.cbGlobalInstall.setSelected(false);
                return;
            }
            for (File f : dirs) {
                if (!f.exists() || !f.isDirectory() || Utilities.canWriteInCluster(f)) continue;
                NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.ReadOnlyMessage", (Object)f), NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.ReadOnlyTitle"), 0, 0, new Object[]{NotifyDescriptor.OK_OPTION}, null);
                DialogDisplayer.getDefault().notifyLater(nd);
                this.cbGlobalInstall.setSelected(false);
                return;
            }
            Utilities.setGlobalInstallation(true);
        } else {
            Utilities.setGlobalInstallation(false);
        }
    }

    private void cbCheckPeriodActionPerformed(ActionEvent evt) {
        this.setAutoUpdatePeriod(this.cbCheckPeriod.getSelectedIndex());
    }

    private void bProxyActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    public SettingsTableModel getSettingsTableModel() {
        return (SettingsTableModel)this.table.getModel();
    }

    private long lastModification(UpdateUnitProvider unitProvider) {
        Preferences p = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        return p.getLong(unitProvider.getName() + "_" + "lastCheckTime", 0L);
    }

    private boolean needRefresh() {
        return this.refreshModel;
    }

    public void setNeedRefresh() {
        this.refreshModel = true;
        this.getPluginManager().undecorateTabTitles();
    }

    private void setData(UpdateUnitProvider provider, UpdateUnitProviderPanel panel) {
        provider.setDisplayName(panel.getProviderName());
        boolean forceRead = false;
        try {
            URL oldUrl = provider.getProviderURL();
            URL newUrl = new URL(panel.getProviderURL());
            if (!oldUrl.toExternalForm().equals(newUrl.toExternalForm())) {
                provider.setProviderURL(newUrl);
                this.setNeedRefresh();
                forceRead = true;
            }
        }
        catch (MalformedURLException mex) {
            Logger.getLogger(SettingsTab.class.getName()).log(Level.INFO, mex.getLocalizedMessage(), mex);
        }
        provider.setEnable(panel.isActive());
        if (panel.isActive()) {
            this.refreshProvider(provider, forceRead);
        } else {
            this.setNeedRefresh();
        }
    }

    public void refreshProvider(final UpdateUnitProvider provider, final boolean force) {
        this.setWaitingState(true);
        Utilities.startAsWorkerThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Utilities.presentRefreshProviders(Collections.singleton(provider), SettingsTab.this.getPluginManager(), force);
                    SettingsTab.this.getPluginManager().updateUnitsChanged();
                }
                finally {
                    SettingsTab.this.setWaitingState(false);
                }
            }
        });
    }

    private static DialogDescriptor getCustomizerDescriptor(UpdateUnitProviderPanel panel) {
        JButton bOK = panel.getOKButton();
        Object[] options = new Object[]{bOK, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, panel.getDisplayName(), true, options, DialogDescriptor.OK_OPTION, 0, null, null);
        return descriptor;
    }

    private int getAutoUpdatePeriod() {
        return AutoupdateSettings.getPeriod();
    }

    private void setAutoUpdatePeriod(int period) {
        if (period != this.getAutoUpdatePeriod()) {
            AutoupdateSettings.setPeriod(period);
            this.cbCheckPeriod.removeItem(SettingsTab.getMessage("CTL_Update_custom"));
        }
    }

    void setWaitingState(boolean waitingState) {
        this.getPluginManager().setWaitingState(waitingState);
        this.table.setEnabled(!waitingState);
    }

    private static class UpdateProviderRenderer
    extends DefaultTableCellRenderer {
        private UpdateProviderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel renderComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof UpdateUnitProvider) {
                UpdateUnitProvider u = (UpdateUnitProvider)value;
                Image img = u.getSourceIcon();
                Icon icon = ImageUtilities.image2Icon((Image)img);
                renderComponent.setIcon(icon);
                renderComponent.setText(u.getDisplayName());
                renderComponent.setHorizontalAlignment(2);
            }
            JLabel retval = renderComponent;
            return retval;
        }
    }

    private class Table
    extends JTable {
        public Table() {
            this.setShowGrid(false);
            this.setIntercellSpacing(new Dimension(0, 0));
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTable.class, (String)"ACN_UpdateCentersTable"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"ACD_UpdateCentersTable"));
            SettingsTab.this.lUpdateCenters.setLabelFor(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (UIManager.getLookAndFeel().getID().equals("Nimbus")) {
                this.getParent().setBackground(new Color(this.getBackground().getRGB(), false));
            } else {
                this.getParent().setBackground(this.getBackground());
            }
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
            Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
            Color bgColor = this.getBackground();
            Color bgColorDarker = UnitTable.getDarkerColor(bgColor);
            if (this.isRowSelected(rowIndex)) {
                c.setForeground(this.getSelectionForeground());
            } else {
                c.setForeground(this.getForeground());
            }
            if (!this.isCellSelected(rowIndex, vColIndex)) {
                if (rowIndex % 2 == 0) {
                    c.setBackground(bgColorDarker);
                } else {
                    c.setBackground(bgColor);
                }
            }
            return c;
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction() {
            super(UnitTab.textForKey("SettingsTab.AddButton.text"));
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey("SettingsTab.AddButton.text"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            final UpdateUnitProviderPanel panel = new UpdateUnitProviderPanel(true, NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_NewProviderName"), NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_NewProviderURL"), false);
            DialogDescriptor descriptor = SettingsTab.getCustomizerDescriptor(panel);
            panel.getOKButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        SettingsTab.this.getSettingsTableModel().add(panel.getProviderName(), panel.getProviderName(), new URL(panel.getProviderURL()), panel.isActive());
                        SettingsTab.this.getSettingsTableModel().refreshModel();
                        SettingsTableModel model = SettingsTab.this.getSettingsTableModel();
                        for (int i = 0; i < model.getRowCount(); ++i) {
                            String providerName = model.getValueAt(i, 1).toString();
                            if (panel.getProviderName() == null || !panel.getProviderName().equals(providerName)) continue;
                            SettingsTab.this.table.getSelectionModel().setSelectionInterval(i, i);
                        }
                    }
                    catch (MalformedURLException mex) {
                        Logger.getLogger(SettingsTab.class.getName()).log(Level.INFO, mex.getLocalizedMessage(), mex);
                    }
                }
            });
            DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction() {
            super(UnitTab.textForKey("SettingsTab.RemoveButton.text"));
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey("SettingsTab.RemoveButton.text"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] rowIndexes;
            SettingsTableModel model = SettingsTab.this.getSettingsTableModel();
            for (int rowIndex : rowIndexes = SettingsTab.this.table.getSelectedRows()) {
                UpdateUnitProvider provider;
                if (rowIndex == -1 || (provider = model.getUpdateUnitProvider(rowIndex)) == null) continue;
                String msg = NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bRemove.message", (Object)provider.getDisplayName());
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg);
                nd.setOptionType(0);
                Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (!NotifyDescriptor.YES_OPTION.equals(object)) continue;
                model.remove(rowIndex);
            }
            model.refreshModel();
            if (rowIndexes.length > 0) {
                if (model.getRowCount() > rowIndexes[0]) {
                    SettingsTab.this.table.getSelectionModel().setSelectionInterval(rowIndexes[0], rowIndexes[0]);
                } else {
                    SettingsTab.this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        }
    }

    private class EditAction
    extends AbstractAction {
        EditAction() {
            super(UnitTab.textForKey("SettingsTab.EditButton.text"));
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey("SettingsTab.EditButton.text"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            final int rowIndex = SettingsTab.this.table.getSelectedRow();
            if (rowIndex != -1) {
                final UpdateUnitProvider provider = SettingsTab.this.getSettingsTableModel().getUpdateUnitProvider(rowIndex);
                if (provider == null) {
                    return;
                }
                if (provider.getProviderURL() == null) {
                    return;
                }
                final UpdateUnitProviderPanel panel = new UpdateUnitProviderPanel(provider.isEnabled(), provider.getDisplayName(), provider.getProviderURL().toExternalForm(), true);
                DialogDescriptor descriptor = SettingsTab.getCustomizerDescriptor(panel);
                panel.getOKButton().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        SettingsTab.this.setData(provider, panel);
                        SettingsTab.this.table.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                    }
                });
                DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
                if (SettingsTab.this.listener != null) {
                    SettingsTab.this.listener.modelOrSelectionChanged();
                }
            }
        }
    }

    private class Listener
    implements ListSelectionListener,
    TableModelListener,
    Runnable {
        private final StringBuffer sb = new StringBuffer();
        private boolean sbEnabled;
        private UpdateUnitProvider uup;

        private Listener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            this.modelOrSelectionChanged();
        }

        @Override
        public void tableChanged(TableModelEvent arg0) {
            this.modelOrSelectionChanged();
        }

        private void modelOrSelectionChanged() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
                return;
            }
            int rowIndex = SettingsTab.this.table.getSelectedRow();
            if (rowIndex != -1 && SettingsTab.this.table.getRowCount() > 0) {
                this.uup = ((SettingsTableModel)SettingsTab.this.table.getModel()).getUpdateUnitProvider(rowIndex);
                if (this.uup != null) {
                    SettingsTab.this.details.setTitle(this.uup.getDisplayName());
                    UnitDetails.UNIT_DETAILS_PROCESSOR.post((Runnable)this);
                }
            } else {
                SettingsTab.this.details.setTitle(null);
                SettingsTab.this.details.setText(null);
                SettingsTab.this.details.setActionListener2(null);
                SettingsTab.this.details.setActionListener(null);
                ListSelectionModel lsm = SettingsTab.this.table.getSelectionModel();
                lsm.setSelectionInterval(0, 0);
            }
        }

        @Override
        public void run() {
            String desc;
            if (EventQueue.isDispatchThread()) {
                SettingsTab.this.details.setText(this.sb.toString());
                SettingsTab.this.details.setActionListener(SettingsTab.this.removeAction);
                SettingsTab.this.details.setActionListener2(SettingsTab.this.editAction);
                SettingsTab.this.editAction.setEnabled(this.sbEnabled);
                this.sb.setLength(0);
                return;
            }
            long lastTime = SettingsTab.this.lastModification(this.uup);
            if (lastTime > 0L) {
                this.sb.append("<b>").append(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadTime", (Object)"</b>")).append(new SimpleDateFormat().format(new Date(lastTime))).append("<br>");
            } else {
                String never = SettingsTab.getMessage("UnitTab_ReloadTime_Never");
                this.sb.append("<b>").append(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadTime", (Object)"</b>")).append(never).append("<br>");
            }
            URL u = this.uup.getProviderURL();
            String string = desc = this.uup.getDescription() == null ? "" : this.uup.getDescription();
            if (u != null) {
                if (desc.length() > 0) {
                    this.sb.append("<b>").append(SettingsTab.getMessage("SettingsTab_UpdateUnitProvider_Description")).append("</b><br>");
                    this.sb.append(desc).append("<br><br>");
                }
                this.sb.append("<b>" + SettingsTab.getMessage("SettingsTab_UpdateUnitProvider_URL") + " </b><a href=\"" + u.toExternalForm() + "\">" + u.toExternalForm() + "</a><br>");
                this.sbEnabled = true;
            } else {
                this.sbEnabled = false;
            }
            EventQueue.invokeLater(this);
        }
    }
}

