/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository.ui;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.repository.M2RepositoryBrowserTopComponent;
import org.netbeans.modules.maven.repository.ui.LicensePanel;
import org.netbeans.modules.maven.repository.ui.MailingListPanel;
import org.openide.awt.Actions;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ProjectInfoPanel
extends TopComponent
implements MultiViewElement,
LookupListener {
    private MultiViewElementCallback callback;
    private Lookup.Result<MavenProject> result;
    private JToolBar toolbar;
    private JButton btnCheckout;
    private JButton btnCimUrl;
    private JButton btnIssues;
    private JButton btnProjectHome;
    private JButton btnScmUrl;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblCimSystem;
    private JLabel lblCimUrl;
    private JLabel lblConnection;
    private JLabel lblDescription;
    private JLabel lblDevConnection;
    private JLabel lblIssues;
    private JLabel lblProjectHome;
    private JLabel lblProjectName;
    private JLabel lblScmUrl;
    private JLabel lblSystem;
    private JPanel pnlCim;
    private JPanel pnlIssues;
    private JPanel pnlLicense;
    private JPanel pnlMailingLists;
    private JPanel pnlScm;
    private JTextArea taDescription;
    private JTextField txtCimSystem;
    private JTextField txtConnection;
    private JTextField txtDevConnection;
    private JTextField txtProjectName;
    private JTextField txtSystem;

    public ProjectInfoPanel(Lookup lookup) {
        super(lookup);
        this.initComponents();
        this.btnCheckout.setIcon(null);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.jPanel1.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.pnlCim.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.pnlIssues.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.pnlLicense.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.jPanel4.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.pnlMailingLists.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.pnlScm.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.lblProjectName = new JLabel();
        this.txtProjectName = new JTextField();
        this.lblDescription = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taDescription = new JTextArea();
        this.lblProjectHome = new JLabel();
        this.btnProjectHome = new JButton();
        this.pnlIssues = new JPanel();
        this.lblSystem = new JLabel();
        this.txtSystem = new JTextField();
        this.lblIssues = new JLabel();
        this.btnIssues = new JButton();
        this.pnlScm = new JPanel();
        this.lblScmUrl = new JLabel();
        this.btnScmUrl = new JButton();
        this.lblConnection = new JLabel();
        this.txtConnection = new JTextField();
        this.lblDevConnection = new JLabel();
        this.txtDevConnection = new JTextField();
        this.btnCheckout = new JButton();
        this.pnlCim = new JPanel();
        this.lblCimSystem = new JLabel();
        this.txtCimSystem = new JTextField();
        this.lblCimUrl = new JLabel();
        this.btnCimUrl = new JButton();
        this.pnlLicense = new JPanel();
        this.pnlMailingLists = new JPanel();
        this.setLayout(new BorderLayout());
        this.lblProjectName.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ProjectInfoPanel.lblProjectName.text"));
        this.txtProjectName.setEditable(false);
        this.lblDescription.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ProjectInfoPanel.lblDescription.text"));
        this.taDescription.setColumns(20);
        this.taDescription.setEditable(false);
        this.taDescription.setRows(5);
        this.jScrollPane1.setViewportView(this.taDescription);
        this.lblProjectHome.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ProjectInfoPanel.lblProjectHome.text"));
        this.btnProjectHome.setText("prj url");
        this.btnProjectHome.setBorder(null);
        this.btnProjectHome.setBorderPainted(false);
        this.btnProjectHome.setContentAreaFilled(false);
        this.btnProjectHome.setHorizontalAlignment(10);
        this.pnlIssues.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ProjectInfoPanel.class, (String)"TIT_Issues")));
        this.lblSystem.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ProjectInfoPanel.lblSystem.text"));
        this.txtSystem.setEditable(false);
        this.lblIssues.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ProjectInfoPanel.lblIssues.text"));
        this.btnIssues.setText("isssue tracking url");
        this.btnIssues.setBorder(null);
        this.btnIssues.setBorderPainted(false);
        this.btnIssues.setContentAreaFilled(false);
        this.btnIssues.setHorizontalAlignment(10);
        GroupLayout pnlIssuesLayout = new GroupLayout(this.pnlIssues);
        this.pnlIssues.setLayout(pnlIssuesLayout);
        pnlIssuesLayout.setHorizontalGroup(pnlIssuesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlIssuesLayout.createSequentialGroup().addContainerGap().addGroup(pnlIssuesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSystem).addComponent(this.lblIssues)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlIssuesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnIssues, -1, 599, Short.MAX_VALUE).addComponent(this.txtSystem, -1, 599, Short.MAX_VALUE)).addContainerGap()));
        pnlIssuesLayout.setVerticalGroup(pnlIssuesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlIssuesLayout.createSequentialGroup().addGroup(pnlIssuesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSystem).addComponent(this.txtSystem, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlIssuesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnIssues).addComponent(this.lblIssues)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlScm.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ProjectInfoPanel.class, (String)"TIT_SCM")));
        this.lblScmUrl.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ProjectInfoPanel.lblScmUrl.text"));
        this.btnScmUrl.setText("scm url");
        this.btnScmUrl.setBorder(null);
        this.btnScmUrl.setBorderPainted(false);
        this.btnScmUrl.setContentAreaFilled(false);
        this.btnScmUrl.setHorizontalAlignment(10);
        this.lblConnection.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ProjectInfoPanel.lblConnection.text"));
        this.txtConnection.setEditable(false);
        this.lblDevConnection.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ProjectInfoPanel.lblDevConnection.text"));
        this.txtDevConnection.setEditable(false);
        this.btnCheckout.setAction(CommonArtifactActions.createScmCheckoutAction((Lookup)this.getLookup()));
        this.btnCheckout.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ProjectInfoPanel.btnCheckout.text"));
        GroupLayout pnlScmLayout = new GroupLayout(this.pnlScm);
        this.pnlScm.setLayout(pnlScmLayout);
        pnlScmLayout.setHorizontalGroup(pnlScmLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlScmLayout.createSequentialGroup().addContainerGap().addGroup(pnlScmLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblScmUrl).addComponent(this.lblConnection).addComponent(this.lblDevConnection)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlScmLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnScmUrl, -1, 541, Short.MAX_VALUE).addGroup(pnlScmLayout.createSequentialGroup().addGroup(pnlScmLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.txtDevConnection, GroupLayout.Alignment.LEADING, -1, 414, Short.MAX_VALUE).addComponent(this.txtConnection, GroupLayout.Alignment.LEADING, -1, 414, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCheckout))).addContainerGap()));
        pnlScmLayout.setVerticalGroup(pnlScmLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlScmLayout.createSequentialGroup().addGroup(pnlScmLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblScmUrl).addComponent(this.btnScmUrl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlScmLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblConnection).addComponent(this.txtConnection, -2, -1, -2).addComponent(this.btnCheckout)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlScmLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDevConnection).addComponent(this.txtDevConnection, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlCim.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ProjectInfoPanel.class, (String)"TIT_CIManagement")));
        this.lblCimSystem.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ProjectInfoPanel.lblCimSystem.text"));
        this.txtCimSystem.setEditable(false);
        this.lblCimUrl.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ProjectInfoPanel.lblCimUrl.text"));
        this.btnCimUrl.setText("cim url");
        this.btnCimUrl.setBorder(null);
        this.btnCimUrl.setBorderPainted(false);
        this.btnCimUrl.setContentAreaFilled(false);
        this.btnCimUrl.setHorizontalAlignment(10);
        GroupLayout pnlCimLayout = new GroupLayout(this.pnlCim);
        this.pnlCim.setLayout(pnlCimLayout);
        pnlCimLayout.setHorizontalGroup(pnlCimLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCimLayout.createSequentialGroup().addContainerGap().addGroup(pnlCimLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCimSystem).addComponent(this.lblCimUrl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlCimLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnCimUrl, -1, 599, Short.MAX_VALUE).addComponent(this.txtCimSystem, -1, 599, Short.MAX_VALUE)).addContainerGap()));
        pnlCimLayout.setVerticalGroup(pnlCimLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCimLayout.createSequentialGroup().addGroup(pnlCimLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCimSystem).addComponent(this.txtCimSystem, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlCimLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCimUrl).addComponent(this.lblCimUrl)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlLicense.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ProjectInfoPanel.class, (String)"TIT_Licenses")));
        this.pnlLicense.setLayout(new GridLayout(1, 1));
        this.pnlMailingLists.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ProjectInfoPanel.class, (String)"TIT_MailingLists")));
        this.pnlMailingLists.setLayout(new GridLayout(1, 1));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pnlMailingLists, GroupLayout.Alignment.LEADING, -1, 706, Short.MAX_VALUE).addComponent(this.pnlLicense, GroupLayout.Alignment.LEADING, -1, 706, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblProjectName).addComponent(this.lblDescription)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 550, Short.MAX_VALUE).addComponent(this.txtProjectName, -1, 550, Short.MAX_VALUE))).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.lblProjectHome).addGap(18, 18, 18).addComponent(this.btnProjectHome, -1, 554, Short.MAX_VALUE)).addComponent(this.pnlIssues, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.pnlScm, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.pnlCim, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblProjectName).addComponent(this.txtProjectName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDescription).addComponent(this.jScrollPane1, -1, 61, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnProjectHome, -2, 21, -2).addComponent(this.lblProjectHome)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlIssues, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlScm, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlCim, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlLicense, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlMailingLists, -2, -1, -2).addGap(85, 85, 85)));
        this.jScrollPane2.setViewportView(this.jPanel4);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 376, Short.MAX_VALUE).addContainerGap())));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 276, Short.MAX_VALUE).addContainerGap())));
        this.add(this.jPanel1, "Center");
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new M2RepositoryBrowserTopComponent.EditorToolbar();
            this.toolbar.setFloatable(false);
            Action[] a = new Action[1];
            Action[] actions = (Action[])this.getLookup().lookup(a.getClass());
            Dimension space = new Dimension(3, 0);
            this.toolbar.addSeparator(space);
            for (Action act : actions) {
                JButton btn = new JButton();
                Actions.connect((AbstractButton)btn, (Action)act);
                this.toolbar.add(btn);
                this.toolbar.addSeparator(space);
            }
        }
        return this.toolbar;
    }

    public void componentOpened() {
        super.componentOpened();
        this.result = this.getLookup().lookup(new Lookup.Template(MavenProject.class));
        this.populateFields();
        this.result.addLookupListener((LookupListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.result.removeLookupListener((LookupListener)this);
    }

    public void componentShowing() {
        super.componentShowing();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    private void populateFields() {
        boolean loading = true;
        Iterator iter = this.result.allInstances().iterator();
        String name = null;
        String desc = null;
        String homeUrl = null;
        String imUrl = null;
        String imSystem = null;
        String scmUrl = null;
        String scmConn = null;
        String scmDevConn = null;
        String cimSystem = null;
        String cimUrl = null;
        if (iter.hasNext()) {
            List mailings;
            List licenses;
            CiManagement cim;
            Scm scm;
            loading = false;
            MavenProject prj = (MavenProject)iter.next();
            name = prj.getName();
            desc = prj.getDescription();
            homeUrl = prj.getUrl();
            IssueManagement im = prj.getIssueManagement();
            if (im != null) {
                imUrl = im.getUrl();
                imSystem = im.getSystem();
            }
            if ((scm = prj.getScm()) != null) {
                scmUrl = scm.getUrl();
                scmConn = scm.getConnection();
                scmDevConn = scm.getDeveloperConnection();
            }
            if ((cim = prj.getCiManagement()) != null) {
                cimSystem = cim.getSystem();
                cimUrl = cim.getUrl();
            }
            if ((licenses = prj.getLicenses()) != null) {
                GridLayout layout = (GridLayout)this.pnlLicense.getLayout();
                layout.setColumns(1);
                layout.setRows(licenses.size());
                for (License lic : licenses) {
                    LicensePanel pnl = new LicensePanel();
                    this.setPlainText(pnl.txtName, lic.getName(), loading);
                    this.setLinkedText(pnl.btnURL, lic.getUrl(), loading);
                    this.pnlLicense.add(pnl);
                }
            }
            if ((mailings = prj.getMailingLists()) != null) {
                GridLayout layout = (GridLayout)this.pnlMailingLists.getLayout();
                layout.setColumns(1);
                layout.setRows(mailings.size());
                for (MailingList list : mailings) {
                    MailingListPanel pnl = new MailingListPanel();
                    this.setPlainText(pnl.txtName, list.getName(), loading);
                    this.setLinkedText(pnl.btnArchive, list.getArchive(), loading);
                    this.setPlainText(pnl.txtSubscribe, list.getSubscribe(), loading);
                    this.setPlainText(pnl.txtUnsubscribe, list.getUnsubscribe(), loading);
                    this.pnlMailingLists.add(pnl);
                }
            }
        }
        this.setPlainText(this.txtProjectName, name, loading);
        this.setPlainText(this.taDescription, desc, loading);
        this.setLinkedText(this.btnProjectHome, homeUrl, loading);
        this.setLinkedText(this.btnIssues, imUrl, loading);
        this.setPlainText(this.txtSystem, imSystem, loading);
        this.setLinkedText(this.btnScmUrl, scmUrl, loading);
        this.setPlainText(this.txtConnection, scmConn, loading);
        this.setPlainText(this.txtDevConnection, scmDevConn, loading);
        this.setLinkedText(this.btnCimUrl, cimUrl, loading);
        this.setPlainText(this.txtCimSystem, cimSystem, loading);
    }

    public void resultChanged(LookupEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInfoPanel.this.populateFields();
            }
        });
    }

    private void setLinkedText(JButton btn, String url, boolean loading) {
        if (url == null) {
            btn.setAction(null);
            if (loading) {
                btn.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"LBL_Loading"));
            } else {
                btn.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"LBL_Undefined"));
            }
            btn.setCursor(null);
        } else {
            btn.setAction(new LinkAction(url));
            btn.setCursor(Cursor.getPredefinedCursor(12));
            btn.setText("<html><a href=\"\">" + url + "</a></html>");
        }
    }

    private void setPlainText(JTextComponent field, String value, boolean loading) {
        if (value == null) {
            if (loading) {
                field.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"LBL_Loading"));
            } else {
                field.setText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"LBL_Undefined"));
            }
        } else {
            field.setText(value);
        }
    }

    private class LinkAction
    extends AbstractAction {
        private String url;

        public LinkAction(String url) {
            this.url = url;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                URL u = new URL(this.url);
                HtmlBrowser.URLDisplayer.getDefault().showURL(u);
            }
            catch (MalformedURLException ex) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectInfoPanel.class, (String)"ERR_WrongURL", (Object)this.url));
            }
        }
    }
}

