/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.debugger.ui.actions.AddWatchAction;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class VariablesViewButtons {
    public static final String SHOW_WATCHES = "show_watches";
    public static final String SHOW_EVALUTOR_RESULT = "show_evaluator_result";
    public static final String PREFERENCES_NAME = "variables_view";

    public static JToggleButton createShowWatchesButton() {
        JToggleButton button = VariablesViewButtons.createToggleButton(SHOW_WATCHES, "org/netbeans/modules/debugger/resources/localsView/show_watches_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Show_Watches"));
        button.addActionListener(new ShowWatchesActionListener(button));
        return button;
    }

    public static JToggleButton createShowResultButton() {
        JToggleButton button = VariablesViewButtons.createToggleButton(SHOW_EVALUTOR_RESULT, "org/netbeans/modules/debugger/resources/localsView/show_evaluator_result_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Show_Result"));
        button.addActionListener(new ShowResultActionListener(button));
        return button;
    }

    public static JButton createNewWatchButton() {
        JButton button = VariablesViewButtons.createButton("org/netbeans/modules/debugger/resources/watchesView/create_new_watch_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Create_New_Watch"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AddWatchAction)AddWatchAction.findObject(AddWatchAction.class, (boolean)true)).actionPerformed(null);
            }
        });
        return button;
    }

    public static boolean isWatchesViewNested() {
        Preferences preferences = NbPreferences.forModule(ContextProvider.class).node(PREFERENCES_NAME);
        return preferences.getBoolean(SHOW_WATCHES, true);
    }

    public static boolean isResultsViewNested() {
        Preferences preferences = NbPreferences.forModule(ContextProvider.class).node(PREFERENCES_NAME);
        return preferences.getBoolean(SHOW_EVALUTOR_RESULT, true);
    }

    private static JToggleButton createToggleButton(String id, String iconName, String tooltip) {
        Icon icon = VariablesViewButtons.loadIcon(iconName);
        boolean isSelected = VariablesViewButtons.isButtonSelected(id);
        JToggleButton toggleButton = new JToggleButton(icon, isSelected);
        Dimension size = new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8);
        toggleButton.setPreferredSize(size);
        toggleButton.setMargin(new Insets(1, 1, 1, 1));
        if (!"Aqua".equals(UIManager.getLookAndFeel().getID())) {
            toggleButton.setBorder(new EmptyBorder(toggleButton.getBorder().getBorderInsets(toggleButton)));
        }
        toggleButton.setToolTipText(tooltip);
        toggleButton.setFocusable(false);
        return toggleButton;
    }

    public static JButton createButton(String iconName, String tooltip) {
        Icon icon = VariablesViewButtons.loadIcon(iconName);
        return VariablesViewButtons.createButton(icon, tooltip);
    }

    public static JButton createButton(Icon icon, String tooltip) {
        JButton button = new JButton(icon);
        Dimension size = new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8);
        button.setPreferredSize(size);
        button.setMargin(new Insets(1, 1, 1, 1));
        button.setBorder(new EmptyBorder(button.getBorder().getBorderInsets(button)));
        button.setToolTipText(tooltip);
        button.setFocusable(false);
        return button;
    }

    private static Icon loadIcon(String iconPath) {
        return ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
    }

    private static boolean isButtonSelected(String name) {
        if (name.equals(SHOW_WATCHES)) {
            return VariablesViewButtons.isWatchesViewNested();
        }
        if (name.equals(SHOW_EVALUTOR_RESULT)) {
            return VariablesViewButtons.isResultsViewNested();
        }
        return false;
    }

    private static void setButtonSelected(String name, boolean selected) {
        Preferences preferences = NbPreferences.forModule(ContextProvider.class).node(PREFERENCES_NAME);
        preferences.putBoolean(name, selected);
    }

    private static void openView(String viewName, boolean activate) {
        TopComponent view = WindowManager.getDefault().findTopComponent(viewName);
        view.open();
        if (activate) {
            view.requestActive();
        }
    }

    private static void closeView(String viewName) {
        TopComponent view = WindowManager.getDefault().findTopComponent(viewName);
        view.close();
    }

    private static class ShowResultActionListener
    implements ActionListener {
        private JToggleButton button;

        ShowResultActionListener(JToggleButton toggleButton) {
            this.button = toggleButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isSelected = this.button.isSelected();
            VariablesViewButtons.setButtonSelected(VariablesViewButtons.SHOW_EVALUTOR_RESULT, isSelected);
            if (!isSelected) {
                VariablesViewButtons.openView("resultsView", false);
            }
        }
    }

    private static class ShowWatchesActionListener
    implements ActionListener {
        private JToggleButton button;

        ShowWatchesActionListener(JToggleButton toggleButton) {
            this.button = toggleButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isSelected = this.button.isSelected();
            VariablesViewButtons.setButtonSelected(VariablesViewButtons.SHOW_WATCHES, isSelected);
            if (!isSelected) {
                VariablesViewButtons.openView("watchesView", false);
            }
        }
    }
}

