/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.wizards;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.websvc.api.support.ClientCreator;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JaxWsClientCreator
implements ClientCreator {
    private Project project;
    private WizardDescriptor wiz;

    public JaxWsClientCreator(Project project, WizardDescriptor wizardDescriptor) {
        this.project = project;
        this.wiz = wizardDescriptor;
    }

    public void createClient() throws IOException {
        JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.project.getProjectDirectory());
        String string = (String)this.wiz.getProperty("wsdlDownloadUrl");
        String string2 = (String)this.wiz.getProperty("wsdlFilePath");
        if (string == null) {
            string = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string2))).getURL().toExternalForm();
        }
        FileObject fileObject = jAXWSLightSupport.getWsdlFolder(true);
        boolean bl = false;
        File file = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "src");
        bl = file.exists() ? true : file.mkdirs();
        if (fileObject != null) {
            Object object;
            String string3;
            FileObject fileObject2 = null;
            try {
                fileObject2 = WSUtils.retrieveResource(fileObject, bl ? new URI("src/jax-ws-catalog.xml") : new URI("jax-ws-catalog.xml"), new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                string3 = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_IncorrectURI", (Object)string);
                object = new NotifyDescriptor.Message((Object)string3, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
            }
            catch (UnknownHostException unknownHostException) {
                string3 = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_UnknownHost", (Object)unknownHostException.getMessage());
                object = new NotifyDescriptor.Message((Object)string3, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
            }
            catch (IOException iOException) {
                string3 = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_WsdlRetrieverFailure", (Object)string);
                object = new NotifyDescriptor.Message((Object)string3, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
            }
            if (fileObject2 != null) {
                final boolean bl2 = MavenModelUtils.isJaxWs21Library(this.project);
                string3 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
                object = fileObject2.getName();
                Preferences preferences = ProjectUtils.getPreferences((Project)this.project, MavenWebService.class, (boolean)true);
                if (preferences != null) {
                    preferences.put("_C_" + WSUtils.getUniqueId(fileObject2.getName(), jAXWSLightSupport.getServices()), string);
                }
                String string4 = string;
                ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>((String)object, string3, string4){
                    final /* synthetic */ String val$clientName;
                    final /* synthetic */ String val$relativePath;
                    final /* synthetic */ String val$wsdlLocation;
                    {
                        this.val$clientName = string;
                        this.val$relativePath = string2;
                        this.val$wsdlLocation = string3;
                    }

                    public void performOperation(POMModel pOMModel) {
                        if (!bl2) {
                            try {
                                MavenModelUtils.addJaxws21Library(JaxWsClientCreator.this.project, pOMModel);
                                MavenModelUtils.addJavadoc(JaxWsClientCreator.this.project);
                            }
                            catch (Exception exception) {
                                Logger.getLogger(JaxWsClientCreator.class.getName()).log(Level.INFO, "Cannot add Metro libbrary to pom file", exception);
                            }
                        }
                        Plugin plugin = WSUtils.isEJB(JaxWsClientCreator.this.project) ? MavenModelUtils.addJaxWSPlugin(pOMModel, "2.0") : MavenModelUtils.addJaxWSPlugin(pOMModel);
                        MavenModelUtils.addWsimportExecution(plugin, this.val$clientName, this.val$relativePath, this.val$wsdlLocation);
                        if (WSUtils.isWeb(JaxWsClientCreator.this.project)) {
                            MavenModelUtils.addWarPlugin(pOMModel);
                        } else {
                            MavenModelUtils.addWsdlResources(pOMModel);
                        }
                    }
                };
                Utilities.performPOMModelOperations((FileObject)this.project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(modelOperation));
                RunConfig runConfig = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (Project)this.project, (String)"JAX-WS:wsimport", Collections.singletonList("compile"));
                RunUtils.executeMaven((RunConfig)runConfig);
            }
        }
    }
}

