/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring.rename;

import java.util.List;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.refactoring.RefactoringUtil;
import org.netbeans.modules.web.refactoring.TldRefactoring;
import org.netbeans.modules.web.refactoring.rename.RenameItem;
import org.netbeans.modules.web.refactoring.rename.TldRename;
import org.netbeans.modules.web.taglib.model.FunctionType;
import org.netbeans.modules.web.taglib.model.ListenerType;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.ValidatorType;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

abstract class BaseTldRename
extends TldRefactoring {
    protected final WebModule webModule;

    public BaseTldRename(WebModule webModule) {
        this.webModule = webModule;
    }

    protected abstract List<RenameItem> getAffectedClasses();

    protected abstract AbstractRefactoring getRefactoring();

    /*
     * WARNING - void declaration
     */
    @Override
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        for (TldRefactoring.TaglibHandle taglibHandle : this.getTaglibs(this.webModule)) {
            if (!taglibHandle.isValid()) {
                problem = RefactoringUtil.addToEnd(new Problem(false, NbBundle.getMessage(BaseTldRename.class, (String)"TXT_TLdInvalidProblem", (Object)taglibHandle.getTldFile())), problem);
                continue;
            }
            Taglib taglib = taglibHandle.getTaglib();
            for (RenameItem item : this.getAffectedClasses()) {
                void var13_14;
                String clazz = item.getOldFqn();
                String newName = item.getNewFqn();
                for (TagType tagType : taglib.getTag()) {
                    if (clazz.equals(tagType.getTagClass())) {
                        refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new TagClassRenameElement(clazz, newName, tagType, taglib, taglibHandle.getTldFile()));
                    }
                    if (!clazz.equals(tagType.getTeiClass())) continue;
                    refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new TeiClassRenameElement(clazz, newName, tagType, taglib, taglibHandle.getTldFile()));
                }
                for (TagType tagType : taglib.getFunction()) {
                    if (!clazz.equals(tagType.getFunctionClass())) continue;
                    refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new FunctionTypeRenameElement(clazz, newName, (FunctionType)tagType, taglib, taglibHandle.getTldFile()));
                }
                ValidatorType validatorType = taglib.getValidator();
                if (validatorType != null && clazz.equals(validatorType.getValidatorClass())) {
                    refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new ValidatorRenameElement(clazz, newName, validatorType, taglib, taglibHandle.getTldFile()));
                }
                ListenerType[] arr$ = taglib.getListener();
                int len$ = arr$.length;
                boolean bl = false;
                while (var13_14 < len$) {
                    ListenerType listenerType = arr$[var13_14];
                    if (clazz.equals(listenerType.getListenerClass())) {
                        refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new ListenerRenameElement(clazz, newName, listenerType, taglib, taglibHandle.getTldFile()));
                    }
                    ++var13_14;
                }
            }
        }
        return problem;
    }

    private static class ListenerRenameElement
    extends TldRefactoring.TldRefactoringElement {
        private final String newName;
        private final ListenerType listenerType;

        public ListenerRenameElement(String clazz, String newName, ListenerType listenerType, Taglib taglib, FileObject tldFile) {
            super(clazz, taglib, tldFile);
            this.newName = newName;
            this.listenerType = listenerType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TldRename.class, (String)"TXT_TaglibListenerClassRename", (Object)this.clazz, (Object)this.newName);
        }

        public void performChange() {
            this.listenerType.setListenerClass(this.newName);
            this.write();
        }

        public void undoChange() {
            this.listenerType.setListenerClass(this.clazz);
            this.write();
        }
    }

    private static class FunctionTypeRenameElement
    extends TldRefactoring.TldRefactoringElement {
        private final String newName;
        private final FunctionType functionType;

        public FunctionTypeRenameElement(String clazz, String newName, FunctionType functionType, Taglib taglib, FileObject tldFile) {
            super(clazz, taglib, tldFile);
            this.newName = newName;
            this.functionType = functionType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TldRename.class, (String)"TXT_TaglibFunctionClassRename", (Object)this.clazz, (Object)this.newName);
        }

        public void performChange() {
            this.functionType.setFunctionClass(this.newName);
            this.write();
        }

        public void undoChange() {
            this.functionType.setFunctionClass(this.clazz);
            this.write();
        }
    }

    private static class ValidatorRenameElement
    extends TldRefactoring.TldRefactoringElement {
        private final String newName;
        private final ValidatorType validatorType;

        public ValidatorRenameElement(String clazz, String newName, ValidatorType validatorType, Taglib taglib, FileObject tldFile) {
            super(clazz, taglib, tldFile);
            this.newName = newName;
            this.validatorType = validatorType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TldRename.class, (String)"TXT_TaglibValidatorClassRename", (Object)this.clazz, (Object)this.newName);
        }

        public void performChange() {
            this.validatorType.setValidatorClass(this.newName);
            this.write();
        }

        public void undoChange() {
            this.validatorType.setValidatorClass(this.clazz);
            this.write();
        }
    }

    private static class TeiClassRenameElement
    extends TldRefactoring.TldRefactoringElement {
        private final String newName;
        private final TagType tagType;

        public TeiClassRenameElement(String clazz, String newName, TagType tagType, Taglib taglib, FileObject tldFile) {
            super(clazz, taglib, tldFile);
            this.newName = newName;
            this.tagType = tagType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TldRename.class, (String)"TXT_TaglibTeiClassRename", (Object)this.clazz, (Object)this.newName);
        }

        public void performChange() {
            this.tagType.setTeiClass(this.newName);
            this.write();
        }

        public void undoChange() {
            this.tagType.setTeiClass(this.clazz);
            this.write();
        }
    }

    private static class TagClassRenameElement
    extends TldRefactoring.TldRefactoringElement {
        private final String newName;
        private final TagType tagType;

        public TagClassRenameElement(String clazz, String newName, TagType tagType, Taglib taglib, FileObject tldFile) {
            super(clazz, taglib, tldFile);
            this.newName = newName;
            this.tagType = tagType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TldRename.class, (String)"TXT_TaglibTagClassRename", (Object)this.clazz, (Object)this.newName);
        }

        public void performChange() {
            this.tagType.setTagClass(this.newName);
            this.write();
        }

        public void undoChange() {
            this.tagType.setTagClass(this.clazz);
            this.write();
        }
    }
}

