/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

public class FloatSorter {
    private float[] x;
    private int len;
    private int off;

    public FloatSorter(float[] x, int off, int len) {
        this.x = x;
        this.off = off;
        this.len = len;
    }

    public void sort(boolean asc) {
        if (asc) {
            this.sort1Asc(this.off, this.len);
        } else {
            this.sort1Desc(this.off, this.len);
        }
    }

    protected void swap(int a, int b) {
        float t = this.x[a];
        this.x[a] = this.x[b];
        this.x[b] = t;
    }

    private int med3(int a, int b, int c) {
        return this.x[a] < this.x[b] ? (this.x[b] < this.x[c] ? b : (this.x[a] < this.x[c] ? c : a)) : (this.x[b] > this.x[c] ? b : (this.x[a] > this.x[c] ? c : a));
    }

    private void sort1Asc(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.x[j - 1] > this.x[j]; --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        float v = this.x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.x[b] <= v) {
                if (this.x[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.x[c] >= v) {
                if (this.x[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort1Asc(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort1Asc(n - s, s);
        }
    }

    private void sort1Desc(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.x[j - 1] < this.x[j]; --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        float v = this.x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.x[b] >= v) {
                if (this.x[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.x[c] <= v) {
                if (this.x[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort1Desc(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort1Desc(n - s, s);
        }
    }

    private void vecswap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }
}

