/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

abstract class AbstractLongMap {
    private final int VALUE_SIZE;
    final int ENTRY_SIZE;
    private File tempFile;
    long fileSize;
    private long keys;
    final int KEY_SIZE;
    final int ID_SIZE;
    final int FOFFSET_SIZE;
    Data dumpBuffer;

    AbstractLongMap(int size, int idSize, int foffsetSize, int valueSize) throws FileNotFoundException, IOException {
        assert (idSize == 4 || idSize == 8);
        assert (foffsetSize == 4 || foffsetSize == 8);
        this.keys = (long)size * 4L / 3L;
        this.ID_SIZE = idSize;
        this.FOFFSET_SIZE = foffsetSize;
        this.KEY_SIZE = this.ID_SIZE;
        this.VALUE_SIZE = valueSize;
        this.ENTRY_SIZE = this.KEY_SIZE + this.VALUE_SIZE;
        this.fileSize = this.keys * (long)this.ENTRY_SIZE;
        this.tempFile = File.createTempFile("NBProfiler", ".map");
        RandomAccessFile file = new RandomAccessFile(this.tempFile, "rw");
        if (Boolean.getBoolean("org.netbeans.lib.profiler.heap.zerofile")) {
            byte[] zeros = new byte[524288];
            while (file.length() < this.fileSize) {
                file.write(zeros);
            }
            file.write(zeros, 0, (int)(this.fileSize - file.length()));
        }
        file.setLength(this.fileSize);
        this.setDumpBuffer(file);
        this.tempFile.deleteOnExit();
    }

    protected void finalize() throws Throwable {
        this.tempFile.delete();
        super.finalize();
    }

    Entry get(long key) {
        long index = this.getIndex(key);
        long mapKey;
        while ((mapKey = this.getID(index)) != key) {
            if (mapKey == 0L) {
                return null;
            }
            index = this.getNextIndex(index);
        }
        return this.createEntry(index);
    }

    Entry put(long key, long value) {
        long index = this.getIndex(key);
        while (true) {
            if (this.getID(index) == 0L) {
                this.putID(index, key);
                return this.createEntry(index, value);
            }
            index = this.getNextIndex(index);
        }
    }

    private void setDumpBuffer(RandomAccessFile file) throws IOException {
        long length = file.length();
        try {
            this.dumpBuffer = length > Integer.MAX_VALUE ? new LongMemoryMappedData(file, length) : new MemoryMappedData(file, length);
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof OutOfMemoryError) {
                this.dumpBuffer = new FileData(file, length);
            }
            throw ex;
        }
    }

    long getID(long index) {
        if (this.ID_SIZE == 4) {
            return (long)this.dumpBuffer.getInt(index) & 0xFFFFFFFFL;
        }
        return this.dumpBuffer.getLong(index);
    }

    void putID(long index, long key) {
        if (this.ID_SIZE == 4) {
            this.dumpBuffer.putInt(index, (int)key);
        } else {
            this.dumpBuffer.putLong(index, key);
        }
    }

    long getFoffset(long index) {
        if (this.FOFFSET_SIZE == 4) {
            return this.dumpBuffer.getInt(index);
        }
        return this.dumpBuffer.getLong(index);
    }

    void putFoffset(long index, long key) {
        if (this.FOFFSET_SIZE == 4) {
            this.dumpBuffer.putInt(index, (int)key);
        } else {
            this.dumpBuffer.putLong(index, key);
        }
    }

    private long getIndex(long key) {
        long hash = key & Long.MAX_VALUE;
        return hash % this.keys * (long)this.ENTRY_SIZE;
    }

    private long getNextIndex(long index) {
        if ((index += (long)this.ENTRY_SIZE) >= this.fileSize) {
            index = 0L;
        }
        return index;
    }

    abstract Entry createEntry(long var1);

    abstract Entry createEntry(long var1, long var3);

    private static class LongMemoryMappedData
    implements Data {
        private static int BUFFER_SIZE_BITS = 30;
        private static long BUFFER_SIZE = 1L << BUFFER_SIZE_BITS;
        private static int BUFFER_SIZE_MASK = (int)(BUFFER_SIZE - 1L);
        private static int BUFFER_EXT = 32768;
        private MappedByteBuffer[] dumpBuffer;

        LongMemoryMappedData(RandomAccessFile file, long length) throws IOException {
            FileChannel channel = file.getChannel();
            this.dumpBuffer = new MappedByteBuffer[(int)((length + BUFFER_SIZE - 1L) / BUFFER_SIZE)];
            for (int i = 0; i < this.dumpBuffer.length; ++i) {
                long position = (long)i * BUFFER_SIZE;
                long size = Math.min(BUFFER_SIZE + (long)BUFFER_EXT, length - position);
                this.dumpBuffer[i] = channel.map(FileChannel.MapMode.READ_WRITE, position, size);
            }
            channel.close();
        }

        @Override
        public byte getByte(long index) {
            return this.dumpBuffer[this.getBufferIndex(index)].get(this.getBufferOffset(index));
        }

        @Override
        public int getInt(long index) {
            return this.dumpBuffer[this.getBufferIndex(index)].getInt(this.getBufferOffset(index));
        }

        @Override
        public long getLong(long index) {
            return this.dumpBuffer[this.getBufferIndex(index)].getLong(this.getBufferOffset(index));
        }

        @Override
        public void putByte(long index, byte data) {
            this.dumpBuffer[this.getBufferIndex(index)].put(this.getBufferOffset(index), data);
        }

        @Override
        public void putInt(long index, int data) {
            this.dumpBuffer[this.getBufferIndex(index)].putInt(this.getBufferOffset(index), data);
        }

        @Override
        public void putLong(long index, long data) {
            this.dumpBuffer[this.getBufferIndex(index)].putLong(this.getBufferOffset(index), data);
        }

        private int getBufferIndex(long index) {
            return (int)(index >> BUFFER_SIZE_BITS);
        }

        private int getBufferOffset(long index) {
            return (int)(index & (long)BUFFER_SIZE_MASK);
        }
    }

    private static class MemoryMappedData
    implements Data {
        MappedByteBuffer buf;

        MemoryMappedData(RandomAccessFile file, long length) throws IOException {
            FileChannel channel = file.getChannel();
            this.buf = channel.map(FileChannel.MapMode.READ_WRITE, 0L, length);
            channel.close();
        }

        @Override
        public byte getByte(long index) {
            return this.buf.get((int)index);
        }

        @Override
        public int getInt(long index) {
            return this.buf.getInt((int)index);
        }

        @Override
        public long getLong(long index) {
            return this.buf.getLong((int)index);
        }

        @Override
        public void putByte(long index, byte data) {
            this.buf.put((int)index, data);
        }

        @Override
        public void putInt(long index, int data) {
            this.buf.putInt((int)index, data);
        }

        @Override
        public void putLong(long index, long data) {
            this.buf.putLong((int)index, data);
        }
    }

    private class FileData
    implements Data {
        RandomAccessFile file;
        byte[] buf;
        boolean bufferModified;
        long offset;
        static final int BUFFER_SIZE = 128;

        FileData(RandomAccessFile f, long length) throws IOException {
            this.file = f;
            this.buf = new byte[AbstractLongMap.this.ENTRY_SIZE * 128];
        }

        @Override
        public synchronized byte getByte(long index) {
            int i = this.loadBufferIfNeeded(index);
            return this.buf[i];
        }

        @Override
        public synchronized int getInt(long index) {
            int i = this.loadBufferIfNeeded(index);
            int ch1 = this.buf[i++] & 0xFF;
            int ch2 = this.buf[i++] & 0xFF;
            int ch3 = this.buf[i++] & 0xFF;
            int ch4 = this.buf[i] & 0xFF;
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }

        @Override
        public synchronized long getLong(long index) {
            int i = this.loadBufferIfNeeded(index);
            return ((long)this.buf[i++] << 56) + ((long)(this.buf[i++] & 0xFF) << 48) + ((long)(this.buf[i++] & 0xFF) << 40) + ((long)(this.buf[i++] & 0xFF) << 32) + ((long)(this.buf[i++] & 0xFF) << 24) + (long)((this.buf[i++] & 0xFF) << 16) + (long)((this.buf[i++] & 0xFF) << 8) + (long)((this.buf[i++] & 0xFF) << 0);
        }

        @Override
        public synchronized void putByte(long index, byte data) {
            int i = this.loadBufferIfNeeded(index);
            this.buf[i] = data;
            this.bufferModified = true;
        }

        @Override
        public synchronized void putInt(long index, int data) {
            int i = this.loadBufferIfNeeded(index);
            this.buf[i++] = (byte)(data >>> 24);
            this.buf[i++] = (byte)(data >>> 16);
            this.buf[i++] = (byte)(data >>> 8);
            this.buf[i++] = (byte)(data >>> 0);
            this.bufferModified = true;
        }

        @Override
        public synchronized void putLong(long index, long data) {
            int i = this.loadBufferIfNeeded(index);
            this.buf[i++] = (byte)(data >>> 56);
            this.buf[i++] = (byte)(data >>> 48);
            this.buf[i++] = (byte)(data >>> 40);
            this.buf[i++] = (byte)(data >>> 32);
            this.buf[i++] = (byte)(data >>> 24);
            this.buf[i++] = (byte)(data >>> 16);
            this.buf[i++] = (byte)(data >>> 8);
            this.buf[i++] = (byte)(data >>> 0);
            this.bufferModified = true;
        }

        private int loadBufferIfNeeded(long index) {
            int i = (int)(index % (long)(AbstractLongMap.this.ENTRY_SIZE * 128));
            long newOffset = index - (long)i;
            if (this.offset != newOffset) {
                try {
                    if (this.bufferModified) {
                        this.file.seek(this.offset);
                        this.file.write(this.buf, 0, this.getBufferSize(this.offset));
                        this.bufferModified = false;
                    }
                    this.file.seek(newOffset);
                    this.file.readFully(this.buf, 0, this.getBufferSize(newOffset));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.offset = newOffset;
            }
            return i;
        }

        private int getBufferSize(long off) {
            int size = this.buf.length;
            if (AbstractLongMap.this.fileSize - off < (long)this.buf.length) {
                size = (int)(AbstractLongMap.this.fileSize - off);
            }
            return size;
        }
    }

    static interface Data {
        public byte getByte(long var1);

        public int getInt(long var1);

        public long getLong(long var1);

        public void putByte(long var1, byte var3);

        public void putInt(long var1, int var3);

        public void putLong(long var1, long var3);
    }

    abstract class Entry {
        Entry() {
        }
    }
}

