/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.NewGrailsProjectWizardIterator;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PanelProjectLocationVisual
extends SettingsPanel
implements DocumentListener {
    private PanelConfigureProject panel;
    private JButton browseLocationJButton;
    private JLabel projectFolderLabel;
    private JTextField projectFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;

    @Override
    boolean valid(WizardDescriptor settings) {
        if (this.projectNameTextField.getText().trim().length() == 0) {
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"GetProjectLocationPanel.EmptyProjectName"));
            return false;
        }
        if (!new File(this.projectLocationTextField.getText().trim()).isDirectory()) {
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"GetProjectLocationPanel.LocationNotDirectory"));
            return false;
        }
        if (new File(this.projectFolderTextField.getText().trim()).exists()) {
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"GetProjectLocationPanel.FileAlreadyExists"));
            return false;
        }
        return true;
    }

    @Override
    void read(WizardDescriptor d) {
        File projectLocation = (File)d.getProperty("projectFolder");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        Integer count = (Integer)d.getProperty("WizardPanel_GrailsProjectCounter");
        String formater = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"TXT_GrailsApplication");
        int baseCount = count;
        String newPrjName = (String)d.getProperty("name");
        if (newPrjName == null) {
            while ((newPrjName = this.validFreeProjectName(projectLocation, formater, baseCount)) == null) {
                ++baseCount;
            }
        }
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        this.projectFolderTextField.setText(projectLocation.getAbsolutePath() + File.separatorChar + this.projectNameTextField.getText().trim());
        this.projectNameTextField.setText(newPrjName);
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    @Override
    void store(WizardDescriptor d) {
        d.putProperty("projectFolder", (Object)new File(this.projectFolderTextField.getText().trim()));
        d.putProperty("projectName", (Object)this.projectNameTextField.getText().trim());
    }

    public PanelProjectLocationVisual(PanelConfigureProject parentStep) {
        this.panel = parentStep;
        this.initComponents();
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.projectNameTextField.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectLocationLabel = new JLabel();
        this.projectFolderLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationTextField = new JTextField();
        this.projectFolderTextField = new JTextField();
        this.browseLocationJButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setDisplayedMnemonic('N');
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectNameLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectNameLabel.AccessibleContext.accessibleDescription"));
        this.projectLocationLabel.setDisplayedMnemonic('L');
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectLocationLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectLocationLabel.AccessibleContext.accessibleDescription"));
        this.projectFolderLabel.setDisplayedMnemonic('F');
        this.projectFolderLabel.setLabelFor(this.projectFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectFolderLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.projectFolderLabel, gridBagConstraints);
        this.projectFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectFolderLabel.AccessibleContext.accessibleDescription"));
        this.projectNameTextField.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectNameTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectNameTextField.AccessibleContext.accessibleName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectNameTextField.AccessibleContext.accessibleDescription"));
        this.projectLocationTextField.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectLocationTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        this.projectLocationTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectLocationTextField.AccessibleContext.accessibleName"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectLocationTextField.AccessibleContext.accessibleDescription"));
        this.projectFolderTextField.setEditable(false);
        this.projectFolderTextField.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectFolderTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.projectFolderTextField, gridBagConstraints);
        this.projectFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectFolderTextField.AccessibleContext.accessibleName"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectFolderTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseLocationJButton, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.browseLocationJButton.text"));
        this.browseLocationJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationVisual.this.browseLocationJButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.browseLocationJButton, gridBagConstraints);
        this.browseLocationJButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.browseLocationJButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.AccessibleContext.accessibleDescription"));
    }

    private void browseLocationJButtonActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.FileChooserTitle"));
        chooser.setFileSelectionMode(1);
        String path = this.projectLocationTextField.getText().trim();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this))) {
            File projectDir = chooser.getSelectedFile();
            this.projectLocationTextField.setText(projectDir.getAbsolutePath());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText().trim();
            String projectFolder = this.projectLocationTextField.getText().trim();
            this.getProjectFolderTextField().setText(new File(projectFolder, projectName).getAbsolutePath());
            this.panel.fireChangeEvent();
        }
    }

    public JTextField getProjectFolderTextField() {
        return this.projectFolderTextField;
    }

    private String validFreeProjectName(File parentFolder, String formater, int index) {
        String name = MessageFormat.format(formater, index);
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }
}

