/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grailsproject.GrailsProjectSettings;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.ProgressLineProcessor;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NewGrailsProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private static final Logger LOGGER = Logger.getLogger(NewGrailsProjectWizardIterator.class.getName());
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private PanelConfigureProject pls;
    private int baseCount;

    public static NewGrailsProjectWizardIterator create() {
        return new NewGrailsProjectWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        this.pls = new PanelConfigureProject();
        return new WizardDescriptor.Panel[]{this.pls};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"LAB_ConfigureProject")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate(final ProgressHandle handle) throws IOException {
        File dirF;
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        handle.start(100);
        try {
            String displayName = "<new project> (create-app)";
            Callable callable = ExecutionSupport.getInstance().createCreateApp((File)this.wiz.getProperty("projectFolder"));
            ExecutionDescriptor descriptor = new ExecutionDescriptor().frontWindow(true).inputVisible(true);
            descriptor = descriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                    return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, InputProcessors.bridge((LineProcessor)new ProgressLineProcessor(handle, 100, 2))});
                }
            });
            ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)displayName);
            Future future = service.run();
            try {
                Integer ret = (Integer)future.get();
                if (ret != 0) {
                    String msg = NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"WIZARD_ERROR_MESSAGE_APPLICATION");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex.getCause());
            }
        }
        finally {
            handle.progress(100);
            handle.finish();
        }
        if ((dirF = (File)this.wiz.getProperty("projectFolder")) != null) {
            FileObject dir = FileUtil.toFileObject((File)(dirF = FileUtil.normalizeFile((File)dirF)));
            if (dir == null) {
                LOGGER.warning("Folder was expected, but not found: " + dirF.getCanonicalPath());
            } else {
                resultSet.add(dir);
                GrailsProjectSettings.getDefault().setNewProjectCount(this.baseCount);
                File parentDir = dirF.getParentFile();
                if (parentDir != null && parentDir.exists() && parentDir.isDirectory()) {
                    GrailsProjectSettings.getDefault().setLastUsedArtifactFolder(dirF.getParentFile());
                }
            }
            dirF = dirF.getParentFile();
            if (dirF != null && dirF.exists()) {
                ProjectChooser.setProjectsFolder((File)dirF);
            }
        }
        return resultSet;
    }

    public Set instantiate() throws IOException {
        HashSet resultSet = new HashSet();
        return resultSet;
    }

    public void initialize(WizardDescriptor wizard) {
        this.wiz = wizard;
        this.index = 0;
        this.baseCount = GrailsProjectSettings.getDefault().getNewProjectCount() + 1;
        wizard.putProperty("WizardPanel_GrailsProjectCounter", (Object)this.baseCount);
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"LAB_IteratorName"), this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

