/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ejb;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.customizer.support.CheckBoxUpdater;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.Wrapper;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EjbRunCustomizerPanel
extends JPanel {
    private Project project;
    private ModelHandle handle;
    private EjbJar module;
    private ComboBoxUpdater<Wrapper> listener;
    private CheckBoxUpdater deployOnSaveUpdater;
    private JComboBox comServer;
    private JLabel dosDescription;
    private JCheckBox jCheckBoxDeployOnSave;
    private JLabel lblJ2EEVersion;
    private JLabel lblServer;
    private JTextField txtJ2EEVersion;

    public EjbRunCustomizerPanel(ModelHandle handle, Project project) {
        this.initComponents();
        this.handle = handle;
        this.project = project;
        this.module = EjbJar.getEjbJar((FileObject)project.getProjectDirectory());
        this.loadComboModel();
        if (this.module != null) {
            this.txtJ2EEVersion.setText(this.module.getJ2eePlatformVersion());
        }
        this.initValues();
    }

    private void initValues() {
        this.listener = Wrapper.createComboBoxUpdater(this.handle, this.comServer, this.lblServer);
        this.deployOnSaveUpdater = new CheckBoxUpdater(this.jCheckBoxDeployOnSave){

            public Boolean getValue() {
                String s = EjbRunCustomizerPanel.this.handle.getRawAuxiliaryProperty("netbeans.deploy.on.save", true);
                if (s != null) {
                    return Boolean.valueOf(s);
                }
                return null;
            }

            public void setValue(Boolean value) {
                EjbRunCustomizerPanel.this.handle.setRawAuxiliaryProperty("netbeans.deploy.on.save", value == null ? null : Boolean.toString(value), true);
            }

            public boolean getDefaultValue() {
                return true;
            }
        };
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                EjbRunCustomizerPanel.this.updateDoSEnablement();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void updateDoSEnablement() {
        String cos = this.handle.getRawAuxiliaryProperty("netbeans.compile.on.save", true);
        boolean enabled = cos != null && ("all".equalsIgnoreCase(cos) || "app".equalsIgnoreCase(cos));
        this.jCheckBoxDeployOnSave.setEnabled(enabled);
        this.dosDescription.setEnabled(enabled);
    }

    private void loadComboModel() {
        String[] ids = Deployment.getDefault().getServerInstanceIDs(Collections.singleton(J2eeModule.Type.EJB), this.module.getJ2eeProfile());
        ArrayList<Wrapper> col = new ArrayList<Wrapper>();
        SessionContent sc = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
        if (sc != null && sc.getServerInstanceId() != null) {
            col.add(new Wrapper("DEV-NULL", sc.getServerInstanceId()));
        } else {
            col.add(new Wrapper("DEV-NULL"));
        }
        for (int i = 0; i < ids.length; ++i) {
            Wrapper wr = new Wrapper(ids[i]);
            col.add(wr);
        }
        this.comServer.setModel(new DefaultComboBoxModel<Object>(col.toArray()));
    }

    void applyChangesInAWT() {
        Object obj = this.comServer.getSelectedItem();
        if (obj != null) {
            LogRecord record = new LogRecord(Level.INFO, "USG_PROJECT_CONFIG_MAVEN_SERVER");
            record.setLoggerName("org.netbeans.ui.metrics.maven");
            record.setParameters(new Object[]{obj.toString()});
            POHImpl.USG_LOGGER.log(record);
        }
    }

    void applyChanges() {
        SessionContent sc = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
        sc.setServerInstanceId(null);
        POHImpl poh = (POHImpl)((Object)this.project.getLookup().lookup(POHImpl.class));
        poh.hackModuleServerChange();
    }

    private void initComponents() {
        this.lblServer = new JLabel();
        this.comServer = new JComboBox();
        this.lblJ2EEVersion = new JLabel();
        this.txtJ2EEVersion = new JTextField();
        this.jCheckBoxDeployOnSave = new JCheckBox();
        this.dosDescription = new JLabel();
        this.lblServer.setText(NbBundle.getMessage(EjbRunCustomizerPanel.class, (String)"LBL_Server"));
        this.lblJ2EEVersion.setText(NbBundle.getMessage(EjbRunCustomizerPanel.class, (String)"LBL_J2EE_Version"));
        this.txtJ2EEVersion.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxDeployOnSave, (String)NbBundle.getMessage(EjbRunCustomizerPanel.class, (String)"EjbRunCustomizerPanel.jCheckBoxDeployOnSave.text"));
        this.dosDescription.setText(NbBundle.getMessage(EjbRunCustomizerPanel.class, (String)"EjbRunCustomizerPanel.dosDescription.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblJ2EEVersion).add((Component)this.lblServer)).add(14, 14, 14).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.comServer, 0, 277, Short.MAX_VALUE).add(2, (Component)this.txtJ2EEVersion, -1, 277, Short.MAX_VALUE))).add((Component)this.jCheckBoxDeployOnSave))).add((GroupLayout.Group)layout.createSequentialGroup().add(24, 24, 24).add((Component)this.dosDescription, -1, 378, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblServer).add((Component)this.comServer, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblJ2EEVersion).add((Component)this.txtJ2EEVersion, -2, -1, -2)).addPreferredGap(0).add((Component)this.jCheckBoxDeployOnSave).addPreferredGap(0).add((Component)this.dosDescription, -2, -1, -2).addContainerGap(131, Short.MAX_VALUE)));
    }
}

