/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

public class ParserServletContext
implements ServletContext {
    public static final String JSP_TAGLIBRARY_CACHE = "com.sun.jsp.taglibraryCache";
    public static final String JSP_TAGFILE_JAR_URLS_CACHE = "com.sun.jsp.tagFileJarUrlsCache";
    private static final Logger LOGGER = Logger.getLogger(ParserServletContext.class.getName());
    protected Hashtable<String, Object> myAttributes;
    protected FileObject wmRoot;
    private JspConfigDescriptor jspConfigDesc;
    private final WebModuleProvider webModuleProvider;
    protected boolean useEditorVersion;

    public ParserServletContext(FileObject wmRoot, WebModuleProvider WebModuleProvider2, boolean useEditor) {
        LOGGER.log(Level.FINE, "ParserServletContext created");
        this.myAttributes = new Hashtable();
        this.wmRoot = wmRoot;
        this.webModuleProvider = WebModuleProvider2;
        this.useEditorVersion = useEditor;
        this.jspConfigDesc = new JspConfigDescriptor(){

            public Collection<TaglibDescriptor> getTaglibs() {
                return Collections.emptyList();
            }

            public Collection<JspPropertyGroupDescriptor> getJspPropertyGroups() {
                return Collections.emptyList();
            }
        };
        this.setAttribute(JSP_TAGLIBRARY_CACHE, new ConcurrentHashMap());
        this.setAttribute(JSP_TAGFILE_JAR_URLS_CACHE, new ConcurrentHashMap());
    }

    public Object getAttribute(String name) {
        LOGGER.log(Level.FINE, "getAttribute({0}) = {1}", new Object[]{name, this.myAttributes.get(name)});
        return this.myAttributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.myAttributes.keys();
    }

    public ServletContext getContext(String uripath) {
        return null;
    }

    public String getInitParameter(String name) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return new Vector().elements();
    }

    public int getMajorVersion() {
        return 3;
    }

    public String getMimeType(String file) {
        return null;
    }

    public int getMinorVersion() {
        return 0;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    protected FileObject getResourceAsObject(String path) {
        LOGGER.log(Level.FINE, "getResourceAsObject({0})", path);
        FileObject fileObject = null;
        if (this.wmRoot != null) {
            fileObject = this.wmRoot.getFileObject(path);
        }
        WebModule webModule = this.webModuleProvider.getWebModule();
        if (fileObject == null && path != null && webModule != null && webModule.getWebInf() != null) {
            int index = path.toLowerCase().indexOf("web-inf");
            if (index > -1) {
                String newPath = path.substring(index + 7);
                fileObject = webModule.getWebInf().getFileObject(newPath);
            } else {
                fileObject = webModule.getWebInf().getFileObject(path);
            }
        }
        return fileObject;
    }

    public String getRealPath(String path) {
        File ff;
        LOGGER.log(Level.FINE, "getRealPath({0})", path);
        if (!path.startsWith("/")) {
            return null;
        }
        FileObject fo = this.getResourceAsObject(path);
        if (fo != null && (ff = FileUtil.toFile((FileObject)fo)) != null) {
            return ff.getAbsolutePath();
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        LOGGER.log(Level.FINE, "getResource({0})", path);
        if (!path.startsWith("/")) {
            throw new MalformedURLException(NbBundle.getMessage(ParserServletContext.class, (String)"EXC_PathMustStartWithSlash", (Object)path));
        }
        FileObject fo = this.getResourceAsObject(path);
        if (fo == null) {
            return null;
        }
        return URLMapper.findURL((FileObject)fo, (int)1);
    }

    public InputStream getResourceAsStream(String path) {
        InputStream result;
        LOGGER.log(Level.FINE, "getResourceAsStream({0})", path);
        FileObject fo = this.getResourceAsObject(path);
        if (fo != null && this.useEditorVersion && (result = this.getEditorInputStream(fo)) != null) {
            return result;
        }
        try {
            URL url = this.getResource(path);
            if (url == null) {
                return null;
            }
            return url.openStream();
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, null, t);
            return null;
        }
    }

    private InputStream getEditorInputStream(FileObject fo) {
        InputStream result = null;
        EditorCookie ec = null;
        try {
            ec = (EditorCookie)DataObject.find((FileObject)fo).getCookie(EditorCookie.class);
        }
        catch (DataObjectNotFoundException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        if (ec != null && ec instanceof CloneableEditorSupport) {
            try {
                result = ((CloneableEditorSupport)ec).getInputStream();
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
        return result;
    }

    public Set<String> getResourcePaths(String path) {
        String basePath;
        LOGGER.log(Level.FINE, "getResourcePaths({0})", path);
        HashSet<String> thePaths = new HashSet<String>();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((basePath = this.getRealPath(path)) == null) {
            return thePaths;
        }
        File theBaseDir = new File(basePath);
        if (!theBaseDir.exists() || !theBaseDir.isDirectory()) {
            return thePaths;
        }
        String[] theFiles = theBaseDir.list();
        for (int i = 0; i < theFiles.length; ++i) {
            File testFile = new File(basePath + File.separator + theFiles[i]);
            if (testFile.isFile()) {
                thePaths.add(path + theFiles[i]);
                continue;
            }
            if (!testFile.isDirectory()) continue;
            thePaths.add(path + theFiles[i] + "/");
        }
        return thePaths;
    }

    public String getServerInfo() {
        return "NB.ParserServletContext/1.0";
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public String getServletContextName() {
        return this.getServerInfo();
    }

    public Enumeration getServletNames() {
        return new Vector().elements();
    }

    public Enumeration getServlets() {
        return new Vector().elements();
    }

    public void log(String message) {
        LOGGER.log(Level.INFO, message);
    }

    public void log(Exception exception, String message) {
        this.log(message, exception);
    }

    public void log(String message, Throwable exception) {
        LOGGER.log(Level.INFO, message);
        LOGGER.log(Level.INFO, null, exception);
    }

    public void removeAttribute(String name) {
        this.myAttributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.myAttributes.put(name, value);
    }

    public String getContextPath() {
        return "";
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public boolean setInitParameter(String string, String string1) {
        return false;
    }

    public ServletRegistration.Dynamic addServlet(String string, String string1) {
        System.err.println("** addServlet(string,string)");
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String string, Servlet srvlt) {
        System.err.println("** addServlet(string,srvlt)");
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String string, Class<? extends Servlet> type) {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> type) throws ServletException {
        return null;
    }

    public ServletRegistration getServletRegistration(String string) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String string, String string1) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String string, Filter filter) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String string, Class<? extends Filter> type) {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> type) throws ServletException {
        return null;
    }

    public FilterRegistration getFilterRegistration(String string) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public void addListener(String string) {
    }

    public <T extends EventListener> void addListener(T t) {
    }

    public void addListener(Class<? extends EventListener> type) {
    }

    public <T extends EventListener> T createListener(Class<T> type) throws ServletException {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.jspConfigDesc;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public void declareRoles(String ... strings) {
    }

    public static interface WebModuleProvider {
        public WebModule getWebModule();
    }
}

