/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.ui.PullUpAction;
import org.netbeans.modules.refactoring.java.ui.PullUpPanel;
import org.netbeans.modules.refactoring.java.ui.PushDownRefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PullUpRefactoringUI
implements RefactoringUI {
    private final PullUpRefactoring refactoring;
    private final Set initialMembers = new HashSet();
    private PullUpPanel panel;
    private String description;

    public PullUpRefactoringUI(TreePathHandle selectedElements, CompilationInfo info) {
        TreePathHandle selectedPath = PushDownRefactoringUI.resolveSelection(selectedElements, info);
        if (selectedPath != null) {
            Element selected = selectedPath.resolveElement(info);
            this.initialMembers.add(MemberInfo.create(selected, info));
            if (!(selected instanceof TypeElement)) {
                selected = info.getElementUtilities().enclosingTypeElement(selected);
            }
            TreePath tp = info.getTrees().getPath(selected);
            TreePathHandle sourceType = TreePathHandle.create((TreePath)tp, (CompilationInfo)info);
            this.description = ElementHeaders.getHeader((TreePath)tp, (CompilationInfo)info, (String)"%name%");
            this.refactoring = new PullUpRefactoring(sourceType);
            this.refactoring.getContext().add((Object)info.getClasspathInfo());
        } else {
            this.refactoring = new PullUpRefactoring(selectedElements);
        }
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new PullUpPanel(this.refactoring, this.initialMembers, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(PullUpAction.class, (String)"DSC_PullUp", (Object)this.description);
    }

    public String getName() {
        return NbBundle.getMessage(PullUpAction.class, (String)"LBL_PullUp");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PullUpRefactoringUI.class.getName());
    }

    private void captureParameters() {
        this.refactoring.setTargetType((ElementHandle<TypeElement>)this.panel.getTargetType().getElementHandle());
        this.refactoring.setMembers(this.panel.getMembers());
    }
}

