/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.reader;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public final class MyRandomAccessFile
extends RandomAccessFile {
    private final MappedByteBuffer buffer;
    private final FileChannel channel = this.getChannel();

    public MyRandomAccessFile(String fileName) throws IOException {
        super(fileName, "r");
        this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
    }

    public int read() throws IOException {
        if (this.buffer.remaining() == 0) {
            return -1;
        }
        return 0xFF & this.buffer.get();
    }

    public MappedByteBuffer getBuffer() {
        return this.buffer;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.buffer.get(b, off, len);
        return len;
    }

    public long getFilePointer() throws IOException {
        return this.buffer.position();
    }

    public void seek(long pos) throws IOException {
        this.buffer.position((int)pos);
    }

    public void dispose() {
        try {
            this.buffer.clear();
            this.channel.close();
            this.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

