/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.netbeans.modules.editor.lib2.view.ViewHierarchy;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyEvent;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyListener;
import org.openide.util.WeakListeners;

public class BaseCaret
implements Caret,
MouseListener,
MouseMotionListener,
PropertyChangeListener,
DocumentListener,
ActionListener,
AtomicLockListener,
FoldHierarchyListener {
    public static final String BLOCK_CARET = "block-caret";
    public static final String LINE_CARET = "line-caret";
    public static final String THIN_LINE_CARET = "thin-line-caret";
    public static final String THICK_LINE_CARET = "thick-line-caret";
    private static final Logger LOG = Logger.getLogger(BaseCaret.class.getName());
    private static final Logger LOG_EDT = Logger.getLogger(BaseCaret.class.getName() + ".EDT");
    private final ListenerImpl listenerImpl;
    private Rectangle caretBounds;
    protected JTextComponent component;
    Point magicCaretPosition;
    MarkFactory.ContextMark caretMark = new MarkFactory.ContextMark(Position.Bias.Forward, false);
    MarkFactory.ContextMark selectionMark = new MarkFactory.ContextMark(Position.Bias.Forward, false);
    boolean caretVisible;
    boolean blinkVisible;
    boolean selectionVisible;
    protected EventListenerList listenerList = new EventListenerList();
    protected Timer flasher;
    String type;
    int width;
    boolean italic;
    private int[] xPoints = new int[4];
    private int[] yPoints = new int[4];
    private Action selectWordAction;
    private Action selectLineAction;
    protected ChangeEvent changeEvent;
    protected char[] dotChar = new char[]{' '};
    private boolean overwriteMode;
    private BaseDocument listenDoc;
    protected Font afterCaretFont;
    protected Font beforeCaretFont;
    protected Color textForeColor;
    protected Color textBackColor;
    private transient boolean inAtomicLock = false;
    private transient boolean inAtomicUnlock = false;
    private transient boolean modified;
    private transient int undoOffset = -1;
    static final long serialVersionUID = -9113841520331402768L;
    private MouseEvent dndArmedEvent = null;
    private boolean updateAfterFoldHierarchyChange;
    private FoldHierarchyListener weakFHListener;
    private boolean typingModificationOccurred;
    private Preferences prefs = null;
    private final PreferenceChangeListener prefsListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String setingName;
            String string = setingName = evt == null ? null : evt.getKey();
            if (setingName == null || "caret-blink-rate".equals(setingName)) {
                SettingsConversions.callSettingsChange(BaseCaret.this);
                int rate = BaseCaret.this.prefs.getInt("caret-blink-rate", -1);
                if (rate == -1) {
                    JTextComponent c = BaseCaret.this.component;
                    Integer rateI = c == null ? null : (Integer)c.getClientProperty("nbeditor-default-swing-caret-blink-rate");
                    rate = rateI != null ? rateI : 300;
                }
                BaseCaret.this.setBlinkRate(rate);
                BaseCaret.this.refresh();
            }
        }
    };
    private PreferenceChangeListener weakPrefsListener = null;
    private boolean caretUpdatePending;

    public BaseCaret() {
        this.listenerImpl = new ListenerImpl();
    }

    void updateType() {
        JTextComponent c = this.component;
        if (c != null && this.prefs != null) {
            boolean newItalic;
            String newType;
            int newWidth = 0;
            Color caretColor = Color.black;
            if (this.overwriteMode) {
                newType = this.prefs.get("caret-type-overwrite-mode", BLOCK_CARET);
                newItalic = this.prefs.getBoolean("caret-italic-overwrite-mode", false);
            } else {
                newType = this.prefs.get("caret-type-insert-mode", LINE_CARET);
                newItalic = this.prefs.getBoolean("caret-italic-insert-mode", false);
                newWidth = this.prefs.getInt("thick-caret-width", 5);
            }
            FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)c)).lookup(FontColorSettings.class);
            if (fcs != null) {
                if (this.overwriteMode) {
                    AttributeSet attribs = fcs.getFontColors("caret-color-overwrite-mode");
                    if (attribs != null) {
                        caretColor = (Color)attribs.getAttribute(StyleConstants.Foreground);
                    }
                } else {
                    AttributeSet attribs = fcs.getFontColors("caret-color-insert-mode");
                    if (attribs != null) {
                        caretColor = (Color)attribs.getAttribute(StyleConstants.Foreground);
                    }
                }
            }
            this.type = newType;
            this.italic = newItalic;
            this.width = newWidth;
            c.setCaretColor(caretColor);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Updating caret color:" + caretColor + '\n');
            }
            this.resetBlink();
            this.dispatchUpdate(false);
        }
    }

    private boolean updateCaretBounds() {
        JTextComponent c = this.component;
        if (c != null) {
            Rectangle newCaretBounds;
            int offset = this.getDot();
            try {
                BaseDocument doc;
                newCaretBounds = c.getUI().modelToView(c, offset, Position.Bias.Forward);
                if (newCaretBounds != null) {
                    newCaretBounds.width = Math.max(newCaretBounds.width, 2);
                }
                if ((doc = Utilities.getDocument(c)) != null) {
                    doc.getChars(offset, this.dotChar, 0, 1);
                }
            }
            catch (BadLocationException e) {
                newCaretBounds = null;
                Utilities.annotateLoggable(e);
            }
            if (newCaretBounds != null) {
                LOG.log(Level.FINE, "updateCaretBounds: old={0}, new={1}, offset={2}", new Object[]{this.caretBounds, newCaretBounds, offset});
                this.caretBounds = newCaretBounds;
                return true;
            }
        }
        LOG.log(Level.FINE, "updateCaretBounds: no change, old={0}", this.caretBounds);
        return false;
    }

    @Override
    public void install(JTextComponent c) {
        assert (SwingUtilities.isEventDispatchThread());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Installing to " + BaseCaret.s2s(c));
        }
        this.component = c;
        this.blinkVisible = true;
        BaseDocument doc = Utilities.getDocument(c);
        if (doc != null) {
            this.modelChanged(null, doc);
        }
        this.updateCaretBounds();
        if (this.caretBounds == null) {
            this.component.addComponentListener(this.listenerImpl);
        }
        this.component.addPropertyChangeListener(this);
        this.component.addFocusListener(this.listenerImpl);
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
        ViewHierarchy.get((JTextComponent)this.component).addViewHierarchyListener((ViewHierarchyListener)this.listenerImpl);
        EditorUI editorUI = Utilities.getEditorUI(this.component);
        editorUI.addPropertyChangeListener(this);
        if (this.component.hasFocus()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Component has focus, calling BaseCaret.focusGained(); doc=" + this.component.getDocument().getProperty("title") + '\n');
            }
            this.listenerImpl.focusGained(null);
        }
        this.dispatchUpdate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deinstall(JTextComponent c) {
        FoldHierarchy hierarchy;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Deinstalling from " + BaseCaret.s2s(c));
        }
        this.component = null;
        this.caretBounds = null;
        BaseCaret baseCaret = this;
        synchronized (baseCaret) {
            ListenerImpl listenerImpl = this.listenerImpl;
            synchronized (listenerImpl) {
                if (this.flasher != null) {
                    this.setBlinkRate(0);
                }
            }
        }
        c.removeComponentListener(this.listenerImpl);
        c.removePropertyChangeListener(this);
        c.removeFocusListener(this.listenerImpl);
        c.removeMouseListener(this);
        c.removeMouseMotionListener(this);
        ViewHierarchy.get((JTextComponent)c).removeViewHierarchyListener((ViewHierarchyListener)this.listenerImpl);
        EditorUI editorUI = Utilities.getEditorUI(c);
        editorUI.removePropertyChangeListener(this);
        if (this.weakFHListener != null && (hierarchy = FoldHierarchy.get((JTextComponent)c)) != null) {
            hierarchy.removeFoldHierarchyListener(this.weakFHListener);
        }
        this.modelChanged(this.listenDoc, null);
    }

    protected void modelChanged(BaseDocument oldDoc, BaseDocument newDoc) {
        if (oldDoc != null) {
            assert (oldDoc == this.listenDoc);
            DocumentUtilities.removeDocumentListener((Document)oldDoc, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.CARET_UPDATE);
            oldDoc.removeAtomicLockListener(this);
            try {
                this.caretMark.remove();
                this.selectionMark.remove();
            }
            catch (InvalidMarkException e) {
                Utilities.annotateLoggable(e);
            }
            this.listenDoc = null;
            if (this.prefs != null && this.weakPrefsListener != null) {
                this.prefs.removePreferenceChangeListener(this.weakPrefsListener);
            }
        }
        if (newDoc != null) {
            DocumentUtilities.addDocumentListener((Document)newDoc, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.CARET_UPDATE);
            this.listenDoc = newDoc;
            newDoc.addAtomicLockListener(this);
            try {
                Utilities.insertMark(newDoc, this.caretMark, 0);
                Utilities.insertMark(newDoc, this.selectionMark, 0);
            }
            catch (InvalidMarkException e) {
                Utilities.annotateLoggable(e);
            }
            catch (BadLocationException e) {
                Utilities.annotateLoggable(e);
            }
            this.prefs = (Preferences)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((Document)newDoc)).lookup(Preferences.class);
            if (this.prefs != null) {
                this.weakPrefsListener = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs);
                this.prefs.addPreferenceChangeListener(this.weakPrefsListener);
            }
            Utilities.runInEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    BaseCaret.this.updateType();
                }
            });
        }
    }

    @Override
    public void paint(Graphics g) {
        JTextComponent c = this.component;
        if (c == null) {
            return;
        }
        EditorUI editorUI = Utilities.getEditorUI(c);
        if (this.getDot() != 0 && this.caretBounds == null) {
            this.update(true);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("BaseCaret.paint(): caretBounds=" + this.caretBounds + this.dumpVisibility() + '\n');
        }
        if (this.caretBounds != null && this.isVisible() && this.blinkVisible) {
            this.paintCustomCaret(g);
        }
    }

    protected void paintCustomCaret(Graphics g) {
        JTextComponent c = this.component;
        if (c != null) {
            EditorUI editorUI = Utilities.getEditorUI(c);
            g.setColor(c.getCaretColor());
            if (THIN_LINE_CARET.equals(this.type)) {
                int upperX = this.caretBounds.x;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    upperX = (int)((double)upperX + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                }
                g.drawLine(upperX, this.caretBounds.y, this.caretBounds.x, this.caretBounds.y + this.caretBounds.height - 1);
            } else if (THICK_LINE_CARET.equals(this.type)) {
                Color textBackgroundColor;
                int blkWidth = this.width;
                if (blkWidth <= 0) {
                    blkWidth = 5;
                }
                if (this.afterCaretFont != null) {
                    g.setFont(this.afterCaretFont);
                }
                if ((textBackgroundColor = c.getBackground()) != null) {
                    g.setXORMode(textBackgroundColor);
                }
                g.fillRect(this.caretBounds.x, this.caretBounds.y, blkWidth, this.caretBounds.height - 1);
            } else if (BLOCK_CARET.equals(this.type)) {
                if (this.afterCaretFont != null) {
                    g.setFont(this.afterCaretFont);
                }
                if (this.afterCaretFont != null && this.afterCaretFont.isItalic() && this.italic) {
                    int upperX;
                    this.xPoints[0] = upperX = (int)((double)this.caretBounds.x + Math.tan(this.afterCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                    this.yPoints[0] = this.caretBounds.y;
                    this.xPoints[1] = upperX + this.caretBounds.width;
                    this.yPoints[1] = this.caretBounds.y;
                    this.xPoints[2] = this.caretBounds.x + this.caretBounds.width;
                    this.yPoints[2] = this.caretBounds.y + this.caretBounds.height - 1;
                    this.xPoints[3] = this.caretBounds.x;
                    this.yPoints[3] = this.caretBounds.y + this.caretBounds.height - 1;
                    g.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    g.fillRect(this.caretBounds.x, this.caretBounds.y, this.caretBounds.width, this.caretBounds.height);
                }
                if (!Character.isWhitespace(this.dotChar[0])) {
                    Color textBackgroundColor = c.getBackground();
                    if (textBackgroundColor != null) {
                        g.setColor(textBackgroundColor);
                    }
                    g.drawChars(this.dotChar, 0, 1, this.caretBounds.x, this.caretBounds.y + editorUI.getLineAscent());
                }
            } else {
                int blkWidth = 2;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    int upperX;
                    this.xPoints[0] = upperX = (int)((double)this.caretBounds.x + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                    this.yPoints[0] = this.caretBounds.y;
                    this.xPoints[1] = upperX + blkWidth;
                    this.yPoints[1] = this.caretBounds.y;
                    this.xPoints[2] = this.caretBounds.x + blkWidth;
                    this.yPoints[2] = this.caretBounds.y + this.caretBounds.height - 1;
                    this.xPoints[3] = this.caretBounds.x;
                    this.yPoints[3] = this.caretBounds.y + this.caretBounds.height - 1;
                    g.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    g.fillRect(this.caretBounds.x, this.caretBounds.y, blkWidth, this.caretBounds.height - 1);
                }
            }
        }
    }

    void dispatchUpdate(final boolean scrollViewToCaret) {
        Utilities.runInEventDispatchThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BaseDocument doc;
                JTextComponent c = BaseCaret.this.component;
                if (c != null && (doc = Utilities.getDocument(c)) != null) {
                    doc.readLock();
                    try {
                        BaseCaret.this.update(scrollViewToCaret);
                    }
                    finally {
                        doc.readUnlock();
                    }
                }
            }
        });
    }

    protected void update(boolean scrollViewToCaret) {
        this.caretUpdatePending = false;
        JTextComponent c = this.component;
        if (c != null) {
            BaseTextUI ui = (BaseTextUI)c.getUI();
            EditorUI editorUI = ui.getEditorUI();
            BaseDocument doc = Utilities.getDocument(c);
            if (doc != null) {
                Rectangle oldCaretBounds = this.caretBounds;
                if (oldCaretBounds != null) {
                    if (this.italic) {
                        oldCaretBounds.width += oldCaretBounds.height;
                    }
                    c.repaint(oldCaretBounds);
                }
                if (this.updateCaretBounds()) {
                    int oldRelY;
                    JScrollBar hScrollBar;
                    Container scrollPane;
                    Container viewport;
                    Rectangle scrollBounds = new Rectangle(this.caretBounds);
                    if (oldCaretBounds == null && (viewport = c.getParent()) instanceof JViewport && (scrollPane = viewport.getParent()) instanceof JScrollPane && (hScrollBar = ((JScrollPane)scrollPane).getHorizontalScrollBar()) != null) {
                        int hScrollBarHeight = hScrollBar.getPreferredSize().height;
                        Dimension extentSize = ((JViewport)viewport).getExtentSize();
                        if (extentSize.height >= this.caretBounds.height + hScrollBarHeight) {
                            scrollBounds.height += hScrollBarHeight;
                        }
                    }
                    Rectangle visibleBounds = c.getVisibleRect();
                    boolean doScroll = scrollViewToCaret;
                    if (!(oldCaretBounds == null || scrollViewToCaret && !this.updateAfterFoldHierarchyChange || (oldRelY = oldCaretBounds.y - visibleBounds.y) < 0 || oldRelY >= visibleBounds.height || oldCaretBounds.y == this.caretBounds.y && oldCaretBounds.x == this.caretBounds.x)) {
                        doScroll = true;
                        int oldRelX = oldCaretBounds.x - visibleBounds.x;
                        scrollBounds.y = Math.max(this.caretBounds.y - oldRelY, 0);
                        scrollBounds.height = visibleBounds.height;
                    }
                    if (scrollViewToCaret && (this.caretBounds.y > visibleBounds.y + visibleBounds.height + this.caretBounds.height || this.caretBounds.y + this.caretBounds.height < visibleBounds.y - this.caretBounds.height)) {
                        scrollBounds.y -= (visibleBounds.height - this.caretBounds.height) / 2;
                        scrollBounds.height = visibleBounds.height;
                    }
                    this.updateAfterFoldHierarchyChange = false;
                    if (doScroll) {
                        c.scrollRectToVisible(scrollBounds);
                    }
                    this.resetBlink();
                    c.repaint(this.caretBounds);
                }
            }
        }
    }

    private void updateSystemSelection() {
        Clipboard clip;
        if (this.getDot() != this.getMark() && this.component != null && (clip = this.getSystemSelection()) != null) {
            clip.setContents(new StringSelection(this.component.getSelectedText()), null);
        }
    }

    private Clipboard getSystemSelection() {
        return this.component.getToolkit().getSystemSelection();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] listeners = BaseCaret.this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ChangeListener.class) continue;
                    if (BaseCaret.this.changeEvent == null) {
                        BaseCaret.this.changeEvent = new ChangeEvent(BaseCaret.this);
                    }
                    ((ChangeListener)listeners[i + 1]).stateChanged(BaseCaret.this.changeEvent);
                }
            }
        };
        if (this.inAtomicUnlock) {
            SwingUtilities.invokeLater(runnable);
        } else {
            Utilities.runInEventDispatchThread(runnable);
        }
        this.updateSystemSelection();
    }

    @Override
    public final boolean isVisible() {
        return this.caretVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVisibleImpl(boolean v) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("BaseCaret.setVisible(" + v + ")\n");
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.INFO, "", new Exception());
            }
        }
        boolean visible = this.isVisible();
        BaseCaret baseCaret = this;
        synchronized (baseCaret) {
            ListenerImpl listenerImpl = this.listenerImpl;
            synchronized (listenerImpl) {
                if (this.flasher != null) {
                    if (visible) {
                        this.flasher.stop();
                    }
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer((v ? "Starting" : "Stopping") + " the caret blinking timer: " + this.dumpVisibility() + '\n');
                    }
                    if (v) {
                        this.flasher.start();
                    } else {
                        this.flasher.stop();
                    }
                }
            }
            this.caretVisible = v;
        }
        JTextComponent c = this.component;
        if (c != null && this.caretBounds != null) {
            Rectangle repaintRect = this.caretBounds;
            if (this.italic) {
                repaintRect = new Rectangle(repaintRect);
                repaintRect.width += repaintRect.height;
            }
            c.repaint(repaintRect);
        }
    }

    private String dumpVisibility() {
        return "visible=" + this.isVisible() + ", blinkVisible=" + this.blinkVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBlink() {
        BaseCaret baseCaret = this;
        synchronized (baseCaret) {
            boolean visible = this.isVisible();
            ListenerImpl listenerImpl = this.listenerImpl;
            synchronized (listenerImpl) {
                if (this.flasher != null) {
                    this.flasher.stop();
                    this.blinkVisible = true;
                    if (visible) {
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.finer("Reset blinking (caret already visible) - starting the caret blinking timer: " + this.dumpVisibility() + '\n');
                        }
                        this.flasher.start();
                    } else if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("Reset blinking (caret not visible) - caret blinking timer not started: " + this.dumpVisibility() + '\n');
                    }
                }
            }
        }
    }

    @Override
    public void setVisible(final boolean v) {
        Utilities.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                BaseCaret.this.setVisibleImpl(v);
            }
        });
    }

    @Override
    public final boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    @Override
    public void setSelectionVisible(boolean v) {
        Document doc;
        if (this.selectionVisible == v) {
            return;
        }
        JTextComponent c = this.component;
        if (c != null && (doc = c.getDocument()) != null) {
            this.selectionVisible = v;
            final BaseTextUI ui = (BaseTextUI)c.getUI();
            doc.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        ui.getEditorUI().repaintBlock(BaseCaret.this.caretMark.getOffset(), BaseCaret.this.selectionMark.getOffset());
                    }
                    catch (BadLocationException e) {
                        Utilities.annotateLoggable(e);
                    }
                    catch (InvalidMarkException e) {
                        Utilities.annotateLoggable(e);
                    }
                }
            });
        }
    }

    @Override
    public void setMagicCaretPosition(Point p) {
        this.magicCaretPosition = p;
    }

    @Override
    public final Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setBlinkRate(int rate) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setBlinkRate(" + rate + ")" + this.dumpVisibility() + '\n');
        }
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            if (this.flasher == null && rate > 0) {
                this.flasher = new Timer(rate, new WeakTimerListener(this));
            }
            if (this.flasher != null) {
                if (rate > 0) {
                    if (this.flasher.getDelay() != rate) {
                        this.flasher.setDelay(rate);
                    }
                } else {
                    this.flasher.stop();
                    this.flasher.removeActionListener(this);
                    this.flasher = null;
                    this.blinkVisible = true;
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("Zero blink rate - no blinking. flasher=null; blinkVisible=true");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlinkRate() {
        BaseCaret baseCaret = this;
        synchronized (baseCaret) {
            ListenerImpl listenerImpl = this.listenerImpl;
            synchronized (listenerImpl) {
                return this.flasher != null ? this.flasher.getDelay() : 0;
            }
        }
    }

    @Override
    public int getDot() {
        if (this.component != null) {
            try {
                return this.caretMark.getOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public int getMark() {
        if (this.component != null) {
            try {
                return this.selectionMark.getOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public void setDot(int offset) {
        this.setDot(offset, this.caretBounds, 0);
    }

    public void setDot(int offset, boolean expandFold) {
        this.setDot(offset, this.caretBounds, 0, expandFold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDot(int offset, Rectangle scrollRect, int scrollPolicy, boolean expandFold) {
        JTextComponent c;
        if (LOG_EDT.isLoggable(Level.FINE) && !SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("BaseCaret.setDot() not in EDT: offset=" + offset);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("setDot: offset=" + offset);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.INFO, "setDot call stack", new Exception());
            }
        }
        if ((c = this.component) != null) {
            boolean dotChanged;
            block16: {
                BaseDocument doc = (BaseDocument)c.getDocument();
                dotChanged = false;
                doc.readLock();
                try {
                    if (doc == null || offset < 0 || offset > doc.getLength()) break block16;
                    dotChanged = true;
                    try {
                        Utilities.moveMark(doc, this.caretMark, offset);
                        Utilities.moveMark(doc, this.selectionMark, offset);
                        FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)c);
                        if (this.weakFHListener == null) {
                            this.weakFHListener = (FoldHierarchyListener)WeakListeners.create(FoldHierarchyListener.class, (EventListener)this, (Object)hierarchy);
                            hierarchy.addFoldHierarchyListener(this.weakFHListener);
                        }
                        hierarchy.lock();
                        try {
                            Fold collapsed = null;
                            while (expandFold && (collapsed = FoldUtilities.findCollapsedFold((FoldHierarchy)hierarchy, (int)offset, (int)offset)) != null && collapsed.getStartOffset() < offset && collapsed.getEndOffset() > offset) {
                                hierarchy.expand(collapsed);
                            }
                        }
                        finally {
                            hierarchy.unlock();
                        }
                    }
                    catch (BadLocationException e) {
                        throw new IllegalStateException(e.toString());
                    }
                    catch (InvalidMarkException e) {
                        throw new IllegalStateException(e.toString());
                    }
                }
                finally {
                    doc.readUnlock();
                }
            }
            if (dotChanged) {
                this.fireStateChanged();
                this.dispatchUpdate(true);
            }
        }
    }

    public void setDot(int offset, Rectangle scrollRect, int scrollPolicy) {
        this.setDot(offset, scrollRect, scrollPolicy, true);
    }

    @Override
    public void moveDot(int offset) {
        this.moveDot(offset, this.caretBounds, 1);
    }

    public void moveDot(int offset, Rectangle scrollRect, int scrollPolicy) {
        JTextComponent c;
        if (LOG_EDT.isLoggable(Level.FINE) && !SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("BaseCaret.moveDot() not in EDT: offset=" + offset);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("moveDot: offset=" + offset);
        }
        if ((c = this.component) != null) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            if (doc != null && offset >= 0 && offset <= doc.getLength()) {
                try {
                    int oldCaretPos = this.getDot();
                    if (offset == oldCaretPos) {
                        return;
                    }
                    Utilities.moveMark(doc, this.caretMark, offset);
                    if (this.selectionVisible) {
                        Utilities.getEditorUI(c).repaintBlock(oldCaretPos, offset);
                    }
                }
                catch (BadLocationException e) {
                    throw new IllegalStateException(e.toString());
                }
                catch (InvalidMarkException e) {
                    throw new IllegalStateException(e.toString());
                }
            }
            this.fireStateChanged();
            this.dispatchUpdate(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            boolean typingModification;
            BaseDocument doc = (BaseDocument)this.component.getDocument();
            BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
            if ((bevt.isInUndo() || bevt.isInRedo()) && this.component == Utilities.getLastActiveComponent() && !Boolean.TRUE.equals(DocumentUtilities.getEventProperty((DocumentEvent)evt, (Object)"caretIgnore"))) {
                this.undoOffset = evt.getOffset() + evt.getLength();
                typingModification = true;
            } else {
                this.undoOffset = -1;
                typingModification = DocumentUtilities.isTypingModification((Document)this.component.getDocument());
            }
            this.modified = true;
            this.modifiedUpdate(typingModification);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            boolean typingModification;
            BaseDocument doc = (BaseDocument)c.getDocument();
            BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
            if ((bevt.isInUndo() || bevt.isInRedo()) && c == Utilities.getLastActiveComponent() && !Boolean.TRUE.equals(DocumentUtilities.getEventProperty((DocumentEvent)evt, (Object)"caretIgnore"))) {
                this.undoOffset = evt.getOffset();
                typingModification = true;
            } else {
                this.undoOffset = -1;
                typingModification = DocumentUtilities.isTypingModification((Document)this.component.getDocument());
            }
            this.modified = true;
            this.modifiedUpdate(typingModification);
        }
    }

    private void modifiedUpdate(boolean typingModification) {
        if (!this.inAtomicLock) {
            JTextComponent c = this.component;
            if (this.modified && c != null) {
                if (this.undoOffset >= 0) {
                    this.setDot(this.undoOffset);
                } else {
                    this.fireStateChanged();
                    this.dispatchUpdate(c.hasFocus() && typingModification);
                }
                this.modified = false;
            }
        } else {
            this.typingModificationOccurred |= typingModification;
        }
    }

    @Override
    public void atomicLock(AtomicLockEvent evt) {
        this.inAtomicLock = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void atomicUnlock(AtomicLockEvent evt) {
        this.inAtomicLock = false;
        this.inAtomicUnlock = true;
        try {
            this.modifiedUpdate(this.typingModificationOccurred);
        }
        finally {
            this.inAtomicUnlock = false;
            this.typingModificationOccurred = false;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        if (evt == null) {
            this.dispatchUpdate(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseClicked(MouseEvent evt) {
        JTextComponent c;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("mouseClicked: " + BaseCaret.logMouseEvent(evt));
        }
        if ((c = this.component) == null) return;
        if (SwingUtilities.isLeftMouseButton(evt)) {
            if (evt.getClickCount() == 2) {
                BaseTextUI ui = (BaseTextUI)c.getUI();
                int offset = ui.viewToModel(c, evt.getX(), evt.getY());
                FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)c);
                Document doc = c.getDocument();
                if (!(doc instanceof AbstractDocument)) return;
                AbstractDocument adoc = (AbstractDocument)doc;
                adoc.readLock();
                try {
                    hierarchy.lock();
                    try {
                        Fold collapsed = FoldUtilities.findCollapsedFold((FoldHierarchy)hierarchy, (int)offset, (int)offset);
                        if (collapsed != null && collapsed.getStartOffset() <= offset && collapsed.getEndOffset() >= offset) {
                            hierarchy.expand(collapsed);
                            return;
                        }
                        if (this.selectWordAction == null) {
                            this.selectWordAction = ((BaseKit)ui.getEditorKit(c)).getActionByName("select-word");
                        }
                        if (this.selectWordAction == null) return;
                        this.selectWordAction.actionPerformed(null);
                        return;
                    }
                    finally {
                        hierarchy.unlock();
                    }
                }
                finally {
                    adoc.readUnlock();
                }
            } else {
                if (evt.getClickCount() != 3) return;
                if (this.selectLineAction == null) {
                    BaseTextUI ui = (BaseTextUI)c.getUI();
                    this.selectLineAction = ((BaseKit)ui.getEditorKit(c)).getActionByName("select-line");
                }
                if (this.selectLineAction == null) return;
                this.selectLineAction.actionPerformed(null);
            }
            return;
        }
        if (!SwingUtilities.isMiddleMouseButton(evt) || evt.getClickCount() != 1) return;
        if (c == null) {
            return;
        }
        Toolkit tk = c.getToolkit();
        Clipboard buffer = this.getSystemSelection();
        if (buffer == null) {
            return;
        }
        Transferable trans = buffer.getContents(null);
        if (trans == null) {
            return;
        }
        final BaseDocument doc = (BaseDocument)c.getDocument();
        if (doc == null) {
            return;
        }
        final int offset = ((BaseTextUI)c.getUI()).viewToModel(c, evt.getX(), evt.getY());
        try {
            final String pastingString = (String)trans.getTransferData(DataFlavor.stringFlavor);
            if (pastingString == null) {
                return;
            }
            doc.runAtomicAsUser(new Runnable(){

                @Override
                public void run() {
                    try {
                        doc.insertString(offset, pastingString, null);
                        BaseCaret.this.setDot(offset + pastingString.length());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            return;
        }
        catch (UnsupportedFlavorException ufe) {
            return;
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private void mousePressedImpl(MouseEvent evt) {
        JTextComponent c = this.component;
        if (c != null && (SwingUtilities.isLeftMouseButton(evt) && !evt.isPopupTrigger() && (evt.getModifiers() & 0xC) == 0 || !this.isSelectionVisible() || this.getMark() == this.getDot())) {
            int offset = ((BaseTextUI)c.getUI()).viewToModel(c, evt.getX(), evt.getY());
            if (offset >= 0) {
                if ((evt.getModifiers() & 1) != 0) {
                    this.moveDot(offset);
                } else {
                    this.setDot(offset);
                }
                this.setMagicCaretPosition(null);
            }
            if (c.isEnabled()) {
                c.requestFocus();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("mousePressed: " + BaseCaret.logMouseEvent(evt));
        }
        this.dndArmedEvent = null;
        if (this.isDragPossible(evt) && this.mapDragOperationFromModifiers(evt) != 0) {
            this.dndArmedEvent = evt;
            evt.consume();
            return;
        }
        this.mousePressedImpl(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("mouseReleased: " + BaseCaret.logMouseEvent(evt));
        }
        if (this.dndArmedEvent != null) {
            this.mousePressedImpl(evt);
        }
        this.dndArmedEvent = null;
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    protected int mapDragOperationFromModifiers(MouseEvent e) {
        int mods = e.getModifiersEx();
        if ((mods & 0x400) != 1024) {
            return 0;
        }
        return 3;
    }

    protected boolean isDragPossible(MouseEvent e) {
        int mark;
        Caret caret;
        int dot;
        JTextComponent c;
        boolean possible;
        JComponent comp = this.getEventComponent(e);
        boolean bl = comp == null ? false : (possible = comp.getTransferHandler() != null);
        if (possible && (c = (JTextComponent)this.getEventComponent(e)).getDragEnabled() && (dot = (caret = c.getCaret()).getDot()) != (mark = caret.getMark())) {
            Point p = new Point(e.getX(), e.getY());
            int pos = c.viewToModel(p);
            int p0 = Math.min(dot, mark);
            int p1 = Math.max(dot, mark);
            if (pos >= p0 && pos < p1) {
                return true;
            }
        }
        return false;
    }

    protected JComponent getEventComponent(MouseEvent e) {
        Object src = e.getSource();
        if (src instanceof JComponent) {
            JComponent c = (JComponent)src;
            return c;
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("mouseDragged: " + BaseCaret.logMouseEvent(evt));
        }
        if (this.dndArmedEvent != null) {
            evt.consume();
            return;
        }
        JTextComponent c = this.component;
        if (SwingUtilities.isLeftMouseButton(evt) && c != null) {
            int offset = ((BaseTextUI)c.getUI()).viewToModel(c, evt.getX(), evt.getY());
            if (offset == -1) {
                offset = 0;
            }
            if (offset >= 0 && (evt.getModifiers() & 1) == 0) {
                this.moveDot(offset);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    private static String logMouseEvent(MouseEvent evt) {
        return "x=" + evt.getX() + ", y=" + evt.getY() + ", component=" + BaseCaret.s2s(evt.getComponent()) + ", source=" + BaseCaret.s2s(evt.getSource());
    }

    private static String s2s(Object o) {
        return o == null ? "null" : o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("document".equals(propName)) {
            BaseDocument newDoc = evt.getNewValue() instanceof BaseDocument ? (BaseDocument)evt.getNewValue() : null;
            this.modelChanged(this.listenDoc, newDoc);
        } else if ("overwriteMode".equals(propName)) {
            Boolean b = (Boolean)evt.getNewValue();
            this.overwriteMode = b != null ? b : false;
            this.updateType();
        } else if ("ancestor".equals(propName) && evt.getSource() == this.component) {
            JScrollPane scrollPane;
            JScrollBar hScrollBar;
            Container parent = this.component.getParent();
            if (parent instanceof JViewport && (parent = parent.getParent()) instanceof JScrollPane && (hScrollBar = (scrollPane = (JScrollPane)parent).getHorizontalScrollBar()) != null) {
                hScrollBar.addComponentListener((ComponentListener)WeakListeners.create(ComponentListener.class, (EventListener)this.listenerImpl, (Object)hScrollBar));
            }
        } else if ("enabled".equals(evt.getPropertyName())) {
            Boolean enabled = (Boolean)evt.getNewValue();
            if (this.component.isFocusOwner()) {
                if (enabled == Boolean.TRUE) {
                    if (this.component.isEditable()) {
                        this.setVisible(true);
                    }
                    this.setSelectionVisible(true);
                } else {
                    this.setVisible(false);
                    this.setSelectionVisible(false);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            boolean bl = this.blinkVisible = !this.blinkVisible;
            if (this.caretBounds != null) {
                Rectangle repaintRect = this.caretBounds;
                if (this.italic) {
                    repaintRect = new Rectangle(repaintRect);
                    repaintRect.width += repaintRect.height;
                }
                c.repaint(repaintRect);
            }
        }
    }

    public void foldHierarchyChanged(FoldHierarchyEvent evt) {
        boolean scrollToView;
        int caretOffset = this.getDot();
        int addedFoldCnt = evt.getAddedFoldCount();
        if (addedFoldCnt > 0) {
            FoldHierarchy hierarchy = (FoldHierarchy)evt.getSource();
            Fold collapsed = null;
            while ((collapsed = FoldUtilities.findCollapsedFold((FoldHierarchy)hierarchy, (int)caretOffset, (int)caretOffset)) != null && collapsed.getStartOffset() < caretOffset && collapsed.getEndOffset() > caretOffset) {
                hierarchy.expand(collapsed);
            }
            scrollToView = true;
        } else {
            int startOffset = Integer.MAX_VALUE;
            if (evt.getAffectedStartOffset() <= caretOffset && evt.getAffectedEndOffset() >= caretOffset) {
                for (int i = 0; i < evt.getFoldStateChangeCount(); ++i) {
                    Fold fold;
                    FoldStateChange change = evt.getFoldStateChange(i);
                    if (!change.isCollapsedChanged() || !(fold = change.getFold()).isCollapsed() || fold.getStartOffset() > caretOffset || fold.getEndOffset() < caretOffset || fold.getStartOffset() >= startOffset) continue;
                    startOffset = fold.getStartOffset();
                }
                if (startOffset != Integer.MAX_VALUE) {
                    this.setDot(startOffset, false);
                }
            }
            scrollToView = false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseCaret.this.updateAfterFoldHierarchyChange = true;
                BaseCaret.this.dispatchUpdate(scrollToView);
            }
        });
    }

    void scheduleCaretUpdate() {
        if (!this.caretUpdatePending) {
            this.caretUpdatePending = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseCaret.this.update(false);
                }
            });
        }
    }

    public final void refresh() {
        this.updateType();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseCaret.this.updateCaretBounds();
            }
        });
    }

    static {
        if (Boolean.getBoolean("netbeans.debug.editor.caret.focus") && LOG.getLevel().intValue() < Level.FINE.intValue()) {
            LOG.setLevel(Level.FINE);
        }
        if (Boolean.getBoolean("netbeans.debug.editor.caret.focus.extra") && LOG.getLevel().intValue() < Level.FINER.intValue()) {
            LOG.setLevel(Level.FINER);
        }
    }

    private class ListenerImpl
    extends ComponentAdapter
    implements FocusListener,
    ViewHierarchyListener {
        ListenerImpl() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            JTextComponent c;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("BaseCaret.focusGained(); doc=" + BaseCaret.this.component.getDocument().getProperty("title") + '\n');
            }
            if ((c = BaseCaret.this.component) != null) {
                BaseCaret.this.updateType();
                if (BaseCaret.this.component.isEnabled()) {
                    if (BaseCaret.this.component.isEditable()) {
                        BaseCaret.this.setVisible(true);
                    }
                    BaseCaret.this.setSelectionVisible(true);
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Caret visibility: " + BaseCaret.this.isVisible() + '\n');
                }
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Text component is null, caret will not be visible\n");
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("BaseCaret.focusLost(); doc=" + BaseCaret.this.component.getDocument().getProperty("title") + "\nFOCUS GAINER: " + evt.getOppositeComponent() + '\n');
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("FOCUS EVENT: " + evt + '\n');
                }
            }
            BaseCaret.this.setVisible(false);
            BaseCaret.this.setSelectionVisible(evt.isTemporary());
        }

        @Override
        public void componentShown(ComponentEvent e) {
            Component hScrollBar = e.getComponent();
            if (hScrollBar != BaseCaret.this.component) {
                Container scrollPane = hScrollBar.getParent();
                if (BaseCaret.this.caretBounds != null && scrollPane instanceof JScrollPane) {
                    Rectangle viewRect = ((JScrollPane)scrollPane).getViewport().getViewRect();
                    Rectangle hScrollBarRect = new Rectangle(viewRect.x, viewRect.y + viewRect.height, hScrollBar.getWidth(), hScrollBar.getHeight());
                    if (hScrollBarRect.intersects(BaseCaret.this.caretBounds)) {
                        BaseCaret.this.dispatchUpdate(true);
                    }
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Component c = e.getComponent();
            if (c == BaseCaret.this.component && BaseCaret.this.caretBounds == null) {
                BaseCaret.this.dispatchUpdate(true);
                if (BaseCaret.this.caretBounds != null) {
                    c.removeComponentListener(this);
                }
            }
        }

        public void viewHierarchyChanged(ViewHierarchyEvent evt) {
            if (BaseCaret.this.getDot() >= evt.affectedStartOffset()) {
                BaseCaret.this.scheduleCaretUpdate();
            }
        }
    }
}

