/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import java.util.Arrays;
import java.util.Collection;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Rule;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateTemporalAnnotationHint;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidColumnName;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class TemporalFieldsAnnotated
extends JPAEntityAttributeCheck {
    private static Collection<String> temporalTypes = Arrays.asList("java.util.Calendar", "java.util.Date");

    @Override
    public ErrorDescription[] check(JPAProblemContext ctx, AttributeWrapper attrib) {
        String temporal = attrib.getTemporal();
        if ((temporal == null || temporal.length() == 0) && temporalTypes.contains(((Object)attrib.getType()).toString())) {
            CreateTemporalAnnotationHint fix = new CreateTemporalAnnotationHint(ctx.getFileObject(), (ElementHandle<Element>)ElementHandle.create((Element)attrib.getJavaElement()));
            return new ErrorDescription[]{Rule.createProblem(attrib.getJavaElement(), (ProblemContext)ctx, NbBundle.getMessage(ValidColumnName.class, (String)"MSG_TemporalAttrNotAnnotatedProperly"), fix)};
        }
        return null;
    }
}

