/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Rule;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateManyToOneRelationshipHint;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateOneToOneRelationshipHint;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateUnidirManyToOneRelationship;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateUnidirOneToOneRelationship;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class RelationshipForEntityTypeAttrDefined
extends JPAEntityAttributeCheck {
    @Override
    public ErrorDescription[] check(JPAProblemContext ctx, AttributeWrapper attrib) {
        Entity entity;
        if (ctx.isEmbeddable()) {
            return null;
        }
        Element typeElement = ctx.getCompilationInfo().getTypes().asElement(attrib.getType());
        if (typeElement != null && typeElement.getKind() == ElementKind.CLASS && (entity = ModelUtils.getEntity(ctx.getMetaData(), (TypeElement)typeElement)) != null) {
            List<? extends AnnotationMirror> anns = attrib.getJavaElement().getAnnotationMirrors();
            if (anns != null) {
                boolean id = false;
                boolean rel = false;
                for (AnnotationMirror annotationMirror : anns) {
                    annotationMirror.getAnnotationType().asElement().toString();
                    if (annotationMirror.getAnnotationType().asElement().toString().equals("javax.persistence.Id")) {
                        id = true;
                    } else if (annotationMirror.getAnnotationType().asElement().toString().equals("javax.persistence.ManyToOne") || annotationMirror.getAnnotationType().asElement().toString().equals("javax.persistence.OneToOne")) {
                        rel = true;
                    }
                    if (!id || !rel) continue;
                    return null;
                }
            }
            ElementHandle classHandle = ElementHandle.create((Element)ctx.getJavaClass());
            ElementHandle elemHandle = ElementHandle.create((Element)attrib.getJavaElement());
            String remoteClassName = ((TypeElement)typeElement).getQualifiedName().toString();
            CreateUnidirOneToOneRelationship createUnidirOneToOneRelationship = new CreateUnidirOneToOneRelationship(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle, (ElementHandle<Element>)elemHandle);
            CreateOneToOneRelationshipHint fix2 = new CreateOneToOneRelationshipHint(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle, ctx.getAccessType(), attrib.getName(), remoteClassName);
            CreateUnidirManyToOneRelationship fix3 = new CreateUnidirManyToOneRelationship(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle, (ElementHandle<Element>)elemHandle);
            CreateManyToOneRelationshipHint fix4 = new CreateManyToOneRelationshipHint(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle, ctx.getAccessType(), attrib.getName(), remoteClassName);
            return new ErrorDescription[]{Rule.createProblem(attrib.getJavaElement(), (ProblemContext)ctx, NbBundle.getMessage(RelationshipForEntityTypeAttrDefined.class, (String)"MSG_EntityRelationNotDefined"), Severity.WARNING, Arrays.asList(createUnidirOneToOneRelationship, fix2, fix3, fix4))};
        }
        return null;
    }
}

