/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.tasklist.projectint.EmptyIterator;
import org.netbeans.modules.tasklist.projectint.FileObjectIterator;
import org.netbeans.modules.tasklist.projectint.MainProjectScanningScope;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;

class MainProjectIterator
implements Iterator<FileObject> {
    private Iterator<FileObject> iterator;

    @Override
    public boolean hasNext() {
        this.initialize();
        return this.iterator.hasNext();
    }

    @Override
    public FileObject next() {
        this.initialize();
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void initialize() {
        if (null == this.iterator) {
            this.iterator = this.createIterator();
        }
    }

    protected Iterator<FileObject> createIterator() {
        boolean isMainProject = true;
        Project currentProject = OpenProjects.getDefault().getMainProject();
        if (null == currentProject) {
            isMainProject = false;
            currentProject = MainProjectScanningScope.findCurrentProject();
            if (null == currentProject) {
                return new EmptyIterator();
            }
        }
        ArrayList<FileObject> roots = new ArrayList<FileObject>(10);
        this.addProject(currentProject, roots);
        if (isMainProject) {
            this.addDependantProjects(currentProject, roots);
        }
        return new FileObjectIterator(roots);
    }

    private void addDependantProjects(Project mainProject, ArrayList<FileObject> roots) {
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            SubprojectProvider subProjectProvider;
            if (projects[i].equals(mainProject) || null == (subProjectProvider = (SubprojectProvider)projects[i].getLookup().lookup(SubprojectProvider.class)) || !subProjectProvider.getSubprojects().contains(mainProject)) continue;
            this.addProject(projects[i], roots);
        }
    }

    private void addProject(Project p, ArrayList<FileObject> roots) {
        SourceGroup[] groups;
        Sources sources = ProjectUtils.getSources((Project)p);
        for (SourceGroup group : groups = sources.getSourceGroups("generic")) {
            FileObject rootFolder = group.getRootFolder();
            roots.add(rootFolder);
        }
    }
}

