/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Rectangle;
import java.awt.Shape;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

public final class VisualUpdate<V extends EditorView> {
    private static final int MAJOR_SPAN_CHANGED = 1;
    private static final int MINOR_SPAN_CHANGED = 2;
    private static final int WIDTH_CHANGED = 4;
    private static final int HEIGHT_CHANGED = 8;
    private static final int TABS_CHANGED = 16;
    private static final int IN_CACHE = 32;
    private final EditorBoxView<V> boxView;
    Rectangle repaintBounds;
    private int statusBits;
    int visualIndex;
    int endVisualIndex;
    double visualOffset;
    double endVisualOffset;

    public VisualUpdate(EditorBoxView<V> boxView) {
        this.boxView = boxView;
    }

    public EditorBoxView<V> getView() {
        return this.boxView;
    }

    public Rectangle getRepaintBounds() {
        return this.repaintBounds;
    }

    public boolean isPreferenceChanged() {
        return (this.statusBits & 0x1F) != 0;
    }

    public boolean isMajorChildrenSpanChanged() {
        return (this.statusBits & 1) != 0;
    }

    void markMajorChildrenSpanChanged() {
        this.statusBits |= 1;
    }

    public boolean isMinorChildrenSpanChanged() {
        return (this.statusBits & 2) != 0;
    }

    void markMinorChildrenSpanChanged() {
        this.statusBits |= 2;
    }

    public boolean isWidthChanged() {
        return (this.statusBits & 4) != 0;
    }

    void markWidthChanged() {
        this.statusBits |= 4;
    }

    public boolean isHeightChanged() {
        return (this.statusBits & 8) != 0;
    }

    void markHeightChanged() {
        this.statusBits |= 8;
    }

    public boolean isTabsChanged() {
        return (this.statusBits & 0x10) != 0;
    }

    void markTabsChanged() {
        this.statusBits |= 0x10;
    }

    public boolean isInCache() {
        return (this.statusBits & 0x20) != 0;
    }

    void markInCache() {
        this.statusBits |= 0x20;
    }

    double changedMajorSpan() {
        return this.endVisualOffset - this.visualOffset;
    }

    void updateSpansAndLayout(Shape alloc) {
        this.boxView.updateSpansAndLayout(this, alloc);
    }

    public String toString() {
        return "[" + this.visualIndex + "," + this.endVisualIndex + "]" + ", " + ViewUtils.toStringAxis(this.boxView.getMajorAxis()) + "[" + ViewUtils.toStringPrec1(this.visualOffset) + "," + ViewUtils.toStringPrec1(this.endVisualOffset) + "], repaintBnds=" + this.repaintBounds + "\n    major/minorChSpanChged=" + this.isMajorChildrenSpanChanged() + "/" + this.isMinorChildrenSpanChanged() + ", width/heightChged=" + this.isWidthChanged() + "/" + this.isHeightChanged() + ", tabsChged=" + this.isTabsChanged();
    }
}

