/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.diff;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.diff.SimpleDiffBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class DiffCommand
extends BasicCommand {
    protected EventManager eventManager;
    private String beforeDate1;
    private String revision1;
    private String revision2;
    private String beforeDate2;
    private String keywordSubst;
    private boolean ignoreAllWhitespace;
    private boolean ignoreBlankLines;
    private boolean ignoreCase;
    private boolean ignoreSpaceChange;
    private boolean contextDiff;
    private boolean unifiedDiff;

    public Builder createBuilder(EventManager eventMan) {
        if (this.isContextDiff() || this.isUnifiedDiff()) {
            return null;
        }
        return new SimpleDiffBuilder(eventMan, this);
    }

    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        client.ensureConnection();
        this.eventManager = em;
        super.execute(client, em);
        try {
            this.addRDSwitches();
            if (this.getKeywordSubst() != null && !this.getKeywordSubst().equals("")) {
                this.requests.add(new ArgumentRequest("-k" + this.getKeywordSubst()));
            }
            this.addArgumentRequest(this.isIgnoreAllWhitespace(), "-w");
            this.addArgumentRequest(this.isIgnoreBlankLines(), "-B");
            this.addArgumentRequest(this.isIgnoreSpaceChange(), "-b");
            this.addArgumentRequest(this.isIgnoreCase(), "-i");
            this.addArgumentRequest(this.isContextDiff(), "-c");
            this.addArgumentRequest(this.isUnifiedDiff(), "-u");
            this.addRequestForWorkingDirectory(client);
            this.addArgumentRequests();
            this.addRequest(CommandRequest.DIFF);
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    private void addRDSwitches() {
        if (this.getRevision2() != null) {
            this.requests.add(1, new ArgumentRequest("-r"));
            this.requests.add(2, new ArgumentRequest(this.getRevision2()));
        } else if (this.getBeforeDate2() != null) {
            this.requests.add(1, new ArgumentRequest("-D " + this.getBeforeDate2()));
        }
        if (this.getRevision1() != null) {
            this.requests.add(1, new ArgumentRequest("-r"));
            this.requests.add(2, new ArgumentRequest(this.getRevision1()));
        } else if (this.getBeforeDate1() != null) {
            this.requests.add(1, new ArgumentRequest("-D " + this.getBeforeDate1()));
        } else {
            return;
        }
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getBeforeDate1() {
        return this.beforeDate1;
    }

    public void setBeforeDate1(String beforeDate) {
        this.beforeDate1 = beforeDate;
    }

    public String getRevision1() {
        return this.revision1;
    }

    public void setRevision1(String firstRevision) {
        this.revision1 = firstRevision;
    }

    public String getRevision2() {
        return this.revision2;
    }

    public void setRevision2(String secondRevision) {
        this.revision2 = secondRevision;
    }

    public String getBeforeDate2() {
        return this.beforeDate2;
    }

    public void setBeforeDate2(String beforeDate2) {
        this.beforeDate2 = beforeDate2;
    }

    public String getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(String keywordSubst) {
        this.keywordSubst = keywordSubst;
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("diff ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            for (int index = 0; index < files.length; ++index) {
                toReturn.append(files[index].getName() + " ");
            }
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'r') {
            if (this.getRevision1() == null) {
                this.setRevision1(optArg);
            } else {
                this.setRevision2(optArg);
            }
        } else if (opt == 'D') {
            if (this.getBeforeDate1() == null) {
                this.setBeforeDate1(optArg);
            } else {
                this.setBeforeDate2(optArg);
            }
        } else if (opt == 'k') {
            this.setKeywordSubst(optArg);
        } else if (opt == 'w') {
            this.setIgnoreAllWhitespace(true);
        } else if (opt == 'b') {
            this.setIgnoreSpaceChange(true);
        } else if (opt == 'B') {
            this.setIgnoreBlankLines(true);
        } else if (opt == 'i') {
            this.setIgnoreCase(true);
        } else if (opt == 'c') {
            this.setContextDiff(true);
        } else if (opt == 'u') {
            this.setUnifiedDiff(true);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rlr:D:k:wBbicu";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setRevision1(null);
        this.setRevision2(null);
        this.setBeforeDate1(null);
        this.setBeforeDate2(null);
        this.setKeywordSubst(null);
        this.setIgnoreAllWhitespace(false);
        this.setIgnoreBlankLines(false);
        this.setIgnoreCase(false);
        this.setIgnoreSpaceChange(false);
        this.setContextDiff(false);
        this.setUnifiedDiff(false);
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (this.getKeywordSubst() != null && this.getKeywordSubst().length() > 0) {
            toReturn.append("-k" + this.getKeywordSubst() + " ");
        }
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.getRevision1() != null) {
            toReturn.append("-r " + this.getRevision1() + " ");
        }
        if (this.getBeforeDate1() != null) {
            toReturn.append("-D " + this.getBeforeDate1() + " ");
        }
        if (this.getRevision2() != null) {
            toReturn.append("-r " + this.getRevision2() + " ");
        }
        if (this.getBeforeDate2() != null) {
            toReturn.append("-D " + this.getBeforeDate2() + " ");
        }
        if (this.isIgnoreAllWhitespace()) {
            toReturn.append("-w ");
        }
        if (this.isIgnoreBlankLines()) {
            toReturn.append("-B ");
        }
        if (this.isIgnoreCase()) {
            toReturn.append("-i ");
        }
        if (this.isIgnoreSpaceChange()) {
            toReturn.append("-b ");
        }
        if (this.isContextDiff()) {
            toReturn.append("-c ");
        }
        if (this.isUnifiedDiff()) {
            toReturn.append("-u ");
        }
        return toReturn.toString();
    }

    public boolean isIgnoreAllWhitespace() {
        return this.ignoreAllWhitespace;
    }

    public void setIgnoreAllWhitespace(boolean ignoreAllWhitespace) {
        this.ignoreAllWhitespace = ignoreAllWhitespace;
    }

    public boolean isIgnoreBlankLines() {
        return this.ignoreBlankLines;
    }

    public void setIgnoreBlankLines(boolean ignoreBlankLines) {
        this.ignoreBlankLines = ignoreBlankLines;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean isIgnoreSpaceChange() {
        return this.ignoreSpaceChange;
    }

    public void setIgnoreSpaceChange(boolean ignoreSpaceChange) {
        this.ignoreSpaceChange = ignoreSpaceChange;
    }

    public boolean isContextDiff() {
        return this.contextDiff;
    }

    public void setContextDiff(boolean contextDiff) {
        this.contextDiff = contextDiff;
    }

    public boolean isUnifiedDiff() {
        return this.unifiedDiff;
    }

    public void setUnifiedDiff(boolean unifiedDiff) {
        this.unifiedDiff = unifiedDiff;
    }
}

