/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.ui.StringArrayCustomEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

final class CndOtherOptionsPanel
extends JPanel
implements ActionListener {
    private boolean isChanged = false;
    private final List<ExtensionsElements> eeList = new ArrayList<ExtensionsElements>();
    private JPanel jPanel1;

    public CndOtherOptionsPanel() {
        this.setName("TAB_CndOtherOptionsTab");
        this.initComponents();
        this.initGeneratedComponents();
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
    }

    void applyChanges() {
        for (ExtensionsElements ee : this.eeList) {
            ee.apply();
        }
        this.isChanged = false;
    }

    void update() {
        for (ExtensionsElements ee : this.eeList) {
            ee.update();
        }
    }

    void cancel() {
        this.isChanged = false;
    }

    boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.isChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editExtensionsButtonActionPerformed(ExtensionsElements ee) {
        StringArrayCustomEditor editor = new StringArrayCustomEditor(ee.getValues().toArray(new String[0]), ee.defaultValue, CndOtherOptionsPanel.getMessage("EE_ItemLabel"), CndOtherOptionsPanel.getMessage("EE_ItemLabel_Mnemonic").charAt(0), CndOtherOptionsPanel.getMessage("EE_ItemListLabel"), CndOtherOptionsPanel.getMessage("EE_ItemListLabel_Mnemonic").charAt(0), false);
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        outerPanel.add((Component)editor, gridBagConstraints);
        Object[] options = new Object[]{NotifyDescriptor.OK_OPTION};
        DialogDescriptor dd = new DialogDescriptor((Object)outerPanel, CndOtherOptionsPanel.getMessage("ExtensionsListEditorTitle"), true, options, NotifyDescriptor.OK_OPTION, 0, null, null);
        DialogDisplayer dialogDisplayer = DialogDisplayer.getDefault();
        Dialog dl = dialogDisplayer.createDialog(dd);
        dl.getAccessibleContext().setAccessibleDescription(CndOtherOptionsPanel.getMessage("ExtensionsListEditorTitle_AD"));
        dl.pack();
        dl.setSize(new Dimension(300, (int)dl.getPreferredSize().getHeight()));
        try {
            dl.setVisible(true);
        }
        catch (Throwable th) {
            if (!(th.getCause() instanceof InterruptedException)) {
                throw new RuntimeException(th);
            }
        }
        finally {
            dl.dispose();
        }
        ee.defaultValue = editor.getDefaultValue();
        ee.setValues(editor.getItemList());
    }

    private void initGeneratedComponents() {
        List orderedExtensions = MIMEExtensions.getCustomizable();
        for (MIMEExtensions ext : orderedExtensions) {
            final ExtensionsElements ee = new ExtensionsElements(ext);
            ee.label.setText(NbBundle.getMessage(CndOtherOptionsPanel.class, (String)"EE_ExtensionListTitle", (Object)ext.getLocalizedDescription()));
            ee.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CndOtherOptionsPanel.this.editExtensionsButtonActionPerformed(ee);
                }
            });
            this.eeList.add(ee);
        }
        GroupLayout layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(layout);
        GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup();
        horizontalGroup.addGap(6, 6, 6);
        GroupLayout.ParallelGroup labelsGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        for (int i = 0; i < this.eeList.size(); ++i) {
            labelsGroup.addComponent(this.eeList.get((int)i).label);
        }
        horizontalGroup.addGroup(labelsGroup);
        horizontalGroup.addGap(4, 4, 4);
        GroupLayout.ParallelGroup textfieldsGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING, false);
        for (int i = 0; i < this.eeList.size(); ++i) {
            textfieldsGroup.addComponent(this.eeList.get((int)i).textfield, -1, 400, Short.MAX_VALUE);
        }
        horizontalGroup.addGroup(textfieldsGroup);
        horizontalGroup.addGap(6, 6, 6);
        GroupLayout.ParallelGroup buttonsGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        for (int i = 0; i < this.eeList.size(); ++i) {
            buttonsGroup.addComponent(this.eeList.get((int)i).button);
        }
        horizontalGroup.addGroup(buttonsGroup);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(horizontalGroup).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addContainerGap();
        for (int i = 0; i < this.eeList.size(); ++i) {
            ExtensionsElements ee = this.eeList.get(i);
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(ee.label).addComponent(ee.textfield, -2, 23, -2).addComponent(ee.button, -2, 23, -2));
            if (i != this.eeList.size() - 1) {
                verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
                continue;
            }
            verticalGroup.addContainerGap(20, Short.MAX_VALUE);
        }
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(verticalGroup));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel1.setOpaque(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 423, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 306, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
    }

    private static String getMessage(String resourceName) {
        return NbBundle.getMessage(CndOtherOptionsPanel.class, (String)resourceName);
    }

    private static final class ExtensionsElements {
        private static final String DELIMITER = ", ";
        private final MIMEExtensions es;
        public final JLabel label = new JLabel();
        public final JEditorPane textfield = new JEditorPane();
        public final JButton button = new JButton();
        private List<String> list;
        private String defaultValue;

        public ExtensionsElements(MIMEExtensions es) {
            this.es = es;
            this.update();
            this.textfield.setContentType("text/html");
            this.textfield.setEditable(false);
            this.updateTextField();
            this.button.setText(CndOtherOptionsPanel.getMessage("CndOtherOptionsPanel.Extensions.EditButton"));
        }

        public void updateTextField() {
            StringBuilder text = new StringBuilder();
            for (String elem : this.list) {
                if (text.length() > 0) {
                    text.append(DELIMITER);
                }
                if (elem.equals(this.defaultValue)) {
                    elem = "<b>" + elem + "</b>";
                }
                text.append(elem);
            }
            this.textfield.setText(text.toString());
        }

        List<String> getValues() {
            return Collections.unmodifiableList(this.list);
        }

        void setValues(String[] values) {
            this.list = Arrays.asList(values);
            Collections.sort(this.list, String.CASE_INSENSITIVE_ORDER);
            this.updateTextField();
        }

        public void apply() {
            this.es.setExtensions(this.getValues(), this.defaultValue);
        }

        public void update() {
            this.list = new ArrayList<String>(this.es.getValues());
            this.defaultValue = this.es.getDefaultExtension();
            this.updateTextField();
        }
    }
}

