/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.File;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.TomcatManagerConfig;
import org.netbeans.modules.tomcat5.TomcatModule;
import org.netbeans.modules.tomcat5.TomcatModuleConfig;
import org.netbeans.modules.tomcat5.util.LogViewer;
import org.netbeans.modules.tomcat5.util.ServerLog;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.netbeans.modules.tomcat5.util.UnsupportedLoggerException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class LogManager {
    private ServerLog serverLog;
    private LogViewer sharedContextLogViewer;
    private LogViewer juliLogViewer;
    private Map tomcatModuleConfigs = Collections.synchronizedMap(new WeakHashMap());
    private Map contextLogViewers = Collections.synchronizedMap(new HashMap());
    private TomcatManager manager;
    private final Object serverLogLock = new Object();
    private final Object sharedContextLogLock = new Object();
    private final Object juliLogLock = new Object();
    private final Object contextLogLock = new Object();
    private Boolean juliJarExist;

    public LogManager(TomcatManager tm) {
        this.manager = tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openServerLog() {
        final Process process = this.manager.getTomcatProcess();
        assert (process != null);
        Object object = this.serverLogLock;
        synchronized (object) {
            if (this.serverLog != null) {
                this.serverLog.takeFocus();
                return;
            }
            this.serverLog = new ServerLog(this.manager, this.manager.getTomcatProperties().getDisplayName(), new InputStreamReader(process.getInputStream()), new InputStreamReader(process.getErrorStream()), true, false);
            this.serverLog.start();
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    process.waitFor();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    LogManager.this.closeServerLog();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeServerLog() {
        Object object = this.serverLogLock;
        synchronized (object) {
            if (this.serverLog != null) {
                this.serverLog.interrupt();
                this.serverLog = null;
            }
        }
    }

    public boolean hasServerLog() {
        return this.manager.getTomcatProcess() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSharedContextLog() {
        TomcatManagerConfig tomcatManagerConfig = this.manager.getTomcatManagerConfig();
        tomcatManagerConfig.refresh();
        if (!tomcatManagerConfig.hasLogger()) {
            return;
        }
        LogViewer newSharedContextLog = null;
        try {
            TomcatProperties tp = this.manager.getTomcatProperties();
            newSharedContextLog = new LogViewer(this.manager, null, tomcatManagerConfig.loggerClassName(), tomcatManagerConfig.loggerDir(), tomcatManagerConfig.loggerPrefix(), tomcatManagerConfig.loggerSuffix(), tomcatManagerConfig.loggerTimestamp(), false);
        }
        catch (UnsupportedLoggerException e) {
            NotifyDescriptor.Message notDesc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(LogManager.class, (String)"MSG_UnsupportedLogger", (Object)e.getLoggerClassName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
            return;
        }
        catch (NullPointerException npe) {
            Logger.getLogger(LogManager.class.getName()).log(Level.INFO, null, npe);
        }
        Object object = this.sharedContextLogLock;
        synchronized (object) {
            if (this.sharedContextLogViewer != null && this.sharedContextLogViewer.isOpen() && !this.sharedContextLogViewer.equals(newSharedContextLog)) {
                this.sharedContextLogViewer.removeAllLogViewerStopListener();
                this.sharedContextLogViewer.close();
                this.sharedContextLogViewer = newSharedContextLog;
                this.sharedContextLogViewer.addLogViewerStopListener(new LogViewer.LogViewerStopListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void callOnStop() {
                        Object object = LogManager.this.sharedContextLogLock;
                        synchronized (object) {
                            LogManager.this.sharedContextLogViewer = null;
                        }
                    }
                });
                this.sharedContextLogViewer.start();
            } else if (this.sharedContextLogViewer == null || !this.sharedContextLogViewer.isOpen()) {
                if (this.sharedContextLogViewer != null) {
                    this.sharedContextLogViewer.removeAllLogViewerStopListener();
                }
                this.sharedContextLogViewer = newSharedContextLog;
                this.sharedContextLogViewer.addLogViewerStopListener(new LogViewer.LogViewerStopListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void callOnStop() {
                        Object object = LogManager.this.sharedContextLogLock;
                        synchronized (object) {
                            LogManager.this.sharedContextLogViewer = null;
                        }
                    }
                });
                this.sharedContextLogViewer.start();
            }
            this.sharedContextLogViewer.takeFocus();
        }
    }

    public boolean hasSharedLogger() {
        TomcatManagerConfig tomcatManagerConfig = this.manager.getTomcatManagerConfig();
        tomcatManagerConfig.refresh();
        return tomcatManagerConfig.hasLogger();
    }

    public synchronized boolean hasJuliLog() {
        if (this.juliJarExist == null) {
            this.juliJarExist = new File(this.manager.getTomcatProperties().getCatalinaHome(), "bin/tomcat-juli.jar").exists() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.juliJarExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openJuliLog() {
        Object object = this.juliLogLock;
        synchronized (object) {
            if (this.juliLogViewer == null || !this.juliLogViewer.isOpen()) {
                if (this.juliLogViewer != null) {
                    this.juliLogViewer.removeAllLogViewerStopListener();
                }
                try {
                    TomcatProperties tp = this.manager.getTomcatProperties();
                    this.juliLogViewer = new LogViewer(this.manager, null, null, null, "localhost.", null, true, false);
                    this.juliLogViewer.setDisplayName(NbBundle.getMessage(LogManager.class, (String)"TXT_JuliLogDisplayName", (Object)tp.getDisplayName()));
                }
                catch (UnsupportedLoggerException e) {
                    Logger.getLogger(LogManager.class.getName()).log(Level.INFO, null, e);
                    return;
                }
                catch (NullPointerException npe) {
                    Logger.getLogger(LogManager.class.getName()).log(Level.INFO, null, npe);
                    return;
                }
                this.juliLogViewer.addLogViewerStopListener(new LogViewer.LogViewerStopListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void callOnStop() {
                        Object object = LogManager.this.juliLogLock;
                        synchronized (object) {
                            LogManager.this.juliLogViewer = null;
                        }
                    }
                });
                this.juliLogViewer.start();
            }
            this.juliLogViewer.takeFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openContextLog(TomcatModule module) {
        final String moduleID = module.getModuleID();
        Object o = this.tomcatModuleConfigs.get(module);
        TomcatModuleConfig moduleConfig = null;
        LogViewer contextLog = null;
        if (o == null) {
            moduleConfig = new TomcatModuleConfig(module.getDocRoot(), module.getPath(), this.manager.getTomcatManagerConfig().serverXmlPath());
            this.tomcatModuleConfigs.put(module, moduleConfig);
        } else {
            moduleConfig = (TomcatModuleConfig)o;
            moduleConfig.refresh();
        }
        if (!moduleConfig.hasLogger()) {
            return;
        }
        contextLog = (LogViewer)this.contextLogViewers.get(moduleID);
        LogViewer newContextLog = null;
        try {
            newContextLog = new LogViewer(this.manager, module.getPath(), moduleConfig.loggerClassName(), moduleConfig.loggerDir(), moduleConfig.loggerPrefix(), moduleConfig.loggerSuffix(), moduleConfig.loggerTimestamp(), false);
        }
        catch (UnsupportedLoggerException e) {
            NotifyDescriptor.Message notDesc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(LogManager.class, (String)"MSG_UnsupportedLogger", (Object)e.getLoggerClassName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
            return;
        }
        catch (NullPointerException npe) {
            Logger.getLogger(LogManager.class.getName()).log(Level.INFO, null, npe);
        }
        Object object = this.contextLogLock;
        synchronized (object) {
            if (contextLog != null && contextLog.isOpen() && !contextLog.equals(newContextLog)) {
                contextLog.removeAllLogViewerStopListener();
                contextLog.close();
                contextLog = newContextLog;
                contextLog.addLogViewerStopListener(new LogViewer.LogViewerStopListener(){

                    @Override
                    public void callOnStop() {
                        LogManager.this.contextLogViewers.remove(moduleID);
                    }
                });
                this.contextLogViewers.put(moduleID, contextLog);
                contextLog.start();
            } else if (contextLog == null || !contextLog.isOpen()) {
                if (contextLog != null) {
                    contextLog.removeAllLogViewerStopListener();
                }
                contextLog = newContextLog;
                contextLog.addLogViewerStopListener(new LogViewer.LogViewerStopListener(){

                    @Override
                    public void callOnStop() {
                        LogManager.this.contextLogViewers.remove(moduleID);
                    }
                });
                this.contextLogViewers.put(moduleID, contextLog);
                contextLog.start();
            }
        }
        contextLog.takeFocus();
    }

    public boolean hasContextLogger(TomcatModule module) {
        Object o = this.tomcatModuleConfigs.get(module);
        TomcatModuleConfig moduleConfig = null;
        if (o == null) {
            moduleConfig = new TomcatModuleConfig(module.getDocRoot(), module.getPath(), this.manager.getTomcatManagerConfig().serverXmlPath());
            this.tomcatModuleConfigs.put(module, moduleConfig);
        } else {
            moduleConfig = (TomcatModuleConfig)o;
            moduleConfig.refresh();
        }
        return moduleConfig.hasLogger();
    }
}

