/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.ui;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditableComboBox
extends JComboBox {
    private String storageKey;
    private Preferences prefs;
    private static final String LIST_DELIMITER = "*";

    public EditableComboBox() {
        this.setEditable(true);
    }

    public void setStorage(String key, Preferences prefs) {
        this.storageKey = key;
        this.prefs = prefs;
    }

    public void read(String path) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(path);
        String old = null;
        if (this.prefs != null) {
            old = this.prefs.get(this.storageKey, "");
        }
        if (old == null) {
            old = "";
        }
        StringTokenizer st = new StringTokenizer(old, LIST_DELIMITER);
        int history = 5;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.isEmpty() || list.contains(s)) continue;
            list.add(s);
            if (--history != 0) continue;
            break;
        }
        DefaultComboBoxModel<Object> rootModel = new DefaultComboBoxModel<Object>(list.toArray());
        this.setModel(rootModel);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 35; ++i) {
            buf.append("w");
        }
        this.setPrototypeDisplayValue(buf.toString());
    }

    public void store() {
        ArrayList<String> list = new ArrayList<String>();
        String text = this.getText();
        if (!text.isEmpty()) {
            list.add(text);
        }
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            String s = this.getModel().getElementAt(i).toString();
            if (s.isEmpty() || list.contains(s)) continue;
            list.add(s);
        }
        StringBuilder buf = new StringBuilder();
        for (String s : list) {
            if (buf.length() > 0) {
                buf.append(LIST_DELIMITER);
            }
            buf.append(s);
        }
        if (this.prefs != null) {
            this.prefs.put(this.storageKey, buf.toString());
        }
    }

    public String getText() {
        Component component;
        if (this.editor != null && (component = this.editor.getEditorComponent()) instanceof JTextField) {
            return ((JTextField)component).getText();
        }
        if (this.getSelectedItem() != null) {
            return this.getSelectedItem().toString();
        }
        return null;
    }

    public String getLastText() {
        String candidate = this.getText();
        if (candidate == null || candidate.isEmpty()) {
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                String s = this.getModel().getElementAt(i).toString();
                if (s.isEmpty()) continue;
                return s;
            }
        }
        return candidate;
    }

    public void setText(String path) {
        this.setSelectedItem(path);
    }

    public void addChangeListener(final ActionListener listener) {
        Component component = this.editor.getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    listener.actionPerformed(null);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    listener.actionPerformed(null);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    listener.actionPerformed(null);
                }
            });
        }
    }
}

