/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.util.HashSet;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.filters.SourceFileFilter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AllBinaryFileFilter
extends SourceFileFilter {
    private static AllBinaryFileFilter instance = null;
    private static String[] suffixes = null;

    public static AllBinaryFileFilter getInstance() {
        if (instance == null) {
            instance = new AllBinaryFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(AllBinaryFileFilter.class, (String)"FILECHOOSER_All_BINARIES_FILEFILTER");
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            if (FileUtil.getExtension((String)f.getName()).length() == 0) {
                FileObject fo = CndFileUtils.toFileObject(CndFileUtils.normalizeFile(f));
                if (fo != null && fo.isValid()) {
                    return MIMENames.isBinary(FileUtil.getMIMEType((FileObject)fo));
                }
            } else {
                return super.accept(f);
            }
        }
        return false;
    }

    @Override
    public String[] getSuffixes() {
        if (suffixes == null) {
            suffixes = this.getAllSuffixes();
        }
        return suffixes;
    }

    private String[] getAllSuffixes() {
        HashSet<String> allSuffixes = new HashSet<String>();
        allSuffixes.addAll(MIMEExtensions.get("application/x-exe").getValues());
        allSuffixes.addAll(MIMEExtensions.get("application/x-exe+dll").getValues());
        allSuffixes.addAll(MIMEExtensions.get("application/x-executable+elf").getValues());
        allSuffixes.addAll(MIMEExtensions.get("application/x-core+elf").getValues());
        allSuffixes.addAll(MIMEExtensions.get("application/x-shobj+elf").getValues());
        allSuffixes.addAll(MIMEExtensions.get("application/x-stobj+elf").getValues());
        allSuffixes.addAll(MIMEExtensions.get("application/x-elf").getValues());
        allSuffixes.addAll(MIMEExtensions.get("application/x-object+elf").getValues());
        return allSuffixes.toArray(new String[allSuffixes.size()]);
    }
}

