/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class MIMEExtensions {
    private static final Preferences preferences = NbPreferences.forModule(MIMEExtensions.class);
    private static final Manager manager = new Manager();
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final String mimeType;
    private final String description;
    private final Set<String> exts;

    public static MIMEExtensions get(String mimeType) {
        return manager.get(mimeType);
    }

    public static List<MIMEExtensions> getCustomizable() {
        return manager.getOrderedExtensions();
    }

    public static boolean isCustomizableExtensions(String mimeType) {
        return MIMEExtensions.get(mimeType) != null;
    }

    public static boolean isRegistered(String mimeType, String ext) {
        if (ext == null || ext.length() == 0) {
            return false;
        }
        MIMEExtensions out = MIMEExtensions.get(mimeType);
        if (out == null) {
            return FileUtil.getMIMETypeExtensions((String)mimeType).contains(ext);
        }
        return out.contains(ext);
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    private MIMEExtensions(String mimeType, String description) {
        this.mimeType = mimeType;
        this.description = description;
        this.exts = new TreeSet<String>();
        this.exts.addAll(FileUtil.getMIMETypeExtensions((String)mimeType));
    }

    private MIMEExtensions(String mimeType, MIMEExtensions primary) {
        this.mimeType = mimeType;
        this.description = primary.description;
        this.exts = primary.exts;
    }

    public void setExtensions(List<String> newExts, String defaultExt) {
        if (!newExts.contains(defaultExt)) {
            throw new IllegalArgumentException("input list " + newExts + " doesn't contain default element:" + defaultExt);
        }
        Collection<String> old = this.getValues();
        ArrayList<String> toRemove = new ArrayList<String>(old);
        toRemove.removeAll(newExts);
        ArrayList<String> toAdd = new ArrayList<String>(newExts);
        toAdd.removeAll(old);
        for (String ext : toRemove) {
            FileUtil.setMIMEType((String)ext, null);
        }
        for (String ext : toAdd) {
            FileUtil.setMIMEType((String)ext, (String)this.mimeType);
        }
        if (!toRemove.isEmpty() || !toAdd.isEmpty()) {
            this.exts.clear();
            this.exts.addAll(newExts);
            this.cs.fireChange();
        }
        preferences.put(this.getMIMEType(), defaultExt);
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public String getDefaultExtension() {
        String defaultExt = preferences.get(this.getMIMEType(), "");
        if (defaultExt.length() == 0) {
            Collection<String> vals = this.getValues();
            return vals.isEmpty() ? "" : vals.iterator().next();
        }
        return defaultExt;
    }

    public String getLocalizedDescription() {
        return this.description;
    }

    public Collection<String> getValues() {
        return Collections.unmodifiableSet(this.exts);
    }

    private boolean contains(String ext) {
        return this.exts.contains(ext);
    }

    public String toString() {
        return this.description + "[" + this.mimeType + ":" + this.getDefaultExtension() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MIMEExtensions other = (MIMEExtensions)obj;
        return this.mimeType.equals(other.mimeType);
    }

    public int hashCode() {
        int hash = this.mimeType.hashCode();
        return hash;
    }

    public void addExtension(String ext) {
        if (!this.getValues().contains(ext)) {
            this.exts.add(ext);
            FileUtil.setMIMEType((String)ext, (String)this.mimeType);
        }
    }

    public void setDefaultExtension(String defaultExt) {
        this.addExtension(defaultExt);
        preferences.put(this.getMIMEType(), defaultExt);
    }

    private static class Manager {
        private final Map<String, MIMEExtensions> mime2ext = new LinkedHashMap<String, MIMEExtensions>(5);
        private final FileObject configFolder = FileUtil.getConfigFile((String)"CND/Extensions");
        private final FileChangeListener listener;

        private Manager() {
            if (this.configFolder != null) {
                this.listener = new L();
                this.configFolder.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)this.configFolder));
                this.initialize(this.configFolder);
            } else {
                this.listener = null;
            }
        }

        public MIMEExtensions get(String mimeType) {
            MIMEExtensions out = this.mime2ext.get(mimeType);
            if (out == null) {
                out = new MIMEExtensions(mimeType, "DEFAULT " + mimeType);
                this.mime2ext.put(mimeType, out);
            }
            return out;
        }

        public List<MIMEExtensions> getOrderedExtensions() {
            LinkedHashMap<String, MIMEExtensions> out = new LinkedHashMap<String, MIMEExtensions>(this.mime2ext);
            out.remove("text/sh");
            out.remove("text/x-c/text/x-h");
            return new ArrayList<MIMEExtensions>(out.values());
        }

        private void initialize(FileObject configFolder) {
            this.mime2ext.clear();
            if (configFolder != null) {
                for (FileObject fo : FileUtil.getOrder(Arrays.asList(configFolder.getChildren()), (boolean)false)) {
                    MIMEExtensions data = this.create(fo);
                    if (this.mime2ext.containsKey(data.getMIMEType())) continue;
                    this.mime2ext.put(data.getMIMEType(), data);
                    if (!"text/x-h".equals(data.getMIMEType())) continue;
                    MIMEExtensions cHeader = new MIMEExtensions("text/x-c/text/x-h", data);
                    String defExt = preferences.get("text/x-c/text/x-h", "");
                    if (defExt.length() == 0) {
                        cHeader.setDefaultExtension(data.getDefaultExtension());
                    }
                    this.mime2ext.put("text/x-c/text/x-h", cHeader);
                }
                MIMEExtensions shell = new MIMEExtensions("text/sh", "");
                this.mime2ext.put("text/sh", shell);
            }
        }

        private MIMEExtensions create(FileObject configFile) throws MissingResourceException {
            Object attr = configFile.getAttribute("mimeType");
            if (!(attr instanceof String)) {
                throw new MissingResourceException(configFile.getPath(), configFile.getClass().getName(), "no stringvalue attribute \"mimeType\"");
            }
            String mimeType = (String)attr;
            attr = configFile.getAttribute("SystemFileSystem.localizingBundle");
            if (!(attr instanceof String)) {
                throw new MissingResourceException(configFile.getPath(), configFile.getClass().getName(), "no stringvalue attribute \"SystemFileSystem.localizingBundle\"");
            }
            ResourceBundle rb = NbBundle.getBundle((String)((String)attr));
            String localizedName = rb.getString(configFile.getPath());
            attr = configFile.getAttribute("default");
            if (attr != null && !(attr instanceof String)) {
                throw new MissingResourceException(configFile.getPath(), configFile.getClass().getName(), "no stringvalue attribute \"default\"");
            }
            String defaultExt = (String)(attr == null ? "" : attr);
            MIMEExtensions out = new MIMEExtensions(mimeType, localizedName);
            defaultExt = preferences.get(mimeType, defaultExt);
            out.setDefaultExtension(defaultExt);
            return out;
        }

        private final class L
        implements FileChangeListener {
            private L() {
            }

            public void fileFolderCreated(FileEvent fe) {
                Manager.this.initialize(Manager.this.configFolder);
            }

            public void fileDataCreated(FileEvent fe) {
                Manager.this.initialize(Manager.this.configFolder);
            }

            public void fileChanged(FileEvent fe) {
                Manager.this.initialize(Manager.this.configFolder);
            }

            public void fileDeleted(FileEvent fe) {
                Manager.this.initialize(Manager.this.configFolder);
            }

            public void fileRenamed(FileRenameEvent fe) {
                Manager.this.initialize(Manager.this.configFolder);
            }

            public void fileAttributeChanged(FileAttributeEvent fe) {
                Manager.this.initialize(Manager.this.configFolder);
            }
        }
    }
}

