/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public class SemanticAnalysis
extends SemanticAnalyzer {
    public static final EnumSet<ColoringAttributes> UNUSED_FIELD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.FIELD);
    public static final EnumSet<ColoringAttributes> UNUSED_STATIC_FIELD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.FIELD, ColoringAttributes.STATIC);
    public static final EnumSet<ColoringAttributes> UNUSED_METHOD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.STATIC, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> UNUSED_STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.STATIC, ColoringAttributes.METHOD, ColoringAttributes.UNUSED);
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights = null;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(Parser.Result r, SchedulerEvent event) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        PHPParseResult result = (PHPParseResult)r;
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        if (result.getProgram() != null) {
            result.getProgram().accept(new SemanticHighlightVisitor(highlights, result.getSnapshot()));
            this.semanticHighlights = highlights.size() > 0 ? highlights : null;
        }
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    private class SemanticHighlightVisitor
    extends DefaultVisitor {
        Map<OffsetRange, Set<ColoringAttributes>> highlights;
        private final Map<String, IdentifierColoring> privateFieldsUsed;
        private final Map<String, IdentifierColoring> privateMethod;
        private List<Block> needToScan = new ArrayList<Block>();
        private final Snapshot snapshot;

        public SemanticHighlightVisitor(Map<OffsetRange, Set<ColoringAttributes>> highlights, Snapshot snapshot) {
            this.highlights = highlights;
            this.privateFieldsUsed = new HashMap<String, IdentifierColoring>();
            this.privateMethod = new HashMap<String, IdentifierColoring>();
            this.snapshot = snapshot;
        }

        private void addOffsetRange(ASTNode node, Set<ColoringAttributes> coloring) {
            int start = this.snapshot.getOriginalOffset(node.getStartOffset());
            if (start > -1) {
                int end = start + node.getEndOffset() - node.getStartOffset();
                assert (coloring != null) : ((Object)this.snapshot.getText()).toString();
                this.highlights.put(new OffsetRange(start, end), coloring);
            }
        }

        @Override
        public void visit(Program program) {
            this.scan(program.getStatements());
            for (Comment comment : program.getComments()) {
                if (comment.getCommentType() != Comment.Type.TYPE_VARTYPE) continue;
                this.scan(comment);
            }
        }

        @Override
        public void visit(ClassDeclaration cldec) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            Identifier name = cldec.getName();
            this.addOffsetRange(name, ColoringAttributes.CLASS_SET);
            this.needToScan = new ArrayList<Block>();
            if (cldec.getBody() != null) {
                cldec.getBody().accept(this);
                for (Block block : this.needToScan) {
                    block.accept(this);
                }
                for (IdentifierColoring item : this.privateFieldsUsed.values()) {
                    if (item.coloring.contains(ColoringAttributes.STATIC)) {
                        this.addOffsetRange(item.identifier, UNUSED_STATIC_FIELD_SET);
                        continue;
                    }
                    this.addOffsetRange(item.identifier, UNUSED_FIELD_SET);
                }
                for (IdentifierColoring item : this.privateMethod.values()) {
                    if (item.coloring.contains(ColoringAttributes.STATIC)) {
                        this.addOffsetRange(item.identifier, UNUSED_STATIC_METHOD_SET);
                        continue;
                    }
                    this.addOffsetRange(item.identifier, UNUSED_METHOD_SET);
                }
            }
        }

        @Override
        public void visit(MethodDeclaration md) {
            Block body;
            boolean isPrivate = BodyDeclaration.Modifier.isPrivate(md.getModifier());
            EnumSet<ColoringAttributes> coloring = ColoringAttributes.METHOD_SET;
            if (BodyDeclaration.Modifier.isStatic(md.getModifier())) {
                coloring = STATIC_METHOD_SET;
            }
            Identifier identifier = md.getFunction().getFunctionName();
            String name = identifier.getName();
            if (isPrivate && name != null && !name.startsWith("__")) {
                this.privateMethod.put(identifier.getName(), new IdentifierColoring(identifier, coloring));
            } else {
                this.addOffsetRange(identifier, coloring);
            }
            if (!BodyDeclaration.Modifier.isAbstract(md.getModifier()) && (body = md.getFunction().getBody()) != null) {
                this.needToScan.add(body);
            }
        }

        @Override
        public void visit(MethodInvocation node) {
            IdentifierColoring item;
            Identifier identifier = null;
            if (node.getMethod().getFunctionName().getName() instanceof Variable) {
                Variable variable = (Variable)node.getMethod().getFunctionName().getName();
                if (variable.getName() instanceof Identifier) {
                    identifier = (Identifier)variable.getName();
                }
            } else if (node.getMethod().getFunctionName().getName() instanceof Identifier) {
                identifier = (Identifier)node.getMethod().getFunctionName().getName();
            }
            if (identifier != null && (item = this.privateMethod.remove(identifier.getName())) != null) {
                this.addOffsetRange(item.identifier, item.coloring);
            }
            super.visit(node);
        }

        @Override
        public void visit(InterfaceDeclaration node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            Identifier name = node.getName();
            this.addOffsetRange(name, ColoringAttributes.CLASS_SET);
            node.getBody().accept(this);
        }

        @Override
        public void visit(FieldsDeclaration node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            boolean isPrivate = BodyDeclaration.Modifier.isPrivate(node.getModifier());
            EnumSet coloring = ColoringAttributes.FIELD_SET;
            if (BodyDeclaration.Modifier.isStatic(node.getModifier())) {
                coloring = ColoringAttributes.STATIC_FIELD_SET;
            }
            Variable[] variables = node.getVariableNames();
            for (int i = 0; i < variables.length; ++i) {
                Variable variable = variables[i];
                if (!isPrivate) {
                    this.addOffsetRange(variable.getName(), coloring);
                    continue;
                }
                if (!(variable.getName() instanceof Identifier)) continue;
                Identifier identifier = (Identifier)variable.getName();
                this.privateFieldsUsed.put(identifier.getName(), new IdentifierColoring(identifier, coloring));
            }
        }

        @Override
        public void visit(FieldAccess node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            if (!node.getField().isDollared()) {
                Expression expr = node.getField().getName();
                new FieldAccessVisitor(ColoringAttributes.FIELD_SET).scan(expr);
            }
            super.scan(node.getDispatcher());
        }

        @Override
        public void visit(StaticMethodInvocation node) {
            String name;
            IdentifierColoring item;
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            FunctionName fnName = node.getMethod().getFunctionName();
            if (fnName.getName() instanceof Identifier && (item = this.privateMethod.remove(name = ((Identifier)fnName.getName()).getName())) != null) {
                this.addOffsetRange(item.identifier, item.coloring);
            }
            this.addOffsetRange(fnName, ColoringAttributes.STATIC_SET);
            super.visit(node);
        }

        @Override
        public void visit(PHPVarComment node) {
            int start = node.getVariable().getStartOffset();
            int end = start + 4;
            int startTranslated = this.snapshot.getOriginalOffset(start);
            if (startTranslated > -1) {
                int endTranslated = startTranslated + end - start;
                this.highlights.put(new OffsetRange(startTranslated, endTranslated), ColoringAttributes.CUSTOM1_SET);
            }
        }

        @Override
        public void visit(StaticFieldAccess node) {
            Expression expr = node.getField().getName();
            if (expr instanceof ArrayAccess) {
                ArrayAccess arrayAccess = (ArrayAccess)expr;
                expr = arrayAccess.getName();
            }
            new FieldAccessVisitor(ColoringAttributes.STATIC_FIELD_SET).scan(expr);
            super.visit(node);
        }

        private class FieldAccessVisitor
        extends DefaultVisitor {
            private final Set<ColoringAttributes> coloring;

            public FieldAccessVisitor(Set<ColoringAttributes> coloring) {
                this.coloring = coloring;
            }

            @Override
            public void visit(ArrayAccess node) {
                this.scan(node.getName());
            }

            @Override
            public void visit(Identifier identifier) {
                IdentifierColoring removed = (IdentifierColoring)SemanticHighlightVisitor.this.privateFieldsUsed.remove(identifier.getName());
                if (removed != null) {
                    SemanticHighlightVisitor.this.addOffsetRange(removed.identifier, removed.coloring);
                }
                SemanticHighlightVisitor.this.addOffsetRange(identifier, this.coloring);
            }
        }

        private class IdentifierColoring {
            public Identifier identifier;
            public Set<ColoringAttributes> coloring;

            public IdentifierColoring(Identifier identifier, Set<ColoringAttributes> coloring) {
                this.identifier = identifier;
                this.coloring = coloring;
            }
        }
    }
}

