/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.parser.PHPDocCommentParser;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DeclarationFinderImpl
implements DeclarationFinder {
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        return DeclarationFinderImpl.findDeclarationImpl(info, caretOffset);
    }

    public OffsetRange getReferenceSpan(Document doc, int caretOffset) {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence(doc, caretOffset);
        return DeclarationFinderImpl.getReferenceSpan(ts, caretOffset);
    }

    public static OffsetRange getReferenceSpan(TokenSequence<PHPTokenId> ts, int caretOffset) {
        block18: {
            PHPTokenId id;
            Token token;
            block20: {
                block19: {
                    if (ts == null) {
                        return OffsetRange.NONE;
                    }
                    ts.move(caretOffset);
                    if (!ts.moveNext()) break block18;
                    token = ts.token();
                    id = (PHPTokenId)token.id();
                    if (id.equals((Object)PHPTokenId.PHP_STRING) || id.equals((Object)PHPTokenId.PHP_VARIABLE)) {
                        return new OffsetRange(ts.offset(), ts.offset() + token.length());
                    }
                    if (!id.equals((Object)PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING)) break block19;
                    OffsetRange retval = new OffsetRange(ts.offset(), ts.offset() + token.length());
                    for (int i = 0; i < 2 && ts.movePrevious(); ++i) {
                        token = ts.token();
                        id = (PHPTokenId)token.id();
                        if (id.equals((Object)PHPTokenId.PHP_INCLUDE) || id.equals((Object)PHPTokenId.PHP_INCLUDE_ONCE) || id.equals((Object)PHPTokenId.PHP_REQUIRE) || id.equals((Object)PHPTokenId.PHP_REQUIRE_ONCE)) {
                            return retval;
                        }
                        if (!id.equals((Object)PHPTokenId.PHP_STRING) || !((Object)token.text()).toString().equalsIgnoreCase("define")) continue;
                        return retval;
                    }
                    break block18;
                }
                if (!id.equals((Object)PHPTokenId.PHPDOC_COMMENT)) break block20;
                PHPDocCommentParser docParser = new PHPDocCommentParser();
                PHPDocBlock docBlock = docParser.parse(ts.offset() - 3, ts.offset() + token.length() - 3, token.toString());
                ASTNode[] hierarchy = Utils.getNodeHierarchyAtOffset(docBlock, caretOffset);
                PhpDocTypeTagInfo node = null;
                PHPDocTypeTag typeTag = null;
                if (hierarchy != null && hierarchy.length > 0) {
                    if (hierarchy[0] instanceof PHPDocTypeTag) {
                        typeTag = (PHPDocTypeTag)hierarchy[0];
                        if (typeTag.getStartOffset() < caretOffset && caretOffset < typeTag.getEndOffset()) {
                            List<? extends PhpDocTypeTagInfo> tagInfos = PhpDocTypeTagInfo.create(typeTag, ASTNodeInfo.Kind.CLASS);
                            for (PhpDocTypeTagInfo phpDocTypeTagInfo : tagInfos) {
                                if (!phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.CLASS)) continue;
                                node = phpDocTypeTagInfo;
                                break;
                            }
                            if (node == null || !node.getRange().containsInclusive(caretOffset)) {
                                tagInfos = PhpDocTypeTagInfo.create(typeTag, ASTNodeInfo.Kind.VARIABLE);
                                for (PhpDocTypeTagInfo phpDocTypeTagInfo : tagInfos) {
                                    if (!phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.VARIABLE)) continue;
                                    node = phpDocTypeTagInfo;
                                    break;
                                }
                            }
                            if (node != null) {
                                return node.getRange().containsInclusive(caretOffset) ? node.getRange() : OffsetRange.NONE;
                            }
                        }
                    } else {
                        List<PHPDocTag> tags = docBlock.getTags();
                        for (PHPDocTag pHPDocTag : tags) {
                            MagicMethodDeclarationInfo methodInfo = MagicMethodDeclarationInfo.create(pHPDocTag);
                            if (methodInfo == null) continue;
                            if (methodInfo.getRange().containsInclusive(caretOffset)) {
                                return methodInfo.getRange();
                            }
                            if (!methodInfo.getTypeRange().containsInclusive(caretOffset)) continue;
                            return methodInfo.getTypeRange();
                        }
                    }
                }
                break block18;
            }
            if (!id.equals((Object)PHPTokenId.PHP_COMMENT) || token.text() == null) break block18;
            String text = ((Object)token.text()).toString();
            String dollaredVar = "@var";
            if (text.contains("@var")) {
                String[] segments = text.split("\\s");
                for (int i = 0; i < segments.length; ++i) {
                    String seg = segments[i];
                    if (!seg.equals("@var") || segments.length <= i + 2) continue;
                    for (int j = 1; j <= 2; ++j) {
                        OffsetRange offsetRange;
                        seg = segments[i + j];
                        if (seg == null || seg.trim().length() <= 0) continue;
                        int indexOf = text.indexOf(seg);
                        assert (indexOf != -1);
                        if (!(offsetRange = new OffsetRange(indexOf += ts.offset(), indexOf + seg.length())).containsInclusive(caretOffset)) continue;
                        return offsetRange;
                    }
                    return OffsetRange.NONE;
                }
            }
        }
        return OffsetRange.NONE;
    }

    public static DeclarationFinder.DeclarationLocation findDeclarationImpl(ParserResult info, int caretOffset) {
        if (!(info instanceof PHPParseResult)) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        PHPParseResult result = (PHPParseResult)info;
        Model model = result.getModel();
        OccurencesSupport occurencesSupport = model.getOccurencesSupport(caretOffset);
        Occurence underCaret = occurencesSupport.getOccurence();
        return DeclarationFinderImpl.findDeclarationImpl(underCaret, info);
    }

    private static DeclarationFinder.DeclarationLocation findDeclarationImpl(Occurence underCaret, ParserResult info) {
        DeclarationFinder.DeclarationLocation location = DeclarationFinder.DeclarationLocation.NONE;
        if (underCaret != null) {
            Collection<? extends PhpElement> gotoDeclarations = underCaret.gotoDeclarations();
            if (gotoDeclarations == null || gotoDeclarations.isEmpty()) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            PhpElement declaration = gotoDeclarations.iterator().next();
            FileObject declarationFo = declaration.getFileObject();
            if (declarationFo == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            location = new DeclarationFinder.DeclarationLocation(declarationFo, declaration.getOffset(), (ElementHandle)declaration);
            Collection<? extends PhpElement> alternativeDeclarations = gotoDeclarations;
            if (alternativeDeclarations.size() > 1) {
                FileObject currentFile = info.getSnapshot().getSource().getFileObject();
                int numberOfCurrentDeclaration = 0;
                DeclarationFinder.DeclarationLocation alternatives = DeclarationFinder.DeclarationLocation.NONE;
                for (PhpElement phpElement : alternativeDeclarations) {
                    FileObject elemFo = phpElement.getFileObject();
                    if (elemFo == null) continue;
                    DeclarationFinder.DeclarationLocation declLocation = new DeclarationFinder.DeclarationLocation(elemFo, phpElement.getOffset(), (ElementHandle)phpElement);
                    if (currentFile == elemFo) {
                        location = declLocation;
                        ++numberOfCurrentDeclaration;
                    }
                    AlternativeLocationImpl al = new AlternativeLocationImpl(phpElement, declLocation);
                    if (alternatives == DeclarationFinder.DeclarationLocation.NONE) {
                        alternatives = al.getLocation();
                    }
                    alternatives.addAlternative((DeclarationFinder.AlternativeLocation)al);
                }
                return numberOfCurrentDeclaration == 1 && !EnumSet.of(Occurence.Accuracy.MORE_TYPES, Occurence.Accuracy.MORE).contains((Object)underCaret.degreeOfAccuracy()) ? location : alternatives;
            }
        }
        return location;
    }

    public static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private PhpElement modelElement;
        private DeclarationFinder.DeclarationLocation declaration;

        public AlternativeLocationImpl(PhpElement modelElement, DeclarationFinder.DeclarationLocation declaration) {
            this.modelElement = modelElement;
            this.declaration = declaration;
        }

        public AlternativeLocationImpl(PhpElement modelElement) {
            this(modelElement, new DeclarationFinder.DeclarationLocation(modelElement.getFileObject(), modelElement.getOffset(), (ElementHandle)modelElement));
        }

        public ElementHandle getElement() {
            return this.modelElement;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            formatter.reset();
            ElementKind ek = this.modelElement.getKind();
            if (ek != null) {
                formatter.name(ek, true);
                if (this.modelElement instanceof FullyQualifiedElement && !((FullyQualifiedElement)this.modelElement).getNamespaceName().isDefaultNamespace()) {
                    QualifiedName namespaceName = ((FullyQualifiedElement)this.modelElement).getNamespaceName();
                    formatter.appendText(namespaceName.append(this.modelElement.getName()).toString());
                } else {
                    formatter.appendText(this.modelElement.getName());
                }
                formatter.name(ek, false);
            } else {
                formatter.appendText(this.modelElement.getName());
            }
            if (this.declaration.getFileObject() != null) {
                formatter.appendText(" in ");
                formatter.appendText(FileUtil.getFileDisplayName((FileObject)this.declaration.getFileObject()));
            }
            return formatter.getText();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.declaration;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            AlternativeLocationImpl i = (AlternativeLocationImpl)o;
            return this.modelElement.getName().compareTo(i.modelElement.getName());
        }
    }
}

