/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.EditorOptions;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.indent.GeneratingBracketCompleter;
import org.netbeans.modules.php.editor.indent.PHPNewLineIndenter;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.util.Exceptions;

public class PHPBracketCompleter
implements KeystrokeHandler {
    static final boolean CONTINUE_COMMENTS = Boolean.getBoolean("php.cont.comment");
    private static final PHPTokenId[] STRING_TOKENS = new PHPTokenId[]{PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE};
    private int previousAdjustmentOffset = -1;
    private boolean isAfter;
    private int previousAdjustmentIndent;

    public boolean isInsertMatchingEnabled(BaseDocument doc) {
        EditorOptions options = EditorOptions.get((String)"text/x-php5");
        if (options != null) {
            return options.getMatchBrackets();
        }
        return true;
    }

    private PHPTokenId findContextForEnd(TokenSequence<? extends PHPTokenId> ts, int offset, int[] startOfContext) {
        if (ts == null) {
            return null;
        }
        if (ts.offset() != offset) {
            ts.move(offset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return null;
            }
        }
        PHPTokenId returnValeu = null;
        Token<? extends PHPTokenId> bracketColumnToken = LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CLOSETAG));
        if (bracketColumnToken != null && (bracketColumnToken.id() == PHPTokenId.PHP_CURLY_OPEN || bracketColumnToken.id() == PHPTokenId.PHP_TOKEN && ":".equals(((Object)ts.token().text()).toString()))) {
            startOfContext[0] = ts.offset();
            List<PHPTokenId> lookFor = Arrays.asList(PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_CLASS, PHPTokenId.PHP_FUNCTION, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_DO, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_SWITCH, PHPTokenId.PHP_CASE, PHPTokenId.PHP_OPENTAG);
            Token<? extends PHPTokenId> keyToken = LexUtilities.findPreviousToken(ts, lookFor);
            if (keyToken.id() == PHPTokenId.PHP_CASE) {
                return null;
            }
            if (bracketColumnToken.id() == PHPTokenId.PHP_CURLY_OPEN) {
                returnValeu = keyToken.id() == PHPTokenId.PHP_CLASS || keyToken.id() == PHPTokenId.PHP_FUNCTION ? (PHPTokenId)keyToken.id() : PHPTokenId.PHP_CURLY_OPEN;
            } else if (bracketColumnToken.id() == PHPTokenId.PHP_TOKEN && ":".equals(((Object)bracketColumnToken.text()).toString()) && keyToken.id() != PHPTokenId.PHP_OPENTAG && keyToken.id() != PHPTokenId.PHP_CLASS && keyToken.id() != PHPTokenId.PHP_FUNCTION) {
                returnValeu = (PHPTokenId)keyToken.id();
            }
            if (keyToken.id() != PHPTokenId.PHP_CURLY_CLOSE && keyToken.id() != PHPTokenId.PHP_SEMICOLON) {
                startOfContext[0] = ts.offset();
            }
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        return returnValeu;
    }

    private boolean isEndMissing(BaseDocument doc, int offset, PHPTokenId startTokenId) throws BadLocationException {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        if (ts == null) {
            return false;
        }
        ts.move(0);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        int curlyBalance = 0;
        if (startTokenId == PHPTokenId.PHP_CURLY_OPEN || startTokenId == PHPTokenId.PHP_FUNCTION || startTokenId == PHPTokenId.PHP_CLASS) {
            do {
                Token token;
                if ((token = ts.token()).id() == PHPTokenId.PHP_CURLY_CLOSE) {
                    --curlyBalance;
                    continue;
                }
                if (token.id() != PHPTokenId.PHP_CURLY_OPEN) continue;
                ++curlyBalance;
            } while (ts.moveNext());
        } else {
            PHPTokenId endTokenId = null;
            if (startTokenId == PHPTokenId.PHP_FOR) {
                endTokenId = PHPTokenId.PHP_ENDFOR;
            } else if (startTokenId == PHPTokenId.PHP_FOREACH) {
                endTokenId = PHPTokenId.PHP_ENDFOREACH;
            } else if (startTokenId == PHPTokenId.PHP_WHILE) {
                endTokenId = PHPTokenId.PHP_ENDWHILE;
            } else if (startTokenId == PHPTokenId.PHP_SWITCH) {
                endTokenId = PHPTokenId.PHP_ENDSWITCH;
            } else if (startTokenId == PHPTokenId.PHP_IF) {
                endTokenId = PHPTokenId.PHP_ENDIF;
            } else if (startTokenId == PHPTokenId.PHP_ELSE || startTokenId == PHPTokenId.PHP_ELSEIF) {
                startTokenId = PHPTokenId.PHP_IF;
                endTokenId = PHPTokenId.PHP_ENDIF;
            }
            ts.move(0);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return false;
            }
            int balance = 0;
            boolean checkAlternativeSyntax = false;
            do {
                Token token;
                if ((token = ts.token()).id() == PHPTokenId.PHP_CURLY_CLOSE) {
                    --curlyBalance;
                    continue;
                }
                if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                    ++curlyBalance;
                    checkAlternativeSyntax = false;
                    continue;
                }
                if (token.id() == startTokenId) {
                    checkAlternativeSyntax = true;
                    continue;
                }
                if (token.id() == PHPTokenId.PHP_TOKEN && ":".equals(((Object)token.text()).toString()) && checkAlternativeSyntax) {
                    ++balance;
                    checkAlternativeSyntax = false;
                    continue;
                }
                if (token.id() != endTokenId) continue;
                --balance;
            } while (ts.moveNext() && curlyBalance > -1 && balance > -1);
            return balance > 0;
        }
        return curlyBalance > 0;
    }

    public int beforeBreak(Document document, int offset, JTextComponent target) throws BadLocationException {
        int begin;
        boolean insert;
        this.isAfter = false;
        Caret caret = target.getCaret();
        final BaseDocument doc = (BaseDocument)document;
        boolean insertMatching = this.isInsertMatchingEnabled(doc);
        int lineBegin = Utilities.getRowStart((BaseDocument)doc, (int)offset);
        int lineEnd = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
        if (lineBegin == offset && lineEnd == offset) {
            return -1;
        }
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        if (ts == null) {
            return -1;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return -1;
        }
        Token<? extends PHPTokenId> token = ts.token();
        TokenId id = token.id();
        int tokenOffsetOnCaret = ts.offset();
        int[] startOfContext = new int[1];
        PHPTokenId completeIn = insertMatching ? this.findContextForEnd(ts, offset, startOfContext) : null;
        boolean bl = insert = completeIn != null && this.isEndMissing(doc, offset, completeIn);
        if (insert) {
            int indent = IndentUtils.lineIndent((Document)doc, (int)IndentUtils.lineStartOffset((Document)document, (int)startOfContext[0]));
            int afterLastNonWhite = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)offset);
            StringBuilder sb = new StringBuilder();
            if (offset > afterLastNonWhite || id == PHPTokenId.PHP_CLOSETAG || offset < afterLastNonWhite && "?>".equals(doc.getText(afterLastNonWhite - 1, 2))) {
                sb.append("\n");
                sb.append(IndentUtils.createIndentString((Document)doc, (int)this.countIndent(doc, offset, indent)));
            } else {
                String restOfLine = doc.getText(offset, Utilities.getRowEnd((BaseDocument)doc, (int)afterLastNonWhite) - offset);
                sb.append(restOfLine);
                sb.append("\n");
                sb.append(IndentUtils.createIndentString((Document)doc, (int)this.countIndent(doc, offset, indent)));
                doc.remove(offset, restOfLine.length());
            }
            if (completeIn == PHPTokenId.PHP_CURLY_OPEN || completeIn == PHPTokenId.PHP_CLASS || completeIn == PHPTokenId.PHP_FUNCTION) {
                if (id == PHPTokenId.PHP_CLOSETAG && offset > tokenOffsetOnCaret) {
                    token = LexUtilities.findPreviousToken(ts, Arrays.asList(PHPTokenId.PHP_OPENTAG));
                    String begin2 = token != null ? ((Object)token.text()).toString() : "<?php";
                    sb.append(begin2);
                    sb.append(" } ?>");
                } else {
                    sb.append("}");
                }
            } else if (completeIn == PHPTokenId.PHP_IF || completeIn == PHPTokenId.PHP_ELSE || completeIn == PHPTokenId.PHP_ELSEIF) {
                sb.append("endif;");
            } else if (completeIn == PHPTokenId.PHP_FOR) {
                sb.append("endfor;");
            } else if (completeIn == PHPTokenId.PHP_FOREACH) {
                sb.append("endforeach;");
            } else if (completeIn == PHPTokenId.PHP_WHILE) {
                sb.append("endwhile;");
            } else if (completeIn == PHPTokenId.PHP_SWITCH) {
                sb.append("endswitch;");
            }
            if (id == PHPTokenId.PHP_CLOSETAG) {
                sb.append("\n");
            }
            int insertOffset = offset;
            doc.insertString(insertOffset, sb.toString(), null);
            caret.setDot(insertOffset);
            return -1;
        }
        if (id == PHPTokenId.PHP_CURLY_CLOSE || LexUtilities.textEquals(token.text(), ']') || LexUtilities.textEquals(token.text(), ')')) {
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
            StringBuilder sb = new StringBuilder();
            if (LexUtilities.textEquals(token.text(), ')') && ts.movePrevious()) {
                Token<? extends PHPTokenId> helpToken = LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                if (helpToken.id() == PHPTokenId.PHP_TOKEN && (helpToken.text().charAt(0) == ',' || helpToken.text().charAt(0) == '(') && ts.movePrevious() && (helpToken = LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT))).id() == PHPTokenId.PHP_ARRAY) {
                    sb.append("\n");
                }
            } else {
                sb.append("\n");
            }
            sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
            int insertOffset = offset;
            doc.insertString(insertOffset, sb.toString(), null);
            caret.setDot(insertOffset);
        }
        if (id == PHPTokenId.WHITESPACE && (begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset)) != -1 && offset < begin) {
            ts.move(begin);
            if (ts.moveNext() && ((id = ts.token().id()) == PHPTokenId.PHP_LINE_COMMENT || id == PHPTokenId.PHPDOC_COMMENT_START || id == PHPTokenId.PHP_COMMENT_START)) {
                offset = begin;
            }
        }
        if (id == PHPTokenId.PHP_LINE_COMMENT) {
            Token<? extends PHPTokenId> firstToken;
            int prevBegin;
            boolean continueComment = false;
            int begin3 = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
            boolean previousLineWasComment = false;
            int rowStart = Utilities.getRowStart((BaseDocument)doc, (int)offset);
            if (rowStart > 0 && (prevBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)(rowStart - 1))) != -1 && (firstToken = LexUtilities.getToken(doc, prevBegin)) != null && firstToken.id() == PHPTokenId.PHP_LINE_COMMENT) {
                previousLineWasComment = true;
            }
            if (previousLineWasComment || offset > begin3) {
                Token<? extends PHPTokenId> firstToken2;
                int nextLineFirst;
                int nextLine;
                Token<? extends PHPTokenId> firstToken3;
                if (ts.offset() + token.length() > offset + 1) {
                    String trailing = doc.getText(offset, Utilities.getRowEnd((BaseDocument)doc, (int)offset) - offset);
                    if (trailing.trim().length() != 0) {
                        continueComment = true;
                    }
                } else if (CONTINUE_COMMENTS && (firstToken3 = LexUtilities.getToken(doc, begin3)) != null && firstToken3.id() == PHPTokenId.PHP_LINE_COMMENT) {
                    continueComment = true;
                }
                if (!continueComment && (nextLine = Utilities.getRowEnd((BaseDocument)doc, (int)offset) + 1) < doc.getLength() && (nextLineFirst = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)nextLine)) != -1 && (firstToken2 = LexUtilities.getToken(doc, nextLineFirst)) != null && firstToken2.id() == PHPTokenId.PHP_LINE_COMMENT) {
                    continueComment = true;
                }
            }
            if (continueComment) {
                char c;
                int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                StringBuilder sb = new StringBuilder();
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                sb.append("//");
                int afterHash = begin3 + 2;
                String line = doc.getText(afterHash, Utilities.getRowEnd((BaseDocument)doc, (int)afterHash) - afterHash);
                for (int i = 0; i < line.length() && ((c = line.charAt(i)) == ' ' || c == '\t'); ++i) {
                    sb.append(c);
                }
                int insertOffset = offset;
                if (offset == begin3 && insertOffset > 0) {
                    insertOffset = Utilities.getRowStart((BaseDocument)doc, (int)offset);
                    int sp = Utilities.getRowStart((BaseDocument)doc, (int)offset) + sb.length();
                    doc.insertString(insertOffset, sb.toString(), null);
                    caret.setDot(sp);
                    return sp;
                }
                doc.insertString(insertOffset, sb.toString(), null);
                caret.setDot(insertOffset);
                return insertOffset + sb.length() + 1;
            }
        }
        if (id == PHPTokenId.PHPDOC_COMMENT || id == PHPTokenId.PHPDOC_COMMENT_START && offset > ts.offset() || id == PHPTokenId.PHPDOC_COMMENT_END) {
            final Object[] ret = PHPBracketCompleter.beforeBreakInComments(doc, ts, offset, caret, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END);
            boolean isEmptyComment = (Boolean)ret[1];
            if (isEmptyComment) {
                final int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)ts.offset());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final long currentTimeMillis = System.currentTimeMillis();
                        try {
                            ParserManager.parseWhenScanFinished(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    if (System.currentTimeMillis() - currentTimeMillis < 1500L) {
                                        GeneratingBracketCompleter.generateDocTags(doc, (Integer)ret[0], indent);
                                    }
                                }
                            });
                        }
                        catch (ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            return (Integer)ret[0];
        }
        if (!(id != PHPTokenId.PHP_COMMENT && id != PHPTokenId.PHP_COMMENT_START && id != PHPTokenId.PHP_COMMENT_END || id == PHPTokenId.PHP_COMMENT_START && offset == ts.offset())) {
            Object[] ret = PHPBracketCompleter.beforeBreakInComments(doc, ts, offset, caret, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END);
            return (Integer)ret[0];
        }
        return -1;
    }

    private static Object[] beforeBreakInComments(BaseDocument doc, TokenSequence<? extends PHPTokenId> ts, int offset, Caret caret, PHPTokenId commentStart, PHPTokenId commentBody, PHPTokenId commentEnd) throws BadLocationException {
        PHPTokenId id = (PHPTokenId)ts.token().id();
        if (id == commentBody || id == commentStart) {
            int newCaretOffset;
            int insertOffset = id == commentStart ? ts.offset() + ts.token().length() : offset;
            if (insertOffset > doc.getLength()) {
                insertOffset = doc.getLength();
            }
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)ts.offset());
            int afterLastNonWhite = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)insertOffset);
            boolean addClosingTag = !PHPBracketCompleter.isClosedComment(DocumentUtilities.getText((Document)doc), insertOffset);
            StringBuilder sb = new StringBuilder();
            if (offset > afterLastNonWhite) {
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                sb.append(" * ");
                newCaretOffset = insertOffset + sb.length() + 1;
            } else {
                String restOfLine = doc.getText(insertOffset, Utilities.getRowEnd((BaseDocument)doc, (int)afterLastNonWhite) - insertOffset);
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                sb.append(" * ");
                newCaretOffset = insertOffset + sb.length() + 1;
                sb.append(restOfLine);
                doc.remove(insertOffset, restOfLine.length());
            }
            if (addClosingTag) {
                sb.append("\n");
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                sb.append(" */");
            }
            doc.insertString(insertOffset, sb.toString(), null);
            caret.setDot(insertOffset);
            return new Object[]{newCaretOffset, addClosingTag};
        }
        if (id == commentEnd) {
            int insertOffset = ts.offset();
            if (ts.movePrevious()) {
                assert (ts.token().id() == commentBody || ts.token().id() == commentStart) : "PHP_COMMENT_END should not be preceeded by " + ((PHPTokenId)ts.token().id()).name();
            } else assert (false) : "PHP_COMMENT_END without PHP_COMMENT or PHP_COMMENT_START";
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)ts.offset());
            int beforeFirstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)insertOffset);
            int rowStart = Utilities.getRowStart((BaseDocument)doc, (int)insertOffset);
            int newCaretOffset = insertOffset;
            StringBuilder sb = new StringBuilder();
            if (beforeFirstNonWhite >= insertOffset) {
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                sb.append(" * ");
                newCaretOffset = rowStart + sb.length();
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                sb.append(" ");
                doc.remove(rowStart, insertOffset - rowStart);
                insertOffset = rowStart;
            } else {
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                sb.append(" ");
            }
            doc.insertString(insertOffset, sb.toString(), null);
            caret.setDot(newCaretOffset);
            return new Object[]{newCaretOffset, false};
        }
        return new Object[]{-1, false};
    }

    private static boolean isClosedComment(CharSequence txt, int pos) {
        int length = txt.length();
        int quotation = 0;
        for (int i = pos; i < length; ++i) {
            char c = txt.charAt(i);
            if (c == '*' && i < length - 1 && txt.charAt(i + 1) == '/') {
                char cc;
                if (quotation == 0 || i < length - 2) {
                    return true;
                }
                boolean isClosed = true;
                for (int j = i + 2; j < length && (cc = txt.charAt(j)) != '\n'; ++j) {
                    if (cc != '\"' || j >= length - 1 || txt.charAt(j + 1) == '\'') continue;
                    isClosed = false;
                    break;
                }
                if (!isClosed) continue;
                return true;
            }
            if (c == '/' && i < length - 1 && txt.charAt(i + 1) == '*') {
                return false;
            }
            if (c == '\n') {
                quotation = 0;
                continue;
            }
            if (c != '\"' || i >= length - 1 || txt.charAt(i + 1) == '\'') continue;
            ++quotation;
            quotation %= 2;
        }
        return false;
    }

    static boolean isEndMissing(BaseDocument doc, int offset, boolean skipJunk, boolean[] insertEndResult, boolean[] insertRBraceResult, int[] startOffsetResult, int[] indentResult, PHPTokenId insertingEnd) throws BadLocationException {
        TokenSequence<PHPTokenId> ts;
        int length = doc.getLength();
        if (startOffsetResult != null) {
            startOffsetResult[0] = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        }
        if ((ts = LexUtilities.getPHPTokenSequence((Document)doc, offset)) == null) {
            return false;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        Token token = ts.token();
        int balance = 1;
        boolean EOF = false;
        if (insertingEnd == PHPTokenId.PHP_CURLY_CLOSE) {
            while (!(token.id() != PHPTokenId.PHP_CURLY_OPEN && token.id() != PHPTokenId.PHP_CURLY_CLOSE && token.id() != PHPTokenId.WHITESPACE || EOF)) {
                if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                    ++balance;
                } else if (token.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                    --balance;
                }
                if (ts.moveNext()) {
                    token = ts.token();
                    continue;
                }
                EOF = true;
            }
            if (EOF && balance == 1) {
                return true;
            }
        }
        return false;
    }

    public boolean beforeCharInserted(Document document, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        String selection;
        TokenSequence<PHPTokenId> ts;
        this.isAfter = false;
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)document;
        if (!this.isInsertMatchingEnabled(doc)) {
            return false;
        }
        if (caretOffset == 0) {
            return false;
        }
        if (target.getSelectionStart() != -1) {
            char firstChar;
            String selection2;
            if (GsfUtilities.isCodeTemplateEditing((Document)doc)) {
                int end;
                int start = target.getSelectionStart();
                if (start < (end = target.getSelectionEnd())) {
                    target.setSelectionStart(start);
                    target.setSelectionEnd(start);
                    caretOffset = start;
                    caret.setDot(caretOffset);
                    doc.remove(start, end - start);
                }
            } else if ((ch == '\"' || ch == '\'' || ch == '(' || ch == '{' || ch == '[' || ch == '/') && (selection2 = target.getSelectedText()) != null && selection2.length() > 0 && (firstChar = selection2.charAt(0)) != ch) {
                int start = target.getSelectionStart();
                int end = target.getSelectionEnd();
                TokenSequence<? extends PHPTokenId> ts2 = LexUtilities.getPositionedSequence(doc, start);
                if (!(ts2 == null || PHPBracketCompleter.isStringToken((Token<? extends PHPTokenId>)ts2.token()) && firstChar != '\"' && firstChar != '\'')) {
                    char lastChar = selection2.charAt(selection2.length() - 1);
                    if (selection2.length() > 1 && (firstChar == '\"' || firstChar == '\'' || firstChar == '(' || firstChar == '{' || firstChar == '[' || firstChar == '/') && lastChar == this.matching(firstChar)) {
                        doc.remove(end - 1, 1);
                        doc.insertString(end - 1, Character.toString(this.matching(ch)), null);
                        doc.remove(start, 1);
                        doc.insertString(start, Character.toString(ch), null);
                        target.getCaret().setDot(end);
                    } else {
                        doc.remove(start, end - start);
                        doc.insertString(start, ch + selection2 + this.matching(ch), null);
                        target.getCaret().setDot(start + selection2.length() + 2);
                    }
                    return true;
                }
            }
        }
        if ((ts = LexUtilities.getPHPTokenSequence((Document)doc, caretOffset)) == null) {
            return false;
        }
        ts.move(caretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        Token token = ts.token();
        TokenId id = token.id();
        PHPTokenId[] stringTokens = null;
        PHPTokenId beginTokenId = null;
        if (id == PHPTokenId.PHP_LINE_COMMENT && target.getSelectionStart() != -1 && (ch == '*' || ch == '+' || ch == '_') && (selection = target.getSelectedText()) != null && selection.length() > 0 && selection.charAt(0) != ch && selection.indexOf(32) == -1) {
            int start = target.getSelectionStart();
            doc.remove(start, target.getSelectionEnd() - start);
            doc.insertString(start, ch + selection + this.matching(ch), null);
            target.getCaret().setDot(start + selection.length() + 2);
            return true;
        }
        if (ch == '\"') {
            stringTokens = STRING_TOKENS;
            beginTokenId = PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING;
        } else if (ch == '\'') {
            stringTokens = STRING_TOKENS;
            beginTokenId = PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING;
        }
        if (stringTokens != null) {
            boolean inserted = this.completeQuote(doc, caretOffset, ch);
            if (inserted) {
                caret.setDot(caretOffset + 1);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean afterCharInserted(Document document, int dotPos, JTextComponent target, char ch) throws BadLocationException {
        this.isAfter = true;
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)document;
        if (this.previousAdjustmentOffset != -1) {
            TokenSequence<PHPTokenId> ts;
            if (dotPos == this.previousAdjustmentOffset && (ts = LexUtilities.getPHPTokenSequence((Document)doc, dotPos)) != null) {
                ts.move(dotPos);
                if (ts.moveNext() && ts.offset() < dotPos) {
                    GsfUtilities.setLineIndentation((BaseDocument)doc, (int)dotPos, (int)this.previousAdjustmentIndent);
                }
            }
            this.previousAdjustmentOffset = -1;
        }
        switch (ch) {
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                if (!this.isInsertMatchingEnabled(doc)) {
                    return false;
                }
                Token<? extends PHPTokenId> token = LexUtilities.getToken(doc, dotPos);
                if (token == null) {
                    return true;
                }
                TokenId id = token.id();
                if (id == PHPTokenId.PHP_VARIABLE && token.length() == 1 || LexUtilities.textEquals(token.text(), '[') || LexUtilities.textEquals(token.text(), ']') || LexUtilities.textEquals(token.text(), '(') || LexUtilities.textEquals(token.text(), ')')) {
                    if (ch == ']' || ch == ')') {
                        this.skipClosingBracket(doc, caret, ch);
                    } else if (ch == '[' || ch == '(') {
                        this.completeOpeningBracket(doc, dotPos, caret, ch);
                    }
                } else if (id == PHPTokenId.PHP_CASTING && ch == ')') {
                    this.skipClosingBracket(doc, caret, ch);
                }
                if (ch == '}') {
                    this.reindent(doc, dotPos, PHPTokenId.PHP_CURLY_CLOSE, caret);
                    break;
                }
                if (ch != '{') break;
                this.reindent(doc, dotPos, PHPTokenId.PHP_CURLY_OPEN, caret);
            }
        }
        return true;
    }

    private void reindent(BaseDocument doc, int offset, TokenId id, Caret caret) throws BadLocationException {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        if (ts != null) {
            ts.move(offset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return;
            }
            Token token = ts.token();
            if (token.id() == id) {
                OffsetRange begin;
                int rowFirstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
                if (ts.offset() > rowFirstNonWhite) {
                    return;
                }
                if (id == PHPTokenId.PHP_CURLY_OPEN && ts.offset() == rowFirstNonWhite && ts.movePrevious()) {
                    int previousExprestion = PHPNewLineIndenter.findStartTokenOfExpression(ts);
                    int previousIndent = Utilities.getRowIndent((BaseDocument)doc, (int)previousExprestion);
                    int currentIndent = Utilities.getRowIndent((BaseDocument)doc, (int)offset);
                    int newIndent = this.countIndent(doc, offset, previousIndent);
                    if (newIndent != currentIndent) {
                        GsfUtilities.setLineIndentation((BaseDocument)doc, (int)offset, (int)Math.max(newIndent, 0));
                        return;
                    }
                }
                if ((begin = id == PHPTokenId.PHP_CURLY_CLOSE ? LexUtilities.findBwd(doc, ts, PHPTokenId.PHP_CURLY_OPEN, '{', PHPTokenId.PHP_CURLY_CLOSE, '}') : LexUtilities.findBegin(doc, ts)) != OffsetRange.NONE) {
                    int beginOffset = begin.getStart();
                    int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)beginOffset);
                    this.previousAdjustmentIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                    GsfUtilities.setLineIndentation((BaseDocument)doc, (int)offset, (int)indent);
                    this.previousAdjustmentOffset = caret.getDot();
                }
            }
        }
    }

    public OffsetRange findMatching(Document document, int offset) {
        return OffsetRange.NONE;
    }

    public boolean charBackspaced(Document document, int dotPos, JTextComponent target, char ch) throws BadLocationException {
        BaseDocument doc = (BaseDocument)document;
        switch (ch) {
            case ' ': {
                TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, dotPos);
                if (ts == null) break;
                ts.move(dotPos);
                if (!ts.moveNext() && !ts.movePrevious() || ts.offset() != dotPos - 1 || ts.token().id() != PHPTokenId.PHP_LINE_COMMENT) break;
                doc.remove(dotPos - 1, 1);
                target.getCaret().setDot(dotPos - 1);
                return true;
            }
            case '(': 
            case '[': 
            case '{': {
                char tokenAtDot = LexUtilities.getTokenChar(doc, dotPos);
                if (!(tokenAtDot == ']' && LexUtilities.getTokenBalance(doc, '[', ']', dotPos) != 0 || tokenAtDot == ')' && LexUtilities.getTokenBalance(doc, '(', ')', dotPos) != 0) && (tokenAtDot != '}' || LexUtilities.getTokenBalance(doc, '{', '}', dotPos) == 0)) break;
                doc.remove(dotPos, 1);
                break;
            }
            case '\"': 
            case '\'': {
                char[] match = doc.getChars(dotPos, 1);
                if (match == null || match[0] != ch) break;
                doc.remove(dotPos, 1);
            }
        }
        return true;
    }

    private void skipClosingBracket(BaseDocument doc, Caret caret, char bracket) throws BadLocationException {
        int caretOffset = caret.getDot();
        if (this.isSkipClosingBracket(doc, caretOffset, bracket)) {
            doc.remove(caretOffset - 1, 1);
            caret.setDot(caretOffset);
        }
    }

    private boolean isSkipClosingBracket(BaseDocument doc, int caretOffset, char bracket) throws BadLocationException {
        if (caretOffset == doc.getLength()) {
            return false;
        }
        boolean skipClosingBracket = false;
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, caretOffset);
        if (ts == null) {
            return false;
        }
        ts.move(caretOffset);
        if (!ts.moveNext()) {
            return false;
        }
        Token token = ts.token();
        if (token != null && LexUtilities.textEquals(token.text(), bracket)) {
            char leftBracket = bracket == ')' ? (char)'(' : (bracket == ']' ? (char)'[' : '{');
            ts.moveNext();
            Token nextToken = ts.token();
            while (nextToken != null && LexUtilities.textEquals(nextToken.text(), bracket)) {
                token = nextToken;
                if (!ts.moveNext()) break;
                nextToken = ts.token();
            }
            int braceBalance = 0;
            int bracketBalance = -1;
            Token lastRBracket = token;
            ts.movePrevious();
            token = ts.token();
            boolean finished = false;
            while (!finished && token != null) {
                if (LexUtilities.textEquals(token.text(), '(') || LexUtilities.textEquals(token.text(), '[')) {
                    if (LexUtilities.textEquals(token.text(), leftBracket) && ++bracketBalance == 0) {
                        if (braceBalance != 0) {
                            bracketBalance = 1;
                        }
                        finished = true;
                    }
                } else if (LexUtilities.textEquals(token.text(), ']') || LexUtilities.textEquals(token.text(), ']')) {
                    if (LexUtilities.textEquals(token.text(), bracket)) {
                        --bracketBalance;
                    }
                } else if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                    if (++braceBalance > 0) {
                        finished = true;
                    }
                } else if (token.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                    --braceBalance;
                }
                if (!ts.movePrevious()) break;
                token = ts.token();
            }
            if (bracketBalance != 0) {
                skipClosingBracket = true;
            } else {
                braceBalance = 0;
                bracketBalance = 1;
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                int ofs = lastRBracket.offset(th);
                ts.move(ofs);
                ts.moveNext();
                token = ts.token();
                finished = false;
                while (!finished && token != null) {
                    if (LexUtilities.textEquals(token.text(), '(') || LexUtilities.textEquals(token.text(), '[')) {
                        if (LexUtilities.textEquals(token.text(), leftBracket)) {
                            ++bracketBalance;
                        }
                    } else if (LexUtilities.textEquals(token.text(), ')') || LexUtilities.textEquals(token.text(), ']')) {
                        if (LexUtilities.textEquals(token.text(), bracket) && --bracketBalance == 0) {
                            if (braceBalance != 0) {
                                bracketBalance = -1;
                            }
                            finished = true;
                        }
                    } else if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                        ++braceBalance;
                    } else if (token.id() == PHPTokenId.PHP_CURLY_CLOSE && --braceBalance < 0) {
                        finished = true;
                    }
                    if (!ts.movePrevious()) break;
                    token = ts.token();
                }
                skipClosingBracket = bracketBalance == 0;
            }
        }
        return skipClosingBracket;
    }

    private void completeOpeningBracket(BaseDocument doc, int dotPos, Caret caret, char bracket) throws BadLocationException {
        if (this.isCompletablePosition(doc, dotPos + 1)) {
            String matchingBracket = "" + this.matching(bracket);
            doc.insertString(dotPos + 1, matchingBracket, null);
            caret.setDot(dotPos + 1);
        }
    }

    private boolean isEscapeSequence(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos <= 0) {
            return false;
        }
        char previousChar = doc.getChars(dotPos - 1, 1)[0];
        return previousChar == '\\';
    }

    private boolean completeQuote(BaseDocument doc, int dotPos, char bracket) throws BadLocationException {
        Token previousToken;
        if (this.isEscapeSequence(doc, dotPos)) {
            return false;
        }
        Object[] result = PHPBracketCompleter.findPhpSectionBoundaries(doc, dotPos, true);
        if (result == null) {
            return false;
        }
        TokenSequence ts = (TokenSequence)result[0];
        int sectionStart = (Integer)result[1];
        int sectionEnd = (Integer)result[2];
        boolean onlyWhitespacePreceeds = (Boolean)result[3];
        boolean onlyWhitespaceFollows = (Boolean)result[4];
        Token token = ts.token();
        if (token == null) {
            return false;
        }
        Token token2 = previousToken = ts.movePrevious() ? ts.token() : null;
        if (token.id() == PHPTokenId.PHP_COMMENT || token.id() == PHPTokenId.PHP_LINE_COMMENT || token.id() == PHPTokenId.PHPDOC_COMMENT || token.id() == PHPTokenId.T_INLINE_HTML) {
            return false;
        }
        boolean insideString = PHPBracketCompleter.isStringToken((Token<? extends PHPTokenId>)token);
        if (!insideString && onlyWhitespaceFollows && previousToken != null && PHPBracketCompleter.isStringToken((Token<? extends PHPTokenId>)previousToken)) {
            insideString = true;
        }
        if (insideString) {
            if (onlyWhitespaceFollows) {
                return false;
            }
            char chr = doc.getChars(dotPos, 1)[0];
            if (chr == bracket) {
                if (!this.isAfter) {
                    doc.insertString(dotPos, "" + bracket, null);
                } else if (dotPos >= doc.getLength() - 1 || doc.getText(dotPos + 1, 1).charAt(0) != bracket) {
                    return true;
                }
                doc.remove(dotPos, 1);
                return true;
            }
        } else {
            int firstNonWhiteFwd;
            boolean insert = onlyWhitespaceFollows;
            if (!insert && (firstNonWhiteFwd = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)dotPos, (int)sectionEnd)) != -1) {
                char chr = doc.getChars(firstNonWhiteFwd, 1)[0];
                boolean bl = insert = chr == ')' || chr == ',' || chr == '+' || chr == '}' || chr == ';' || chr == ']' || chr == '.';
            }
            if (insert) {
                doc.insertString(dotPos, "" + bracket + (this.isAfter ? "" : Character.valueOf(this.matching(bracket))), null);
                return true;
            }
        }
        return false;
    }

    private static Object[] findPhpSectionBoundaries(BaseDocument doc, int offset, boolean currentLineOnly) {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        int lowest = 0;
        int highest = doc.getLength();
        if (currentLineOnly) {
            lowest = doc.getParagraphElement(offset).getStartOffset();
            highest = Math.max(doc.getParagraphElement(offset).getEndOffset() - 1, lowest);
        }
        int sectionEnd = highest;
        boolean onlyWhitespaceFollows = true;
        while (highest >= ts.offset()) {
            if (ts.token().id() == PHPTokenId.PHP_CLOSETAG) {
                sectionEnd = ts.offset();
                break;
            }
            if (ts.token().id() != PHPTokenId.WHITESPACE) {
                onlyWhitespaceFollows = false;
            }
            if (ts.moveNext()) continue;
        }
        int sectionStart = lowest;
        boolean onlyWhitespacePreceeds = true;
        while (ts.movePrevious() && lowest <= ts.offset()) {
            if (ts.token().id() == PHPTokenId.PHP_OPENTAG) {
                sectionStart = ts.offset();
                break;
            }
            if (ts.token().id() == PHPTokenId.WHITESPACE) continue;
            onlyWhitespacePreceeds = false;
        }
        ts.move(offset);
        if (!ts.moveNext()) assert (ts.movePrevious());
        assert (sectionStart != -1 && sectionEnd != -1) : "sectionStart=" + sectionStart + ", sectionEnd=" + sectionEnd;
        return new Object[]{ts, sectionStart, sectionEnd, onlyWhitespacePreceeds, onlyWhitespaceFollows};
    }

    private static boolean isStringToken(Token<? extends PHPTokenId> token) {
        for (PHPTokenId stringTokenId : STRING_TOKENS) {
            if (token.id() != stringTokenId) continue;
            return true;
        }
        return false;
    }

    private boolean isCompletablePosition(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos == doc.getLength()) {
            return true;
        }
        char chr = doc.getChars(dotPos, 1)[0];
        return chr == ')' || chr == ',' || chr == '\"' || chr == '\'' || chr == ' ' || chr == ']' || chr == '}' || chr == '\n' || chr == '\t' || chr == ';';
    }

    private char matching(char bracket) {
        switch (bracket) {
            case '(': {
                return ')';
            }
            case '/': {
                return '/';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
        }
        return bracket;
    }

    private int countIndent(BaseDocument doc, int offset, int previousIndent) {
        int value = previousIndent;
        boolean delta = false;
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        ts.move(offset);
        if (!ts.moveNext() || !ts.moveNext()) {
            return previousIndent;
        }
        Token token = ts.token();
        while (token.id() != PHPTokenId.PHP_CURLY_OPEN && token.id() != PHPTokenId.PHP_SEMICOLON && (token.id() != PHPTokenId.PHP_TOKEN || !"(".equals(token.text()) && !"[".equals(token.text())) && ts.movePrevious()) {
            token = ts.token();
        }
        if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
            while (token.id() != PHPTokenId.PHP_CLASS && token.id() != PHPTokenId.PHP_FUNCTION && token.id() != PHPTokenId.PHP_IF && token.id() != PHPTokenId.PHP_ELSE && token.id() != PHPTokenId.PHP_ELSEIF && token.id() != PHPTokenId.PHP_FOR && token.id() != PHPTokenId.PHP_FOREACH && token.id() != PHPTokenId.PHP_WHILE && token.id() != PHPTokenId.PHP_DO && token.id() != PHPTokenId.PHP_SWITCH && ts.movePrevious()) {
                token = ts.token();
            }
            CodeStyle codeStyle = CodeStyle.get((Document)doc);
            CodeStyle.BracePlacement bracePlacement = codeStyle.getOtherBracePlacement();
            if (token.id() == PHPTokenId.PHP_CLASS) {
                bracePlacement = codeStyle.getClassDeclBracePlacement();
            } else if (token.id() == PHPTokenId.PHP_FUNCTION) {
                bracePlacement = codeStyle.getMethodDeclBracePlacement();
            } else if (token.id() == PHPTokenId.PHP_IF || token.id() == PHPTokenId.PHP_ELSE || token.id() == PHPTokenId.PHP_ELSEIF) {
                bracePlacement = codeStyle.getIfBracePlacement();
            } else if (token.id() == PHPTokenId.PHP_FOR || token.id() == PHPTokenId.PHP_FOREACH) {
                bracePlacement = codeStyle.getForBracePlacement();
            } else if (token.id() == PHPTokenId.PHP_WHILE || token.id() == PHPTokenId.PHP_DO) {
                bracePlacement = codeStyle.getWhileBracePlacement();
            } else if (token.id() == PHPTokenId.PHP_SWITCH) {
                bracePlacement = codeStyle.getSwitchBracePlacement();
            }
            value = bracePlacement == CodeStyle.BracePlacement.NEW_LINE_INDENTED ? previousIndent + codeStyle.getIndentSize() : previousIndent;
        }
        return value;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, final int caretOffset) {
        final LinkedHashSet ranges = new LinkedHashSet();
        DefaultVisitor pathVisitor = new DefaultVisitor(){

            @Override
            public void scan(ASTNode node) {
                if (node != null && node.getStartOffset() <= caretOffset && caretOffset <= node.getEndOffset()) {
                    ranges.add(new OffsetRange(node.getStartOffset(), node.getEndOffset()));
                    super.scan(node);
                }
            }
        };
        if (info instanceof PHPParseResult) {
            pathVisitor.scan(((PHPParseResult)info).getProgram());
        }
        ArrayList<OffsetRange> retval = new ArrayList<OffsetRange>(ranges);
        Collections.reverse(retval);
        return retval;
    }

    public int getNextWordOffset(Document document, int offset, boolean reverse) {
        BaseDocument doc = (BaseDocument)document;
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        if (ts == null) {
            return -1;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return -1;
        }
        if (reverse && ts.offset() == offset && !ts.movePrevious()) {
            return -1;
        }
        Token token = ts.token();
        TokenId id = token.id();
        if (id == PHPTokenId.WHITESPACE) {
            int start;
            if (reverse && ts.offset() < offset || !reverse && ts.offset() > offset) {
                return ts.offset();
            }
            while (id == PHPTokenId.WHITESPACE) {
                if (reverse && !ts.movePrevious()) {
                    return -1;
                }
                if (!reverse && !ts.moveNext()) {
                    return -1;
                }
                token = ts.token();
                id = token.id();
            }
            if (reverse ? (start = ts.offset() + token.length()) < offset : (start = ts.offset()) > offset) {
                return start;
            }
        }
        if (id == PHPTokenId.PHP_VARIABLE || id == PHPTokenId.PHP_STRING) {
            char charAtI;
            int i;
            String s = ((Object)token.text()).toString();
            int length = s.length();
            int wordOffset = offset - ts.offset();
            if (reverse) {
                int offsetInImage = offset - 1 - ts.offset();
                if (offsetInImage < 0) {
                    return -1;
                }
                if (offsetInImage < length && Character.isUpperCase(s.charAt(offsetInImage))) {
                    for (int i2 = offsetInImage - 1; i2 >= 0; --i2) {
                        char charAtI2 = s.charAt(i2);
                        if (charAtI2 == '_') {
                            return ts.offset() + i2 + 1;
                        }
                        if (Character.isUpperCase(charAtI2)) continue;
                        return ts.offset() + i2 + 1;
                    }
                    return ts.offset();
                }
                for (int i3 = offsetInImage - 1; i3 >= 0; --i3) {
                    char charAtI3 = s.charAt(i3);
                    if (charAtI3 == '_') {
                        return ts.offset() + i3 + 1;
                    }
                    if (!Character.isUpperCase(charAtI3)) continue;
                    for (int j = i3; j >= 0; --j) {
                        char charAtJ = s.charAt(j);
                        if (charAtJ == '_') {
                            return ts.offset() + j + 1;
                        }
                        if (Character.isUpperCase(charAtJ)) continue;
                        return ts.offset() + j + 1;
                    }
                    return ts.offset();
                }
                return ts.offset();
            }
            int start = wordOffset + 1;
            if (wordOffset < 0 || wordOffset >= s.length()) {
                return -1;
            }
            if (Character.isUpperCase(s.charAt(wordOffset))) {
                for (i = start; i < length && Character.isUpperCase(charAtI = s.charAt(i)); ++i) {
                    if (s.charAt(i) == '_') {
                        return ts.offset() + i;
                    }
                    ++start;
                }
            }
            for (i = start; i < length; ++i) {
                charAtI = s.charAt(i);
                if (charAtI != '_' && !Character.isUpperCase(charAtI)) continue;
                return ts.offset() + i;
            }
        }
        return -1;
    }

    public static enum LineBalance {
        PLAIN,
        UP_FIRST,
        DOWN_FIRST;

    }
}

