/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class UserdirFile {
    private String moduleFolderName;
    private String folderName;
    private String filename;

    public UserdirFile(String moduleFolderName, String folderName, String filename) {
        this.moduleFolderName = moduleFolderName;
        this.folderName = folderName;
        this.filename = filename;
    }

    public String moduleFolderName() {
        return this.moduleFolderName;
    }

    public String folderName() {
        return this.folderName;
    }

    public String filename() {
        return this.filename;
    }

    public String fullPath() {
        String fullPath = this.moduleFolderName() + File.separator + this.folderName() + File.separator + this.filename() + "." + "xml";
        return fullPath;
    }

    public void read(Reader reader) throws IOException {
        FileObject fo = FileUtil.getConfigFile((String)this.fullPath());
        if (fo == null) {
            return;
        }
        InputStream inputStream = fo.getInputStream();
        reader.readFrom(inputStream);
    }

    public void write(final Writer writer) throws IOException, FileStateInvalidException {
        final FileObject rootFo = FileUtil.getConfigRoot();
        FileSystem fs = rootFo.getFileSystem();
        final String fullPath = this.fullPath();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject fo = FileUtil.createData((FileObject)rootFo, (String)fullPath);
                FileLock lock = fo.lock();
                try {
                    OutputStream os = fo.getOutputStream(lock);
                    writer.writeTo(os);
                }
                finally {
                    lock.releaseLock();
                }
            }
        });
    }

    public String toString() {
        return this.fullPath();
    }

    public static interface Writer {
        public void writeTo(OutputStream var1) throws IOException, FileStateInvalidException;
    }

    public static interface Reader {
        public void readFrom(InputStream var1) throws IOException;
    }
}

