/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types;

import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.LineBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.props.IntegerProperty;
import org.netbeans.modules.cnd.debugger.common2.utils.props.StringProperty;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;

public final class LineBreakpoint
extends NativeBreakpoint {
    public IntegerProperty lineNumber;
    public StringProperty fileName;

    public LineBreakpoint(int flags) {
        super(LineBreakpointType.getDefault(), flags);
        this.lineNumber = new IntegerProperty(this.pos, "lineNumber", null, false, -1);
        this.fileName = new StringProperty(this.pos, "fileName", null, false, null);
    }

    public void setFileName(String fileName) {
        if (IpeUtils.sameString(this.fileName.toString(), fileName)) {
            return;
        }
        this.fileName.set(fileName);
    }

    public String getShortFileName() {
        if (this.fileName.get() == null) {
            return "";
        }
        return CndPathUtilitities.getBaseName((String)this.fileName.get());
    }

    public String getFileName() {
        if (this.fileName.get() == null) {
            return "";
        }
        return this.fileName.get();
    }

    public void removeAnnotations() {
        int annoLineNo = this.annoLineNo();
        if (annoLineNo != 0) {
            this.lineNumber.set(annoLineNo);
        }
        super.removeAnnotations();
    }

    public void setLineNumber(int newLineNumber) {
        if (this.annoLineNo() != 0) {
            this.removeAnnotations();
            this.lineNumber.set(newLineNumber);
            this.addAnnotation(this.fileName.get(), this.lineNumber.get(), 0L);
        } else {
            this.lineNumber.set(newLineNumber);
        }
    }

    public void setLineNumberInitial(int newLineNumber) {
        if (this.annoLineNo() != 0) {
            this.removeAnnotations();
            this.lineNumber.setFromObjectInitial(newLineNumber);
            this.addAnnotation(this.fileName.get(), this.lineNumber.get(), 0L);
        } else {
            this.lineNumber.setFromObjectInitial(newLineNumber);
        }
    }

    public int getLineNumber() {
        int lineNo = this.annoLineNo();
        if (lineNo == 0) {
            lineNo = this.lineNumber.get();
        }
        return lineNo;
    }

    private int annoLineNo() {
        DebuggerAnnotation[] annotations = this.annotations();
        if (annotations.length > 0) {
            DebuggerAnnotation a = annotations[0];
            return a.getLineNo();
        }
        return 0;
    }

    public void setFileAndLine(String fileName, int lineNumber) {
        this.setFileName(fileName);
        this.setLineNumber(lineNumber);
    }

    protected final String getSummary() {
        return Catalog.format("CTL_Line_event_name", this.getFileName(), this.getLineNumber());
    }

    protected String getDisplayNameHelp() {
        return CndPathUtilitities.getBaseName((String)this.getFileName()) + ":" + this.getLineNumber();
    }

    protected void processOriginalEventspec(String oeventspec) {
        assert (IpeUtils.isEmpty(oeventspec));
    }
}

