/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types;

import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.props.FunctionSubEventProperty;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.FunctionBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.props.StringProperty;
import org.netbeans.modules.cnd.debugger.common2.values.FunctionSubEvent;

public final class FunctionBreakpoint
extends NativeBreakpoint {
    public StringProperty function;
    public StringProperty qfunction;
    public FunctionSubEventProperty subEvent;

    public FunctionBreakpoint(int flags) {
        super(new FunctionBreakpointType(), flags);
        this.function = new StringProperty(this.pos, "function", null, false, null);
        this.qfunction = new StringProperty(this.pos, "qfunction", null, false, null);
        this.subEvent = new FunctionSubEventProperty(this.pos, "subEvent", null, false, FunctionSubEvent.IN);
    }

    public void setFunction(String function) {
        this.function.set(function);
    }

    public String getFunction() {
        return this.function.get();
    }

    public void setQfunction(String qfunc) {
        this.qfunction.set(qfunc);
    }

    public String getQfunction() {
        return this.qfunction.get();
    }

    public void setSubEvent(FunctionSubEvent se) {
        this.subEvent.set(se);
    }

    public FunctionSubEvent getSubEvent() {
        return this.subEvent.get();
    }

    protected final String getSummary() {
        return this.getFunction();
    }

    protected String getDisplayNameHelp() {
        String summary = null;
        FunctionBreakpoint fb = this;
        FunctionSubEvent se = fb.getSubEvent();
        summary = se.equals(FunctionSubEvent.IN) ? fb.getFunction() : (se.equals(FunctionSubEvent.INFUNCTION) ? Catalog.format("Handler_AllFunc", fb.getFunction()) : (se.equals(FunctionSubEvent.RETURNS) ? Catalog.format("Handler_ReturnFrom", fb.getFunction()) : fb.getFunction()));
        return summary;
    }

    protected void processOriginalEventspec(String oeventspec) {
        assert (!IpeUtils.isEmpty(oeventspec));
        this.function.set(oeventspec);
    }
}

