/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.util.ArrayList;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.RoutingToken;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchVariable;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;

public class NativeWatch {
    private String expression;
    private String qexpression;
    private String scope;
    private String replacedwith = null;
    private boolean restricted;
    private ModelListener updater;
    private Watch watch;
    private int routingToken = 0;
    private boolean deletingChildren = false;
    private ArrayList<WatchVariable> subWatches = new ArrayList();

    public NativeWatch(Watch watch) {
        this.watch = watch;
    }

    public Watch watch() {
        return this.watch;
    }

    public String getExpression() {
        if (this.watch != null) {
            return this.watch.getExpression();
        }
        return this.expression;
    }

    public void setExpression(String expression) {
        if (this.watch != null) {
            this.watch.setExpression(expression);
        } else {
            this.expression = expression;
        }
    }

    public String getScope() {
        assert (this.watch == null);
        return this.scope;
    }

    public void setScope(String scope) {
        assert (this.watch == null);
        this.scope = scope;
    }

    public void replacedWith(String r) {
        this.replacedwith = r;
    }

    public String getReplaced() {
        return this.replacedwith;
    }

    public boolean isReplaced() {
        return this.replacedwith != null;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        assert (this.watch == null);
        this.restricted = restricted;
    }

    public String getQualifiedExpression() {
        assert (this.watch == null);
        return this.qexpression;
    }

    public void setQualifiedExpression(String qexpression) {
        assert (this.watch == null);
        if (this.qexpression != null) {
            return;
        }
        this.qexpression = qexpression;
    }

    public void setUpdater(ModelListener updater) {
        this.updater = updater;
    }

    public void update() {
        if (this.updater != null) {
            if (this.watch == null) {
                this.updater.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)this));
            } else {
                this.updater.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)this.watch));
            }
        }
    }

    public void cleanup() {
        this.setUpdater(null);
    }

    void prepareForSaving() {
    }

    void restored() {
    }

    public int getRoutingToken() {
        if (this.routingToken == 0) {
            this.routingToken = RoutingToken.WATCHES.getUniqueRoutingTokenInt();
        }
        return this.routingToken;
    }

    public void delete() {
        assert (this.getSubWatches().length == 0) : "NativeWatch.delete(): still have children";
        if (this.watch != null) {
            this.watch.remove();
        } else {
            DebuggerManager.get().watchBag().remove(this);
        }
    }

    public void postDelete(boolean spreading) {
        if (this.deletingChildren) {
            return;
        }
        this.deletingChildren = true;
        WatchVariable[] children = this.getSubWatches();
        if (children.length == 0) {
            this.delete();
        } else {
            for (WatchVariable w : children) {
                w.getDebugger().postDeleteWatch(w, spreading);
            }
        }
    }

    public final WatchVariable[] getSubWatches() {
        WatchVariable[] array = new WatchVariable[this.subWatches.size()];
        this.subWatches.toArray(array);
        return array;
    }

    public int nChildren() {
        return this.subWatches.size();
    }

    public WatchVariable findByDebugger(NativeDebugger debugger) {
        assert (debugger != null);
        for (WatchVariable w : this.subWatches) {
            assert (w.getDebugger() != null);
            if (w.getDebugger() != debugger) continue;
            return w;
        }
        if (Log.Watch.map) {
            System.out.printf("NativeWatch.findByDebugger(): no WatchVariable for %s --- NsubWatches = %d\n", this.getExpression(), this.subWatches.size());
        }
        return null;
    }

    private final int findByWatch(WatchVariable subWatch) {
        for (int wx = 0; wx < this.subWatches.size(); ++wx) {
            WatchVariable candidate = this.subWatches.get(wx);
            if (candidate != subWatch) continue;
            return wx;
        }
        return -1;
    }

    public final void removeSubWatch(WatchVariable subWatch, NativeDebugger debugger) {
        assert (subWatch != null) : "removeSubWatch(): null subWatch";
        assert (subWatch.getDebugger() == debugger) : "removeSubWatch(): sub-watch not associated with debugger or removed twice";
        int wx = this.findByWatch(subWatch);
        WatchVariable removed = this.subWatches.remove(wx);
        assert (removed != null) : "removeSubWatch(): No watch under this debugger " + debugger + "\n" + "last removal: XXX";
        assert (removed == subWatch) : "removeSubWatch(): watch under debugger different from one being removed.\nlast removal: XXX";
    }

    public void setSubWatchFor(WatchVariable subWatch, NativeDebugger debugger) {
        assert (subWatch != null) : "setSubWatchFor(): null subWatch";
        assert (debugger != null) : "setSubWatchFor(): null debugger";
        assert (subWatch.getDebugger() == debugger) : "setSubWatchFor(): debuggers don't match";
        this.deletingChildren = false;
        subWatch.setNativeWatch(this);
        this.subWatches.add(subWatch);
        this.update();
    }
}

